/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   keyapi.c
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   keyboard related stuffs
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "KeyApi.h"
#include "eventmgr.h"
#include "msg.h"
#include "qtype.h"
#include "ui.h"

#define NULL	0

void KeyDecode(MsgType *msg)
{
	EvtAppendEvt(EVT_KEY, msg->msgID, msg->para1, msg->para2, NULL);
}

const ObjectBounds keys_bounds[256] = 
{
	{0,0,0,0},{1,31,18,14},{1,46,20,14},{22,46,14,14},{0,0,0,0}, /* 0 - 4 */
	{0,0,0,0},{0,0,0,0},{1,31,18,14},{141,1,18,14},{0,0,0,0}, /* 5 - 9 */
	{0,0,0,0},{0,0,0,0},{0,0,0,0},{141,16,18,14},{0,0,0,0}, /* 10 - 14 */
	{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}, /* 15 - 19 */
    {0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}, /* 20 - 24 */
	{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}, /* 25 - 29 */
	{0,0,0,0},{0,0,0,0},{37,46,48,14},{1,16,13,14},{104,46,13,14}, /*30 - 34*/
	{29,16,13,14},{0,0,0,0},{57,16,13,14},{85,16,13,14},{104,46,13,14}, /*35 - 39*/
	{113,16,13,14},{127,16,13,14},{99,16,13,14},{118,46,13,14},{118,31,13,14}, /*40 - 44*/
	{127,16,13,14},{132,31,13,14},{146,46,13,14},{127,1,13,14},{1,1,13,14}, /*45 - 49*/
	{15,1,13,14},{29,1,13,14},{43,1,13,14},{57,1,13,14},{71,1,13,14}, /*50 - 54*/
	{85,1,13,14},{99,1,13,14},{113,1,13,14},{146,31,13,14},{146,31,13,14}, /*55 - 59*/
	{118,31,13,14},{118,46,13,14},{132,31,13,14},{146,46,13,14},{0,0,0,0}, /*60 - 64*/
	{1,16,13,14},{76,31,13,14},{48,31,13,14},{29,16,13,14},{29,1,13,14}, /*65 - 69*/
	{43,16,13,14},{57,16,13,14},{71,16,13,14},{99,1,13,14},{85,16,13,14}, /*70 - 74*/
	{99,16,13,14},{113,16,13,14},{104,31,13,14},{90,31,13,14},{113,1,13,14}, /*75 - 79*/
	{127,1,13,14},{1,1,13,14},{43,1,13,14},{15,16,13,14},{57,1,13,14}, /*80 - 84*/
	{85,1,13,14},{62,31,13,14},{15,1,13,14},{34,31,13,14},{71,1,13,14}, /*85 - 89*/
	{20,31,13,14},{104,31,13,14},{132,46,13,14},{118,31,13,14},{71,16,13,14}, /*90 - 94*/
	{127,16,13,14},{132,46,13,14},{1,16,13,14},{76,31,13,14},{48,31,13,14}, /*95 - 99*/
	{29,16,13,14},{29,1,13,14},{43,16,13,14},{57,16,13,14},{71,16,13,14}, /* 100 - 104*/
	{99,1,13,14},{85,16,13,14},{99,16,13,14},{113,16,13,14},{104,31,13,14}, /*105 - 109*/
	{90,31,13,14},{113,1,13,14},{127,1,13,14},{1,1,13,14},{43,1,13,14}, /*110 - 114*/
	{15,16,13,14},{57,1,13,14},{85,1,13,14},{62,31,13,14},{15,1,13,14}, /*115 - 119*/
	{34,31,13,14},{71,1,13,14},{20,31,13,14},{132,31,13,14},{132,46,13,14}, /*120 - 124*/
	{146,31,13,14},{146,46,13,14},{48,31,13,14},{0,0,0,0},{90,31,13,14}, /*125 - 129*/
	{0,0,0,0},{118,31,13,14},{0,0,0,0},{0,0,0,0},{118,46,13,14}, /*130 - 134*/
	{104,46,13,14},{118,46,13,14},{62,31,13,14},{104,31,13,14},{0,0,0,0}, /*135 - 139*/
	{43,1,13,14},{76,31,13,14},{48,31,13,14},{34,31,13,14},{20,31,13,14}, /*140 - 144*/
	{132,31,13,14},{118,31,13,14},{132,46,13,14},{146,46,13,14},{0,0,0,0}, /*145 - 149*/
	{0,0,0,0},{0,0,0,0},{146,46,13,14},{99,1,13,14},{104,31,13,14}, /*150 - 154*/
	{0,0,0,0},{43,16,13,14},{1,1,13,14},{15,16,13,14},{127,16,13,14}, /*155 - 159*/
	{0,0,0,0},{15,1,13,14},{1,16,13,14},{90,31,13,14},{132,31,13,14}, /*160 - 164*/
	{76,31,13,14},{0,0,0,0},{104,31,13,14},{146,31,13,14},{127,1,13,14}, /*165 - 169*/
	{99,16,13,14},{104,46,13,14},{0,0,0,0},{0,0,0,0},{113,1,13,14}, /*170 - 174*/
	{0,0,0,0},{132,46,13,14},{34,31,13,14},{0,0,0,0},{0,0,0,0}, /*175 - 179*/
	{0,0,0,0},{62,31,13,14},{0,0,0,0},{0,0,0,0},{0,0,0,0}, /*180 - 184*/
	{0,0,0,0},{113,16,13,14},{118,46,13,14},{0,0,0,0},{0,0,0,0}, /*185 - 189*/
	{0,0,0,0},{104,46,13,14},{15,1,13,14},{1,1,13,14},{43,1,13,14}, /*190 - 194*/
	{71,1,13,14},{29,1,13,14},{57,1,13,14},{29,1,13,14},{71,1,13,14}, /*195 - 199*/
	{15,16,13,14},{1,16,13,14},{43,16,13,14},{29,16,13,14},{99,1,13,14}, /*200 - 204*/
	{85,1,13,14},{127,1,13,14},{113,1,13,14},{104,46,13,14},{90,31,13,14}, /*205 - 209*/
	{34,31,13,14},{20,31,13,14},{62,31,13,14},{76,31,13,14},{48,31,13,14}, /*210 - 214*/
	{0,0,0,0}, {57,1,13,14},{71,16,13,14},{57,16,13,14},{99,16,13,14}, /*215 - 219*/
	{85,16,13,14},{113,16,13,14},{85,1,13,14},{0,0,0,0},{15,1,13,14}, /*220 - 224*/
	{1,1,13,14},{43,1,13,14},{71,1,13,14},{29,1,13,14},{57,1,13,14}, /*225 - 229*/
	{29,16,13,14},{71,16,13,14},{15,16,13,14},{1,16,13,14},{43,16,13,14}, /*230 - 234*/
	{29,16,13,14},{99,1,13,14},{85,1,13,14},{127,1,13,14},{113,1,13,14}, /*235 - 239*/
	{0,0,0,0},{90,31,13,14},{34,31,13,14},{20,31,13,14},{62,31,13,14}, /*240 - 244*/
	{76,31,13,14},{48,31,13,14},{20,31,13,14},{57,16,13,14},{71,16,13,14}, /*245 - 249*/
	{57,16,13,14},{99,16,13,14},{85,16,13,14},{113,16,13,14},{85,16,13,14}, /*250 - 254*/
	{127,16,13,14} /*255*/
};


const SHORT keyboard_bitmap_index[256] =
{
    0x0000,0x01EF,0x03FF,0x021F,0x0000,0x03EF,0x03F0,0x0010,0x03FF,0x0000,  /*0 - 9*/
	0X0000,0X0000,0X0000,0X03FF,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,	/*10 - 19*/
    0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,0X0000,  /*20 - 29*/
	0X0000,0X0000,0X03FF,0X0010,0X0006,0X0010,0X0210,0X0010,0X0010,0X0009,	/*30 - 39*/
	0X0010,0X0010,0X0010,0X0006,0X0009,0X0009,0X0009,0X0009,0X0010,0X0010,	/*40 - 49*/
	0X0010,0X0010,0X0010,0X0010,0X0010,0X0010,0X0010,0X0010,0X0006,0X0009,	/*50 - 59*/
	0X0006,0X0009,0X0006,0X0006,0X0210,0X0006,0X0006,0X0006,0X0006,0X0006,	/*60 - 69*/
	0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,	/*70 - 79*/
	0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,0X0006,	/*80 - 89*/
	0X0006,0X0010,0X0009,0X0010,0X0010,0X0006,0X0200,0X0009,0X0009,0X0009,	/*90 - 99*/
	0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,	/*100 - 109*/
	0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,0X0009,	/*110 - 119*/
	0X0009,0X0009,0X0009,0X0010,0X0006,0X0010,0X0200,0X0010,0X0000,0X0200,	/*120 - 129*/
	0X0000,0X0200,0X0000,0X0000,0X0200,0X0200,0X01E0,0X0010,0x00C0,0X0000,	/*130 - 139*/
	0x0200,0X0200,0X0200,0X0200,0X0200,0x01E0,0x01E0,0x0010,0X0010,0X0000,	/*140 - 149*/
	0X0000,0X0000,0X01E0,0X0200,0X0120,0X0000,0X0200,0X0200,0X0200,0X00C0,	/*150 - 159*/
	0X0000,0X0200,0X0200,0X0010,0X0200,0X0010,0X0000,0X0200,0X01E0,0X0200,	/*160 - 169*/
	0X0200,0X0010,0X0000,0X0000,0X0200,0X0000,0X01E0,0X0010,0X0000,0X0000,	/*170 - 179*/
	0X0000,0X0200,0X0000,0X0000,0X0000,0X0000,0X0200,0X0010,0X0000,0X0000,	/*180 - 189*/
	0X0000,0X0120,0X00C0,0X00C0,0X00C0,0X00C0,0X00C0,0X00C0,0X0200,0X0200,	/*190 - 199*/
	0X00C0,0X00C0,0X00C0,0X00C0,0X00C0,0X00C0,0X00C0,0X00C0,0X00C0,0X00C0,	/*200 - 209*/
	0X00C0,0X00C0,0X00C0,0X00C0,0X00C0,0X0000,0X0200,0X00C0,0X00C0,0X00C0,	/*210 - 219*/
	0X00C0,0X00C0,0X0200,0X0000,0X0120,0X0120,0X0120,0X0120,0X0120,0X0120,	/*220 - 229*/
	0X0200,0X0200,0X0120,0X0120,0X0120,0X0120,0X0120,0X0120,0X0120,0X0120,	/*230 - 239*/
	0X0000,0X0120,0X0120,0X0120,0X0120,0X0120,0X0120,0X0010,0X0200,0X0120,	/*240 - 249*/
	0X0120,0X0120,0X0120,0X0120,0X0200,0X0120								/*250 - 255*/
};

const UWORD key0[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 
0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c003, 0x000c0000, 0x00c00000, 0x0c003000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c003, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x03000003, 0xc00fc00c, 0x030300c0, 0x03c00c00, 0xcc00c00f, 
0xf00c00c3, 0x00c00c30, 0x0c003000, 0xc003c00c, 0x00fc00c0, 0x0f000003, 0xc030c00c, 0x030300c0, 
0x0c300c00, 0xf000c003, 0x000c00c3, 0x00c00c30, 0x0c003000, 0xc00c300c, 0x00c300c0, 0x3f000003, 
0xc030c00c, 0x033300c0, 0x0c300c00, 0xc000c003, 0x000c00c3, 0x00c00c30, 0x0c003000, 0xc00c300c, 
0x00c300c0, 0xffffff03, 0xc030c00c, 0x033300c0, 0x0ff00c00, 0xc000c003, 0x000c00c3, 0x00c00c30, 
0x0c003000, 0xc00c300c, 0x00c300c0, 0x3f000003, 0xc00fc00c, 0x00cc00c0, 0x0c000c00, 0xc000c003, 
0x300c003f, 0x00c00c30, 0x0c003000, 0xc00c300c, 0x00fc00c0, 0x0f000003, 0xc000c00c, 0x00cc00c0, 
0x03f00c00, 0xc000c000, 0xc00c0003, 0x00c003c0, 0x0c003000, 0xc003c00c, 0x00c000c0, 0x03000003, 
0xc000c00c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c003c, 0x00c00000, 0x0c000000, 0xc000000c, 
0x00c000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 
0x00300c00, 0x0c00c000, 0x000c00c0, 0x00c00030, 0x0c00c000, 0xc003000c, 0x000000c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00300c00, 0x3300c000, 0x000c00c0, 0x00c00000, 0x0c00c000, 0xc003000c, 
0x000000c0, 0x03000303, 0xc00f000c, 0x003c00c0, 0x03f00c00, 0x3000c003, 0xc00c00fc, 0x00c00030, 
0x0c00c300, 0xc003000c, 0x000000c0, 0x0f000303, 0xc000c00c, 0x00c300c0, 0x0c300c00, 0xff00c00c, 
0x300c00c3, 0x00c00030, 0x0c00c300, 0xc003000c, 0x000000c0, 0x3f000303, 0xc00fc00c, 0x003000c0, 
0x0c300c00, 0x3000c00c, 0x300c00c3, 0x00c00030, 0x0c00cc00, 0xc003000c, 0x03ff00c0, 0xffffff03, 
0xc030c00c, 0x000c00c0, 0x0c300c00, 0x3000c00c, 0x300c00c3, 0x00c00030, 0x0c00f000, 0xc003000c, 
0x000000c0, 0x3f000003, 0xc030c00c, 0x00c300c0, 0x0c300c00, 0x3000c003, 0xf00c00c3, 0x00c00030, 
0x0c00cc00, 0xc003000c, 0x000000c0, 0x0f000003, 0xc00fc00c, 0x003c00c0, 0x03f00c00, 0x3000c000, 
0x300c00c3, 0x00c00330, 0x0c00c300, 0xc003000c, 0x000000c0, 0x03000003, 0xc000000c, 0x000000c0, 
0x00000c00, 0x0000c00f, 0xc00c0000, 0x00c000c0, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x03000000, 0x30000003, 0x00000030, 
0x00000300, 0x30003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc3c00000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x30003000, 0x00030000, 0x00300000, 0x03000000, 0x3003c003, 
0xcc300000, 0x03003fc0, 0x300c0c03, 0x000fc030, 0x0c0c0300, 0x3f003003, 0xf003003f, 0xc0300000, 
0x03000000, 0x3003c003, 0xcc03c3c0, 0xf30000c0, 0x30033003, 0x00300030, 0x0c0c0300, 0x30c03003, 
0x0c030033, 0x30300000, 0x03000000, 0x30000003, 0xcc003333, 0x03000300, 0x3000c003, 0x00300030, 
0x03300300, 0x30c03003, 0x0c030033, 0x30300000, 0x03000000, 0x3003c003, 0xcc03f330, 0xc3000c00, 
0x3000c003, 0x00300030, 0x03300300, 0x30c03003, 0x0c030033, 0x303003c0, 0x03000f00, 0x3003c003, 
0xcc3333c0, 0x33003000, 0x30033003, 0x00300030, 0x00c00300, 0x30c03003, 0x0c030033, 0x303003c0, 
0x03000f00, 0x3000c003, 0xc3c3f303, 0xc3003fc0, 0x300c0c03, 0x000fc030, 0x00c00300, 0x3f003003, 
0x0c030033, 0x303000c0, 0x03000000, 0x30030003, 0xc0000300, 0x03000000, 0x30000003, 0x00000030, 
0x00000300, 0x00003000, 0x00030000, 0x00300300, 0x03000000, 0x30000003, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0xc0c00000, 0x00000000, 0x00000000, 0x00303c3c, 
0x0f03000f, 0x00300000, 0x03003000, 0x30000c03, 0xc3f30303, 0x0c330030, 0xccc00000, 0x00000000, 
0x00000000, 0x00300cc3, 0x30c3000f, 0x00300000, 0x03003000, 0x30000c03, 0xcc03000c, 0x0c330030, 
0xccc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c30003, 0x00300000, 0x03003000, 0x30000c03, 
0xcc03c33f, 0x3f333cfc, 0x0cc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c3000c, 0x00300fff, 
0x03000c00, 0x30003003, 0xc3c3330c, 0x0c333330, 0x0cc00000, 0x00000000, 0x00000000, 0x00300c0c, 
0x0f030000, 0x00300000, 0x03000c00, 0x30003003, 0xc033330c, 0x0c333330, 0x0cc00000, 0x00000000, 
0x00000000, 0x00300c30, 0x00c30000, 0x00300fff, 0x03000c00, 0x30003003, 0xc033330c, 0x0c333330, 
0x0cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x00c30000, 0x00300000, 0x03000300, 0x3000c003, 
0xcfc3330c, 0x0333330c, 0x0cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x30c30000, 0x00300000, 
0x03000300, 0x3000c003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300cff, 
0x0f030000, 0x00300000, 0x03000300, 0x3000c003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };

const UWORD key1[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 
0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc00fc00c, 0x0c30c0c0, 0x0ff00c00, 0xff00c03f, 0xf00c0303, 0x00c03030, 0x0c003000, 0xc00fc00c, 
0x00ff00c0, 0x00000003, 0xc030300c, 0x0c30c0c0, 0x0c000c00, 0xc0c0c003, 0x000c0303, 0x00c03030, 
0x0c003000, 0xc030300c, 0x00c0c0c0, 0x03000003, 0xc030300c, 0x0c30c0c0, 0x0c000c00, 0xc0c0c003, 
0x000c0303, 0x00c03030, 0x0c003000, 0xc030300c, 0x00c0c0c0, 0x0f000003, 0xc030300c, 0x0c30c0c0, 
0x0c000c00, 0xc0c0c003, 0x000c00cc, 0x00c03030, 0x0c003000, 0xc030300c, 0x00c0c0c0, 0x3f000003, 
0xc03c300c, 0x0cccc0c0, 0x0ff00c00, 0xff00c003, 0x000c0030, 0x00c03030, 0x0c003000, 0xc030300c, 
0x00ff00c0, 0xffffff03, 0xc033300c, 0x0cccc0c0, 0x0c000c00, 0xc0c0c003, 0x000c0030, 0x00c03030, 
0x0c003000, 0xc030300c, 0x00c000c0, 0x3f000003, 0xc030f00c, 0x0cccc0c0, 0x0c000c00, 0xc0c0c003, 
0x000c0030, 0x00c03030, 0x0c003000, 0xc030300c, 0x00c000c0, 0x0f000003, 0xc030300c, 0x030300c0, 
0x0c000c00, 0xc0c0c003, 0x000c0030, 0x00c03030, 0x0c003000, 0xc030300c, 0x00c000c0, 0x03000003, 
0xc00fcc0c, 0x030300c0, 0x0ff00c00, 0xc0c0c003, 0x000c0030, 0x00c00fc0, 0x0c003000, 0xc00fc00c, 
0x00c000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc00fc00c, 0x00ff00c0, 
0x3fc00c00, 0xff00c00f, 0xc00c0303, 0x00c03ff0, 0x0c030300, 0xc030000c, 0x000000c0, 0x00000003, 
0xc030300c, 0x030000c0, 0x30300c00, 0xc000c030, 0x000c0303, 0x00c000c0, 0x0c030300, 0xc030000c, 
0x000000c0, 0x03000303, 0xc030300c, 0x030000c0, 0x30300c00, 0xc000c030, 0x000c0303, 0x00c000c0, 
0x0c030c00, 0xc030000c, 0x000000c0, 0x0f000303, 0xc030300c, 0x030000c0, 0x30300c00, 0xc000c030, 
0x000c0303, 0x00c000c0, 0x0c033000, 0xc030000c, 0x000000c0, 0x3f000303, 0xc030300c, 0x00fc00c0, 
0x30300c00, 0xff00c033, 0xf00c03ff, 0x00c000c0, 0x0c03c000, 0xc030000c, 0x000000c0, 0xffffff03, 
0xc03ff00c, 0x000300c0, 0x30300c00, 0xc000c030, 0x300c0303, 0x00c000c0, 0x0c033000, 0xc030000c, 
0x000000c0, 0x3f000003, 0xc030300c, 0x000300c0, 0x30300c00, 0xc000c030, 0x300c0303, 0x00c000c0, 
0x0c030c00, 0xc030000c, 0x000000c0, 0x0f000003, 0xc030300c, 0x000300c0, 0x30300c00, 0xc000c030, 
0x300c0303, 0x00c030c0, 0x0c030300, 0xc030000c, 0x000000c0, 0x03000003, 0xc030300c, 0x03fc00c0, 
0x3fc00c00, 0xc000c00f, 0xc00c0303, 0x00c00f00, 0x0c030300, 0xc03ff00c, 0x0fffc0c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x0300ffc0, 0x300c0c03, 0x003f0030, 
0x0c0c0300, 0xff00300c, 0x03030300, 0x3030000c, 0x03003000, 0x30000003, 0xc3c00000, 0x030000c0, 
0x300c0c03, 0x00c0c030, 0x0c0c0300, 0xc0c0300f, 0x030303c0, 0xf0300030, 0x03000c00, 0x30000003, 
0xcc300000, 0x030000c0, 0x300c0c03, 0x00c00030, 0x0c0c0300, 0xc0c0300f, 0x03030333, 0x303000c0, 
0x03000300, 0x3000f003, 0xcc03c3c0, 0xf3000300, 0x30033003, 0x00c00030, 0x03300300, 0xc0c0300c, 
0xc303030c, 0x30300300, 0x030000c0, 0x3000f003, 0xcc003333, 0x03000c00, 0x3000c003, 0x00c00030, 
0x03300300, 0xff00300c, 0xc3030300, 0x30300c00, 0x03000030, 0x30000003, 0xcc03f330, 0xc3003000, 
0x30033003, 0x00c00030, 0x03300300, 0xc0c0300c, 0x33030300, 0x30300300, 0x030000c0, 0x3000f003, 
0xcc3333c0, 0x3300c000, 0x300c0c03, 0x00c00030, 0x00c00300, 0xc0c0300c, 0x33030300, 0x303000c0, 
0x03000300, 0x3000f003, 0xc3c3f303, 0xc300c000, 0x300c0c03, 0x00c0c030, 0x00c00300, 0xc0c0300c, 
0x0f030300, 0x30300030, 0x03000c00, 0x30000003, 0xc0000300, 0x0300ffc0, 0x300c0c03, 0x003f0030, 
0x00c00300, 0xff00300c, 0x0f030300, 0x3030000c, 0x03003000, 0x30000003, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xf3f00000, 0xc0c00000, 0x00000000, 0x00000000, 0x00303c3c, 
0x0f030000, 0x00300000, 0x03000c00, 0x3003f003, 0xfc0cfcfc, 0xf3f30030, 0xccc00000, 0x00000000, 
0x00000000, 0x00300cc3, 0x30c30033, 0x003000c0, 0x03000c00, 0x300c0c03, 0xf3fcfff3, 0xf3f30030, 
0xccc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c30033, 0x003000c0, 0x03000c00, 0x30000c03, 
0xf3fc3cc0, 0xc0f33cfc, 0x0cc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c30033, 0x003000c0, 
0x03000c00, 0x30000c03, 0xfc3cccf3, 0xf3f33330, 0x0cc00000, 0x00000000, 0x00000000, 0x00300c0c, 
0x0f030000, 0x00303fff, 0x03000c00, 0x30003003, 0xffccccf3, 0xf3f33330, 0x0cc00000, 0x00000000, 
0x00000000, 0x00300c30, 0x00c30000, 0x003000c0, 0x03000c00, 0x3000c003, 0xffccccf3, 0xf3f33330, 
0x0cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x00c30000, 0x003000c0, 0x03000c00, 0x3000c003, 
0xf03cccf3, 0xfcf3330c, 0x0cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x30c30000, 0x003000c0, 
0x03000c00, 0x30000003, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 0x00000000, 0x00300cff, 
0x0f030000, 0x00300000, 0x03000c00, 0x3000c003, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };

const key2[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 
0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc00fc00c, 0x0c30c0c0, 0x0ff00c00, 0xff00c03f, 0xf00c0303, 0x00c03030, 0x0c003000, 0xc00fc00c, 
0x00ff00c0, 0x00000003, 0xc030300c, 0x0c30c0c0, 0x0c000c00, 0xc0c0c003, 0x000c0303, 0x00c03030, 
0x0c003000, 0xc030300c, 0x00c0c0c0, 0x03000003, 0xc030300c, 0x0c30c0c0, 0x0c000c00, 0xc0c0c003, 
0x000c0303, 0x00c03030, 0x0c003000, 0xc030300c, 0x00c0c0c0, 0x0f000003, 0xc030300c, 0x0c30c0c0, 
0x0c000c00, 0xc0c0c003, 0x000c00cc, 0x00c03030, 0x0c003000, 0xc030300c, 0x00c0c0c0, 0x3f000003, 
0xc03c300c, 0x0cccc0c0, 0x0ff00c00, 0xff00c003, 0x000c0030, 0x00c03030, 0x0c003000, 0xc030300c, 
0x00ff00c0, 0xffffff03, 0xc033300c, 0x0cccc0c0, 0x0c000c00, 0xc0c0c003, 0x000c0030, 0x00c03030, 
0x0c003000, 0xc030300c, 0x00c000c0, 0x3f000003, 0xc030f00c, 0x0cccc0c0, 0x0c000c00, 0xc0c0c003, 
0x000c0030, 0x00c03030, 0x0c003000, 0xc030300c, 0x00c000c0, 0x0f000003, 0xc030300c, 0x030300c0, 
0x0c000c00, 0xc0c0c003, 0x000c0030, 0x00c03030, 0x0c003000, 0xc030300c, 0x00c000c0, 0x03000003, 
0xc00fcc0c, 0x030300c0, 0x0ff00c00, 0xc0c0c003, 0x000c0030, 0x00c00fc0, 0x0c003000, 0xc00fc00c, 
0x00c000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc00fc00c, 0x00ff00c0, 
0x3fc00c00, 0xff00c00f, 0xc00c0303, 0x00c03ff0, 0x0c030300, 0xc030000c, 0x000000c0, 0x00000003, 
0xc030300c, 0x030000c0, 0x30300c00, 0xc000c030, 0x000c0303, 0x00c000c0, 0x0c030300, 0xc030000c, 
0x000000c0, 0x03000303, 0xc030300c, 0x030000c0, 0x30300c00, 0xc000c030, 0x000c0303, 0x00c000c0, 
0x0c030c00, 0xc030000c, 0x000000c0, 0x0f000303, 0xc030300c, 0x030000c0, 0x30300c00, 0xc000c030, 
0x000c0303, 0x00c000c0, 0x0c033000, 0xc030000c, 0x000000c0, 0x3f000303, 0xc030300c, 0x00fc00c0, 
0x30300c00, 0xff00c033, 0xf00c03ff, 0x00c000c0, 0x0c03c000, 0xc030000c, 0x000000c0, 0xffffff03, 
0xc03ff00c, 0x000300c0, 0x30300c00, 0xc000c030, 0x300c0303, 0x00c000c0, 0x0c033000, 0xc030000c, 
0x000000c0, 0x3f000003, 0xc030300c, 0x000300c0, 0x30300c00, 0xc000c030, 0x300c0303, 0x00c000c0, 
0x0c030c00, 0xc030000c, 0x000000c0, 0x0f000003, 0xc030300c, 0x000300c0, 0x30300c00, 0xc000c030, 
0x300c0303, 0x00c030c0, 0x0c030300, 0xc030000c, 0x000000c0, 0x03000003, 0xc030300c, 0x03fc00c0, 
0x3fc00c00, 0xc000c00f, 0xc00c0303, 0x00c00f00, 0x0c030300, 0xc03ff00c, 0x0fffc0c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xff00ffc0, 0x300c0c03, 0x003f0030, 
0x0c0c0300, 0xff00300c, 0x03030300, 0x3030000c, 0x03003000, 0x30000003, 0xfc3fffff, 0xff0000c0, 
0x300c0c03, 0x00c0c030, 0x0c0c0300, 0xc0c0300f, 0x030303c0, 0xf0300030, 0x03000c00, 0x30000003, 
0xf3cfffff, 0xff0000c0, 0x300c0c03, 0x00c00030, 0x0c0c0300, 0xc0c0300f, 0x03030333, 0x303000c0, 
0x03000300, 0x3000f003, 0xf3fc3c3f, 0x0f000300, 0x30033003, 0x00c00030, 0x03300300, 0xc0c0300c, 
0xc303030c, 0x30300300, 0x030000c0, 0x3000f003, 0xf3ffcccc, 0xff000c00, 0x3000c003, 0x00c00030, 
0x03300300, 0xff00300c, 0xc3030300, 0x30300c00, 0x03000030, 0x30000003, 0xf3fc0ccf, 0x3f003000, 
0x30033003, 0x00c00030, 0x03300300, 0xc0c0300c, 0x33030300, 0x30300300, 0x030000c0, 0x3000f003, 
0xf3cccc3f, 0xcf00c000, 0x300c0c03, 0x00c00030, 0x00c00300, 0xc0c0300c, 0x33030300, 0x303000c0, 
0x03000300, 0x3000f003, 0xfc3c0cfc, 0x3f00c000, 0x300c0c03, 0x00c0c030, 0x00c00300, 0xc0c0300c, 
0x0f030300, 0x30300030, 0x03000c00, 0x30000003, 0xfffffcff, 0xff00ffc0, 0x300c0c03, 0x003f0030, 
0x00c00300, 0xff00300c, 0x0f030300, 0x3030000c, 0x03003000, 0x30000003, 0xffffffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0xc0c00000, 0x00000000, 0x00000000, 0x00303c3c, 
0x0f030000, 0x00300000, 0x03000c00, 0x3003f003, 0xc3f30303, 0x0c330030, 0xccc00000, 0x00000000, 
0x00000000, 0x00300cc3, 0x30c30033, 0x003000c0, 0x03000c00, 0x300c0c03, 0xcc03000c, 0x0c330030, 
0xccc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c30033, 0x003000c0, 0x03000c00, 0x30000c03, 
0xcc03c33f, 0x3f333cfc, 0x0cc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c30033, 0x003000c0, 
0x03000c00, 0x30000c03, 0xc3c3330c, 0x0c333330, 0x0cc00000, 0x00000000, 0x00000000, 0x00300c0c, 
0x0f030000, 0x00303fff, 0x03000c00, 0x30003003, 0xc033330c, 0x0c333330, 0x0cc00000, 0x00000000, 
0x00000000, 0x00300c30, 0x00c30000, 0x003000c0, 0x03000c00, 0x3000c003, 0xc033330c, 0x0c333330, 
0x0cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x00c30000, 0x003000c0, 0x03000c00, 0x3000c003, 
0xcfc3330c, 0x0333330c, 0x0cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x30c30000, 0x003000c0, 
0x03000c00, 0x30000003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300cff, 
0x0f030000, 0x00300000, 0x03000c00, 0x3000c003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };

const key3[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 
0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c003, 0x000c0000, 0x00c00000, 0x0c003000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c003, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x03000003, 0xc00fc00c, 0x030300c0, 0x03c00c00, 0xcc00c00f, 
0xf00c00c3, 0x00c00c30, 0x0c003000, 0xc003c00c, 0x00fc00c0, 0x0f000003, 0xc030c00c, 0x030300c0, 
0x0c300c00, 0xf000c003, 0x000c00c3, 0x00c00c30, 0x0c003000, 0xc00c300c, 0x00c300c0, 0x3f000003, 
0xc030c00c, 0x033300c0, 0x0c300c00, 0xc000c003, 0x000c00c3, 0x00c00c30, 0x0c003000, 0xc00c300c, 
0x00c300c0, 0xffffff03, 0xc030c00c, 0x033300c0, 0x0ff00c00, 0xc000c003, 0x000c00c3, 0x00c00c30, 
0x0c003000, 0xc00c300c, 0x00c300c0, 0x3f000003, 0xc00fc00c, 0x00cc00c0, 0x0c000c00, 0xc000c003, 
0x300c003f, 0x00c00c30, 0x0c003000, 0xc00c300c, 0x00fc00c0, 0x0f000003, 0xc000c00c, 0x00cc00c0, 
0x03f00c00, 0xc000c000, 0xc00c0003, 0x00c003c0, 0x0c003000, 0xc003c00c, 0x00c000c0, 0x03000003, 
0xc000c00c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c003c, 0x00c00000, 0x0c000000, 0xc000000c, 
0x00c000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 
0x00300c00, 0x0c00c000, 0x000c00c0, 0x00c00030, 0x0c00c000, 0xc003000c, 0x000000c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00300c00, 0x3300c000, 0x000c00c0, 0x00c00000, 0x0c00c000, 0xc003000c, 
0x000000c0, 0x03000303, 0xc00f000c, 0x003c00c0, 0x03f00c00, 0x3000c003, 0xc00c00fc, 0x00c00030, 
0x0c00c300, 0xc003000c, 0x000000c0, 0x0f000303, 0xc000c00c, 0x00c300c0, 0x0c300c00, 0xff00c00c, 
0x300c00c3, 0x00c00030, 0x0c00c300, 0xc003000c, 0x000000c0, 0x3f000303, 0xc00fc00c, 0x003000c0, 
0x0c300c00, 0x3000c00c, 0x300c00c3, 0x00c00030, 0x0c00cc00, 0xc003000c, 0x03ff00c0, 0xffffff03, 
0xc030c00c, 0x000c00c0, 0x0c300c00, 0x3000c00c, 0x300c00c3, 0x00c00030, 0x0c00f000, 0xc003000c, 
0x000000c0, 0x3f000003, 0xc030c00c, 0x00c300c0, 0x0c300c00, 0x3000c003, 0xf00c00c3, 0x00c00030, 
0x0c00cc00, 0xc003000c, 0x000000c0, 0x0f000003, 0xc00fc00c, 0x003c00c0, 0x03f00c00, 0x3000c000, 
0x300c00c3, 0x00c00330, 0x0c00c300, 0xc003000c, 0x000000c0, 0x03000003, 0xc000000c, 0x000000c0, 
0x00000c00, 0x0000c00f, 0xc00c0000, 0x00c000c0, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xff000000, 0x30000003, 0x00000030, 
0x00000300, 0x30003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xfc3fffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x30003000, 0x00030000, 0x00300000, 0x03000000, 0x3003c003, 
0xf3cfffff, 0xff003fc0, 0x300c0c03, 0x000fc030, 0x0c0c0300, 0x3f003003, 0xf003003f, 0xc0300000, 
0x03000000, 0x3003c003, 0xf3fc3c3f, 0x0f0000c0, 0x30033003, 0x00300030, 0x0c0c0300, 0x30c03003, 
0x0c030033, 0x30300000, 0x03000000, 0x30000003, 0xf3ffcccc, 0xff000300, 0x3000c003, 0x00300030, 
0x03300300, 0x30c03003, 0x0c030033, 0x30300000, 0x03000000, 0x3003c003, 0xf3fc0ccf, 0x3f000c00, 
0x3000c003, 0x00300030, 0x03300300, 0x30c03003, 0x0c030033, 0x303003c0, 0x03000f00, 0x3003c003, 
0xf3cccc3f, 0xcf003000, 0x30033003, 0x00300030, 0x00c00300, 0x30c03003, 0x0c030033, 0x303003c0, 
0x03000f00, 0x3000c003, 0xfc3c0cfc, 0x3f003fc0, 0x300c0c03, 0x000fc030, 0x00c00300, 0x3f003003, 
0x0c030033, 0x303000c0, 0x03000000, 0x30030003, 0xfffffcff, 0xff000000, 0x30000003, 0x00000030, 
0x00000300, 0x00003000, 0x00030000, 0x00300300, 0x03000000, 0x30000003, 0xffffffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 0xc0c00000, 0x00000000, 0x00000000, 0x00303c3c, 
0x0f03000f, 0x00300000, 0x03003000, 0x30000c03, 0xfc0cfcfc, 0xf3f30030, 0xccc00000, 0x00000000, 
0x00000000, 0x00300cc3, 0x30c3000f, 0x00300000, 0x03003000, 0x30000c03, 0xf3fcfff3, 0xf3f30030, 
0xccc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c30003, 0x00300000, 0x03003000, 0x30000c03, 
0xf3fc3cc0, 0xc0f33cfc, 0x0cc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c3000c, 0x00300fff, 
0x03000c00, 0x30003003, 0xfc3cccf3, 0xf3f33330, 0x0cc00000, 0x00000000, 0x00000000, 0x00300c0c, 
0x0f030000, 0x00300000, 0x03000c00, 0x30003003, 0xffccccf3, 0xf3f33330, 0x0cc00000, 0x00000000, 
0x00000000, 0x00300c30, 0x00c30000, 0x00300fff, 0x03000c00, 0x30003003, 0xffccccf3, 0xf3f33330, 
0x0cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x00c30000, 0x00300000, 0x03000300, 0x3000c003, 
0xf03cccf3, 0xfcf3330c, 0x0cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x30c30000, 0x00300000, 
0x03000300, 0x3000c003, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 0x00000000, 0x00300cff, 
0x0f030000, 0x00300000, 0x03000300, 0x3000c003, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };

const UWORD key4[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 
0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc00f000c, 0x00fc00c0, 0x0fc00c00, 0x0300c03f, 0xc00c00fc, 0x00c00ff0, 0x0c00fc00, 0xc00fc00c, 
0x00fc00c0, 0x00000003, 0xc003000c, 0x030300c0, 0x30300c00, 0x0f00c030, 0x000c0300, 0x00c00030, 
0x0c030300, 0xc030300c, 0x030300c0, 0x03000003, 0xc003000c, 0x000300c0, 0x00300c00, 0x3300c030, 
0x000c0300, 0x00c00030, 0x0c030300, 0xc030300c, 0x030300c0, 0x0f000003, 0xc003000c, 0x000c00c0, 
0x00300c00, 0xc300c030, 0x000c0300, 0x00c000c0, 0x0c030300, 0xc030300c, 0x030300c0, 0x3f000003, 
0xc003000c, 0x003000c0, 0x0fc00c03, 0x0300c03f, 0xc00c03fc, 0x00c000c0, 0x0c00fc00, 0xc00fc00c, 
0x030300c0, 0xffffff03, 0xc003000c, 0x00c000c0, 0x00300c03, 0xffc0c000, 0x300c0303, 0x00c000c0, 
0x0c030300, 0xc000300c, 0x030300c0, 0x3f000003, 0xc003000c, 0x030000c0, 0x00300c00, 0x0300c000, 
0x300c0303, 0x00c00300, 0x0c030300, 0xc000300c, 0x030300c0, 0x0f000003, 0xc003000c, 0x030000c0, 
0x30300c00, 0x0300c000, 0x300c0303, 0x00c00300, 0x0c030300, 0xc000300c, 0x030300c0, 0x03000003, 
0xc003000c, 0x03ff00c0, 0x0fc00c00, 0x0300c03f, 0xc00c00fc, 0x00c00300, 0x0c00fc00, 0xc00fc00c, 
0x00fc00c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc003000c, 0x00fc00c0, 
0x03300c00, 0x3000c030, 0x0c0c0000, 0x00c00f00, 0x0c0c00c0, 0xc000c00c, 0x00c000c0, 0x00000003, 
0xc003000c, 0x030300c0, 0x03300c00, 0xff00c0cc, 0x0c0c0030, 0x00c030c0, 0x0c030300, 0xc003000c, 
0x003000c0, 0x03000303, 0xc003000c, 0x0cfcc0c0, 0x3ffc0c03, 0x3000c0cc, 0x300c00cc, 0x00c03300, 
0x0c00cc00, 0xc00c000c, 0x000c00c0, 0x0f000303, 0xc003000c, 0x330c30c0, 0x03300c03, 0x3000c030, 
0xc00c0303, 0x00c00c00, 0x0c003000, 0xc00c000c, 0x000c00c0, 0x3f000303, 0xc003000c, 0x330c30c0, 
0x0cc00c00, 0xfc00c003, 0x000c0c00, 0xc0c03300, 0x0c0fcfc0, 0xc00c000c, 0x000c00c0, 0xffffff03, 
0xc003000c, 0x330c30c0, 0x33000c00, 0x3300c00c, 0x300c3000, 0x30c0c0cc, 0x0c003000, 0xc00c000c, 
0x000c00c0, 0x3f000003, 0xc003000c, 0x0cf3c0c0, 0xfff00c00, 0x3300c030, 0xcc0c0000, 0x00c0c030, 
0x0c00cc00, 0xc00c000c, 0x000c00c0, 0x0f000003, 0xc000000c, 0x030000c0, 0x33000c03, 0xfc00c0c0, 
0xcc0c0000, 0x00c030cc, 0x0c030300, 0xc003000c, 0x003000c0, 0x03000003, 0xc003000c, 0x00fc00c0, 
0x33000c00, 0x3000c0c0, 0x300c0000, 0x00c00f03, 0x0c0c00c0, 0xc000c00c, 0x00c000c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x03000000, 0x30000003, 0x00000030, 
0x00000303, 0x00303000, 0xff03003f, 0x003003f0, 0x03000300, 0x30030003, 0xc3f00000, 0x03000000, 
0x3000c003, 0x0000fc30, 0x30c00300, 0xc0c03003, 0x00030030, 0x00300030, 0x03000c00, 0x3000c003, 
0xcc030cff, 0x03000c00, 0x3000c003, 0x0000c030, 0xccc00300, 0x33003003, 0x00030030, 0x00300030, 
0x03000c00, 0x3000c003, 0xcc030ccc, 0xc3000000, 0x300ffc03, 0x00030030, 0x33000303, 0xfff0300f, 
0xfc030030, 0x00300030, 0x03000c00, 0x3000c003, 0xc3c30ccc, 0xc300ffc0, 0x3000c003, 0x00030030, 
0x03000300, 0x0c003003, 0x00030030, 0x00300030, 0x03003000, 0x30003003, 0xc0330ccc, 0xc3000000, 
0x3000c003, 0x03cc0030, 0x0c000303, 0xfff03003, 0x00030030, 0x00300030, 0x03000c00, 0x3000c003, 
0xc030fccc, 0xc3000c00, 0x30000003, 0x00cc0030, 0x0cc30300, 0x0c003003, 0x00030030, 0x00300030, 
0x03000c00, 0x3000c003, 0xcfc00ccc, 0xc3000000, 0x300ffc03, 0x00300030, 0x333cc300, 0x0c003003, 
0x00030030, 0x00300030, 0x03000c00, 0x3000c003, 0xc000f000, 0x03000000, 0x30000003, 0x00300030, 
0x30c30300, 0x0c00300f, 0xff03003f, 0x003003f0, 0x03000300, 0x30030003, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300030, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0xc0c00000, 0x00000000, 0x00000000, 0x00300030, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc3f30303, 0x0c330030, 0xccc00000, 0x00000000, 
0x00000000, 0x00300030, 0x0003000c, 0x303030c0, 0x03000000, 0x30000003, 0xcc03000c, 0x0c330030, 
0xccc00000, 0x00000000, 0x00000000, 0x00303c3f, 0x03c30030, 0xc0300c30, 0x030030c0, 0x300f3c03, 
0xcc03c33f, 0x3f333cfc, 0x0cc00000, 0x00000000, 0x00000000, 0x00300330, 0xcc0300c3, 0x0030030c, 
0x0300c300, 0x300f3c03, 0xc3c3330c, 0x0c333330, 0x0cc00000, 0x00000000, 0x00000000, 0x00303f30, 
0xcc03030c, 0x003000c3, 0x0300f3c0, 0x30030c03, 0xc033330c, 0x0c333330, 0x0cc00000, 0x00000000, 
0x00000000, 0x0030c330, 0xcc0300c3, 0x0030030c, 0x0300f3c0, 0x300c3003, 0xc033330c, 0x0c333330, 
0x0cc00000, 0x00000000, 0x00000000, 0x0030c330, 0xcc030030, 0xc0300c30, 0x03000000, 0x30000003, 
0xcfc3330c, 0x0333330c, 0x0cc00000, 0x00000000, 0x00000000, 0x00303f3f, 0x03c3000c, 0x303030c0, 
0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };

const UWORD key5[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000c00c, 0x00c000c0, 
0x00000c00, 0x0000c000, 0xc00c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc003000c, 0x003000c0, 0x00000c00, 0x0c00c003, 0x300c0033, 0x00c000c0, 0x0c00c000, 0xc000000c, 
0x003000c0, 0x00000003, 0xc00c000c, 0x000c00c0, 0x03300c00, 0x3300c000, 0xc00c00cc, 0x00c00300, 
0x0c003000, 0xc00cc00c, 0x00cc00c0, 0x03000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x0f000003, 0xc003c00c, 0x003c00c0, 
0x03c00c00, 0x3c00c003, 0xc00c003c, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x3f000003, 
0xc000300c, 0x000300c0, 0x00300c00, 0x0300c000, 0x300c0003, 0x00c00300, 0x0c003000, 0xc003000c, 
0x003000c0, 0xffffff03, 0xc003f00c, 0x003f00c0, 0x03f00c00, 0x3f00c003, 0xf00c003f, 0x00c00300, 
0x0c003000, 0xc003000c, 0x003000c0, 0x3f000003, 0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 
0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x0f000003, 0xc00c300c, 0x00c300c0, 
0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x03000003, 
0xc003f00c, 0x003f00c0, 0x03f00c00, 0x3f00c003, 0xf00c003f, 0x00c00300, 0x0c003000, 0xc003000c, 
0x003000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000c00c, 0x003000c0, 
0x00000c00, 0x3000c000, 0xc00c0030, 0x00c00000, 0x0c000c00, 0xc000c00c, 0x000000c0, 0x00000003, 
0xc003000c, 0x000c00c0, 0x0cc00c00, 0xcc00c003, 0x000c000c, 0x00c00c30, 0x0c003300, 0xc003000c, 
0x00c300c0, 0x03000303, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x0f000303, 0xc003c00c, 0x003c00c0, 0x03c00c00, 0x3c00c00c, 
0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c300c, 0x00c300c0, 0x3f000303, 0xc00c300c, 0x00c300c0, 
0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c300c, 0x00c300c0, 0xffffff03, 
0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c300c, 
0x00c300c0, 0x3f000003, 0xc00ff00c, 0x00ff00c0, 0x0ff00c00, 0xff00c00c, 0x300c00c3, 0x00c00c30, 
0x0c00c300, 0xc00c300c, 0x00c300c0, 0x0f000003, 0xc00c000c, 0x00c000c0, 0x0c000c00, 0xc000c00c, 
0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc003f00c, 0x003f00c0, 0x03000003, 0xc003f00c, 0x003f00c0, 
0x03f00c00, 0x3f00c003, 0xc00c003c, 0x00c003c0, 0x0c003c00, 0xc000300c, 0x000300c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc003c00c, 
0x003c00c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x03000300, 0x3000c003, 0x00000030, 
0x00300300, 0x0cc03003, 0x3003000c, 0xc0300000, 0x03000000, 0x30000003, 0xc3c00000, 0x03000c00, 
0x30003003, 0x0030c030, 0x00cc0300, 0x33003000, 0xcc030003, 0x00300000, 0x03000000, 0x30000003, 
0xcc300000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300030, 
0x03003000, 0x30000003, 0xcc03c3c0, 0xf3000f00, 0x3000f003, 0x000f0030, 0x00f00300, 0x0f003003, 
0xf003000f, 0x003000c0, 0x03000c00, 0x30030c03, 0xcc003333, 0x030030c0, 0x30030c03, 0x0030c030, 
0x030c0300, 0x30c03003, 0x0c030030, 0xc0300300, 0x03000300, 0x30000003, 0xcc03f330, 0xc30030c0, 
0x30030c03, 0x0030c030, 0x030c0300, 0x30c03003, 0x0c03000c, 0x00300000, 0x03000000, 0x30000003, 
0xcc3333c0, 0x330030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c03003, 0x0c030003, 0x00300000, 
0x03000000, 0x30000003, 0xc3c3f303, 0xc30030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c03003, 
0x0c030030, 0xc0300000, 0x03000000, 0x30000003, 0xc0000300, 0x03000f00, 0x3000f003, 0x000f0030, 
0x00f00300, 0x0f003003, 0x0c03000f, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x003000c0, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x003000c0, 0x00c00000, 0x00000000, 0x00000000, 0x00303c3c, 
0x0f03000c, 0x00300000, 0x03000000, 0x30000003, 0xc3f30303, 0x0c3000c0, 0x00c00000, 0x00000000, 
0x00000000, 0x00300cc3, 0x30c30000, 0x00300000, 0x03000000, 0x30000003, 0xcc03000c, 0x0c30f0f0, 
0x3cc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c3000c, 0x003000c0, 0x03000f00, 0x30000003, 
0xcc03c33f, 0x3f300ccc, 0xc0c00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c3000c, 0x00300330, 
0x030030c0, 0x3000cc03, 0xc3c3330c, 0x0c30fccc, 0xc0c00000, 0x00000000, 0x00000000, 0x00300c0c, 
0x0f030030, 0x00300c0c, 0x03000f00, 0x30033003, 0xc033330c, 0x0c330ccc, 0xc0c00000, 0x00000000, 
0x00000000, 0x00300c30, 0x00c300c0, 0x00300000, 0x03000000, 0x30000003, 0xc033330c, 0x0c330ccc, 
0xc0c00000, 0x00000000, 0x00000000, 0x00300cc0, 0x00c300c0, 0x00300000, 0x03000000, 0x30000003, 
0xcfc3330c, 0x0330fcf0, 0x3cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x30c300c0, 0xc0300000, 
0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300cff, 
0x0f03003f, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };

const UWORD key6[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c003, 
0xc00c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000c00c, 0x003000c0, 
0x00000c00, 0x3000c00c, 0x300c0033, 0x00c000c0, 0x0c00c000, 0xc00cc00c, 0x003000c0, 0x00000003, 
0xc003000c, 0x000c00c0, 0x0c300c00, 0xcc00c003, 0xc00c00cc, 0x00c00300, 0x0c003000, 0xc000000c, 
0x00cc00c0, 0x00000003, 0xc00c000c, 0x000300c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00c00, 
0x0c000c00, 0xc000000c, 0x030300c0, 0x03000003, 0xc003c00c, 0x003c00c0, 0x03c00c00, 0x3c00c003, 
0xc00c003c, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x0f000003, 0xc00c300c, 0x00c300c0, 
0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x3f000003, 
0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 
0x003000c0, 0xffffff03, 0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 
0x0c003000, 0xc003000c, 0x003000c0, 0x3f000003, 0xc00ff00c, 0x00ff00c0, 0x0ff00c00, 0xff00c00f, 
0xf00c00ff, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x0f000003, 0xc00c300c, 0x00c300c0, 
0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x03000003, 
0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 
0x003000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000c00c, 0x00c000c0, 0x00000c00, 0x0000c000, 0x300c00c0, 0x00c00000, 
0x0c000000, 0xc000300c, 0x000000c0, 0x00000003, 0xc003000c, 0x003000c0, 0x00000c00, 0x3000c000, 
0xc00c0030, 0x00c00000, 0x0c003000, 0xc000c00c, 0x000000c0, 0x00000003, 0xc00c000c, 0x000c00c0, 
0x0cc00c00, 0xcc00c003, 0x000c000c, 0x00c00c30, 0x0c00cc00, 0xc003000c, 0x00cc00c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x03000303, 0xc00fc00c, 0x00fc00c0, 0x0fc00c00, 0xfc00c00c, 0x300c00c3, 0x00c00c30, 
0x0c00c300, 0xc00c0c0c, 0x030300c0, 0x0f000303, 0xc00c000c, 0x00c000c0, 0x0c000c00, 0xc000c00c, 
0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c0c0c, 0x030300c0, 0x3f000303, 0xc00c000c, 0x00c000c0, 
0x0c000c00, 0xc000c00c, 0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c0c0c, 0x030300c0, 0xffffff03, 
0xc00fc00c, 0x00fc00c0, 0x0fc00c00, 0xfc00c00c, 0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc003300c, 
0x00cc00c0, 0x3f000003, 0xc00c000c, 0x00c000c0, 0x0c000c00, 0xc000c00c, 0x300c00c3, 0x00c00c30, 
0x0c00c300, 0xc000c00c, 0x003000c0, 0x0f000003, 0xc00c000c, 0x00c000c0, 0x0c000c00, 0xc000c00c, 
0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc000c00c, 0x003000c0, 0x03000003, 0xc00fc00c, 0x00fc00c0, 
0x0fc00c00, 0xfc00c003, 0xc00c003c, 0x00c003c0, 0x0c003c00, 0xc000c00c, 0x003000c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000300, 0x3000c003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x03000c00, 0x30003003, 0x00000030, 0x00c00300, 0x0cc03003, 
0xcc030033, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x03003000, 0x30000c03, 0x0030c030, 
0x03300300, 0x3300300c, 0xf003000c, 0x00300000, 0x03000000, 0x30000003, 0xc3c00000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xcc300000, 0x03000f00, 0x3000f003, 0x000f0030, 0x00f00300, 0x0f00300c, 0x0c03003f, 0xc0300030, 
0x03003000, 0x30000003, 0xcc03c3c0, 0xf30030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c0300f, 
0x0c0300c0, 0x003000c0, 0x03000c00, 0x30030c03, 0xcc003333, 0x030030c0, 0x30030c03, 0x0030c030, 
0x030c0300, 0x30c0300f, 0x0c0300c0, 0x00300300, 0x03000300, 0x30000003, 0xcc03f330, 0xc30030c0, 
0x30030c03, 0x0030c030, 0x030c0300, 0x30c0300c, 0xcc03003f, 0x00300000, 0x03000000, 0x30000003, 
0xcc3333c0, 0x330030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c0300c, 0xcc030000, 0xc0300000, 
0x03000000, 0x30000003, 0xc3c3f303, 0xc30030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c0300c, 
0x3c030000, 0xc0300000, 0x03000000, 0x30000003, 0xc0000300, 0x03000f00, 0x3000f003, 0x000f0030, 
0x00f00300, 0x0f00300c, 0x3c0300ff, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xfff000c0, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x0003003f, 0xc0300000, 
0x03000000, 0x30000003, 0xffffffff, 0xfff000c0, 0x00c00000, 0x00000000, 0x00000000, 0x00303c3c, 
0x0f030030, 0x30300000, 0x03000000, 0x30000003, 0xfc0cfcfc, 0xf3f000c0, 0x00c00000, 0x00000000, 
0x00000000, 0x00300cc3, 0x30c30030, 0x30300000, 0x03000000, 0x30000003, 0xf3fcfff3, 0xf3f0f0f0, 
0x3cc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c30030, 0x303000c0, 0x03000f00, 0x30000003, 
0xf3fc3cc0, 0xc0f00ccc, 0xc0c00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c300fc, 0x30300330, 
0x030030c0, 0x3000cc03, 0xfc3cccf3, 0xf3f0fccc, 0xc0c00000, 0x00000000, 0x00000000, 0x00300c0c, 
0x0f030030, 0x30300c0c, 0x03000f00, 0x30033003, 0xffccccf3, 0xf3f30ccc, 0xc0c00000, 0x00000000, 
0x00000000, 0x00300c30, 0x00c30030, 0x30300000, 0x03000000, 0x30000003, 0xffccccf3, 0xf3f30ccc, 
0xc0c00000, 0x00000000, 0x00000000, 0x00300cc0, 0x00c30030, 0x30300000, 0x03000000, 0x30000003, 
0xf03cccf3, 0xfcf0fcf0, 0x3cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x30c3003f, 0xc0300000, 
0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 0x00000000, 0x00300cff, 
0x0f030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };

const UWORD key7[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c003, 
0xc00c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000c00c, 0x003000c0, 
0x00000c00, 0x3000c00c, 0x300c0033, 0x00c000c0, 0x0c00c000, 0xc00cc00c, 0x003000c0, 0x00000003, 
0xc003000c, 0x000c00c0, 0x0c300c00, 0xcc00c003, 0xc00c00cc, 0x00c00300, 0x0c003000, 0xc000000c, 
0x00cc00c0, 0x00000003, 0xc00c000c, 0x000300c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00c00, 
0x0c000c00, 0xc000000c, 0x030300c0, 0x03000003, 0xc003c00c, 0x003c00c0, 0x03c00c00, 0x3c00c003, 
0xc00c003c, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x0f000003, 0xc00c300c, 0x00c300c0, 
0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x3f000003, 
0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 
0x003000c0, 0xffffff03, 0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 
0x0c003000, 0xc003000c, 0x003000c0, 0x3f000003, 0xc00ff00c, 0x00ff00c0, 0x0ff00c00, 0xff00c00f, 
0xf00c00ff, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x0f000003, 0xc00c300c, 0x00c300c0, 
0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x03000003, 
0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 
0x003000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000c00c, 0x00c000c0, 0x00000c00, 0x0000c000, 0x300c00c0, 0x00c00000, 
0x0c000000, 0xc000300c, 0x000000c0, 0x00000003, 0xc003000c, 0x003000c0, 0x00000c00, 0x3000c000, 
0xc00c0030, 0x00c00000, 0x0c003000, 0xc000c00c, 0x000000c0, 0x00000003, 0xc00c000c, 0x000c00c0, 
0x0cc00c00, 0xcc00c003, 0x000c000c, 0x00c00c30, 0x0c00cc00, 0xc003000c, 0x00cc00c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x03000303, 0xc00fc00c, 0x00fc00c0, 0x0fc00c00, 0xfc00c00c, 0x300c00c3, 0x00c00c30, 
0x0c00c300, 0xc00c0c0c, 0x030300c0, 0x0f000303, 0xc00c000c, 0x00c000c0, 0x0c000c00, 0xc000c00c, 
0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c0c0c, 0x030300c0, 0x3f000303, 0xc00c000c, 0x00c000c0, 
0x0c000c00, 0xc000c00c, 0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c0c0c, 0x030300c0, 0xffffff03, 
0xc00fc00c, 0x00fc00c0, 0x0fc00c00, 0xfc00c00c, 0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc003300c, 
0x00cc00c0, 0x3f000003, 0xc00c000c, 0x00c000c0, 0x0c000c00, 0xc000c00c, 0x300c00c3, 0x00c00c30, 
0x0c00c300, 0xc000c00c, 0x003000c0, 0x0f000003, 0xc00c000c, 0x00c000c0, 0x0c000c00, 0xc000c00c, 
0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc000c00c, 0x003000c0, 0x03000003, 0xc00fc00c, 0x00fc00c0, 
0x0fc00c00, 0xfc00c003, 0xc00c003c, 0x00c003c0, 0x0c003c00, 0xc000c00c, 0x003000c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xff000300, 0x3000c003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xff000c00, 0x30003003, 0x00000030, 0x00c00300, 0x0cc03003, 
0xcc030033, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xff003000, 0x30000c03, 0x0030c030, 
0x03300300, 0x3300300c, 0xf003000c, 0x00300000, 0x03000000, 0x30000003, 0xfc3fffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xf3cfffff, 0xff000f00, 0x3000f003, 0x000f0030, 0x00f00300, 0x0f00300c, 0x0c03003f, 0xc0300030, 
0x03003000, 0x30000003, 0xf3fc3c3f, 0x0f0030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c0300f, 
0x0c0300c0, 0x003000c0, 0x03000c00, 0x30030c03, 0xf3ffcccc, 0xff0030c0, 0x30030c03, 0x0030c030, 
0x030c0300, 0x30c0300f, 0x0c0300c0, 0x00300300, 0x03000300, 0x30000003, 0xf3fc0ccf, 0x3f0030c0, 
0x30030c03, 0x0030c030, 0x030c0300, 0x30c0300c, 0xcc03003f, 0x00300000, 0x03000000, 0x30000003, 
0xf3cccc3f, 0xcf0030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c0300c, 0xcc030000, 0xc0300000, 
0x03000000, 0x30000003, 0xfc3c0cfc, 0x3f0030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c0300c, 
0x3c030000, 0xc0300000, 0x03000000, 0x30000003, 0xfffffcff, 0xff000f00, 0x3000f003, 0x000f0030, 
0x00f00300, 0x0f00300c, 0x3c0300ff, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x003000c0, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x0003003f, 0xc0300000, 
0x03000000, 0x30000003, 0xc0000000, 0x003000c0, 0x00c00000, 0x00000000, 0x00000000, 0x00303c3c, 
0x0f030030, 0x30300000, 0x03000000, 0x30000003, 0xc3f30303, 0x0c3000c0, 0x00c00000, 0x00000000, 
0x00000000, 0x00300cc3, 0x30c30030, 0x30300000, 0x03000000, 0x30000003, 0xcc03000c, 0x0c30f0f0, 
0x3cc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c30030, 0x303000c0, 0x03000f00, 0x30000003, 
0xcc03c33f, 0x3f300ccc, 0xc0c00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c300fc, 0x30300330, 
0x030030c0, 0x3000cc03, 0xc3c3330c, 0x0c30fccc, 0xc0c00000, 0x00000000, 0x00000000, 0x00300c0c, 
0x0f030030, 0x30300c0c, 0x03000f00, 0x30033003, 0xc033330c, 0x0c330ccc, 0xc0c00000, 0x00000000, 
0x00000000, 0x00300c30, 0x00c30030, 0x30300000, 0x03000000, 0x30000003, 0xc033330c, 0x0c330ccc, 
0xc0c00000, 0x00000000, 0x00000000, 0x00300cc0, 0x00c30030, 0x30300000, 0x03000000, 0x30000003, 
0xcfc3330c, 0x0330fcf0, 0x3cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x30c3003f, 0xc0300000, 
0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300cff, 
0x0f030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };

const UWORD key8[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000c00c, 0x00c000c0, 
0x00000c00, 0x0000c000, 0xc00c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc003000c, 0x003000c0, 0x00000c00, 0x0c00c003, 0x300c0033, 0x00c000c0, 0x0c00c000, 0xc000000c, 
0x003000c0, 0x00000003, 0xc00c000c, 0x000c00c0, 0x03300c00, 0x3300c000, 0xc00c00cc, 0x00c00300, 
0x0c003000, 0xc00cc00c, 0x00cc00c0, 0x03000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x0f000003, 0xc003c00c, 0x003c00c0, 
0x03c00c00, 0x3c00c003, 0xc00c003c, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x3f000003, 
0xc000300c, 0x000300c0, 0x00300c00, 0x0300c000, 0x300c0003, 0x00c00300, 0x0c003000, 0xc003000c, 
0x003000c0, 0xffffff03, 0xc003f00c, 0x003f00c0, 0x03f00c00, 0x3f00c003, 0xf00c003f, 0x00c00300, 
0x0c003000, 0xc003000c, 0x003000c0, 0x3f000003, 0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 
0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x0f000003, 0xc00c300c, 0x00c300c0, 
0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00300, 0x0c003000, 0xc003000c, 0x003000c0, 0x03000003, 
0xc003f00c, 0x003f00c0, 0x03f00c00, 0x3f00c003, 0xf00c003f, 0x00c00300, 0x0c003000, 0xc003000c, 
0x003000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000c00c, 0x003000c0, 
0x00000c00, 0x3000c000, 0xc00c0030, 0x00c00000, 0x0c000c00, 0xc000c00c, 0x000000c0, 0x00000003, 
0xc003000c, 0x000c00c0, 0x0cc00c00, 0xcc00c003, 0x000c000c, 0x00c00c30, 0x0c003300, 0xc003000c, 
0x00c300c0, 0x03000303, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x0f000303, 0xc003c00c, 0x003c00c0, 0x03c00c00, 0x3c00c00c, 
0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c300c, 0x00c300c0, 0x3f000303, 0xc00c300c, 0x00c300c0, 
0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c300c, 0x00c300c0, 0xffffff03, 
0xc00c300c, 0x00c300c0, 0x0c300c00, 0xc300c00c, 0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc00c300c, 
0x00c300c0, 0x3f000003, 0xc00ff00c, 0x00ff00c0, 0x0ff00c00, 0xff00c00c, 0x300c00c3, 0x00c00c30, 
0x0c00c300, 0xc00c300c, 0x00c300c0, 0x0f000003, 0xc00c000c, 0x00c000c0, 0x0c000c00, 0xc000c00c, 
0x300c00c3, 0x00c00c30, 0x0c00c300, 0xc003f00c, 0x003f00c0, 0x03000003, 0xc003f00c, 0x003f00c0, 
0x03f00c00, 0x3f00c003, 0xc00c003c, 0x00c003c0, 0x0c003c00, 0xc000300c, 0x000300c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc003c00c, 
0x003c00c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xff000300, 0x3000c003, 0x00000030, 
0x00300300, 0x0cc03003, 0x3003000c, 0xc0300000, 0x03000000, 0x30000003, 0xfc3fffff, 0xff000c00, 
0x30003003, 0x0030c030, 0x00cc0300, 0x33003000, 0xcc030003, 0x00300000, 0x03000000, 0x30000003, 
0xf3cfffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300030, 
0x03003000, 0x30000003, 0xf3fc3c3f, 0x0f000f00, 0x3000f003, 0x000f0030, 0x00f00300, 0x0f003003, 
0xf003000f, 0x003000c0, 0x03000c00, 0x30030c03, 0xf3ffcccc, 0xff0030c0, 0x30030c03, 0x0030c030, 
0x030c0300, 0x30c03003, 0x0c030030, 0xc0300300, 0x03000300, 0x30000003, 0xf3fc0ccf, 0x3f0030c0, 
0x30030c03, 0x0030c030, 0x030c0300, 0x30c03003, 0x0c03000c, 0x00300000, 0x03000000, 0x30000003, 
0xf3cccc3f, 0xcf0030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c03003, 0x0c030003, 0x00300000, 
0x03000000, 0x30000003, 0xfc3c0cfc, 0x3f0030c0, 0x30030c03, 0x0030c030, 0x030c0300, 0x30c03003, 
0x0c030030, 0xc0300000, 0x03000000, 0x30000003, 0xfffffcff, 0xff000f00, 0x3000f003, 0x000f0030, 
0x00f00300, 0x0f003003, 0x0c03000f, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xff000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xff000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xfff000c0, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xfff000c0, 0x00c00000, 0x00000000, 0x00000000, 0x00303c3c, 
0x0f03000c, 0x00300000, 0x03000000, 0x30000003, 0xfc0cfcfc, 0xf3f000c0, 0x00c00000, 0x00000000, 
0x00000000, 0x00300cc3, 0x30c30000, 0x00300000, 0x03000000, 0x30000003, 0xf3fcfff3, 0xf3f0f0f0, 
0x3cc00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c3000c, 0x003000c0, 0x03000f00, 0x30000003, 
0xf3fc3cc0, 0xc0f00ccc, 0xc0c00000, 0x00000000, 0x00000000, 0x00300c03, 0x00c3000c, 0x00300330, 
0x030030c0, 0x3000cc03, 0xfc3cccf3, 0xf3f0fccc, 0xc0c00000, 0x00000000, 0x00000000, 0x00300c0c, 
0x0f030030, 0x00300c0c, 0x03000f00, 0x30033003, 0xffccccf3, 0xf3f30ccc, 0xc0c00000, 0x00000000, 
0x00000000, 0x00300c30, 0x00c300c0, 0x00300000, 0x03000000, 0x30000003, 0xffccccf3, 0xf3f30ccc, 
0xc0c00000, 0x00000000, 0x00000000, 0x00300cc0, 0x00c300c0, 0x00300000, 0x03000000, 0x30000003, 
0xf03cccf3, 0xfcf0fcf0, 0x3cc00000, 0x00000000, 0x00000000, 0x00300cc0, 0x30c300c0, 0xc0300000, 
0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 0x00000000, 0x00300cff, 
0x0f03003f, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xffffffff, 0xfff00000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };

const UWORD key9[610] = { 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 
0x00000c00, 0x0000c000, 0x000c0000, 0x00c00c00, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 
0xc00ffc0c, 0x003000c0, 0x3fff0c03, 0xfff0c00f, 0xcc0c003c, 0x00c00c00, 0x0c000000, 0xc00fc00c, 
0x00fc00c0, 0x00000003, 0xc003300c, 0x000000c0, 0xc0c00c0c, 0x0c00c030, 0x300c00c3, 0x00c00fc0, 
0x0c3f3030, 0xc030300c, 0x030300c0, 0x03000003, 0xc003300c, 0x003000c0, 0xc0c00c0c, 0x0c00c030, 
0xf00c00c0, 0x00c00c30, 0x0c0c3cf0, 0xc0cf0c0c, 0x0c3cc0c0, 0x0f000003, 0xc003300c, 0x003000c0, 
0xc0c00c0c, 0x0c00c033, 0x300c00c0, 0x00c00c30, 0x0c0c3330, 0xc0cccc0c, 0x0cc0c0c0, 0x3f000003, 
0xc00c300c, 0x003000c0, 0xc0ff0c0c, 0x0ff0c033, 0x300c00c0, 0x00c00c30, 0x0c0c3030, 0xc0cf0c0c, 
0x0cc0c0c0, 0xffffff03, 0xc00c300c, 0x003000c0, 0xffc00c0c, 0x0c00c033, 0x300c00c3, 0x00c00fc0, 
0x0c0c3030, 0xc0cccc0c, 0x0c3cc0c0, 0x3f000003, 0xc00c300c, 0x003000c0, 0xc0c00c0c, 0x0c00c03c, 
0x300c003c, 0x00c00c00, 0x0c0c3030, 0xc030300c, 0x030300c0, 0x0f000003, 0xc00c300c, 0x003000c0, 
0xc0c00c0c, 0x0c00c030, 0x300c0030, 0x00c00c00, 0x0c000000, 0xc00fc00c, 0x00fc00c0, 0x03000003, 
0xc00c300c, 0x003000c0, 0xc0ff0c03, 0xfff0c0cf, 0xc00c00c0, 0x00c00c00, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xc000c00c, 0x000000c0, 
0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 0x00fc00c0, 0x00000003, 
0xc003f00c, 0x000000c0, 0x3cf00c03, 0xcf00c003, 0xcc0c003c, 0x00c00c00, 0x0c003c00, 0xc003c00c, 
0x030300c0, 0x03000303, 0xc00cc00c, 0x00f0c0c0, 0x030c0c0c, 0x30c0c00c, 0x300c00c0, 0x00c00f00, 
0x0c000300, 0xc00c300c, 0x0cfcc0c0, 0x0f000303, 0xc00cc00c, 0x030f00c0, 0x3f0c0c0c, 0x30c0c00c, 
0xf00c00c0, 0x00c00cc0, 0x0c003f00, 0xc00c300c, 0x330c30c0, 0x3f000303, 0xc00cc00c, 0x000000c0, 
0xc3fc0c0c, 0x3fc0c00f, 0x300c00c0, 0x00c00cc0, 0x0c00c300, 0xc00c300c, 0x330c30c0, 0xffffff03, 
0xc00cc00c, 0x00f0c0c0, 0xc3000c0c, 0x3000c00c, 0x300c003c, 0x00c00f00, 0x0c00c300, 0xc00c300c, 
0x330c30c0, 0x3f000003, 0xc003f00c, 0x030f00c0, 0x3ffc0c03, 0xcfc0c033, 0xc00c0030, 0x00c00c00, 
0x0c003f00, 0xc003c00c, 0x0cf3c0c0, 0x0f000003, 0xc000c00c, 0x000000c0, 0x00000c00, 0x0000c000, 
0x000c00c0, 0x00c00c00, 0x0c000000, 0xc000000c, 0x030000c0, 0x03000003, 0xc000000c, 0x000000c0, 
0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c00ff00, 0xc00ff00c, 0x00fc00c0, 0x00000003, 
0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 0x0c000000, 0xc000000c, 
0x000000c0, 0x00000003, 0xc000000c, 0x000000c0, 0x00000c00, 0x0000c000, 0x000c0000, 0x00c00000, 
0x0c000000, 0xc000000c, 0x000000c0, 0x00000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 
0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc3c3f03f, 0x03000000, 0x300ffc03, 0x003f0030, 
0x0c0c0300, 0x3f003003, 0xfc03003f, 0x00300030, 0x0303000c, 0x3000c003, 0xc0cc0cc0, 0xc3000000, 
0x300c0003, 0x00c0c030, 0x0c0c0300, 0xc0c03000, 0x030300c0, 0x003000cc, 0x0300c030, 0x3003fc03, 
0xc0c00c00, 0xc303f030, 0x30030003, 0x03003030, 0x0c0c0300, 0xc0c03000, 0x030300c0, 0x003000c0, 
0x03003fc0, 0x300cc003, 0xc0c03000, 0xc30c0ccc, 0x3000c003, 0x0c000c30, 0x0c0c0300, 0xc0c03003, 
0xff03003f, 0x003003f0, 0x030030c0, 0x300cc003, 0xc0c0c03f, 0x030c0f0c, 0x30003003, 0x0c000c30, 
0x0c3c0300, 0xc3c0300c, 0x030300c0, 0xc03000c0, 0x030030c0, 0x3003f003, 0xc0c30000, 0xc30c3c0c, 
0x3000c003, 0x03003030, 0x0ccc0300, 0xc030300c, 0x0303003f, 0x00300300, 0x03003fc0, 0x3000cc03, 
0xc0cc0000, 0xc30ccc0c, 0x30030003, 0x00c0c030, 0x0f000300, 0xc030300c, 0x03030000, 0xc0300300, 
0x0300c030, 0x3000cc03, 0xc0cc00c0, 0xc30303f0, 0x300c0003, 0x00330030, 0x0c000300, 0xc030300c, 
0x03030000, 0xc0300c00, 0x0303000c, 0x300ff003, 0xc0cffc3f, 0x03000000, 0x300ffc03, 0x03f3f030, 
0x0c000300, 0xcfc03003, 0xfc03003f, 0x00300c00, 0x03000000, 0x3000c003, 0xc0000000, 0x03000000, 
0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x03000000, 0x30000003, 0x00000030, 0x00000300, 0x00003000, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300030, 0x00030000, 0x00300000, 
0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0xc0c00000, 0x00000000, 0x00000000, 0x00300030, 
0x0003000c, 0x003000c0, 0x03000000, 0x30000003, 0xc3f30303, 0x0c330030, 0xccc00000, 0x00000000, 
0x00000000, 0x00300030, 0x0003000c, 0x003000c0, 0x03000000, 0x30000003, 0xcc03000c, 0x0c330030, 
0xccc00000, 0x00000000, 0x00000000, 0x00303c3f, 0x03c300ff, 0xc0300ffc, 0x03000f00, 0x30000003, 
0xcc03c33f, 0x3f333cfc, 0x0cc00000, 0x00000000, 0x00000000, 0x00300330, 0xcc03000c, 0x003000c0, 
0x03000f00, 0x3003c303, 0xc3c3330c, 0x0c333330, 0x0cc00000, 0x00000000, 0x00000000, 0x00303f30, 
0xcc03000c, 0x003000c0, 0x03000c00, 0x300c3c03, 0xc033330c, 0x0c333330, 0x0cc00000, 0x00000000, 
0x00000000, 0x0030c330, 0xcc0300ff, 0xc03000c0, 0x03000300, 0x30000003, 0xc033330c, 0x0c333330, 
0x0cc00000, 0x00000000, 0x00000000, 0x0030c330, 0xcc03000c, 0x003000c0, 0x03000000, 0x30000003, 
0xcfc3330c, 0x0333330c, 0x0cc00000, 0x00000000, 0x00000000, 0x00303f3f, 0x03c3000c, 0x003000c0, 
0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 0x00000000, 0x00300000, 
0x0003000c, 0x003000c0, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 0x00c00000, 0x00000000, 
0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 0xc0000000, 0x00300000, 
0x00c00000, 0x00000000, 0x00000000, 0x00300000, 0x00030000, 0x00300000, 0x03000000, 0x30000003, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, };