/* Program File	: lcddebug.c
* Company		: VTech Info-Tech Ltd.
* Project		: PDA
* Programmer	: Thomas Cheng
* Date			: July 29, 1998
* Revision		: 1.0
* Comment		:
* Note			:
*/

#include "uart.h"
#include "lcddebug.h"
#include "font.h"

extern const BYTE SYS_FONT_WIDTH[NUM_OF_FONTS][NUM_OF_CHARS];

USHORT debug_x = 5;
USHORT debug_y = 5;

void LcdPrintf(BYTE *c)
{
	while (*c)
	{
		LcdPutc(*c, SMALL_FONT);
        c++;
	}
}

void LcdPutc(BYTE c, BYTE font)
{
	ObjectBounds bound1;
	if (debug_x < 5 || debug_y < 5 || c == '@')
	{
		debug_x = 5;
		debug_y = 5;
		bound1.xcoord = (USHORT)(0);
		bound1.ycoord = (USHORT)(0);
		bound1.width = (USHORT)(LCD_WIDTH);
		bound1.height = (USHORT)(LCD_HEIGHT);
		LcdDrawBox(&bound1, COLOR_BLACK, COLOR_WHITE, FILL_EMPTY);
	}
	else
	{
		if (debug_x + SYS_FONT_WIDTH[font][c] + SPACE_CHAR > LCD_WIDTH - 5 || c == '\r' || c == '\n')
		{
			debug_x = 5;
			debug_y += FONT_HEIGHT[font] + SPACE_LINE;
			if (debug_y <= LCD_HEIGHT/2 && debug_y + FONT_HEIGHT[font] + SPACE_LINE > LCD_HEIGHT/2)
			{
				bound1.xcoord = (USHORT)(5);
				bound1.ycoord = (USHORT)(LCD_HEIGHT/2);
				bound1.width = (USHORT)(LCD_WIDTH - 10);
				bound1.height = (USHORT)(LCD_HEIGHT/2 - 5);
				LcdEraseRegion(&bound1);
			}
			if (debug_y + FONT_HEIGHT[font] + SPACE_LINE > LCD_HEIGHT - 5)
			{
				bound1.xcoord = (USHORT)(5);
				bound1.ycoord = (USHORT)(5);
				bound1.width = (USHORT)(LCD_WIDTH - 10);
				bound1.height = (USHORT)(LCD_HEIGHT/2);
				LcdEraseRegion(&bound1);
				debug_x = 5;
				debug_y = 5;
			}
		}
		if (c != '\r' && c != '\n')
		{
			LcdDrawCharacter(debug_x, debug_y, c, COLOR_BLACK, COLOR_WHITE, font);
            debug_x += SYS_FONT_WIDTH[font][c] + SPACE_CHAR;
		}
	}
}
