/*	File        : LINK.CMD
 *	Version 	: 1.0
 *  Description : Link map
 *  Author      : Thomas Cheng
 *  Date 		: 20 March, 1998
 */

OUTPUT_FORMAT("ecoff-littlemips")
ENTRY(reset_exception)
/*ENTRY(Reset_Boot_Up)*/
/* AH: init memory first ENTRY(reset_exception) */

MEMORY
{
        FLASH   : org = 0x9FD90000, l = 1M
        RAM     : org = 0x80001100, l = 2M
}

SECTIONS
{
	.atext :							/* initialization program code	*/
	{
		_fatext = . ;
			obj/start.o(.text)
			obj/chkmem.o(.text)
			obj/memchk.o(.text)
			obj/HwInit.o(.text)
			obj/minilzo.o(.text)
			obj/unzip.o(.text)
			*(.rdata)
		eatext = . ;
	} > FLASH
	.adata	:							/* initialization program data	*/
	{
		_fadata = . ;
			obj/start.o(.data)
			obj/chkmem.o(.data)
			obj/memchk.o(.data)
			obj/HwInit.o(.data)
			obj/minilzo.o(.data)
			obj/unzip.o(.data)
		eadata  = . ;
	} > RAM
	.bss	:
	{
		_fbss = . ;
			*(.bss)
			*(COMMON)
			*(.common)
			*(.scommon)
		ebss = . ;
	} > RAM
	.btext :
	{
		_fbtext = . ;
			*(.text)
		ebtext = . ;
	} > RAM
	.data	:
	{
		_fdata = . ;
			*(.data)
		edata   = . ;
	} > RAM
	mem_alloc_start = . ;
}
