/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   picture.c
Author(s)   :   Henry Fok, David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   system picture
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "stdafx.h"
#include "datatype.h"

const UWORD triangle[8] = {
0xFFFFFFFF, 0xFFFFFFF0, 0xFFFFFF00, 0xFFFFF000, 0xFFFF0000, 0xFFF00000, 0xFF000000, 0xF0000000
};

const UWORD lower_triangle[20] =
{ 0xFFFFFFFF, 0xFF000000,
  0x0FFFFFFF, 0xFF000000,
  0x0FFFFFFF, 0xF0000000,
  0x00FFFFFF, 0xF0000000,
  0x00FFFFFF, 0x00000000,
  0x000FFFFF, 0x00000000,
  0x000FFFF0, 0x00000000,
  0x0000FFF0, 0x00000000,
  0x0000FF00, 0x00000000,
  0x00000F00, 0x00000000 };

const UWORD upper_triangle[20] =
{ 0x00000F00, 0x00000000,
  0x0000FF00, 0x00000000,
  0x0000FFF0, 0x00000000,
  0x000FFFF0, 0x00000000,
  0x000FFFFF, 0x00000000,
  0x00FFFFFF, 0x00000000,
  0x00FFFFFF, 0xF0000000,
  0x0FFFFFFF, 0xF0000000,
  0x0FFFFFFF, 0xFF000000,
  0xFFFFFFFF, 0xFF000000 };


const UWORD left_triangle[20] =
{ 0x00000000, 0xFF000000,
  0x0000000F, 0xFF000000,
  0x0000FFFF, 0xFF000000,
  0x00FFFFFF, 0xFF000000,
  0xFFFFFFFF, 0xFF000000,
  0x0FFFFFFF, 0xFF000000,
  0x000FFFFF, 0xFF000000,
  0x00000FFF, 0xFF000000,
  0x0000000F, 0xFF000000,
  0x00000000, 0x0F000000 };


const UWORD right_triangle[20] =
{ 0xFF000000, 0x00000000,
  0xFFFF0000, 0x00000000,
  0xFFFFFF00, 0x00000000,
  0xFFFFFFFF, 0x00000000,
  0xFFFFFFFF, 0xFF000000,
  0xFFFFFFFF, 0xF0000000,
  0xFFFFFFF0, 0x00000000,
  0xFFFFF000, 0x00000000,
  0xFFF00000, 0x00000000,
  0xF0000000, 0x00000000 };

const UWORD square[20] =
{
  0xFFFFFFFF, 0xFF000000,
  0xF0000000, 0x0F000000,
  0xF0000000, 0x0F000000,
  0xF0000000, 0x0F000000,
  0xF0000000, 0x0F000000,
  0xF0000000, 0x0F000000,
  0xF0000000, 0x0F000000,
  0xF0000000, 0x0F000000,
  0xF0000000, 0x0F000000,
  0xFFFFFFFF, 0xFF000000 };


const UWORD cross_square[20] =
{
  0xFFFFFFFF, 0xFF000000,
  0xFF000000, 0xFF000000,
  0xF0F0000F, 0x0F000000,
  0xF00F00F0, 0x0F000000,
  0xF000FF00, 0x0F000000,
  0xF000FF00, 0x0F000000,
  0xF00F00F0, 0x0F000000,
  0xF0F0000F, 0x0F000000,
  0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000 };



const UWORD small_lower_triangle[8] =
{
  0xFFFFFFFF,
  0xFFFFFFF0,
  0x0FFFFFF0,
  0x0FFFFF00,
  0x00FFFF00,
  0x00FFF000,
  0x000FF000,
  0x000F0000 };


const UWORD small_upper_triangle[8] =
{
  0x000F0000,
  0x000FF000,
  0x00FFF000,
  0x00FFFF00,
  0x0FFFFF00,
  0x0FFFFFF0,
  0xFFFFFFF0,
  0xFFFFFFFF };

const UWORD arrow_up[7] =
{
  0x000F0000,
  0x00FFF000,
  0x0FFFFF00,
  0xFFFFFFF0,
  0x00FFF000,
  0x00FFF000,
  0x00FFF000 };


const UWORD arrow_down[7] =
{
  0x00FFF000,
  0x00FFF000,
  0x00FFF000,
  0xFFFFFFF0,
  0x0FFFFF00,
  0x00FFF000,
  0x000F0000 };

const UWORD list_34_arrow_up[7] =
{
  0x555F5555,
  0x55FFF555,
  0x5FFFFF55,
  0xFFFFFFF5,
  0x55FFF555,
  0x55FFF555,
  0x55FFF555 };

const UWORD list_34_arrow_down[7] =
{
  0x55FFF555,
  0x55FFF555,
  0x55FFF555,
  0xFFFFFFF5,
  0x5FFFFF55,
  0x55FFF555,
  0x555F5555 };

const UWORD popup_lower_triangle[4] =
{
  0xFFFFFFF5,
  0x5FFFFF55,
  0x55FFF555,
  0x555F5555 };

const UWORD popup_upper_triangle[4] =
{
  0x555F5555,
  0x55FFF555,
  0x5FFFFF55,
  0xFFFFFFF5};
/*															*/
/* The following diagrams are used by Scrollbar Object		*/
/*															*/
const UWORD scroll_up_arrow[16] = { /* 00040040 */
0xffffffff, 0xffff0000, 0xf0000000, 0xffff0000, 0xf055555a, 0xffff0000, 0xf055f55a, 0xffff0000,
0xf05fff5a, 0xffff0000, 0xf0fffffa, 0xffff0000, 0xfaaaaaaa, 0xffff0000, 0xffffffff, 0xffff0000};

const UWORD scroll_down_arrow[16] = { /* 00040040 */
0xffffffff, 0xffff0000, 0xf0000000, 0xffff0000, 0xf0fffffa, 0xffff0000, 0xf05fff5a, 0xffff0000,
0xf055f55a, 0xffff0000, 0xf055555a, 0xffff0000, 0xfaaaaaaa, 0xffff0000, 0xffffffff, 0xffff0000};

//UWORD scroll_car_diagram[6] = { /* 00040018 */
//0xffffffff, 0xf000afff, 0xf055afff, 0xf055afff, 0xf0aaafff, 0xffffffff};
const UWORD scroll_car_diagram[7] = { /* 0004001c */
0xffffffff, 0xf0000aff, 0xf0555aff, 0xf0555aff, 0xf0555aff, 0xf0aaaaff, 0xffffffff};

/*															*/
/* The following diagrams are used by Scheduler Line Object */
/*															*/
const UWORD sch24_d0[18] = { /* 00040048 */
0x55500000, 0x0fff0000, 0x555fff00, 0x0fff0000, 0x55f0fff0, 0x0fff0000, 0x55f0fff0, 0x0fff0000,
0x55f0fff0, 0x0fff0000, 0x5fffffff, 0x0fff0000, 0xff5fff5f, 0xffff0000, 0x5f55f55f, 0x0fff0000,
0x55fffff0, 0x0fff0000};

const UWORD sch24_d1[18] = { /* 00040048 */
0x55500000, 0x0fff0000, 0x555fff00, 0x0fff0000, 0x55f5f5f0, 0x0fff0000, 0x55ff5ff0, 0x0fff0000,
0x55f5f5f0, 0x0fff0000, 0x5fffffff, 0x0fff0000, 0x55f0fff0, 0x0fff0000, 0x55f0fff0, 0x0fff0000,
0x555fff00, 0x0fff0000};

const UWORD sch24_d2[22] = { /* 00040058 */
0x00000055, 0x55ff0000, 0x0ff00055, 0xffff0000, 0x0f000055, 0x5fff0000, 0x0f0ff0ff, 0x5fff0000,
0x0f0f005f, 0x5fff0000, 0x0f0f0f5f, 0x5fff0000, 0x0f0f005f, 0x5fff0000, 0x0f0ff0ff, 0x5fff0000,
0x0f000055, 0x5fff0000, 0x0ff00055, 0xffff0000, 0x00000055, 0x55ff0000};

const UWORD sch24_d3[18] = { /* 00040048 */
0xff0fff0f, 0xffff0000, 0xf0fafaf0, 0xffff0000, 0xf0ffaff0, 0xffff0000, 0xf0fafaf0, 0xffff0000,
0xffffffff, 0xffff0000, 0xf0f0fff0, 0xffff0000, 0xf0f0fff0, 0xffff0000, 0xf0f0fff0, 0xffff0000,
0xff0fff0f, 0xffff0000};

const UWORD sch24_d4[18] = { /* 00040048 */
0x00055555, 0x550f0000, 0x00f55555, 0xf50f0000, 0x0f0f555f, 0x0f0f0000, 0xf500f5f0, 0x05ff0000,
0xf5555f55, 0x55ff0000, 0xf5aff5ff, 0xa5ff0000, 0xfaf55f55, 0xfaff0000, 0x0f05f5f5, 0x5f0f0000,
0x000f555f, 0x550f0000};

const UWORD sch12_d0[18] = { /* 00040048 */
0x55555555, 0x5fff0000, 0x555fff55, 0x5fff0000, 0x55f0fff5, 0x5fff0000, 0x55f0fff5, 0x5fff0000,
0x55f0fff5, 0x5fff0000, 0x5fffffff, 0x5fff0000, 0xff5fff5f, 0xffff0000, 0x5f55f55f, 0x5fff0000,
0x55fffff5, 0x5fff0000};

const UWORD sch12_d1[18] = { /* 00040048 */
0x55555555, 0x5fff0000, 0x555fff55, 0x5fff0000, 0x55f5f5f5, 0x5fff0000, 0x55ff5ff5, 0x5fff0000,
0x55f5f5f5, 0x5fff0000, 0x5fffffff, 0x5fff0000, 0x55f0fff5, 0x5fff0000, 0x55f0fff5, 0x5fff0000,
0x555fff55, 0x5fff0000};

const UWORD sch12_d2[22] = { /* 00040058 */
0x30000000, 0x00ff0000, 0x3ff00000, 0xffff0000, 0x3f000000, 0x0fff0000, 0x3f0ff0ff, 0x0fff0000,
0x3f0f000f, 0x0fff0000, 0x3f0f0f0f, 0x0fff0000, 0x3f0f000f, 0x0fff0000, 0x3f0ff0ff, 0x0fff0000,
0x3f000000, 0x0fff0000, 0x3ff00000, 0xffff0000, 0x30000000, 0x00ff0000};


const UWORD sch12_d3[18] = { /* 00040048 */
0xff0fff0f, 0xffff0000, 0xf0fafaf0, 0xffff0000, 0xf0ffaff0, 0xffff0000, 0xf0fafaf0, 0xffff0000,
0xffffffff, 0xffff0000, 0xf0f0fff0, 0xffff0000, 0xf0f0fff0, 0xffff0000, 0xf0f0fff0, 0xffff0000,
0xff0fff0f, 0xffff0000};

const UWORD sch12_d4[18] = { /* 00040048 */
0x00055555, 0x555f0000, 0x00f55555, 0xf55f0000, 0x0f0f555f, 0x0f5f0000, 0xf500f5f0, 0x05ff0000,
0xf5555f55, 0x55ff0000, 0xf5aff5ff, 0xa5ff0000, 0xfaf55f55, 0xfaff0000, 0x0f05f5f5, 0x5f5f0000,
0x000f555f, 0x555f0000};

const UWORD schline_header1[240] = { /* Scheduler 12 Hours Mode Header */
0x55555550, 0x00000055, 0x55555000, 0x00005555, 0x55500000, 0x00555555, 0x50000000, 0x55555550,
0x00000055, 0x55555000, 0x00005555, 0x55500000, 0x00555555, 0x50000000, 0x55555550, 0x00000055,
0x55555000, 0x00005555, 0x55500000, 0x00050000, 0x55555550, 0x00000055, 0x55555000, 0xff005555,
0x555000ff, 0x00555555, 0x5ff00ff0, 0x5555555f, 0xf00ff055, 0x55555000, 0xff005555, 0x5550000f,
0x00555555, 0x5000ff00, 0x55555550, 0x00ff0055, 0x55555ff0, 0x0ff05555, 0x555ff00f, 0xf0050000,
0x55555550, 0x00000055, 0x5555500f, 0x00005555, 0x55500f00, 0xf0555555, 0x50f0f00f, 0x55555550,
0xf0f00f55, 0x5555500f, 0x00f05555, 0x555000ff, 0x00555555, 0x500f0000, 0x55555550, 0x0f00f055,
0x555550f0, 0xf00f5555, 0x5550f0f0, 0x0f050000, 0x55555550, 0x00000055, 0x5555500f, 0x00005555,
0x55500f00, 0xf0555555, 0x50f0f00f, 0x55555550, 0xf0000f55, 0x55555000, 0x00f05555, 0x55500f0f,
0x00555555, 0x500f0000, 0x55555550, 0x0f00f055, 0x555550f0, 0xf00f5555, 0x5550f000, 0x0f050000,
0xff55ff50, 0x00000055, 0xfff5500f, 0xff0055ff, 0xf55000ff, 0x00555ff5, 0x50f0f00f, 0x5ff5ff50,
0xf000f055, 0xff555000, 0x0f00555f, 0xf550f00f, 0x0055fff5, 0x500fff00, 0x55fff550, 0x00ff0055,
0x5ff550f0, 0xf00f5ff5, 0xff50f000, 0xf0050000, 0x5f5f55f0, 0x00000055, 0xf555500f, 0x00f05555,
0xf5500f00, 0xf055f55f, 0x50f0f00f, 0x55f55f50, 0xf00f0055, 0x5f555000, 0xf00055f5, 0x5f50ffff,
0xf055f555, 0x500f00f0, 0x5555f550, 0x0f00f055, 0xf55f50f0, 0xf00f55f5, 0x5f50f00f, 0x00050000,
0x5f5555f0, 0x00000055, 0xf555500f, 0x00f05555, 0xf5500f00, 0xf055f55f, 0x50f0f00f, 0x55f55f50,
0xf0f00055, 0x5f55500f, 0x00005555, 0x5f50000f, 0x0055f555, 0x500f00f0, 0x5555f550, 0x0f00f055,
0xf55f50f0, 0xf00f55f5, 0x5f50f0f0, 0x00050000, 0x5f555f50, 0xffff0055, 0xfff55000, 0xff00555f,
0x555000ff, 0x00555ff5, 0x50f00ff0, 0x55f55f50, 0xf0ffff55, 0x5f55500f, 0xfff0555f, 0xf550000f,
0x0055fff5, 0x5000ff00, 0x555f5550, 0x00ff0055, 0x5ff550f0, 0x0ff055f5, 0x5f50f0ff, 0xff050000,
0x5f55f550, 0x00000055, 0x555f5000, 0x0000555f, 0x55500000, 0x0055555f, 0x50000000, 0x55f55f50,
0x00000055, 0x5f555000, 0x00005555, 0x5f500000, 0x0055555f, 0x50000000, 0x555f5550, 0x00000055,
0x555f5000, 0x000055f5, 0x5f500000, 0x00050000, 0x5f5f5550, 0x00000055, 0x555f5000, 0x000055f5,
0x55500000, 0x0055555f, 0x50000000, 0x55f55f50, 0x00000055, 0x5f555000, 0x000055f5, 0x5f500000,
0x0055555f, 0x50000000, 0x55f55550, 0x00000055, 0x555f5000, 0x000055f5, 0x5f500000, 0x00050000,
0x5f5ffff0, 0x00000055, 0xfff55000, 0x000055f5, 0x55500000, 0x00555ff5, 0x50000000, 0x55f55f50,
0x00000055, 0x5f555000, 0x0000555f, 0xf5500000, 0x0055fff5, 0x50000000, 0x55f55550, 0x00000055,
0x5ff55000, 0x000055f5, 0x5f500000, 0x00050000, 0x55555550, 0x00000055, 0x55555000, 0x00005555,
0x55500000, 0x00555555, 0x50000000, 0x55555550, 0x00000055, 0x55555000, 0x00005555, 0x55500000,
0x00555555, 0x50000000, 0x55555550, 0x00000055, 0x55555000, 0x00005555, 0x55500000, 0x00050000};

const UWORD schline_header2[240] = { /* Scheduler 24 Hours Mode Header */
0x55555555, 0x50000000, 0x00555555, 0x55500000, 0x00005555, 0x55555000, 0x00000055, 0x55555550,
0x00000000, 0x55555555, 0x50000000, 0x00555555, 0x55500000, 0x00005555, 0x55555000, 0x00000055,
0x55555550, 0x00000000, 0x55555555, 0x500f0000, 0x55555555, 0x50000000, 0x00555fff, 0x55500000,
0x00005555, 0xff555000, 0x0000005f, 0xf5ff5550, 0x00000000, 0x5ff55ff5, 0x50000000, 0x005ff5ff,
0xf5500000, 0x000055ff, 0x5fff5000, 0x0000005f, 0xf55ff550, 0x00000000, 0x55555555, 0x500f0000,
0x55555555, 0x50000000, 0x0055555f, 0x55500000, 0x0000555f, 0x55f55000, 0x00000055, 0xf55f5550, 
0x00000000, 0x55f5f55f, 0x50000000, 0x0055f5f5, 0x55500000, 0x0000555f, 0x555f5000, 0x00000055, 
0xf5f55f50, 0x00000000, 0x55555555, 0x500f0000, 0x55555555, 0x50000000, 0x0055555f, 0x55500000, 
0x0000555f, 0x55f55000, 0x00000055, 0xf55f5550, 0x00000000, 0x55f5555f, 0x50000000, 0x0055f5f5, 
0x55500000, 0x0000555f, 0x555f5000, 0x00000055, 0xf5f55f50, 0x00000000, 0x55555555, 0x500f0000, 
0x5555ff55, 0x500000ff, 0x005555f5, 0x5550000f, 0xf0005555, 0xff5550ff, 0x00ff0055, 0xf55f5550, 
0xff00ff00, 0x55f55ff5, 0x50ff0000, 0xf055f5ff, 0xf550ff00, 0xff00555f, 0x55f550ff, 0x00ff0055, 
0xf55ff550, 0xff000ff0, 0x55555ff5, 0x500f0000, 0x555f55f5, 0x50000f00, 0x005555f5, 0x555000f0, 
0x0f005555, 0x55f5500f, 0x0f00f055, 0xf55f5550, 0x0f0f00f0, 0x55f5555f, 0x500f000f, 0xf055f555, 
0x5f500f0f, 0x0000555f, 0x55f5500f, 0x0f00f055, 0xf5555f5f, 0x00f0f00f, 0x5555f55f, 0x500f0000, 
0x555f55f5, 0x50000f00, 0x00555f55, 0x555000f0, 0x0f005555, 0x55f5500f, 0x0f00f055, 0xf55f5550, 
0x0f0000f0, 0x55f5f55f, 0x500f00f0, 0xf055f555, 0x5f500f0f, 0x0000555f, 0x5f55500f, 0x0f00f055, 
0xf5555f50, 0x00f0f00f, 0x5555f55f, 0x500f0000, 0x555f55f5, 0x50ff0fff, 0x00555f55, 0x5550000f, 
0xf0005555, 0xff55500f, 0x0f00f055, 0xf55f5550, 0x0f000f00, 0x55f55ff5, 0x500f0f00, 0xf055f5ff, 
0xf5500f0f, 0xff00555f, 0x5f55500f, 0x00ff0055, 0xf55ff550, 0x0f00f00f, 0x5ff5f55f, 0x500f0000, 
0x555f55f5, 0x50000f00, 0xf0555555, 0x555000f0, 0x0f005555, 0x5555500f, 0x0f00f055, 0x55555550, 
0x0f00f000, 0x55555555, 0x500f0fff, 0xff555555, 0x55500f0f, 0x00f05555, 0x5555500f, 0x0f00f055,
0x55555550, 0xf000f00f, 0x5555f55f, 0x500f0000, 0x555f55f5, 0x50000f00, 0xf0555555, 0x555000f0, 
0x0f005555, 0x5555500f, 0x0f00f055, 0x55555550, 0x0f0f0000, 0x55555555, 0x500f0000, 0xf0555555, 
0x55500f0f, 0x00f05555, 0x5555500f, 0x0f00f055, 0x5555555f, 0x0000f00f, 0x5555f55f, 0x500f0000, 
0x5555ff55, 0x500000ff, 0x00555555, 0x5550000f, 0xf0005555, 0x5555500f, 0x00ff0055, 0x55555550,
0x0f0ffff0, 0x55555555, 0x500f0000, 0xf0555555, 0x55500f00, 0xff005555, 0x5555500f, 0x00ff0055, 
0x5555555f, 0xfff00ff0, 0x55555ff5, 0x500f0000, 0x55555555, 0x50000000, 0x00555555, 0x55500000,
0x00005555, 0x55555000, 0x00000055, 0x55555550, 0x00000000, 0x55555555, 0x50000000, 0x00555555,
0x55500000, 0x00005555, 0x55555000, 0x00000055, 0x55555550, 0x00000000, 0x55555555, 0x500f0000};
