/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   sio_rxtx.c
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   SIO RX TX
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "sio.h"
#include "Mmu.h"
#include "sio_rxtx.h"
#include "kb_dev.h"

void SIOTransmit(UWORD tx_command_data)
{
	int output_bit,i;
	for(i=0; i<8; i++)
	{
		
		//////////// Put the Data Out and clk Active ////////
		
		output_bit = ((tx_command_data >> i) & 0x00000001);
		if(output_bit == 0)
		{
			CPU->REG_MFIO_DATA_OUT &= 0xFFFF3FFF;
			CPU->REG_MFIO_DATA_OUT |= 0x00000000;
		}
		else
		{
			CPU->REG_MFIO_DATA_OUT &= 0xFFFF3FFF;
			CPU->REG_MFIO_DATA_OUT |= 0x00004000; // set output bit high //
		}
		
		//////////// Set the Clk In-Active but Data no Change /////////
		CPU->REG_MFIO_DATA_OUT |= 0x00008000;
	}
}


void SIORecieve(UWORD *rx_data)
{
	UWORD i;
	*rx_data = 0x00;
	for(i=0; i<8; i++)
	{
		//////////// Set the Clk Active ///////////////////
		CPU->REG_MFIO_DATA_OUT &= 0xFFFF7FFF;
		*rx_data |= ( ((CPU->REG_MFIO_DATA_IN  >> 13) & 0x00000001) << i);
		CPU->REG_MFIO_DATA_OUT |= 0x00008000; // set clk high //
	}
}
