/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   smcmd.c
Author(s)   :   
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "software.h"
#include "softtype.h"
#include "smcmd.h"

NVRAMConfiguration nvram;
typedef Boolean (*CommandHandlerPtr)(modemCommandStruct*);
volatile CommandHandlerPtr CommandHandler = &SoftModemCommandHandler;
extern void SmStatusHandler(modemStatusStruct *status);

void StartATModeCmd()
{
    modemCommandStruct sm_cmd;
    sm_cmd.command = kStartATModeCmd;
    sm_cmd.param.nvramConfigurationPtr = &nvram;
    (*CommandHandler)(&sm_cmd);
}

void IdleCmd()
{
    modemCommandStruct sm_cmd;
    sm_cmd.command = kIdleCmd;
    (*CommandHandler)(&sm_cmd);
}

void V24CircuitChangeCmd()
{
    modemCommandStruct sm_cmd;
    sm_cmd.command = kV24CircuitChangeCmd;
    sm_cmd.param.v24Circuit.code = 108;
    sm_cmd.param.v24Circuit.value = 1;
    (*CommandHandler)(&sm_cmd);
}

void SetStatusHandlerCmd()
{
    modemCommandStruct sm_cmd;
    sm_cmd.command = kSetStatusHandlerCmd;
    sm_cmd.param.handlerSpec.statusHandlerPtr = SmStatusHandler;
    (*CommandHandler)(&sm_cmd);
}

void RingIndicatorCmd(int is_ring_on)
{
	modemCommandStruct sm_cmd;
	sm_cmd.command = kRingIndicatorCmd;
	sm_cmd.param.state = is_ring_on;
	(*CommandHandler)(&sm_cmd);
}

void RingFrequencyCmd()
{
	modemCommandStruct sm_cmd;
	sm_cmd.command = kRingFrequencyCmd;
	sm_cmd.param.state = 25;
	(*CommandHandler)(&sm_cmd);
}
