/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   smisr.c
Author(s)   :   
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#include "pr31700s.h"
#include "pr31700c.h"
#include "print.h"
#include "dev_bety.h"
#include "smisr.h"
#include "telecom.h"
#include "software.h"
#include "softtype.h"

extern short tel_rx_buf[];
extern short tel_tx_buf[];

typedef void (*LineHandlerPtr) (int, short*, short*);
//volatile LineHandlerPtr LineHandler = &SoftModemLineHandler;
volatile LineHandlerPtr LineHandler = (LineHandlerPtr) 0x300002fc;
void SwapBuffer(short *swapBuffer);

void Tel0_5ISR()
{
	SwapBuffer(tel_rx_buf);        
	(*LineHandler)(TEL_BLOCK_SIZE, tel_rx_buf, tel_tx_buf);
	SwapBuffer(tel_tx_buf);
	
}

void Tel1_0ISR()
{
	SwapBuffer(tel_rx_buf+TEL_BLOCK_SIZE);
	(*LineHandler)(TEL_BLOCK_SIZE, tel_rx_buf+TEL_BLOCK_SIZE,
		tel_tx_buf+TEL_BLOCK_SIZE);
	SwapBuffer(tel_tx_buf+TEL_BLOCK_SIZE);
}

void SwapBuffer(short *swapBuffer)
{
	short *endPtr = swapBuffer + TEL_BLOCK_SIZE;
	short n;
	
	do {
		n = *swapBuffer;
		*(char *) swapBuffer = n >>8;
		*(((char *) swapBuffer)+1) = n &0xff;
		swapBuffer ++;
	}
	while (swapBuffer != endPtr);
}
