/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   start.s
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio
Date:	    :   October 1st, 1999
Purpose:	:   Initialisation
Revision    :   1.1
Note        :   1. Ram init
				2. Clear bss
				3. Copy handler
				4. Load stack pointer
				5. Enable interrupt
===========================================================================
*/


#include "pr3910.h"
#include "pr31700s.h"

#define FLASH
#define APPSTKSIZE  0x10000 // Application stack size
#define SYSSTKSIZE  0x400   // System stack size
	.comm	appstack, APPSTKSIZE
//_kam	.comm	sysstack, SYSSTKSIZE

	.text
	.globl reset_exception
reset_exception:
/*  la      k0, start*/
/*    la      k0, Reset*/
/*    la      k0, ResetHandler*/
    la      k0, ResetChk
	jr		k0
	.align 8

	.globl utlb_exception
	.globl eutlb_exception
	.ent utlb_exception
utlb_exception:
	la		k0, UtlbExcHandle
	jr		k0
eutlb_exception:
	.end utlb_exception

	.align 7

	.globl general_exception
	.globl egeneral_exception
	.ent general_exception
general_exception:
	la		k0, GenExcHandle
	jr		k0
egeneral_exception:
	.end general_exception

	.globl start
start:
#ifdef FLASH
	# clear bss
	la		v0, _fbss
	la		v1, ebss
1:	sw		$0, 0x0(v0)
	sw		$0, 0x4(v0)
	sw		$0, 0x8(v0)
	sw		$0, 0xc(v0)
	addu	v0, 16
	blt		v0, v1, 1b

	# copy .data to RAM
	# src=eatext dst=_fadata stop=eadata
	la	t0, eatext						//_kam, copy initialization program's data only
	la	t1, _fadata						//_kam
	la	t2, eadata						//_kam
1:	lw	t3, 0(t0)
	sw	t3, 0(t1)
	addu	t0, 4
	addu	t1, 4
	blt	t1, t2, 1b
#endif

	move	s0, ra						//_kam, must preserve "ra"
	jal		DecompressSys				//_kam, decompress system before transferring to main
	move	ra, s0						//_kam, restore "ra"

	.globl	wstart
wstart:

	# ok to use k0seg now, so initialize sp
	la		sp, appstack+APPSTKSIZE-24
	subu	sp,sp,24
	sw		ra,0(sp)

	# copy exception handler to vector locations
	la		a0, utlb_exception
#	la		a1, eutlb_exception
	la		a1, utlb_exception + 0x10
	li		a2, UTLB_VECT		# utlb vector
	jal		copyHandler

	la		a0, general_exception
	la		a1, egeneral_exception
	li		a2, GEN_VECT		# general vector
	jal		copyHandler

	# enable interrupts
	# first make sure sw bits are clear
	mtc0	zero, C0_CAUSE
	# clear BEV and set IM and IEC bits
	li		t0, (USER_INTS|STATUS_IEC)
	mtc0	t0, C0_STATUS

	# transfer to main program
	# reg indirect is necessary to switch segments
	la		t0, __main
    jal     t0

	lw		ra,0(sp)
	addu	sp,sp,24

	j		ra

	.globl copyHandler
	.ent copyHandler
copyHandler:
	# a0=src a1=end a2=dst
	# must not change a0 or a1
	# must force a0 & a1 to kseg1
1:	lw		v0, 0(a0)
	sw		v0, 0(a2)
	addu	a0, 4
	addu	a2, 4
	blt		a0, a1, 1b
	j		ra
	.end copyHandler
