/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/***************************************************************************
*                                                                         *
* Project:                                                                *
*              PDA                                                        *
*                                                                         *
* Filename:                                                               *
*              Dev_Sib.h                                                  *
*                                                                         *
* Description:                                                            *
*              Low level device driver for SIB                            *
*                                                                         *
* Version:                                                                *
*              1.0                                                        *
*                                                                         *
* History:                                                                *
*              23/09/98   Prepared by Andrew Hui (AH)                     *
*              23/09/98   V1.0 release (AH)                               *
*                                                                         *
***************************************************************************/
#include "platform.h"
#ifdef PR31700

#include "std.h"
#include "pr31700s.h"
#include "pr31700c.h"
#include "uart.h"

/*---------------------------------------------------------------------------
Prototype :   void  int2hex(int data, char hex[9] );
Purpose   :   convert a 32 bit integer into string
Scope     :   ALL
input     :   data   :  e.g. 0xA28F020B
output    :   hex[9] :  e.g. "A28F020B\0"
return    :   N/A
---------------------------------------------------------------------------*/

void int2hex (int data, char hex[9])
{
    int   i;
    int   temp;
	
    for (i=0; i<8; i++)
    {
        temp = (int)((data>>(4*(7 -i))) &0xf);
		
        if (temp>9) hex[i] = (char)(temp + (int)'A');
        else        hex[i] = (char)(temp + (int)'0' -9);
		
    }
    hex[8]=0;
	
	
	
}

/*---------------------------------------------------------------------------
Prototype :   int  hex2int(char hex[9] );
Purpose   :   convert a hex string to 32 bits integer value
Scope     :   ALL
input     :   hex[9] :  e.g. "A28F020B\0"
return    :   32 bit integer value of the string e.g. 0xA28F020B
---------------------------------------------------------------------------*/

int hex2int ( char hex[9])
{ 
	int     tmp;
	int     i,k;
	i   = 0;
	tmp = 0;
	
	while (hex[i])
	{
		if(hex[i] >= '0' && hex[i] <= '9')       hex[i] -= '0';
		else if(hex[i] >= 'A' && hex[i] <= 'F')  hex[i] = hex[i]-'A'+10;
		else                                return -1;
		tmp = (tmp*0x10) + hex[i++];
	}
}

/*---------------------------------------------------------------------------
Prototype :   void  Delay(int count);
Purpose   :   make a delay
Scope     :   ALL
input     :   int count :     how long to delay
return    :   N/A
---------------------------------------------------------------------------*/

void Delay(int count)
{
    while(count--);
}


/*---------------------------------------------------------------------------
*****************************************************************************
Prototype :   int  LEDBlink();
Purpose   :   For test only
Author    :   Thomas Cheng
*****************************************************************************
---------------------------------------------------------------------------*/

void LEDBlink()
{
/*    CPU ->REG_MFIO_DIRECTN |= 0x3;
while (1)
{
CPU ->REG_MFIO_DATA_OUT |= 0x3;
Delay(0x8FFF);
CPU ->REG_MFIO_DATA_OUT &= ~(0x3);
Delay(0x8FFF);
}*/
}

/* End of file */
#endif

