/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   sysetup.c
Author(s)   :   Jason Ngan
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Sysetup functions
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "stdafx.h"
#include "sysetup.h"
#ifdef PR31700
#include "sndmgr.h"
#endif

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
BYTE    GPassCheck;
BYTE    GAutoPwrOffTime;
BYTE	GCalPenStatus;

KeyMappingSettings		GKeyMapping;
/*****************************************************************/

/*****************************************************************
* Function:	SySetupDatabaseInit
* Purpose: 	This function is used to initialse the the datebase 
*				in the PDA.
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	This function should be called in the StartApplication() function.
*****************************************************************/
BOOLEAN SySetupDatabaseInit(void)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id, rec_id2, rec_id3, rec_id4;
	BYTE		field_type[1];
	BYTE		i;
    BYTE        alarmgr_font;
	
	ClockSettings		clock;
	SoundSettings		sound;
	PasswordSettings	password;
	CountrySettings		country;
	OwnerInfo			ownerinfo;
	ModemSettings		modem;
	EmailSettings		email;
	KeyMappingSettings	key_mapping;
	SysInfoSettings		sys_info;
	UWORD				total_mem, sys_used_mem;
	
	
	/* New Database */
	
    if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
    {
		if (DataNewDB(SYSETUPDB, 1,
			SYSETUPAPP, &SySetup_dbid) == ERR_DATA_NO_SPACE)
			return FALSE;
    }
    else return TRUE;
	
	/* Open Database */
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	/* New Record */
	/*--------------------------------------------------------------------*/	
	/*-- CLOCK -----------------------------------------------------------*/	
	if (DataNewRecord(SySetup_dbid, 1, 2, &rec_id) != TRUE)
		return FALSE;
	
	field_type[0] = CLOCK;
	if (DataWriteField(SySetup_dbid, rec_id, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	
	GAutoPwrOffTime			= 1;
	clock.auto_off_time		= 1;
	clock.home_country		= 93;
    clock.visit_country     = 90;
	clock.home_dst_active	= 0;
	clock.visit_dst_active	= 0;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(ClockSettings), (BYTE*)&clock) != TRUE)
		return FALSE;
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	/*--------------------------------------------------------------------*/	
	/*-- SOUND -----------------------------------------------------------*/	
	if (DataNewRecord(SySetup_dbid, 1, 2, &rec_id) != TRUE)
		return FALSE;
	
	field_type[0] = SOUND;
	if (DataWriteField(SySetup_dbid, rec_id, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	
	sound.vol_min		= 0;
	sound.vol_max		= 14;
	sound.vol_curr		= 7;
	sound.click_min		= 0;
	sound.click_max		= 14;
	sound.click_curr	= 1;
	// New add on 04/11/99 "Mic Settings"
	//--------------------------------------------------------
#ifdef MIC_IN_SET
	sound.mic_min		= 0;
	sound.mic_max		= 14;
	sound.mic_curr		= 7;
	//--------------------------------------------------------
#endif
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(SoundSettings), (BYTE*)&sound) != TRUE)
		return FALSE;
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	/*--------------------------------------------------------------------*/	
	/*-- PASSWORD --------------------------------------------------------*/	
	/* field1 = check_password, password */
	/* field2 = *hits */
	GPassCheck = 0;
	if (DataNewRecord(SySetup_dbid, 1, 3, &rec_id) != TRUE)
		return FALSE;
	
	field_type[0] = PASSWORD;
	if (DataWriteField(SySetup_dbid, rec_id, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	
	password.check_password = 0;	
	for(i=0; i<20; i++)
		password.password[i] = 0;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(PasswordSettings), (BYTE*)&password) != TRUE)
		return FALSE;
	
	password.hints = (BYTE*)qmalloc(sizeof(BYTE));
	password.hints[0] = 0;
	
	if (DataWriteField(SySetup_dbid, rec_id, 2, strlen(password.hints)+1, password.hints) != TRUE)
		return FALSE;
	qfree(password.hints);
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	/*--------------------------------------------------------------------*/	
	/*-- COUNTRY ---------------------------------------------------------*/	
	/* field3 = time difference */
	if (DataNewRecord(SySetup_dbid, 1, 3, &rec_id) != TRUE)
		return FALSE;
	
	field_type[0] = COUNTRY;
	if (DataWriteField(SySetup_dbid, rec_id, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	
	country.region = 27;
	country.time_fmt = SYSETUP_12HR_DISPLAY;
	country.date_fmt = SYSETUP_MDY;
	country.start_of_week = SYSETUP_SUN;
	country.nums = SYSETUP_NUMS_C_F;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(CountrySettings), (BYTE*)&country) != TRUE)
		return FALSE;
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	/*--------------------------------------------------------------------*/	
	/*-- OWNINFO ---------------------------------------------------------*/	
	if (DataNewRecord(SySetup_dbid, 1, 5, &rec_id) != TRUE)
		return FALSE;
	
	field_type[0] = OWNINFO;
	if (DataWriteField(SySetup_dbid, rec_id, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	
	/* field1 to field 4*/
	ownerinfo.first_name = (BYTE*)qmalloc(6*sizeof(BYTE));
    //strcpy(ownerinfo.first_name, (BYTE*)("Helio"));
    strcpy(ownerinfo.first_name, (BYTE*)(""));
	if (DataWriteField(SySetup_dbid, rec_id, 1, strlen(ownerinfo.first_name)+1, ownerinfo.first_name) != TRUE)
		return FALSE;
	ownerinfo.last_name = (BYTE*)qmalloc(6*sizeof(BYTE));
    //strcpy(ownerinfo.last_name, (BYTE*)("VTech"));
    strcpy(ownerinfo.last_name, (BYTE*)(""));
	if (DataWriteField(SySetup_dbid, rec_id, 2, strlen(ownerinfo.last_name)+1, ownerinfo.last_name) != TRUE)
		return FALSE;
	ownerinfo.contact_tel = (BYTE*)qmalloc(sizeof(BYTE));
	ownerinfo.contact_tel[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 3, strlen(ownerinfo.contact_tel)+1, ownerinfo.contact_tel) != TRUE)
		return FALSE;
	ownerinfo.company_name = (BYTE*)qmalloc(sizeof(BYTE));
	ownerinfo.company_name[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 4, strlen(ownerinfo.company_name)+1, ownerinfo.company_name) != TRUE)
		return FALSE;
	
	qfree(ownerinfo.first_name);
	qfree(ownerinfo.last_name);
	qfree(ownerinfo.contact_tel);
	qfree(ownerinfo.company_name);
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	/*--------------------------------------------------------------------*/	
	/*-- MODEM -----------------------------------------------------------*/	
	/* field3 = dial_out_code */
	if (DataNewRecord(SySetup_dbid, 1, 3, &rec_id) != TRUE)
		return FALSE;
	field_type[0] = MODEM;
	if (DataWriteField(SySetup_dbid, rec_id, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	
	modem.sync_speed = SYSETUP_57600BPS;
	modem.speed_type = SYSETUP_NORMAL;
	modem.line_type = SYSETUP_TONE;
	modem.speed = SYSETUP_AUTO;
	modem.parity = SYSETUP_NONE;
	modem.data_bit = SYSETUP_BIT8;
	modem.stop_bit = SYSETUP_BIT1;
	modem.hand_flow_control = SYSETUP_ON;
	modem.data_compression = SYSETUP_ON;
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(ModemSettings), (BYTE*)&modem) != TRUE)
		return FALSE;
	modem.dial_out_code = (BYTE*)qmalloc(sizeof(BYTE));
	modem.dial_out_code[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 2, strlen(modem.dial_out_code)+1, modem.dial_out_code) != TRUE)
		return FALSE;
	qfree(modem.dial_out_code);
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	/*--------------------------------------------------------------------*/	
	/*-- EMAIL -----------------------------------------------------------*/	
	/* email settings should have 4 records for storing 4 ISP */
	/* 1 + 25 fields for storing members */
	if (DataNewRecord(SySetup_dbid, 1, 26, &rec_id) != TRUE)
		return FALSE;
	field_type[0] = EMAIL1;
	if (DataWriteField(SySetup_dbid, rec_id, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	if (DataNewRecord(SySetup_dbid, 1, 26, &rec_id2) != TRUE)
		return FALSE;
	field_type[0] = EMAIL2;
	if (DataWriteField(SySetup_dbid, rec_id2, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	if (DataNewRecord(SySetup_dbid, 1, 26, &rec_id3) != TRUE)
		return FALSE;
	field_type[0] = EMAIL3;
	if (DataWriteField(SySetup_dbid, rec_id3, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	if (DataNewRecord(SySetup_dbid, 1, 26, &rec_id4) != TRUE)
		return FALSE;
	field_type[0] = EMAIL4;
	if (DataWriteField(SySetup_dbid, rec_id4, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	
	email.auto_ip_addr = 0;
	email.apop = 0;
	email.del_mail = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(EmailSettings), (BYTE*)&email) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 1, sizeof(EmailSettings), (BYTE*)&email) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 1, sizeof(EmailSettings), (BYTE*)&email) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 1, sizeof(EmailSettings), (BYTE*)&email) != TRUE)
		return FALSE;
	email.isp = (BYTE*)qmalloc(sizeof(BYTE));
	email.isp[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 2, strlen(email.isp)+1, email.isp) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 2, strlen(email.isp)+1, email.isp) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 2, strlen(email.isp)+1, email.isp) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 2, strlen(email.isp)+1, email.isp) != TRUE)
		return FALSE;
	email.tel = (BYTE*)qmalloc(sizeof(BYTE));
	email.tel[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 3, strlen(email.tel)+1, email.tel) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 3, strlen(email.tel)+1, email.tel) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 3, strlen(email.tel)+1, email.tel) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 3, strlen(email.tel)+1, email.tel) != TRUE)
		return FALSE;
		/*
		email.fax = (BYTE*)qmalloc(sizeof(BYTE));
		email.fax[0] = 0;
		if (DataWriteField(SySetup_dbid, rec_id, 4, strlen(email.fax)+1, email.fax) != TRUE)
		return FALSE;
		if (DataWriteField(SySetup_dbid, rec_id2, 4, strlen(email.fax)+1, email.fax) != TRUE)
		return FALSE;
		if (DataWriteField(SySetup_dbid, rec_id3, 4, strlen(email.fax)+1, email.fax) != TRUE)
		return FALSE;
		if (DataWriteField(SySetup_dbid, rec_id4, 4, strlen(email.fax)+1, email.fax) != TRUE)
		return FALSE;
	*/
	
	email.email_addr = (BYTE*)qmalloc(sizeof(BYTE));
	email.email_addr[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 4, strlen(email.email_addr)+1, email.email_addr) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 4, strlen(email.email_addr)+1, email.email_addr) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 4, strlen(email.email_addr)+1, email.email_addr) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 4, strlen(email.email_addr)+1, email.email_addr) != TRUE)
		return FALSE;
	email.login_name = (BYTE*)qmalloc(sizeof(BYTE));
	email.login_name[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 5, strlen(email.login_name)+1, email.login_name) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 5, strlen(email.login_name)+1, email.login_name) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 5, strlen(email.login_name)+1, email.login_name) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 5, strlen(email.login_name)+1, email.login_name) != TRUE)
		return FALSE;
	email.login_password = (BYTE*)qmalloc(sizeof(BYTE));
	email.login_password[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 6, strlen(email.login_password)+1, email.login_password) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 6, strlen(email.login_password)+1, email.login_password) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 6, strlen(email.login_password)+1, email.login_password) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 6, strlen(email.login_password)+1, email.login_password) != TRUE)
		return FALSE;
	email.smtp_server = (BYTE*)qmalloc(sizeof(BYTE));
	email.smtp_server[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 7, strlen(email.smtp_server)+1, email.smtp_server) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 7, strlen(email.smtp_server)+1, email.smtp_server) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 7, strlen(email.smtp_server)+1, email.smtp_server) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 7, strlen(email.smtp_server)+1, email.smtp_server) != TRUE)
		return FALSE;
	email.pop3_server = (BYTE*)qmalloc(sizeof(BYTE));
	email.pop3_server[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 8, strlen(email.pop3_server)+1, email.pop3_server) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 8, strlen(email.pop3_server)+1, email.pop3_server) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 8, strlen(email.pop3_server)+1, email.pop3_server) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 8, strlen(email.pop3_server)+1, email.pop3_server) != TRUE)
		return FALSE;
	email.user_name = (BYTE*)qmalloc(sizeof(BYTE));
	email.user_name[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 9, strlen(email.user_name)+1, email.user_name) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 9, strlen(email.user_name)+1, email.user_name) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 9, strlen(email.user_name)+1, email.user_name) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 9, strlen(email.user_name)+1, email.user_name) != TRUE)
		return FALSE;
	email.password = (BYTE*)qmalloc(sizeof(BYTE));
	email.password[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 10, strlen(email.password)+1, email.password) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 10, strlen(email.password)+1, email.password) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 10, strlen(email.password)+1, email.password) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 10, strlen(email.password)+1, email.password) != TRUE)
		return FALSE;
	email.pri_dns1 = (BYTE*)qmalloc(sizeof(BYTE));
	email.pri_dns1[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 11, strlen(email.pri_dns1)+1, email.pri_dns1) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 11, strlen(email.pri_dns1)+1, email.pri_dns1) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 11, strlen(email.pri_dns1)+1, email.pri_dns1) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 11, strlen(email.pri_dns1)+1, email.pri_dns1) != TRUE)
		return FALSE;
	email.pri_dns2 = (BYTE*)qmalloc(sizeof(BYTE));
	email.pri_dns2[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 12, strlen(email.pri_dns2)+1, email.pri_dns2) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 12, strlen(email.pri_dns2)+1, email.pri_dns2) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 12, strlen(email.pri_dns2)+1, email.pri_dns2) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 12, strlen(email.pri_dns2)+1, email.pri_dns2) != TRUE)
		return FALSE;
	email.pri_dns3 = (BYTE*)qmalloc(sizeof(BYTE));
	email.pri_dns3[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 13, strlen(email.pri_dns3)+1, email.pri_dns3) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 13, strlen(email.pri_dns3)+1, email.pri_dns3) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 13, strlen(email.pri_dns3)+1, email.pri_dns3) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 13, strlen(email.pri_dns3)+1, email.pri_dns3) != TRUE)
		return FALSE;
	email.pri_dns4 = (BYTE*)qmalloc(sizeof(BYTE));
	email.pri_dns4[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 14, strlen(email.pri_dns4)+1, email.pri_dns4) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 14, strlen(email.pri_dns4)+1, email.pri_dns4) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 14, strlen(email.pri_dns4)+1, email.pri_dns4) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 14, strlen(email.pri_dns4)+1, email.pri_dns4) != TRUE)
		return FALSE;
	email.sec_dns1 = (BYTE*)qmalloc(sizeof(BYTE));
	email.sec_dns1[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 15, strlen(email.sec_dns1)+1, email.sec_dns1) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 15, strlen(email.sec_dns1)+1, email.sec_dns1) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 15, strlen(email.sec_dns1)+1, email.sec_dns1) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 15, strlen(email.sec_dns1)+1, email.sec_dns1) != TRUE)
		return FALSE;
	email.sec_dns2 = (BYTE*)qmalloc(sizeof(BYTE));
	email.sec_dns2[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 16, strlen(email.sec_dns2)+1, email.sec_dns2) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 16, strlen(email.sec_dns2)+1, email.sec_dns2) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 16, strlen(email.sec_dns2)+1, email.sec_dns2) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 16, strlen(email.sec_dns2)+1, email.sec_dns2) != TRUE)
		return FALSE;
	email.sec_dns3 = (BYTE*)qmalloc(sizeof(BYTE));
	email.sec_dns3[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 17, strlen(email.sec_dns3)+1, email.sec_dns3) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 17, strlen(email.sec_dns3)+1, email.sec_dns3) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 17, strlen(email.sec_dns3)+1, email.sec_dns3) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 17, strlen(email.sec_dns3)+1, email.sec_dns3) != TRUE)
		return FALSE;
	email.sec_dns4 = (BYTE*)qmalloc(sizeof(BYTE));
	email.sec_dns4[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 18, strlen(email.sec_dns4)+1, email.sec_dns4) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 18, strlen(email.sec_dns4)+1, email.sec_dns4) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 18, strlen(email.sec_dns4)+1, email.sec_dns4) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 18, strlen(email.sec_dns4)+1, email.sec_dns4) != TRUE)
		return FALSE;
	email.ip_addr1 = (BYTE*)qmalloc(sizeof(BYTE));
	email.ip_addr1[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 19, strlen(email.ip_addr1)+1, email.ip_addr1) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 19, strlen(email.ip_addr1)+1, email.ip_addr1) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 19, strlen(email.ip_addr1)+1, email.ip_addr1) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 19, strlen(email.ip_addr1)+1, email.ip_addr1) != TRUE)
		return FALSE;
	email.ip_addr2 = (BYTE*)qmalloc(sizeof(BYTE));
	email.ip_addr2[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 20, strlen(email.ip_addr2)+1, email.ip_addr2) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 20, strlen(email.ip_addr2)+1, email.ip_addr2) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 20, strlen(email.ip_addr2)+1, email.ip_addr2) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 20, strlen(email.ip_addr2)+1, email.ip_addr2) != TRUE)
		return FALSE;
	email.ip_addr3 = (BYTE*)qmalloc(sizeof(BYTE));
	email.ip_addr3[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 21, strlen(email.ip_addr3)+1, email.ip_addr3) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 21, strlen(email.ip_addr3)+1, email.ip_addr3) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 21, strlen(email.ip_addr3)+1, email.ip_addr3) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 21, strlen(email.ip_addr3)+1, email.ip_addr3) != TRUE)
		return FALSE;
	email.ip_addr4 = (BYTE*)qmalloc(sizeof(BYTE));
	email.ip_addr4[0] = 0;
	if (DataWriteField(SySetup_dbid, rec_id, 22, strlen(email.ip_addr4)+1, email.ip_addr4) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id2, 22, strlen(email.ip_addr4)+1, email.ip_addr4) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id3, 22, strlen(email.ip_addr4)+1, email.ip_addr4) != TRUE)
		return FALSE;
	if (DataWriteField(SySetup_dbid, rec_id4, 22, strlen(email.ip_addr4)+1, email.ip_addr4) != TRUE)
		return FALSE;
	
	qfree(email.isp);
	qfree(email.tel);
	//qfree(email.fax);
	qfree(email.email_addr);
	qfree(email.login_name);
	qfree(email.login_password);
	qfree(email.smtp_server);
	qfree(email.pop3_server);
	qfree(email.user_name);
	qfree(email.password);
	qfree(email.pri_dns1);
	qfree(email.pri_dns2);
	qfree(email.pri_dns3);
	qfree(email.pri_dns4);
	qfree(email.sec_dns1);
	qfree(email.sec_dns2);
	qfree(email.sec_dns3);
	qfree(email.sec_dns4);
	qfree(email.ip_addr1);
	qfree(email.ip_addr2);
	qfree(email.ip_addr3);
	qfree(email.ip_addr4);
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	if (DataCloseRecord(SySetup_dbid, rec_id2) != TRUE)
		return FALSE;
	if (DataCloseRecord(SySetup_dbid, rec_id3) != TRUE)
		return FALSE;
	if (DataCloseRecord(SySetup_dbid, rec_id4) != TRUE)
		return FALSE;
	/*--------------------------------------------------------------------*/	
	/*-- KEY_MAPPING ------------------------------------------------------*/	
	if (DataNewRecord(SySetup_dbid, 1, 6, &rec_id) != TRUE)
		return FALSE;
	field_type[0] = KEY_MAPPING;
	if (DataWriteField(SySetup_dbid, rec_id, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	
    key_mapping.key1 = SYSETUP_PHONEBOOK;
	key_mapping.key2 = SYSETUP_CALCULATOR;
    key_mapping.key3 = SYSETUP_TO_DO_LIST;
    key_mapping.key4 = SYSETUP_GLOBAL_FIND;
    key_mapping.key5 = SYSETUP_SCHEDULER;
	
	GKeyMapping = key_mapping;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(KeyMappingSettings), (BYTE*)&key_mapping) != TRUE)
		return FALSE;
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	/*--------------------------------------------------------------------*/	
	/*-- SYSINFO ---------------------------------------------------------*/	
	if (DataNewRecord(SySetup_dbid, 1, 5, &rec_id) != TRUE)
		return FALSE;
	field_type[0] = SYSINFO;
	if (DataWriteField(SySetup_dbid, rec_id, 0, 1, (BYTE*)field_type) != TRUE)
		return FALSE;
	
    //strcpy(sys_info.version, "1.3.01");
    SysGetOSVersionNo(sys_info.version);
	//sys_info.sdram		= 4;
    //sys_info.sys_used     = 1;
	
	total_mem = MemoryTotalSysMem(&sys_used_mem);
	
	sys_info.sdram		= total_mem/1048576;
	if (sys_info.sdram <= 1)
		sys_info.sdram		= 1;
	else if(sys_info.sdram <= 2)
		sys_info.sdram		= 2;
	else if(sys_info.sdram <= 4)
		sys_info.sdram		= 4;
	else if(sys_info.sdram <= 8)
		sys_info.sdram		= 8;
	else if(sys_info.sdram <= 16)
		sys_info.sdram		= 16;
	else if(sys_info.sdram <= 32)
		sys_info.sdram		= 32;
	
	sys_info.sys_used	= sys_used_mem/1024;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(SysInfoSettings), (BYTE*)&sys_info) != TRUE)
		return FALSE;
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	//By Henry Fok
    if (DataRecordInfo(SySetup_dbid, ALARMGR_FONT, NULL, NULL, NULL, NULL, NULL) != TRUE)
        DataNewRecordWithID(SySetup_dbid, ALARMGR_FONT, 0, 1);
    alarmgr_font = SMALL_FONT;
    DataWriteField(SySetup_dbid, ALARMGR_FONT, 0, 1, &alarmgr_font);
	
    if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	/*--------------------------------------------------------------------*/	
	/*-- CAL_PEN ---------------------------------------------------------*/	
	GCalPenStatus = 1;					/* 1 => cal pen mode */
	/* 0 => normal mode */
	
	return TRUE;
}

/*****************************************************************
* Function:	SySetupGetClockSettings
* Purpose: 	This function is used to get the clock settings
*				from the database
* Scope:		application
* Input:		None
* Output:		Structure of the clock settings
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupGetClockSettings(ClockSettings *clock)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	UWORD		byte_read;
	ClockSettings *get_clock;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, CLOCK, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, (BYTE**)&get_clock, &byte_read) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	*clock = *get_clock;
	qfree(get_clock);
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}

/*****************************************************************
* Function:	SySetupGetKeyMappingSettings
* Purpose: 	This function is used to get the key mapping settings
*				from the database
* Scope:		application
* Input:		None
* Output:		Structure of the key mapping settings
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupGetKeyMappingSettings(KeyMappingSettings *key_mapping)
{
	DatabaseID			SySetup_dbid;
	RecordID			rec_id;
	UWORD				byte_read;
	KeyMappingSettings	*get_key_mapping;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, KEY_MAPPING, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, (BYTE**)&get_key_mapping, &byte_read) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	*key_mapping = *get_key_mapping;
	qfree(get_key_mapping);
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupGetCountrySettings
* Purpose: 	This function is used to get the country settings
*				from the database
* Scope:		application
* Input:		None
* Output:		Structure of the country settings
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupGetCountrySettings(CountrySettings *country)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	UWORD		byte_read;
	CountrySettings	*get_country;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, COUNTRY, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, (BYTE**)&get_country, &byte_read) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	*country = *get_country;
	qfree(get_country);
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}




/*****************************************************************
* Function:	SySetupGetEmailSettings
* Purpose: 	This function is used to get the email settings
*				from the database
* Scope:		application
* Input:		None
* Output:		Structure of the email settings
The isp number:	EMAIL1
EMAIL2
EMAIL3
EMAIL4
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	Different isp number refer to different email settings database
*****************************************************************/
BOOLEAN SySetupGetEmailSettings(EmailSettings *email, UWORD	isp)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	UWORD		byte_read;
	EmailSettings *get_email;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, isp, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, (BYTE**)&get_email, &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 2, &(get_email->isp), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 3, &(get_email->tel), &byte_read) != TRUE)
		return FALSE;
		/*
		if (DataGetField(SySetup_dbid, rec_id, 4, &(get_email->fax), &byte_read) != TRUE)
		return FALSE;
	*/
	if (DataGetField(SySetup_dbid, rec_id, 4, &(get_email->email_addr), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 5, &(get_email->login_name), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 6, &(get_email->login_password), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 7, &(get_email->smtp_server), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 8, &(get_email->pop3_server), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 9, &(get_email->user_name), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 10, &(get_email->password), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 11, &(get_email->pri_dns1), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 12, &(get_email->pri_dns2), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 13, &(get_email->pri_dns3), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 14, &(get_email->pri_dns4), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 15, &(get_email->sec_dns1), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 16, &(get_email->sec_dns2), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 17, &(get_email->sec_dns3), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 18, &(get_email->sec_dns4), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 19, &(get_email->ip_addr1), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 20, &(get_email->ip_addr2), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 21, &(get_email->ip_addr3), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 22, &(get_email->ip_addr4), &byte_read) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	*email = *get_email;
	//qfree(get_email);
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}

/*****************************************************************
* Function:	SySetupGetModemSettings
* Purpose: 	This function is used to get the modem settings
*				from the database
* Scope:		application
* Input:		None
* Output:		Structure of the modem settings
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupGetModemSettings(ModemSettings *modem)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	UWORD		byte_read;
	ModemSettings *get_modem;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, MODEM, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, (BYTE**)&get_modem, &byte_read) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 2, &(get_modem->dial_out_code), &byte_read) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	*modem = *get_modem;
	//qfree(get_modem);
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupGetSyncSpeedSettings
* Purpose: 	This function is used to get the sync. speed settings
*				from the database
* Scope:		application
* Input:		None
* Output:		sync_speed
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupGetSyncSpeedSettings(WORD *sync_speed)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	UWORD		byte_read;
	ModemSettings *get_modem;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, MODEM, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, (BYTE**)&get_modem, &byte_read) != TRUE)
		return FALSE;
	
	switch(get_modem->sync_speed)
	{
	case SYSETUP_38400BPS:
		*sync_speed = 38400;
		break;
	case SYSETUP_19200BPS:
		*sync_speed = 19200;
		break;
	case SYSETUP_9600BPS:
		*sync_speed = 9600;
		break;
	default:
		*sync_speed = 57600;
		break;
	}
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupGetOwnerInfo
* Purpose: 	This function is used to get the owner information
*				from the database
* Scope:		application
* Input:		None
* Output:		Structure of the owner information settings
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupGetOwnerInfo(OwnerInfo *ownerinfo)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	UWORD		byte_read;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, OWNINFO, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, &(ownerinfo->first_name), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 2, &(ownerinfo->last_name), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 3, &(ownerinfo->contact_tel), &byte_read) != TRUE)
		return FALSE;
	if (DataGetField(SySetup_dbid, rec_id, 4, &(ownerinfo->company_name), &byte_read) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}



/*****************************************************************
* Function:	SySetupGetPasswordSettings
* Purpose: 	This function is used to get the password settings
*				from the database
* Scope:		internal
* Input:		None
* Output:		Structure of the password settings
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupGetPasswordSettings(PasswordSettings *password)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	UWORD		byte_read;
	PasswordSettings	*get_password;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, PASSWORD, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, (BYTE**)&get_password, &byte_read) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 2, &(get_password->hints), &byte_read) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	password->hints = (BYTE*)qmalloc(strlen(get_password->hints)+1);
	*password = *get_password;
	qfree(get_password);
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}



/*****************************************************************
* Function:	SySetupGetSoundSettings
* Purpose: 	This function is used to get the sound settings
*				from the database
* Scope:		application
* Input:		None
* Output:		Structure of the sound settings
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupGetSoundSettings(SoundSettings *sound)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	UWORD		byte_read;
	SoundSettings *get_sound;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, SOUND, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataGetField(SySetup_dbid, rec_id, 1, (BYTE**)&get_sound, &byte_read) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	*sound = *get_sound;
	qfree(get_sound);
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}

/********************************************************
* Function:	SySetupScrollbarSetClickSoundSettings
* Purpose: 	This function is called to set sound settings
*				when the scrollbar is moved.
* Scope:		application
* Input:		scrollbar_id	the input scrollbar ID
new_value		the input new value
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
BOOLEAN	SySetupScrollbarSetClickSoundSettings(USHORT min_value, USHORT max_value, USHORT new_value)
{
/*
BYTE		object_type;
Scrollbar	*scroll_ptr;

  FormGetObjectPointer(scrollbar_id, &object_type, (void**)&scroll_ptr);
  ScrollbarSetScrollbar(scrollbar_id, new_value, scroll_ptr->scrollbar_max, scroll_ptr->scrollbar_min, scroll_ptr->scrollbar_pagesize, scroll_ptr->scrollbar_total_num_lines);	
  ScrollbarDrawScrollbar(scrollbar_id);
	*/
	return TRUE;
}

/********************************************************
* Function:	SySetupScrollbarSetVolSettings
* Purpose: 	This function is called to set sound settings
*				when the scrollbar is moved.
* Scope:		application
* Input:		scrollbar_id	the input scrollbar ID
new_value		the input new value
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
BOOLEAN	SySetupScrollbarSetVolSettings(USHORT min_value, USHORT max_value, USHORT new_value)
{
/*
DatabaseID	SySetup_dbid;
RecordID	rec_id;
SoundSettings	sound;

  if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
		if (!SySetupGetSoundSettings(&sound))
		return FALSE;
		
		  sound.vol_max	= (BYTE)max_value;
		  sound.vol_min	= (BYTE)min_value;
		  sound.vol_curr	= (BYTE)new_value;
		  
			if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
			return FALSE;
			
			  if (DataOpenRecord(SySetup_dbid, SOUND, &rec_id, NULL) != TRUE)
			  return FALSE;
			  
				if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(SoundSettings), (BYTE*)&sound) != TRUE)
				return FALSE;
				
				  #ifdef PR31700
				  if(sound.vol_curr == 0)
				  {
				  if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	0, 0, 1))
				  return FALSE;
				  }
				  else
				  {
				  if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((8*sound.vol_curr)/(sound.click_max-sound.click_min)+23), 0, 1))
				  return FALSE;
				  }
				  #endif
				  
					if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
					return FALSE;
					
					  if (DataCloseDB(SySetup_dbid) != TRUE)
					  return FALSE;
	*/
	printf("\n ------>> vol_set: max=%d, min=%d, new_value=%d", max_value, min_value, new_value);
	
	if (max_value - min_value < 1)
	{
		max_value = 14;
		min_value = 0;
	}
	
#ifdef PR31700
	if(new_value == 0)
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	0, 0, 1))
			return FALSE;
	}
	else
	{
		if (!SndSetSndSettings((SHORT)SND_MAX_GAIN,	(SHORT)((8*new_value)/(max_value-min_value)+23), 0, 1))
			return FALSE;
	}
#endif
	if (!SySetupSetVolSettings(min_value, max_value, new_value))
		return TRUE;
	
	
	return TRUE;
}


/********************************************************
* Function:	SySetupSetVolSettings
* Purpose: 	This function is called to set sound settings
* Scope:		application
* Input:		scrollbar_id	the input scrollbar ID
new_value		the input new value
* Output:		None
* Return:		None
* Comment: 	None
*********************************************************/
BOOLEAN	SySetupSetVolSettings(USHORT min_value, USHORT max_value, USHORT new_value)
{
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	SoundSettings	sound;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	if (!SySetupGetSoundSettings(&sound))
		return FALSE;
	
	
	sound.vol_max	= (BYTE)max_value;
	sound.vol_min	= (BYTE)min_value;
	sound.vol_curr	= (BYTE)new_value;
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, SOUND, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(SoundSettings), (BYTE*)&sound) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupGetSystemInfo
* Purpose: 	This function is used to get the system information
*				from the database
* Scope:		application
* Input:		None
* Output:		free_mem		free memory
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupGetSystemInfo(USHORT *free_mem)
{
	
	//	*free_mem = MemoryTotalFree();
	return;
}



/*****************************************************************
* Function:	SySetupRestoreDateSettings
* Purpose: 	This function is used to restore the date settings
*				from the timer
* Scope:		application
* Input:		form_id					Form ID of date settings
year_push_id			The first push button ID of year selection
month_push_id			The first push button ID of month selection	
* Output:		row_num					Row number of the table object in date settings
col_num					Column number of the table object in date settings
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupRestoreDateSettings(ObjectID form_id, ObjectID table_id, ObjectID year_push_id, 
								ObjectID month_push_id, USHORT *row_num, USHORT *col_num)
{
	ObjectID	control_id;
	BYTE		year_label[5]={0};
	SHORT		first_year;
	//SHORT		year_4th_digit;
	USHORT		i = 0;
	RTM			timer;
	CountrySettings	country;
	
	RtcGetTime(&timer);
	SySetupGetCountrySettings(&country);
	
	//-----------------------------------------------------------------------
	/*
	year_4th_digit = timer.year%1000;
	year_4th_digit %= 100;
	year_4th_digit %= 10;
	control_id = year_push_id;
	if (year_4th_digit > 4)
	year_4th_digit -= 5;
	
	  first_year = timer.year - year_4th_digit;
	  sprintf((char*)year_label, "%d", first_year);
	  
		while(i < 5)
		{
		ControlSetLabel(control_id, year_label);
		if (i == year_4th_digit)
		FormSetControlGroupSelection(form_id, control_id);
		i++;
		year_label[3]++;
		control_id++;
		}
		
	*/
	//----------------------------------------------
	control_id = year_push_id;
	if (timer.year < 1907)
		first_year = 1905;
	else if(timer.year > 2093)
		first_year = 2095;
	else
		first_year = timer.year - 2;
	
	sprintf((char*)year_label, "%d", first_year);
	while(i < 5)
	{
		ControlSetLabel(control_id, year_label);
		if (first_year+i == timer.year)
			FormSetControlGroupSelection(form_id, control_id);
		i++;
		sprintf((char*)year_label, "%d", first_year+i);
		control_id++;
	}
	//-----------------------------------------------------------------------
	
	FormSetControlGroupSelection(form_id, (ObjectID)(timer.mon + month_push_id));
	
	SySetupDateUpdateTable(table_id, timer.year, timer.mon, timer.mday,
		country.start_of_week, row_num, col_num);
	
	return;
}


/*****************************************************************
* Function:	SySetupDateUpdateYearBar
* Purpose: 	This function is used to update the year bar settings
*				on the screen
* Scope:		application
* Input:		year_push_id				First year push button object ID
year_push_bkgrd_id			Year push button background object ID
shift_action				Year shift action (LEFT or RIGHT)
* Output:		None
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupDateUpdateYearBar(ObjectID year_push_id, ObjectID year_push_bkgrd_id, SHORT shift_action)
{
	
	BYTE	year_label[5] = {0}, *first_year_label;
	SHORT	first_year;
	
	//	ControlGetLabel(PUSH_SYSETUP_DATE_Y1, &first_year_label);
	ControlGetLabel(year_push_id, &first_year_label);
	first_year = ((SHORT)(first_year_label[0] - 48))*1000 + 
		((SHORT)(first_year_label[1] - 48))*100 + 
		((SHORT)(first_year_label[2] - 48))*10 + 
		((SHORT)(first_year_label[3] - 48));
	
	//-----------------------------------------------------------------------
	/*
	switch(shift_action)
	{
	case SYSETUP_YEAR_LEFT:
	if (first_year == 1905)
				return TRUE;
				first_year -= 5;
				sprintf((char*)year_label, "%d", first_year);
				ControlSetLabel(year_push_id, year_label);
				year_label[3] += 1;
				ControlSetLabel(year_push_id+1, year_label);
				year_label[3] += 1;
				ControlSetLabel(year_push_id+2, year_label);
				year_label[3] += 1;
				ControlSetLabel(year_push_id+3, year_label);
				year_label[3] += 1;
				ControlSetLabel(year_push_id+4, year_label);
				break;
				
				  case SYSETUP_YEAR_RIGHT:
				  if (first_year == 2095)
				  return TRUE;
				  first_year += 5;
				  sprintf((char*)year_label, "%d", first_year);
				  ControlSetLabel(year_push_id, year_label);
				  year_label[3] += 1;
				  ControlSetLabel(year_push_id+1, year_label);
				  year_label[3] += 1;
				  ControlSetLabel(year_push_id+2, year_label);
				  year_label[3] += 1;
				  ControlSetLabel(year_push_id+3, year_label);
				  year_label[3] += 1;
				  ControlSetLabel(year_push_id+4, year_label);
				  break;
				  
					default:	break;
					
					  }
	*/
	//-----------------------------------
	switch(shift_action)
	{
	case SYSETUP_YEAR_LEFT:
		first_year -= 5;
		if (first_year < 1906)
			first_year = 1905;
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id, year_label);
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id+1, year_label);
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id+2, year_label);
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id+3, year_label);
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id+4, year_label);
		break;
		
	case SYSETUP_YEAR_RIGHT:
		first_year += 5;
		if (first_year > 2094)
			first_year = 2095;
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id, year_label);
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id+1, year_label);
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id+2, year_label);
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id+3, year_label);
		sprintf((char*)year_label, "%d", first_year++);
		ControlSetLabel(year_push_id+4, year_label);
		break;
		
	default:	break;
		
	}
	//-----------------------------------------------------------------------
	
	ControlDrawControl(year_push_bkgrd_id);
	ControlDrawControl(year_push_id);
	ControlDrawControl(year_push_id+1);
	ControlDrawControl(year_push_id+2);
	ControlDrawControl(year_push_id+3);
	ControlDrawControl(year_push_id+4);
	
	return TRUE;
}

/*****************************************************************
* Function:	SySetupDateUpdateTable
* Purpose: 	This function is used to update the year bar settings
*				on the screen
* Scope:		application
* Input:		table_id
year
month
day
start_of_week
* Output:		row_num
col_num
* Return:		TRUE if success
*				FALSE if invalid input
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupDateUpdateTable(ObjectID table_id, SHORT year, SHORT month, 
							   SHORT day, SHORT start_of_week, USHORT *row_num, USHORT *col_num)
{
	
	BYTE	day_text[3] = {0}, null_string[1] = {0}, day_in_string[3] = {0};
	SHORT	wday, nth_week, days_in_month;
	SHORT	start_cell, end_cell, current_cell;
	USHORT	i, j;
	Table	*table_ptr;
	
	
	
	TableSetHighlightCell(table_id, *row_num, *col_num, FALSE);
	
	RtcYMDToWday1(year, month, 1, &wday, &nth_week);
	days_in_month = RtcGetDaysInMonth(year, month);
	
	current_cell = 1;
	start_cell = wday - start_of_week;
	if (start_cell < 0)
		start_cell = 6;
	end_cell = start_cell + days_in_month + 1;
	if (day > days_in_month)
		day = days_in_month;
	day += start_cell;
	day_in_string[0] = '1';
	for(i=0; i<6; i++)
	{
		for(j=0; j<7; j++)
		{
			if ((current_cell > start_cell) && (current_cell < end_cell))
			{
				
				if (current_cell == day)
				{
					*row_num = i;
					*col_num = j;
					TableSetHighlightCell(table_id, i, j, TRUE);
				}
				else
					TableSetHighlightCell(table_id, i, j, FALSE);
				
				
				if ((day_in_string[0] <= '9') && (day_in_string[1] == 0))
				{
					TableSetItemText(table_id, i, j, day_in_string);
					if (day_in_string[0] < '9')
						day_in_string[0]++;
					else
					{
						day_in_string[0] = '1';
						day_in_string[1] = '0';
					}
				}
				else if((day_in_string[0] == '1') && (day_in_string[1] <= '9'))
				{
					TableSetItemText(table_id, i, j, day_in_string);
					if (day_in_string[1] < '9')
						day_in_string[1]++;
					else
					{
						day_in_string[0] = '2';
						day_in_string[1] = '0';
					}
				}
				else if((day_in_string[0] == '2') && (day_in_string[1] <= '9'))
				{
					TableSetItemText(table_id, i, j, day_in_string);
					if (day_in_string[1] < '9')
						day_in_string[1]++;
					else
					{
						day_in_string[0] = '3';
						day_in_string[1] = '0';
					}
				}
				else
				{
					TableSetItemText(table_id, i, j, day_in_string);
					day_in_string[1]++;
				}
				
			}
			else
				TableSetItemText(table_id, i, j, null_string);
			
			current_cell++;
		}
	}
	
	return TRUE;
}




/*****************************************************************
* Function:	SySetupGetDateSettings
* Purpose: 	This function is used to get the date settings
*				from the database
* Scope:		application
* Input:		form_id
table_id
month_push_id
year_group_id
month_group_id
row_num
col_num
* Output:		year
month
day
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
void SySetupGetDateSettings(ObjectID form_id, ObjectID table_id, ObjectID month_push_id, 
							USHORT year_group_id, USHORT month_group_id, USHORT row_num, USHORT col_num,
							SHORT *year, SHORT *month, SHORT *day)
{
	
	ObjectID	control_id;
	BYTE		*control_label, *table_text;
	
	ControlGetPushedPushButton(form_id, year_group_id, &control_id);
	ControlGetLabel(control_id, &control_label);
	*year = ((SHORT)(control_label[0] - 48))*1000 + ((SHORT)(control_label[1] - 48))*100 + 
		((SHORT)(control_label[2] - 48))*10 + ((SHORT)(control_label[3] - 48));
	
	ControlGetPushedPushButton(form_id, month_group_id, &control_id);
	*month = (SHORT)(control_id - month_push_id);
	
	TableGetItemText(table_id, row_num, col_num, &table_text);
	if (table_text[1] == 0)
		*day = (SHORT)(table_text[0] - 48);
	else
		*day = (SHORT)((table_text[0] - 48)*10 + table_text[1] - 48);
	
	return;
}

/*****************************************************************
* Function:	SySetupSetCheckPasswordFlag
* Purpose: 	This function is used to set the flag for password checking
when starting up
* Scope:		application
* Input:		set
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupSetCheckPasswordFlag(BOOLEAN set)
{
	
	DatabaseID	SySetup_dbid;
	RecordID	rec_id;
	PasswordSettings	password;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (!SySetupGetPasswordSettings(&password))
		return FALSE;
	qfree(password.hints);
	
	if (DataOpenDB(SySetup_dbid, F_App, OPEN_RW) != TRUE)
		return FALSE;
	
	if (DataOpenRecord(SySetup_dbid, PASSWORD, &rec_id, NULL) != TRUE)
		return FALSE;
	
	if (set)
		password.check_password = 1;
	else
		password.check_password = 0;
	
	if (DataWriteField(SySetup_dbid, rec_id, 1, sizeof(PasswordSettings), (BYTE*)&password) != TRUE)
		return FALSE;
	
	if (DataCloseRecord(SySetup_dbid, rec_id) != TRUE)
		return FALSE;
	
	if (DataCloseDB(SySetup_dbid) != TRUE)
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupCheckPassword
* Purpose: 	This function is used to check the password settings
*				from the database
* Scope:		internal
* Input:		input_password
* Output:		None
* Return:		TRUE if the input password is valid
*				FALSE if not valid
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupCheckPassword(BYTE *input_password)
{
	DatabaseID	SySetup_dbid;
	PasswordSettings	password;
	
	if (!DataFindDB(SYSETUPDB, &SySetup_dbid))
		return FALSE;
	
	if (!SySetupGetPasswordSettings(&password))
		return FALSE;
	qfree(password.hints);
	
	if (strcmp(input_password, password.password))
		return FALSE;
	
	return TRUE;
}


/*****************************************************************
* Function:	SySetupSetCheckPassword
* Purpose: 	This function is used to set the password settings
*				from the database
* Scope:		internal
* Input:		check_password
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupSetCheckPassword(BYTE check_password)
{
	
	GPassCheck = check_password;
	return;
}


/*****************************************************************
* Function:	SySetupSetAutoOffTime
* Purpose: 	This function is used to set the auto off time
* Scope:		internal
* Input:		auto_off_time
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupSetAutoOffTime(BYTE auto_off_time)
{
	
	GAutoPwrOffTime = auto_off_time;
	return;
}

/*****************************************************************
* Function:	SySetupSetKeyMapping
* Purpose: 	This function is used to set the key mapping
* Scope:		internal
* Input:		key_mapping
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupSetKeyMapping(KeyMappingSettings key_mapping)
{
	
	GKeyMapping = key_mapping;
	return;
}


/*****************************************************************
* Function:	SySetupSetCalPenMode
* Purpose: 	This function is used to set the pen calibration mode
* Scope:		internal
* Input:		cal_pen_status
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupSetCalPenMode(BYTE cal_pen_status)
{
	GCalPenStatus = cal_pen_status;
	
	return;
}

/*****************************************************************
* Function:	SySetupGetCalPenMode
* Purpose: 	This function is used to set the pen calibration mode
* Scope:		internal
* Input:		cal_pen_status
* Output:		None
* Return:		None
* Comment: 	None
*****************************************************************/
void SySetupGetCalPenMode(BYTE *cal_pen_status)
{
	
	*cal_pen_status = GCalPenStatus;
	
	return;
}


/*****************************************************************
* Function:	SySetupRestoreSettingsAfterSync
* Purpose: 	This function is used to restore the settings after sync.
* Scope:		application
* Input:		None
* Output:		None
* Return:		TRUE if success
*				FALSE if no memory
* Comment: 	None
*****************************************************************/
BOOLEAN SySetupRestoreSettingsAfterSync(void)
{
	KeyMappingSettings	key_mapping;
	ClockSettings		clock;
	
	if (!SySetupGetKeyMappingSettings(&key_mapping))
		return FALSE;
	SySetupSetKeyMapping(key_mapping);
	
	// ----------------------------------------------------------------------
	
	if (!SySetupGetClockSettings(&clock))
		return TRUE;
	SySetupSetAutoOffTime(clock.auto_off_time);
	// ----------------------------------------------------------------------
	
	return TRUE;
}
