/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   telecom.c
Author(s)   :   
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "dev_bety.h"
#include "pr31700s.h"
#include "pr31700c.h"
#include "telecom.h"
//#define PHILIPS

#define VTECH

extern short tel_rx_buf[TEL_BLOCK_SIZE*4];
extern short tel_tx_buf[TEL_BLOCK_SIZE*4];
extern short snd_tx_buf[TEL_BLOCK_SIZE*4];

void TelInit()
{
	
#ifdef VTECH
	//	CPU->REG_MEM_CONFIG_2 = 0x1133;
    /* Enable SIB Clock */
    CPU->REG_CLK_CTRL |= SIBMCLKDIR | ENSIBMCLK | SIBMCLKDIV(2);
	
    CPU->REG_SIB_CTRL = 0;
	
    /* Reset Betty */
    CPU->REG_IR_CTRL_1 |= (1 << 2);
    Delay(0xFFFF);
    CPU->REG_IR_CTRL_1 &= ~(1 << 2);
    Delay(0xFFFF);
    CPU->REG_IR_CTRL_1 |= (1 << 2);
    Delay(0xFFFF);
	
    /* Clear and Enable SF0 Interrupt */
    CPU->REG_INT_STATUS_1 = SIBSF0INT;
	
    /* Init Tel in SIB register  */
    CPU->REG_SIB_CTRL = TEL16 | TELFSDIV(TEL_SAMPLE_RATE(8000)) | ENTEL | ENSF1
        | ENSF0 | ENSIB;
    /* May need to set SIBSCLKDIV in REG_SIB_CTRL */
	
    /* Init Tel in Betty */
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_TEL_CTRL_A | BTY_WRT
        | BTY_TEL_DIV(TEL_SAMPLE_RATE(8000)+1);
	
    Delay(0xFFFF);
	
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_TEL_CTRL_B | BTY_WRT
        | BTY_TEL_SIDE_ENA /*| BTY_TEL_ATT */| BTY_TEL_OUT_ENA | BTY_TEL_IN_ENA;
    Delay(0xFFFF);
    /* Define start address for telecom RX and TX DMA buffer */
    CPU->REG_SIB_TEL_RX_START = (int) tel_rx_buf & 0x1FFFFFFF;
    CPU->REG_SIB_TEL_TX_START = (int) tel_tx_buf & 0x1FFFFFFF;
    CPU->REG_SIB_SIZE = TELSIZE(TEL_BLOCK_SIZE*4-1);
	
    /* Assign I/O ports as On/Off Hook and Ring Detect */
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_IO_PORT_DIRECTN | BTY_WRT | BTY_IO_DIR(0x1FE)
        | BTY_SIB_ZERO;
	Delay(0xFFFF);
	
    /* External voltage */
	/*    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL | BTY_WRT | BTY_EXT_REF_ENA;
	*/
	//    CPU->REG_INT_ENABLE_1 &= ~SIBSF0INT;
#endif
	
#ifdef PHILIPS
	BtyReset();
	
    CPU->REG_SIB_CTRL = 0;
	
    /* Enable SIB Clock */
    CPU->REG_CLK_CTRL |= SIBMCLKDIR | ENSIBMCLK | SIBMCLKDIV(2);
	
    /* Init Tel in SIB register  */
    CPU->REG_SIB_CTRL |= TEL16 | TELFSDIV(TEL_SAMPLE_RATE(8000)) | ENSF0;
	/* Move here */
	//    CPU->REG_SIB_CTRL |= SNDMONO | SND16 | SNDFSDIV(TEL_SAMPLE_RATE(8000));
	/* Move here */
    CPU->REG_SIB_CTRL |= ENSIB;
	
    /* Define start address for telecom RX and TX DMA buffer */
    CPU->REG_SIB_TEL_RX_START = VirToPhy((int) tel_rx_buf);
    CPU->REG_SIB_TEL_TX_START = VirToPhy((int) tel_tx_buf);
    CPU->REG_SIB_SIZE = TELSIZE(TEL_BLOCK_SIZE*4-1) | SNDSIZE(TEL_BLOCK_SIZE*4-1);
	
    /* Init Tel in Betty */
	/* Add here */
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_TEL_CTRL_A | BTY_WRT
        | BTY_TEL_DIV(TEL_SAMPLE_RATE(8000)+1);
	
	//    CPU->REG_SIB_CTRL |= ENSIB;
	
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_TEL_CTRL_B | BTY_WRT
        | BTY_TEL_SIDE_ENA | BTY_TEL_OUT_ENA | BTY_TEL_IN_ENA;
	
	/* Move here */
    CPU->REG_SIB_CTRL |= ENTEL;
	
	/* Sound Init */
    CPU->REG_SIB_CTRL |= SNDMONO | SND16 | SNDFSDIV(TEL_SAMPLE_RATE(8000));
	CPU->REG_SIB_SND_RX_START = VirToPhy((int) snd_tx_buf);
	CPU->REG_SIB_SND_TX_START = VirToPhy((int) snd_tx_buf);
	//	CPU->REG_SIB_SIZE |= SNDSIZE(TEL_BLOCK_SIZE*4-1);
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_AUD_CTRL_A | BTY_WRT
		| BTY_AUD_DIV(TEL_SAMPLE_RATE(8000)+1);
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_AUD_CTRL_B | BTY_WRT
		| BTY_AUD_OUT_ENA;
	
	
	//    CPU->REG_SIB_CTRL |= ENTEL;
	//    CPU->REG_SIB_CTRL |= ENSND;
	
    /* Assign I/O ports as On/Off Hook and Ring Detect */
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_IO_PORT_DIRECTN | BTY_WRT | BTY_IO_DIR(0x3FE)
        | BTY_SIB_ZERO;
	
    /* External voltage */
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL | BTY_WRT | BTY_EXT_REF_ENA;
#endif
	
#ifdef VTECH_SDRAM
	//	CPU->REG_MEM_CONFIG_2 = 0x1133;
	BtyReset();
	
    CPU->REG_SIB_CTRL = 0;
	
    /* Enable SIB Clock */
    CPU->REG_CLK_CTRL |= SIBMCLKDIR | ENSIBMCLK | SIBMCLKDIV(2);
	
    /* Init Tel in SIB register  */
    CPU->REG_SIB_CTRL |= TEL16 | TELFSDIV(TEL_SAMPLE_RATE(8000)) | ENSF0;
	/* Move here */
	//    CPU->REG_SIB_CTRL |= SNDMONO | SND16 | SNDFSDIV(TEL_SAMPLE_RATE(8000));
	/* Move here */
    CPU->REG_SIB_CTRL |= ENSIB;
	
    /* Define start address for telecom RX and TX DMA buffer */
    CPU->REG_SIB_TEL_RX_START = VirToPhy((int) tel_rx_buf);
    CPU->REG_SIB_TEL_TX_START = VirToPhy((int) tel_tx_buf);
    CPU->REG_SIB_SIZE = TELSIZE(TEL_BLOCK_SIZE*4-1) | SNDSIZE(TEL_BLOCK_SIZE*4-1);
	
    /* Init Tel in Betty */
	/* Add here */
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_TEL_CTRL_A | BTY_WRT
        | BTY_TEL_DIV(TEL_SAMPLE_RATE(8000)+1);
	
	//    CPU->REG_SIB_CTRL |= ENSIB;
	
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_TEL_CTRL_B | BTY_WRT
        | BTY_TEL_SIDE_ENA | BTY_TEL_OUT_ENA | BTY_TEL_IN_ENA;
	
	/* Move here */
    CPU->REG_SIB_CTRL |= ENTEL;
	
	/* Sound Init */
    CPU->REG_SIB_CTRL |= SNDMONO | SND16 | SNDFSDIV(TEL_SAMPLE_RATE(8000));
	CPU->REG_SIB_SND_RX_START = VirToPhy((int) snd_tx_buf);
	CPU->REG_SIB_SND_TX_START = VirToPhy((int) snd_tx_buf);
	//	CPU->REG_SIB_SIZE |= SNDSIZE(TEL_BLOCK_SIZE*4-1);
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_AUD_CTRL_A | BTY_WRT
		| BTY_AUD_DIV(TEL_SAMPLE_RATE(8000)+1);
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_AUD_CTRL_B | BTY_WRT
		| BTY_AUD_OUT_ENA;
	
	
	//    CPU->REG_SIB_CTRL |= ENTEL;
    CPU->REG_SIB_CTRL |= ENSND;
	
    /* Assign I/O ports as On/Off Hook and Ring Detect */
    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_IO_PORT_DIRECTN | BTY_WRT | BTY_IO_DIR(0x3FE)
        | BTY_SIB_ZERO;
	
    /* External voltage */
	/*    BtyClearSF0Int();
    BtyWaitSF0Int();
    CPU->REG_SIB_SF0_CTRL = BETTY_ADC_CTRL | BTY_WRT | BTY_EXT_REF_ENA;
	*/
#endif
}

void TelOnHook()
{
/*    BtyClearSF0Int();
BtyWaitSF0Int();
CPU->REG_SIB_SF0_CTRL = BETTY_IO_PORT_DATA | BTY_WRT | BTY_IO_DATA(0x3FE);
    Delay(0xFF);*/
    CPU->REG_MFIO_DIRECTN |= 1 << 5;
    CPU->REG_MFIO_DATA_OUT |= 1 << 5;
}

void TelOffHook()
{
/*    BtyClearSF0Int();
BtyWaitSF0Int();
CPU->REG_SIB_SF0_CTRL = BETTY_IO_PORT_DATA | BTY_WRT | BTY_IO_DATA(0x0);
    Delay(0xFF);*/
    CPU->REG_MFIO_DIRECTN |= 1 << 5;
    CPU->REG_MFIO_DATA_OUT &= ~(1 << 5);
}

void TelRingDetect()
{
	char temp[12];
	int i;
	//        modemCommandStruct sm_cmd;
	/*       if (ris_int_count != 0 && prev_ris_int_count == ris_int_count)
	{
	UartPrintf(UART_A, "\nRing: ");
	int2hex(ris_int_count, temp);
	UartPrintf(UART_A, temp);
	ris_int_count = 0;
	*/
	for (i=0; i<100; i++)
	{
		//            sm_cmd.command = kRingIndicatorCmd;
		//            sm_cmd.param.state = true;
		//            (*CommandHandler)(&sm_cmd);
    }
	/*
	}
	prev_ris_int_count = ris_int_count;
	*/
}
