/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  

Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
  
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999
	
The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   tlbc.c
Author(s)   :   Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   TLB
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "pr3910.h"
#include "pr31700s.h"
#include "pr31700c.h"
#include "Tlb.h"

/*	Function	: TlbSetASID
*	Purpose		: Set current ASID
*  Scope		: OS
*	Input		: Current ASID
*	Output      : None
*	Comment		:
*/
void TlbSetASID(UWORD sys_asid)
{
	CP0WriteEntryHiReg(ENTRYHI_ASID(sys_asid));
}

/*	Function	: TlbGetASID
*	Purpose		: Get current ASID
*  Scope		: OS
*	Input		: None
*	Output      : Current ASID
*	Comment		:
*/
UWORD TlbGetASID()
{
	return (CP0ReadEntryHiReg() & ENTRYHI_ASIDMASK) >> 6;
}

/*	Function	: TlbGetRand
*	Purpose		: Get Random number
*  Scope		: OS
*	Input		: None
*	Output      : Random number : 8 - 63
*	Comment		:
*/
UWORD TlbGetRand()
{
	return CP0ReadRandReg();
}

/*	Function	: TlbGetBadVPN
*	Purpose		: Get bad VPN
*  Scope		: OS
*	Input		: None
*	Output      : Bad VPN
*	Comment		:
*/
UWORD TlbGetBadVPN()
{
	return (CP0ReadContextReg() & CONTEXT_BADVPNMASK) >> 2;
}

/*	Function	: TlbGetBVAddr
*	Purpose		: Get bad virtual address
*  Scope		: OS
*	Input		: None
*	Output      : Bad virtual address
*	Comment		:
*/
UWORD TlbGetBVAddr()
{
	return CP0ReadBadVAddrReg();
}

#if 0
/*	Function	: TlbSetRandEntry
*	Purpose		: Set TLB content in random entry
*  Scope		: OS
*	Input		: Entry high and low register
*	Output      : None
*	Comment		:
*/
UWORD TlbSetRandEntry(UWORD entryhi, UWORD entrylo)
{
	__asm(".set	noat");
	__asm(".set noreorder");
	__asm("mfc0	$8, $10");
	__asm("mtc0	$4, $10");
	__asm("mtc0	$5, $2");
	__asm("nop");
	__asm("tlbwr");
	__asm("nop");
	__asm("mtc0	$8, $10");
	__asm(".set reorder");
	return (entryhi + entrylo);
}

/*	Function	: TlbSetEntry
*	Purpose		: Set TLB content in specific entry
*  Scope		: OS
*	Input		: Index, entry high and low register
*	Output      : None
*	Comment		:
*/
UWORD TlbSetEntry(UWORD index, UWORD entryhi, UWORD entrylo)
{
	__asm(".set	noat");
	__asm(".set noreorder");
	__asm("mfc0	$8, $10");
	__asm("nop");
	__asm("mtc0	$4, $0");
	__asm("nop");
	__asm("mtc0	$5, $10");
	__asm("nop");
	__asm("mtc0	$6, $2");
	__asm("nop");
	__asm("tlbwi");
	__asm("nop");
	__asm("mtc0	$8, $10");
	__asm("nop");
	__asm(".set reorder");
	return (index + entryhi + entrylo);
}

/*	Function	: TlbGetEntry
*	Purpose		: Get TLB content from specific entry
*  Scope		: OS
*	Input		: Index register
*	Output      : Entry high and low register
*	Comment		:
*/
UWORD TlbGetEntry(UWORD index, UWORD *entryhi, UWORD *entrylo)
{
	__asm(".set	noat");
	__asm(".set noreorder");
	__asm("mfc0	$8, $10");
	__asm("mtc0	$4, $0");
	__asm("nop");
	__asm("tlbr");
	__asm("nop");
	__asm("mfc0 $9, $10");
	__asm("nop");
	__asm("sw	$9, 0($5)");
	__asm("mfc0	$9, $2");
	__asm("nop");
	__asm("sw	$9, 0($6)");
	__asm("mtc0	$8, $10");
	__asm(".set reorder");
	return (index + *entryhi + *entrylo);
}
#endif
/*	Function	: TlbInit
*	Purpose		: Initialize (Clear) TLB content of all entries
*  Scope		: OS
*	Input		: None
*	Output      : None
*	Comment		:
*/
void TlbInit()
{
	UWORD i;
	for (i = 0; i < 64; i++)
	{
		TlbSetEntry(i<<8, 0x00000000, 0x00000000);
	}
}

/*	Function	: TlbDirtyEntry
*	Purpose		: Dirty TLB content of specific ASID
*  Scope		: OS
*	Input		: ASID
*	Output      : None
*	Comment		:
*/
void TlbDirtyEntry(UWORD sys_asid)
{
	UWORD i, entryhi, entrylo;
	for (i = 0; i < 64; i++)
	{
		TlbGetEntry(i<<8, &entryhi, &entrylo);
		if (sys_asid == ((entryhi>>6) & 0x3F))
		{
			TlbSetEntry(i<<8, 0x00000000, 0x00000000);
		}
	}
}
