/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   welcome.c
Author(s)   :   Henry Fok, Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   welcome screen and low battery screen
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include "pr31700s.h"
#include "pr31700c.h"
#include "intc.h"
#include "uart.h"
#include "print.h"
#include "tmrapi.h"
#include "msg.h"
#include "eventmgr.h"
#include "mmu.h"
#include "alaunch.h"
#include "ttp.h"
#include "lcdapi.h"
#include "dev_pwr.h"

//#define DEBUG

extern EvtQueueType evtQueue;
extern MsgQueueType	msgQueue;

UWORD lowbattmr, weltmr;

const UWORD lowbat[500] = {
0x0fffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
0xffffffff, 0xff0f0000, 0x30000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00cf0000, 0xcaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaa00000, 0x0002aaaa,
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000,
0xca855555, 0x5557a8a8, 0xa8aaaaaa, 0x8aaaaaaa, 0xa80aaa8a, 0x8aaaaaaa, 0xa2aaaaaa, 0xaaaaaaaa,
0xaaaaaaaa, 0xaabf0000, 0xca855540, 0x5557a8a8, 0xa8aaaaaa, 0xaaaaaaaa, 0xa8a2aa8a, 0x8aaaaaaa,
0xa2aaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaa15547, 0x555ea8a8, 0xa8828882, 0x882a2aaa,
0xa8a20a02, 0x028a2222, 0xa2aa2888, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaa15547, 0x555eaa22,
0x22a88288, 0x88888a80, 0xa80aa28a, 0x8a220a22, 0xa2a88888, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000,
0xcaa85547, 0x557aaa22, 0x22808a88, 0x88888aaa, 0xa8a2028a, 0x8a022a22, 0xa2a88888, 0xaaaaaaaa,
0xaaaaaaaa, 0xaabf0000, 0xcaa85547, 0x557aaa8a, 0x8a888a88, 0x888a0aaa, 0xa8a2228a, 0x8a2a2a82,
0xa2a88a22, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaaa1547, 0x55eaaa8a, 0x8a808a88, 0x888a8aaa,
0xa80a02a2, 0xa2822aa2, 0xa00a2a22, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaaa1547, 0x55eaaaaa,
0xaaaaaaaa, 0xaaa82aaa, 0xaaaaaaaa, 0xaaaaaa0a, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000,
0xcaaa857f, 0x57aaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
0xaaaaaaaa, 0xaabf0000, 0xcaaa8555, 0x57aaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaaaa143, 0x5eaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaaaa147, 0x5eaaaaaa,
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 
0xcaaaa87f, 0x7aaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
0xaaaaaaaa, 0xaabf0000, 0xcaaaa855, 0x7aaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaaaaa15, 0xeaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa,
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaaaaa15, 0xeaaaaaaa, 
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 
0xcaaaaa87, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 
0xaaaaaaaa, 0xaabf0000, 0xcaaaaa8f, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 0xcaaaaaaa, 0xaaaaaaaa, 
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000, 
0xcaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 
0xaaaaaaaa, 0xaabf0000, 0xcbffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xe2bf0000, 0xcb000000, 0x00000000, 0x00000000, 0x00000000,
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22bf0000, 
0xcb000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22bf0000,
0xcb000000, 0x00000000, 0x00000000, 0xc0000000, 0x3f000303, 0x00000000, 0xccc00000, 0x00000000, 
0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 0x00000000, 0xc0000000, 0x30c00303, 0x00000000,
0xccc00000, 0x00000000, 0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 0x00000000, 0xc00c3330,
0x30cf0fcf, 0xc30cccc0, 0xccc00000, 0x00000000, 0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 
0x00000000, 0xc0333330, 0x3f00c303, 0x0ccf0cc0, 0xccc00000, 0x00000000, 0x00000000, 0x22bf0000,
0xcb000000, 0x00000000, 0x00000000, 0xc0333330, 0x30cfc303, 0x0fcc0cc0, 0xccc00000, 0x00000000, 
0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 0x00000000, 0xc0330cc0, 0x30ccc303, 0x0c0c03c0, 
0x00000000, 0x00000000, 0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 0x00000000, 0xff0c0cc0, 
0x3f0fc0c0, 0xc3cc00c0, 0xccc00000, 0x00000000, 0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000f00, 0x00000000, 0x00000000, 0x00000000, 0x22bf0000, 
0xcb000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22bf0000, 0xcb000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22bf0000,
0xcb000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x22bf0000, 0xcbaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xa2bf0000, 0xc8000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02bf0000, 0xcaaaaaaa, 0xaaaaaaaa, 
0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaabf0000,
0x3aaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 0xaaaaaaaa, 
0xaaaaaaaa, 0xaacf0000, 0x0fffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
0xffffffff, 0xffffffff, 0xffffffff, 0xff0f0000, };

const UWORD welcome[1600] = {
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3c0f0c00, 0x00000000, 
0x00003c00, 0xf000000f, 0x3c00f003, 0xf03f03f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x3c0f3c00, 0x00000000, 0x0000fc00, 0xf0000000, 0x3c00f00f, 0x3cf3cf3c, 0x00000000, 0x00000000, 
0x00000000, 0x000003fc, 0x0f3cff0f, 0xf03fc00f, 0x3c03fc00, 0xffc3c3cf, 0x3c3ff00f, 0x3cf3c03c, 
0x00000000, 0x00000000, 0x00000000, 0x00000f0f, 0x0f3c3c3c, 0x3cf0f00f, 0x3c033c00, 0xf0f3c3cf, 
0x3cf0f00f, 0x3cf3c0f0, 0x00000000, 0x00000000, 0x00000000, 0x00000fff, 0x0f3c3c3c, 0x3cff000f, 
0x3c003c00, 0xf0f3c3cf, 0x3cf0f00f, 0x3cf3c03c, 0x00000000, 0x00000000, 0x00000000, 0x00000f00, 
0x0f3c3c3c, 0x3c0ff00f, 0x3c003c00, 0xf0f3c3cf, 0x3cf0f00f, 0x3cf3c03c, 0x00000000, 0x00000000, 
0x00000000, 0x00000f0f, 0x03f03c3c, 0x3cf0f003, 0xf0f03c00, 0xf0f3c3cf, 0x3cf0f00f, 0x3cf3cf3c, 
0x00000000, 0x00000000, 0x00000000, 0x000003fc, 0x03f00f0f, 0xf03fc003, 0xf0f03c00, 0xffc0ffcf, 
0x3c3ff003, 0xf03f03f0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x000000ff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xfffffff0, 0x00000000, 0x00000000, 0x00000000, 0x000000c0, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000030, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xffffffff, 0xfffffffc, 0x00000000, 0x00000fff, 0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xffffffff, 0xfffc0000, 0x3fffffff, 0xffff0000, 0x03ffffff, 0xffffff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xf000ffff, 0xffffffff, 0xffffffff, 
0xc003ffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xfffffff0, 0x00ffffff, 
0xffffffff, 0xffffffff, 0xfff003ff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xfffffc00, 0x0fffffff, 0xffffffff, 0xffffffff, 0xffff000f, 0xffffff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xffff0000, 0x0fffffff, 0xffffffff, 0xffffffff, 0xffff0000, 0x3fffff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xfffc0000, 0x0fffffff, 0xffffffff, 0xffffffff, 
0xffff0000, 0x03ffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffc00000, 0x00ffffff, 
0xffffffff, 0xffffffff, 0xfff00000, 0x00ffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xff000000, 0x00000fff, 0xffffffff, 0xffffffff, 0xc0000000, 0x003fff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xff000000, 0x00000000, 0xffffffff, 0xfffff000, 0x00000000, 0x000fff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xfc000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x0003ff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xfc000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x0003ff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xfc000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0003ff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xff000000, 0x00000000, 0xffffffff, 0xfffff000, 0x00000000, 0x000fff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xff000000, 0x0000ffff, 0xffffffff, 0xffffffff, 
0xf0000000, 0x003fff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xfff00000, 0x00ffffff, 
0xffffffff, 0xffffffff, 0xfffc0000, 0x00ffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xfffc0000, 0x0fffffff, 0xffffffff, 0xffffffff, 0xffff0000, 0x0fffff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xffffc000, 0x0fffffff, 0xffffffff, 0xffffffff, 0xffff0000, 0xffffff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffff00, 0x0fffffff, 0xffffffff, 0xffffffff, 
0xfffc000f, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xfffffffc, 0x00ffffff, 
0xffffffff, 0xffffffff, 0xff000fff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xffffffff, 0xfc00ffff, 0xffffffff, 0xffffffff, 0xc00fffff, 0xffffff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xffffffff, 0xfffc0000, 0x3fffffff, 0xffff0000, 0x0fffffff, 0xffffff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xfffffffc, 0x00000000, 0x00000fff, 
0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xfff03f03, 0xfffff000, 
0xffffff0f, 0xffffff03, 0xffffff00, 0x0fffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xfff03f03, 0xfffff03f, 0xffffff0f, 0xffffff03, 0xfffffc0f, 0x03ffff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xfff00003, 0xfffff003, 0xffffff0f, 0xffffff03, 0xfffff03f, 0xc0ffff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xfff03f03, 0xfffff03f, 0xffffff0f, 0xffffff03, 
0xfffff03f, 0xc0ffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xfff03f03, 0xfffff03f, 
0xffffff00, 0x3fffff03, 0xfffffc0f, 0x03ffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xfff03f03, 0xfffff000, 0xffffff00, 0x3fffff03, 0xffffff00, 0x0fffff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 
0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 
0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000cf, 0xffffffff, 0xffffffff, 
0xffffffff, 0xffffffff, 0xffffffff, 0xffffff30, 0x00000000, 0x00000000, 0x00000000, 0x000000c0, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000030, 0x00000000, 0x00000000, 
0x00000000, 0x000000ff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xfffffff0, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000fff3c, 0x00f00000, 
0x00000000, 0x00000000, 0x0c3c0000, 0x00000000, 0x0000000c, 0x00000000, 0x00000000, 0x00000000, 
0x0000f03c, 0x00000000, 0x00000000, 0x00000000, 0x3c000000, 0x00000000, 0x0000003c, 0x00000000, 
0x00000000, 0x00000000, 0x0000f03f, 0xf0f0ff00, 0x0ff0ffc0, 0xff0ff0fc, 0xff3cffc0, 0xffc00ff3, 
0xc0f3fcff, 0x0ff0ffff, 0xc0000000, 0x00000000, 0x0000f03c, 0x3cf3c3c0, 0x3c3cf0f3, 0xc3cf030f, 
0x3c3cf0f3, 0xc3c03c3c, 0xf3cf0f3c, 0x3c3cf0f0, 0xf0000000, 0x00000000, 0x0000f03c, 0x3cf3fc00, 
0x3c3cf0f3, 0xffcf00ff, 0x3c3cf0f3, 0xc3c03fc0, 0xf3cff03c, 0x3ffcf0f0, 0xf0000000, 0x00000000, 
0x0000f03c, 0x3cf03fc0, 0x3c3cf0f3, 0xc00f03cf, 0x3c3cf0f3, 0xc3c003fc, 0xf3c0ff3c, 0x3c00f0f0, 
0xf0000000, 0x00000000, 0x0000f03c, 0x3cf3c3c0, 0x3c3cf0f3, 0xc3cf03cf, 0x3c3cf0f3, 0xc3c03c3c, 
0x3f0f0f3c, 0x3c3cf0f0, 0xf0000000, 0x00000000, 0x0000f03c, 0x3cf0ff00, 0x0ff0ffc0, 0xff0f00ff, 
0x0f3cf0f0, 0xffc00ff0, 0x3f03fc0f, 0x0ff0f0f0, 0xf0000000, 0x00000000, 0x00000000, 0x00000000, 
0x0000f000, 0x00000000, 0x00000003, 0x03c00000, 0x3c000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x0000f000, 0x00000000, 0x00000000, 0xff000003, 0xf0000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x003f3000, 0x00000000, 0x000003c0, 0x00000000, 0x0f000000, 
0x00000000, 0x000003c0, 0x000000c0, 0x00000f00, 0x00000000, 0x00f0f000, 0x00000000, 0x000003c0, 
0x00000000, 0x0f000000, 0x00000000, 0x000003c0, 0x000003c0, 0x00000f00, 0x0003fc0f, 0xf3fffcf0, 
0xc3c3f0ff, 0x0ff003ff, 0x03f03fc0, 0x0ffc0ff0, 0x3fc3ff00, 0x0fc0ffc3, 0xf0ffcff0, 0xff03ff00, 
0x000f0f3c, 0x3cf0f0f3, 0xf3cc3cf0, 0x3c3c03c3, 0xcc3cf0f0, 0x0f0f3c3c, 0xf0f3c3c0, 0x30f3c3cc, 
0x3cf0f3c3, 0xc3cf0f00, 0x000ff03c, 0x3cf0f0f3, 0xf3c3fcf0, 0x3ffc03c3, 0xc3fcff00, 0x0f0f3ffc, 
0xfff3c3c0, 0x0ff3c3c3, 0xfcf0f3c3, 0xffcf0f00, 0x0000ff3c, 0x3cf0f03f, 0x3f0f3cf0, 0x3c0003c3, 
0xcf3c0ff0, 0x0f0f3c00, 0xf003c3c0, 0x3cf3c3cf, 0x3cf0f3c3, 0xc00f0f00, 0x000f0f3c, 0x3cf0f03f, 
0x3f0f3cf0, 0x3c3c03c3, 0xcf3cf0f0, 0x0f0f3c3c, 0xf0f3c3c0, 0x3cf3c3cf, 0x3cf0f3c3, 0xc3cf0f00, 
0x0003fc0f, 0xf0f03c3c, 0x0f03fcf0, 0x0ff003c3, 0xc3fc3fc0, 0x0ffc0ff0, 0x3fc3c3c0, 0x0ff0ffc3, 
0xfcffc0f0, 0xff03ff00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00f00000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00f00000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0003c000, 
0x00000000, 0x03cf0ffc, 0x000003c0, 0x0fc00000, 0x00000003, 0xc0f3ffc0, 0x00fc03fc, 0x00000000, 
0x00000000, 0x0003c000, 0x00000000, 0x03c03c00, 0x000003c0, 0x3c000000, 0x00000003, 0xc0f03c00, 
0x03cf0f0f, 0x00000000, 0x0003f0ff, 0xc0ffc03f, 0xfff03fc0, 0xffcfff3c, 0x3fc0ffc0, 0xff3fc3fc, 
0x3ffff000, 0xf3c03c00, 0x0f03cf00, 0x00000000, 0x000c3cf0, 0xf3c3c03c, 0x3c3cf0f3, 0xc3cf3c3c, 
0xf0f3c3c0, 0x3c3c0f0f, 0x3c3c3c00, 0xf3c03c00, 0x0f03cff0, 0x00000000, 0x0003fcf0, 0xf3c3c03c, 
0x3c3cf0f3, 0xc3cf3c3c, 0xfff3c3c0, 0x3c3c0f0f, 0x3c3c3c00, 0xf3c03c00, 0x0f03c0ff, 0x00000000, 
0x000f3cf0, 0xf3c3c03c, 0x3c3cf0f3, 0xc3cf3c3c, 0xf003c3c0, 0x3c3c0f0f, 0x3c3c3c00, 0xf3c03c0f, 
0xcf03c00f, 0x00000000, 0x000f3cf0, 0xf3c3c03c, 0x3c3cf0f3, 0xc3cf3c3c, 0xf0f3c3c0, 0x3c3c0f0f, 
0x3c3c3c00, 0x3f003c00, 0x03cf0f0f, 0x00000000, 0x0003fcf0, 0xf0ffc03c, 0x3c3c3fc0, 0xffcf3c3c, 
0x3fc0ffc0, 0x3c3c03fc, 0x3c3c3c00, 0x3f003c00, 0x00fc03fc, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000003, 0xc0000000, 0x003c003f, 0x000fc0fc, 0x00f00000, 
0x0f3c00f0, 0x03f00f03, 0xf0000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00fc00f3, 
0xc03cf3cf, 0x00f00000, 0x003c00f0, 0x0f3c3f0f, 0x3c000000, 0x00000000, 0x000f3c3f, 0xc3fc3fc3, 
0xc3fc3ff0, 0x03fc0003, 0xc03cf00f, 0x00ffc3c3, 0xcf3c3ff0, 0x003cff00, 0x3c000000, 0x00000000, 
0x000f3cf0, 0xf3c0f0f3, 0xcf0f3c3c, 0x033c000f, 0x003cf00f, 0x00f0f3c3, 0xcf3cf0f0, 0x00f0cf00, 
0xf0000000, 0x00000000, 0x000f3cff, 0xf3c0ff03, 0xcf0f3c3c, 0x003c0003, 0xc03cf03c, 0x00f0f3c3, 
0xcf3cf0f0, 0x003c0f00, 0x3c000000, 0x00000000, 0x000f3cf0, 0x03c00ff3, 0xcf0f3c3c, 0x003c0003, 
0xc03cf0f0, 0x00f0f3c3, 0xcf3cf0f0, 0x003c0f00, 0x3c000000, 0x00000000, 0x0003f0f0, 0xf3c0f0f3, 
0xcf0f3c3c, 0x003c3cf3, 0xcf3cf3c0, 0x00f0f3c3, 0xcf3cf0f0, 0x0f3c0f0f, 0x3c000000, 0x00000000, 
0x0003f03f, 0xc3c03fc3, 0xc3fc3c3c, 0x003c3c3f, 0x0f0fc3ff, 0x00ffc0ff, 0xcf3c3ff0, 0x03f00f03, 
0xf0000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfc000000, 0x00000000, 
0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
};

void WelscrTmr()
{
	TmrIntDisable(weltmr);
	EvtAppendEvt(0, 0, 0, 0, NULL);
}

BOOLEAN Welscr()
{
	BitmapTemplate 		bitmap;
	BOOLEAN				system_battery_empty = FALSE;
	EvtType 			event;
	
    bitmap.xcoord = 0;
	bitmap.ycoord = 0;
	bitmap.width = 160;
	bitmap.height = 160;
	bitmap.quantisation = 2;
	
    (const *)bitmap.bitmap_data = welcome;
	LcdDrawBitmap(&bitmap, COLOR_NO_INVERT);
	
	MsgQueueCreate(&msgQueue);
	EvtQueueCreate(&evtQueue);
	
	weltmr = TmrIntEnable(5000, WelscrTmr);
	
    do
    {
		if (CheckBatteryEmpty() == 1)
		{
			system_battery_empty = TRUE;
			break;	
		}
		
		EvtGetEvent(&event);
		
		if ((event.eventType == POWER_EVENT && event.eventID == BAT_MAIN_EMPTY) ||
			(event.eventType == POWER_EVENT && event.eventID == BAT_DOOR_OPEN))
		{
			system_battery_empty = TRUE;
			break;    		
		}   	
#ifdef DEBUG
		printf("\n Welcome - Event = %ld %ld %ld %ld", event.eventType, event.eventID, event.para1, event.para2);
#endif		    	
	}while(event.eventType == POWER_EVENT);    	
	
	MsgQueueCreate(&msgQueue);
	EvtQueueCreate(&evtQueue);
	
	TmrIntDisable(weltmr);		
	if (system_battery_empty)
	{
#ifdef DEBUG
		printf("\n Low Bat Screen return FALSE");		
#endif		
		return FALSE;
	}		
	else
	{
#ifdef DEBUG
		printf("\n Low Bat Screen return TRUE");		
#endif			
		return TRUE;		
	}		
}

void LowbatscrTmr()
{
	TmrIntDisable(lowbattmr);
#ifdef DEBUG
	printf("\n Low Bat TimeOut");
#endif		
	EvtAppendEvt(0, 0, 0, 0, NULL);
}

BOOLEAN Lowbatscr()
{
	BitmapTemplate 		bitmap;
	BOOLEAN				system_battery_empty = FALSE;
	EvtType 			event;
	
    bitmap.xcoord = 5;
	bitmap.ycoord = 47;
	bitmap.width = 150;
	bitmap.height = 50;
	bitmap.quantisation = 2;
	
    (const *)bitmap.bitmap_data = lowbat;
	LcdDrawBitmap(&bitmap, COLOR_NO_INVERT);
	
	MsgQueueCreate(&msgQueue);
	EvtQueueCreate(&evtQueue);
	
	lowbattmr = TmrIntEnable(5000, LowbatscrTmr);
	
    do
    {
		if (CheckBatteryEmpty() == 1)
		{
#ifdef DEBUG
			printf("\n system_battery_empty = TRUE");
#endif						
			system_battery_empty = TRUE;
			break;	
		}
		
		EvtGetEvent(&event);
		
		if ((event.eventType == POWER_EVENT && event.eventID == BAT_MAIN_EMPTY) ||
			(event.eventType == POWER_EVENT && event.eventID == BAT_DOOR_OPEN))
		{
			system_battery_empty = TRUE;
			break;    		
		}   	
#ifdef DEBUG
		printf("\n LowBatScr - Event = %ld %ld %ld %ld", event.eventType, event.eventID, event.para1, event.para2);
#endif	
		
	}while(event.eventType == POWER_EVENT);    		
	
	
	TmrIntDisable(lowbattmr);
	
#ifdef DEBUG
	printf("\n Quit LowBat Screen - Battery Empty = %ld", system_battery_empty);
#endif	
	
	
	
	if (system_battery_empty)
		return FALSE;
	else return TRUE;			
}
