/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   todo.h
Author(s)   :   David Lo
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   application header file
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __TODO_H_
#define __TODO_H_

#include "uifunc.h"
#include "ui.h"
#include "mmu.h"
#include "ToDoDB.h"
#include "todolang.h"
#ifdef PR31700
#include "ioconmsg.h"
#include "sndmevt.h"
#endif
 
/*****************************************************************
********************** To Do List Application ********************
*****************************************************************/
BOOLEAN SchedulerToDoList(EvtType* Event);
BOOLEAN SchedulerToDoNew(EvtType* Event); 
BOOLEAN SchedulerToDoViewing(EvtType* Event);
BOOLEAN SchedulerToDoPref(EvtType* Event); 
BOOLEAN SchedulerToDoDetails(EvtType* Event); 
BOOLEAN SchedulerReplayVoice(EvtType* Event); 
BOOLEAN SchedulerAlarmSettings(EvtType* Event); 
BOOLEAN SchedulerDateSettings(EvtType* Event); 
BOOLEAN SchedulerSaveChanges(EvtType* Event); 
BOOLEAN SchedulerItemErase(EvtType* Event);
BOOLEAN SchedulerAlarmDateSettings(EvtType* Event);
BOOLEAN SchedulerNoDueDate(EvtType* Event);
BOOLEAN SchedulerRecordVoice(EvtType* Event);
BOOLEAN SchedulerPurgeRecord(EvtType* Event);
BOOLEAN SchedulerPurgeRecord(EvtType* Event);
BOOLEAN SchedulerAlarmVoiceMemoExists(EvtType *Event);
BOOLEAN SchedulerToDoNoMem(EvtType *Event);
BOOLEAN SchedulerToDoInvalidAlarmInput(EvtType *Event);
BOOLEAN SchedulerToDoNoBat(EvtType *Event);
BOOLEAN SchedulerSysLowMem(EvtType *Event);

/*****************************************************************
********************** Global Variables **************************
*****************************************************************/
extern AppStatus		app_status;
extern CheckStatus		chk_status;
extern AlarmSettings	alarm_settings;

/*****************************************************************
*********************** Global Defines ***************************
*****************************************************************/
#define		DEBUG
//#define	SORT_MODIFY							

#define	TO_DO_LIST_COLUMN_0					0
#define	TO_DO_LIST_COLUMN_1					1
#define	TO_DO_LIST_COLUMN_2					2
#define TO_DO_LIST_CONTENTS					3
#define TO_DO_LIST_DUE_DATE					4

#define TO_DO_LIST_SFONT_NUM_OF_ROW			13
#define TO_DO_LIST_LFONT_NUM_OF_ROW			9
#define TO_DO_LIST_LCOLUMN				90
#define TO_DO_LIST_SCOLUMN				92
#define TO_DO_LIST_NUM_OF_ROW				13
#define FIELD_ROW_HEIGHT					9
#define VIEWING_FIELD_HEIGHT_KEYBOARD_ON	71
#define VIEWING_FIELD_HEIGHT_KEYBOARD_OFF	113
#define NEW_FIELD_HEIGHT_KEYBOARD_ON		78
#define NEW_FIELD_HEIGHT_KEYBOARD_OFF		121
#define SCROLLBAR_HEIGHT_KEYBOARD_ON		80
#define SCROLLBAR_HEIGHT_KEYBOARD_OFF		123
#define	TO_DO_BLOCK_SIZE			20
#define	TO_DO_LIST_NUM_FIELD			7
#define	SOUND_NUM_FIELD				2
#define	MAX_TEXT_ON_DISPLAY				50

#define	TO_DO_CHECKBOX_OFFSET				7
//#define	TO_DO_BITMAP_OFFSET					20
#define	TO_DO_POPUP_OFFSET					33
#define	TO_DO_LIST_CONTENT_OFFSET			143
#define	TO_DO_LIST_DATE_OFFSET				156
#define TO_DO_TONE_OFFSET					20
#define TO_DO_VOICE_OFFSET					191

#define	SAME								0
#define BACKWARD							0
#define FORWARD								1
#define	INCOMPLETED							0
#define	COMPLETED							1
#define	NO_ALARM							0
#define	TONE_ALARM							1
#define	VOICE_ALARM							2
#define VOICE_NO_ALARM						3

#define COMPLETED_ITEMS						0
#define PRIORITY							1
#define DUE_DATE							2

#define	TO_DO_LIST							0
#define TO_DO_NEW							1
#define TO_DO_VIEWING						2
#define TO_DO_ALARM_SETTINGS				3
#define TO_DO_DETAILS						4

#define TODAY								0
#define TOMORROW							1
#define NO_DUE_DATE							2
#define CHOOSE_DATE							3

#define ALARM_DUE_DATE						0
#define	ALARM_BEFORE_DUE_DATE				1
#define ALARM_CHOOSE_DATE					2
#define NO_ALARM_DATE						3
#define	VIEWING_ALARM_DATE					4

#define	ALARM_VOICE							0x00
#define	ALARM_TONE							0x01
#define	ALARM_NOACTION						0x02
#define	TO_DO_ALARM_MAX_TEXT				200

/*==================== Menu Item ===========================*/
#define MENU_SMALL_TEXT						0
#define MENU_LARGE_TEXT						1

#define MENU_ITEM_COPY						0
#define MENU_ITEM_CUT						1
#define MENU_ITEM_PASTE						2
#define MENU_ITEM_UNDO						3
#define MENU_ITEM_ZOOM						4
#define TO_DO_LIST_MENU						175

/*======================= To Do List Database ==============*/
#define TDL_STATUS							0x80001000
#define TDL_EDIT_INFO						0x80001001

//======================= To Do List Status Define (Close Application) ========================
#define RESTART_TO_DO_LIST					0	
#define RESTART_TO_DO_VIEWING				1
#define RESTART_TO_DO_NEW					2
#define	RESTART_TO_DO_DATE					3

/******************************************************************
********************** OBJECT ID Defines **************************
******************************************************************/
/*		FORM TO DO LIST (Form 1)			*/
#define FORM_TO_DO_LIST						0
#define	POPUP_TRIGGER_CATE					1
#define	TABLE_TO_DO_LIST					2
#define	SCROLLBAR_TO_DO_LIST				3
#define	BUTTON_TO_DO_NEW_RECORD				4
#define	BUTTON_TO_DO_SORT_RECORD			5
#define	BUTTON_TO_DO_PURGE					6
#define	BITMAP_TO_DO_N1						20
#define	BITMAP_TO_DO_N2						21
#define	BITMAP_TO_DO_N3						22
#define	BITMAP_TO_DO_N4						23
#define	BITMAP_TO_DO_N5						24
#define	BITMAP_TO_DO_N6						25
#define	BITMAP_TO_DO_N7						26
#define	BITMAP_TO_DO_N8						27
#define	BITMAP_TO_DO_N9						28
#define	BITMAP_TO_DO_N10					29
#define	BITMAP_TO_DO_N11					30
#define	BITMAP_TO_DO_N12					31
#define	BITMAP_TO_DO_N13					32
#define TABLE_FIRST_STRING					143
#define MENU_CHANGE_FONT					208

/*		FORM TO DO NEW (Form 2)				*/
#define	FORM_TO_DO_NEW						46
#define	SCROLLBAR_TO_DO_NEW					48
#define	BUTTON_TO_DO_DETAILS				49
//#define BUTTON_TO_DO_ZOOMIN					50
#define FIELD_TO_DO_NEW						51

/*		FORM TO DO VIEWING (Form 3)			*/
#define	FORM_TO_DO_VIEWING					52
#define SCROLLBAR_TO_DO_VIEWING				53
#define BUTTON_TO_DO_ALARM					54
#define BUTTON_TO_DO_DEL					55
#define BUTTON_TO_DO_CHANGE_DUE_DATE		56
#define CHECKBOX_TO_DO_VIEWING				58
#define	BITMAP_TO_DO_TONE_VIEWING			59
#define POPUP_TRIGGER_PRIORITY_VIEWING		60
#define	BUTTON_TO_DO_VIEW_DATE				61
#define FIELD_TO_DO_VIEWING					138
#define	BITMAP_TO_DO_VOICE_VIEWING			204

/*		FORM DATE SETTINGS (Form 4)			*/
#define	FORM_DATE_SETTINGS					62
#define	BUTTON_DATE_SETTING_TODAY			64
#define	PUSHBUTTON_DATE_SETTING_JAN			65
#define	PUSHBUTTON_DATE_SETTING_FEB			66
#define	PUSHBUTTON_DATE_SETTING_MAR			67
#define	PUSHBUTTON_DATE_SETTING_APR			68
#define	PUSHBUTTON_DATE_SETTING_MAY			69
#define	PUSHBUTTON_DATE_SETTING_JUN			70
#define	PUSHBUTTON_DATE_SETTING_JUL			71
#define	PUSHBUTTON_DATE_SETTING_AUG			72
#define	PUSHBUTTON_DATE_SETTING_SEP			73
#define	PUSHBUTTON_DATE_SETTING_OCT			74
#define	PUSHBUTTON_DATE_SETTING_NOV			75
#define	PUSHBUTTON_DATE_SETTING_DEC			76
#define	STRING_DATE_SETTINGS				77
#define	TABLE_DATE_SETTING					84
#define	BITMAP_DATE_SETTING_N1				85
#define	BITMAP_DATE_SETTING_N2				86
#define	BUTTON_DISABLE						87
#define	PUSHBUTTON_DATE_SETTING_Y1			88
#define	PUSHBUTTON_DATE_SETTING_Y2			89	
#define	PUSHBUTTON_DATE_SETTING_Y3			90
#define	PUSHBUTTON_DATE_SETTING_Y4			91
#define	PUSHBUTTON_DATE_SETTING_Y5			92

/*		FORM REPLAY VOICE MEMO (Form 8)		*/
#define	FORM_REPLAY_VOICE					95
#define BITMAP_REPLAY_VOICE_PLAY			57
#define BITMAP_DIALOG_EXIT					96
#define BITMAP_REPLAY_VOICE_PAUSE			97
#define BITMAP_REPLAY_VOICE_STOP			98
#define	SCROLLBAR_REPLAY_VOICE				102

/*		FORM ALARM SETTINGS (Form 9)		*/
#define FORM_ALARM_SETTINGS					119
#define	PUSHBUTTON_ALARM_ON					120
#define	PUSHBUTTON_ALARM_OFF				121
#define	POPUP_TRIGGER_ALARM_DATE			122
#define	PUSHBUTTON_VOICE_MEMO				123
#define	PUSHBUTTON_TONE						124

/*		FORM TO DO PREF (Form 10)			*/
#define	FORM_TO_DO_PREF						103
#define PUSHBUTTON_TO_DO_PREF_N1			104
#define PUSHBUTTON_TO_DO_PREF_N2			105
#define PUSHBUTTON_TO_DO_PREF_N3			106

/*		FORM TO DO DETAILS (Form 11)		*/
#define	FORM_TO_DO_DETAILS					108
#define	PUSHBUTTON_TO_DO_DETAILS_N1			109
#define	PUSHBUTTON_TO_DO_DETAILS_N2			110
#define	PUSHBUTTON_TO_DO_DETAILS_N3			111
#define	PUSHBUTTON_TO_DO_DETAILS_N4			112
#define	PUSHBUTTON_TO_DO_DETAILS_N5			113
#define	POPUP_TRIGGER_DETAILS_DATE			114
#define	BUTTON_DETAILS_ALARM				115

/*		FORM SAVE CHANGES (Form 12)			*/
#define	FORM_SAVE_CHANGES					127
#define BITMAP_SAVE_CHANGES					128
//#define STRING_SAVE_CHANGES					129
#define BUTTON_SAVE_CHANGES_YES				130
#define BUTTON_SAVE_CHANGES_NO				131

/*		FORM ITEM ERASE (Form 13)			*/
#define	FORM_ITEM_ERASE						132
//#define STRING_TO_DO_ERASE_N1				133
//#define STRING_TO_DO_ERASE_N2				134
#define	CHECKBOX_TO_DO_ERASE				135
#define BUTTON_TO_DO_ERASE_YES				136
#define BUTTON_TO_DO_ERASE_NO				137

/*		FORM ALARM DATE SETTINGS (Form 14)	*/
#define	FORM_ALARM_DATE_SETTINGS			169

/*		FORM NO DUE DATE (Form 15)			*/
#define	FORM_NO_DUE_DATE					170
#define	STRING_NO_DUE_DATE_N1				171
#define	STRING_NO_DUE_DATE_N2				172
#define	STRING_NO_DUE_DATE_N3				173
#define	BITMAP_NO_DUE_DATE_EXIT				174

/*		FORM TO DO DETAILS (Form 16)		*/
#define	FORM_RECORD_VOICE					78
#define BITMAP_REPLAY_VOICE_REC				79
#define	SCROLLBAR_TODO_REC					209

/*		FORM PURGE RECORD (Form 17)		*/
#define	FORM_TO_DO_PURGE					176
#define	POPUP_TRIGGER_TO_DO_PURGE			179
#define	CHECKBOX_TO_DO_PURGE				180
#define	BUTTON_TO_DO_PURGE_PROCEED			181
#define	BUTTON_TO_DO_PURGE_CANCEL			182

/*		FORM PURGE RECORD (Form 18)		*/
#define	FORM_TO_DO_VOICE_EXISTS				183
#define	BUTTON_TO_DO_VOICE_EXISTS_PLAY		185
#define	BUTTON_TO_DO_VOICE_EXISTS_REPLACE	186
#define BITMAP_TO_DO_VOICE_EXISTS			187

/*		FORM NO MEM (Form 19)		*/
#define	FORM_TO_DO_NO_MEM					188

/*		FORM_INVALID_ALARM_INPUT (Form 20)	*/
#define	FORM_INVALID_ALARM_INPUT			205

/*		FORM NO BAT (Form 21)		*/
#define	FORM_TO_DO_NO_BAT				210

/*		FORM_SYSTEM_LOW_MEM (Form 22)		*/
#define	FORM_SYSTEM_LOW_MEM				214

#endif
