/*
 * @(#)help.c
 *
 * Copyright 1999-2001, Aaron Ardiri (mailto:aaron@ardiri.com)
 * All rights reserved.
 *
 * The  source code outlines a number of basic Helio Computing Programming
 * principles and you  should be able to take the core structure and write 
 * a large complex program. It is distributed WITHOUT ANY WARRANTY; use it
 * "AS IS" and at your own risk.
 *
 * The code presented is Copyright 2000 by Aaron Ardiri. It should be used
 * for educational purposes only.  You  shall not modify the Cube3D source 
 * code in any way and re-distribute it as your own, however you  are free 
 * to  use the  code as a  guide  for  developing  programs on  the  Helio 
 * Computing Platform.
 */

#include "helio.h"

// image resources
#include "help.inc"

// global variable structure
typedef struct
{
  GfxWindow *helpWindow;
} HelpGlobals;

// globals reference
static HelpGlobals *globals;

/**
 * Initialize the help instructions screen.
 *
 * @return the height in pixels of the instructions data area.
 */
SHORT
HelpInitialize()
{
  GfxRegion region = {{   0,   0 }, { 136, 234 }};

  // create a globals object
  globals = (HelpGlobals *)pmalloc(sizeof(HelpGlobals));

  // initialize windows
  globals->helpWindow = GfxCreateWindow(region.extent.x, region.extent.y);

  // draw the help
  {
    GfxFont   currFont;
    GfxWindow *currWindow;
    GfxWindow *tmpWindow;

    currWindow = GfxGetDrawWindow();
    currFont   = GfxGetFont();

    // draw to help window
    GfxSetDrawWindow(globals->helpWindow);
    GfxFillRegion(globals->helpWindow, &region, gfx_white);

    GfxSetFont(gfx_palmosNormalFont);
    {
      BYTE  *str, *ptrStr;
      SHORT x, y;

      // initialize
      y   = 2;
      str = (BYTE *)pmalloc(256 * sizeof(BYTE));

      // draw title
      strcpy(str, "WIREFRAME CUBE");
      x = (region.extent.x - GfxGetCharsWidth(str, strlen(str))) >> 1;
      GfxDrawString(str, strlen(str), x, y, gfxPaint); 
      y += GfxGetFontHeight();
      GfxDrawLine(x,y-1,x+GfxGetCharsWidth(str,strlen(str))-2,y-1,gfx_black);

      // add a space (little)
      y += GfxGetFontHeight() >> 1;

      // general text
      x = 4;
      strcpy(str,
"Cube3D is a simple wireframe cube demonstration that uses perspective \
geometry for the Helio Computing Platform.");
      ptrStr = str;
      while (strlen(ptrStr) != 0) {
        BYTE count = GfxGetWordWrap(ptrStr, region.extent.x-x);

	x = (region.extent.x - GfxGetCharsWidth(ptrStr, count)) >> 1;
	if (x > 0)
          GfxDrawString(ptrStr, count, x, y, gfxPaint); 
        else
          GfxDrawString(ptrStr, count, x, y, gfxInvert); 
	y += GfxGetFontHeight(); x = 4;

        ptrStr += count;
      }

      // add a space (little)
      y += GfxGetFontHeight() >> 1;

      // show the screen teaser
      {
        GfxRegion r = {{0,0},{bitmap00Width,bitmap00Height}};

        // initialize
        tmpWindow = (GfxWindow *)pmalloc(sizeof(GfxWindow));
	tmpWindow->width   = bitmap00Width;
	tmpWindow->height  = bitmap00Height;
	tmpWindow->memSize = bitmap00Size;
	tmpWindow->memory  = (void *)bitmap00;

        // copy the bitmap resource
        x = (region.extent.x - bitmap00Width) >> 1;
	GfxCopyRegion(tmpWindow, globals->helpWindow, &r, x, y, gfxPaint);

        // clean up
	pfree(tmpWindow);
      }

      // add a space (little)
      y += 48 + (GfxGetFontHeight() >> 1);

      // general text
      x = 4;
      strcpy(str,
"The source code is available for educational purpose only and \
shall not be redistributed or modified without the consent of \
the original author.");
      ptrStr = str;
      while (strlen(ptrStr) != 0) {
        BYTE count = GfxGetWordWrap(ptrStr, region.extent.x-x);

	x = (region.extent.x - GfxGetCharsWidth(ptrStr, count)) >> 1;
        GfxDrawString(ptrStr, count, x, y, gfxPaint); 
	y += GfxGetFontHeight(); x = 4;

        ptrStr += count;
      }

      // add a space (little)
      y += GfxGetFontHeight() >> 1;

      x = 4;
      strcpy(str,
"Interested in developing for the Helio Computing Platform?");
      ptrStr = str;
      while (strlen(ptrStr) != 0) {
        BYTE count = GfxGetWordWrap(ptrStr, region.extent.x-x);

	x = (region.extent.x - GfxGetCharsWidth(ptrStr, count)) >> 1;
        GfxDrawString(ptrStr, count, x, y, gfxPaint); 
	y += GfxGetFontHeight(); x = 4;

        ptrStr += count;
      }
    
      // add space (little)
      y += GfxGetFontHeight() >> 1;

      GfxSetFont(gfx_palmosBoldFont);
      x = 4;
      strcpy(str, "http://www.ardiri.com/");
      x = (region.extent.x - GfxGetCharsWidth(str, strlen(str))) >> 1;
      GfxDrawString(str, strlen(str), x, y, gfxPaint); 
      y += GfxGetFontHeight();
      GfxSetFont(gfx_palmosNormalFont);

      // add space (little)
      y += GfxGetFontHeight() >> 1;

      x = 4;
      strcpy(str, "Happy Hacking!");
      x = (region.extent.x - GfxGetCharsWidth(str, strlen(str))) >> 1;
      GfxDrawString(str, strlen(str), x, y, gfxPaint); 
      y += GfxGetFontHeight();

      // clean up
      pfree(str);
    }

    // restore settings
    GfxSetFont(currFont);
    GfxSetDrawWindow(currWindow);
  }
  
  return region.extent.y;
}

/**
 * Draw the instructions on the screen.
 *
 * @param offset the offset height of the window to start copying from.
 */
void
HelpDrawInstructions(SHORT offset)
{
  GfxRegion helpArea = {{   0, offset }, { 136, 116 }};

  // blit the required area
  GfxCopyRegion(globals->helpWindow, GfxGetDrawWindow(),
                &helpArea, 7, 20, gfxPaint);
}

/**
 * Terminate the help instructions screen.
 */
void
HelpTerminate()
{
  // clean up memory
  GfxDisposeWindow(globals->helpWindow);
  pfree(globals);
}
