/*
 * @(#)syscall.s
 *
 * Copyright 1999-2001, Aaron Ardiri (mailto:aaron@ardiri.com)
 * All rights reserved.
 *
 * The  source code outlines a number of basic Helio Computing Programming
 * principles and you  should be able to take the core structure and write 
 * a large complex program. It is distributed WITHOUT ANY WARRANTY; use it
 * "AS IS" and at your own risk.
 *
 * The code presented is Copyright 2000 by Aaron Ardiri. It should be used
 * for educational purposes only.  You  shall not modify the Cube3D source 
 * code in any way and re-distribute it as your own, however you  are free 
 * to  use the  code as a  guide  for  developing  programs on  the  Helio 
 * Computing Platform.
 */

#include <pr3910.h>

/**
 ** vt-os 1.1
 **
 ** -- Aaron Ardiri, 2000
 **/

#define SYSCALL(name,number)                       \
        .globl   name;                             \
        .ent     name;                             \
name:;                                             \
        .set     noat;                             \
        li       v0, number;                       \
        syscall;                                   \
        j        ra;                               \
        .set     at;                               \
        .end     name;                             \

        .text
SYSCALL(EvtGetEvent                                ,9)
SYSCALL(EvtAppendEvt                               ,14)
SYSCALL(TmrIntEnable                               ,16)
SYSCALL(TmrIntDisable                              ,17)
SYSCALL(TmrWaitTime                                ,18)
SYSCALL(RtcGetTime                                 ,19)
SYSCALL(RtcDiffTime                                ,21)
SYSCALL(pmalloc                                    ,48)
SYSCALL(pfree                                      ,50)
SYSCALL(qfree                                      ,53)
SYSCALL(DataNewRecord                              ,54)
SYSCALL(DataOpenRecord                             ,58)
SYSCALL(DataCloseDB                                ,59)
SYSCALL(DataCloseRecord                            ,62)
SYSCALL(DataWriteField                             ,70)
SYSCALL(DataGetField                               ,72)
SYSCALL(DataNewDB                                  ,78)
SYSCALL(DataFindDB                                 ,79)
SYSCALL(DataOpenDB                                 ,80)
SYSCALL(DataFieldSize                              ,89)
SYSCALL(DataTotalRecord                            ,103)
SYSCALL(strlen                                     ,119)
SYSCALL(strcpy                                     ,121)
SYSCALL(_FormDispatchEvent                         ,224)
SYSCALL(FormDrawForm                               ,226)
SYSCALL(FormSetEventHandler                        ,227)
SYSCALL(FormGetActiveFormID                        ,228)
SYSCALL(FormSetActiveForm                          ,229)
SYSCALL(FormGetObjectPointer                       ,233)
SYSCALL(FormGotoForm                               ,234)
SYSCALL(FormSaveBehindBits                         ,252)
SYSCALL(FormRestoreBitBehind                       ,253)
SYSCALL(FormInitForm                               ,255)
SYSCALL(MenuHandleEvent                            ,262)
SYSCALL(memcpy                                     ,322)
SYSCALL(ScrollbarEraseScrollbar                    ,353)
SYSCALL(ScrollbarGetScrollbar                      ,355)
SYSCALL(ScrollbarSetScrollbar                      ,356)
SYSCALL(ScrollbarDrawScrollbar                     ,363)
SYSCALL(SystemHandleEvent                          ,375)
SYSCALL(UISearchForAddress                         ,459)
SYSCALL(UIDeleteAllAppObjects                      ,465)
SYSCALL(UIApplicationInit                          ,542)
SYSCALL(strncmp                                    ,583)
SYSCALL(SysGetAppID                                ,672) 
SYSCALL(SndPlaySndEffect                           ,734)
SYSCALL(SysGetOSVersionNo                          ,771)

// vt-os 1.1.08

SYSCALL(LcdSetColorMode                            ,856)
SYSCALL(LcdGetColorMode                            ,857)
