/* MakeZHDB V1.1 */
/* Earle F. Philhower, III */
/* To be used my_stdio file applications */
/* Released to Public Domain December 25, 2001 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "zlib.h"


typedef unsigned char byte;
typedef unsigned long DWORD;
typedef unsigned short WORD;


#ifndef __HDB_H_
#define __HDB_H_

#define HDB_VERSION_TEXT 0x8939

#define BYTE		unsigned char
#define USHORT		unsigned short
#define UWORD		unsigned int

#define DatabaseID	unsigned int
#define RecordID	unsigned int
#define AppID		unsigned int

#define SIZE_OF_HDB_HEADER_STRUCT		92
#define SIZE_OF_HDB_REC_HEADER_STRUCT	16
#define SIZE_OF_HDB_DOC_HEADER_STRUCT	16
#define SIZE_OF_HDB_DOC_BOOMARK_STRUCT	20
#define SIZE_OF_HDB_DOC_TOC_STRUCT		40

typedef struct HDB_HEADER_STRUCT 
{
    BYTE  name[32];			//31 chars + NULL
	BYTE  owner[32];		//31 chars + NULL
	USHORT version;			//used to distinguish db version on device
	USHORT dbtype;			//RFU
	UWORD attributes;		//RFU
	UWORD creation_date;	//updated after db is added to device
	UWORD backup_date;		//updated after db is backed up from device
	DatabaseID id;			//updated after db is added to device
	AppID appid;			//updated after db is added to device
	UWORD record_count;		//total records
} HDBHeader;

typedef struct HDB_REC_HEADER_STRUCT
{
	UWORD offset;			//offset to record from beginning of file
	RecordID id;			//user defined must be 0x80000000 - 0x8fffffff, else updated after db is added to device
	UWORD modify_date;		//updated after db is modified from device
	USHORT total_field;		//total fields
	BYTE category;			//record category
	BYTE attribute;			//record attributes
} HDBRecordHeader;

typedef struct HDB_DOC_HEADER_STRUCT
{
	USHORT version;			//HelioDOC version
	USHORT reserved1;		//RFU
	UWORD  uncomp_size;		//total size of doc
	USHORT total_recs;		//number of text records
	USHORT rec_size;		//max size of records
	UWORD  reserved2;		//RFU
} HDBDocHeader;

typedef struct HDB_DOC_BOOMARK_STRUCT
{
	BYTE name[16];			//bookmark identifier, 15 chars + NULL
	UWORD offset;			//char position from beginning of text (decoded)
} HDBDocBookmark;

typedef struct HDB_DOC_TOC_STRUCT
{
	BYTE title[32];				//TOC title, 31 chars + NULL
	UWORD record_count;			//number of entries in TOC
	HDBDocBookmark* toc_item;	//pointer to list of TOC entries, which immediately follow this struct
} HDBTocList;

#define EnFieldSize(word, size, byte_use)												\
{																						\
	byte_use = 0;																		\
	do {																				\
		*(BYTE*)((BYTE*)(&word) + byte_use++) = ((BYTE) size) << 1;						\
		size >>= 7;																		\
	}while(size != 0);																	\
	*(BYTE*)((BYTE*)(&word) + byte_use - 1) |= 0x01;									\
}

#endif





#define BLOCKSIZE 2048





void MakeOneZHDB(char *recordName, char *owner, int size, unsigned char *data, char *outFile)
{
	FILE *out;
	unsigned int i;
	UWORD offset,record_size,encoded_bytes,encoded_size,temp;

	HDBHeader hdb_header_buf;
	HDBRecordHeader *hdb_recheader_buf;
	BYTE** rec_data;
	UWORD* rec_size;
	BYTE *dout;
	int outsz;
	char buff[9];
	int totout;

	totout = 0;
	dout = malloc(2*BLOCKSIZE);

	// Create header
	memset(hdb_header_buf.name, 0x00, 32);
	strncpy(hdb_header_buf.name, recordName, 31);
	hdb_header_buf.name[31] = 0;

	memset(hdb_header_buf.owner, 0x00, 32);
	if (NULL==owner) strcpy(hdb_header_buf.owner, "<");
	else strncpy(hdb_header_buf.owner, owner, 31);
	hdb_header_buf.owner[31] = 0;

	hdb_header_buf.version = HDB_VERSION_TEXT;
	hdb_header_buf.dbtype = 0;
	hdb_header_buf.attributes = 0;
	hdb_header_buf.creation_date = 0;
	hdb_header_buf.backup_date = 0;
	hdb_header_buf.id = 0;
	hdb_header_buf.appid = 0;
	hdb_header_buf.record_count = 1+1+(int)(floor(size/BLOCKSIZE)); //pdb_recheader_buf.num_records;

	//create record list
	hdb_recheader_buf = (HDBRecordHeader*)malloc(hdb_header_buf.record_count * SIZE_OF_HDB_REC_HEADER_STRUCT);
	rec_data = (BYTE**)malloc(hdb_header_buf.record_count * sizeof(BYTE*));
	rec_size = (UWORD*)malloc(hdb_header_buf.record_count * sizeof(UWORD));
	offset = SIZE_OF_HDB_HEADER_STRUCT + (hdb_header_buf.record_count * SIZE_OF_HDB_REC_HEADER_STRUCT);

	// Write header record
	i=0;
	hdb_recheader_buf[i].attribute = 0;
	hdb_recheader_buf[i].category = 0;
	hdb_recheader_buf[i].id = 0x80000000;
	hdb_recheader_buf[i].modify_date = 0;
	hdb_recheader_buf[i].offset = offset;
	hdb_recheader_buf[i].total_field = 1;
	record_size = 8;
	encoded_size = 0;
	temp = record_size;
	EnFieldSize(encoded_size, temp, encoded_bytes);
	rec_size[i] = (record_size + encoded_bytes) * sizeof(BYTE);
	rec_data[i] = (BYTE*)malloc((record_size + encoded_bytes) * sizeof(BYTE));
	memcpy(rec_data[i],&encoded_size,encoded_bytes);
	strcpy(buff, "ZDOC");
	buff[4] = size&255;
	buff[5] = (size>>8)&255;
	buff[6] = (size>>16)&255;
	buff[7] = (size>>24)&255;
	memcpy(rec_data[i]+encoded_bytes, buff, 8*sizeof(BYTE));
	offset += (record_size + encoded_bytes);
	// Write compressed sectors
	for(i=1;i<hdb_header_buf.record_count;i++)
	{
		hdb_recheader_buf[i].attribute = 0;
		hdb_recheader_buf[i].category = 0;
		hdb_recheader_buf[i].id = 0x80000000 | (/*1+*/i);//0;
		hdb_recheader_buf[i].modify_date = 0;
		hdb_recheader_buf[i].offset = offset;
		hdb_recheader_buf[i].total_field = 1;
		record_size = (i==(hdb_header_buf.record_count - 1))?size-(BLOCKSIZE*(hdb_header_buf.record_count - 2)):BLOCKSIZE;
		encoded_size = 0;
		
		outsz=2*BLOCKSIZE;
		compress(dout, &outsz, data, record_size);
		totout += outsz;
		temp = outsz; //record_size;
	    EnFieldSize(encoded_size, temp, encoded_bytes);
		rec_size[i] = (outsz/*record_size*/ + encoded_bytes) * sizeof(BYTE);
		rec_data[i] = (BYTE*)malloc((outsz/*record_size*/ + encoded_bytes) * sizeof(BYTE));
		memcpy(rec_data[i],&encoded_size,encoded_bytes);
		memcpy(rec_data[i]+encoded_bytes, dout/*data*/, outsz/*record_size*sizeof(BYTE)*/);
		offset += (outsz/*record_size*/ + encoded_bytes);
		data += record_size;
	}

	out = fopen(outFile, "wb");
	fwrite(&hdb_header_buf, sizeof(char), SIZE_OF_HDB_HEADER_STRUCT, out);
	fwrite(hdb_recheader_buf, sizeof(char), hdb_header_buf.record_count * SIZE_OF_HDB_REC_HEADER_STRUCT, out);
	for(i=0; i<hdb_header_buf.record_count; i++)
	{
		record_size = rec_size[i];
		fwrite(rec_data[i], sizeof(char), record_size, out);
	}
	fclose(out);
	printf("Compressed %d into %d (%2.1f percent savings)\n", size, totout, 100.0*(1.0-(1.0*totout)/(1.0*size)));
}

