/*
  ===========================================================================
  File        :   main.c
  Author(s)   :   Richard Gaski
  Company     :   Pandora Technology
  Project     :   Helio 
  Date:	      :   March 1st, 2000
  Revision    :   1.0
  Note        :   None
  ===========================================================================
*/        

#include "main.h"
#include <emudbg.h>

#ifdef DEBUG
BYTE debug_msg[80];
#endif

SHORT gitem_num = -1;
USHORT gtop_num = -1;

//main entry point of program
__main(WORD cmd, void *cmd_arg)
{
  switch(cmd)
    {
    case LAUNCH_CMD_NORMAL_LAUNCH:
      UIApplicationInit();		//initialize UI resources
      DBG_APP_BEGIN();
      FormPopupForm(FORM_MAIN);	//start main form
      EventLoop();			//run main event loop
      DBG_APP_END();
      UIDeleteAllAppObjects();	//main event loop has stopped, cleanup
      return TRUE;
    case LAUNCH_CMD_GOTO_REC:
      if(((GotoRec*)cmd_arg)->find_string)
	pfree(((GotoRec*)cmd_arg)->find_string);
    case LAUNCH_CMD_FIND:
    case LAUNCH_CMD_ALARM_HIT:
      pfree(cmd_arg);
      return TRUE;
    }
  return FALSE;
}

void EventLoop(void)
{
  EvtType event;

  while(1)
    {
      EvtGetEvent(&event);
      if(SystemHandleEvent(&event))
	continue;
      if(MenuHandleEvent(&event))
	continue;
      if(ApplicationHandleEvent(&event))
	continue;
      FormDispatchEvent(&event);
      if(event.eventType==EVT_APP_STOP)
	break;
    }
  return;
}

BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
  Form* form_ptr;
  BYTE  object_type;
  void* evtHandler;
	
  switch(Event->eventType)
    {
    case EVT_FORM_LOAD:
      if((Event->para1==1)||(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
	FormInitAllFormObjects((ObjectID)Event->eventID);
      if(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
	return FALSE;

      switch((ObjectID)Event->eventID)
	{
	case FORM_MAIN:
	  evtHandler = (void*)FormMainHandleEvent;
	  break;
	case FORM_ABOUT:
	  evtHandler = (void*)FormAboutHandleEvent;
	  break;
	default:
	  return FALSE;
	}
      FormSetEventHandler((ObjectID)Event->eventID,(void**)&FormDispatchEvent,evtHandler);
      FormSetActiveForm((ObjectID)Event->eventID);
      break;
    default:
      return FALSE;
    }
  return TRUE;
}

int byowner=0;
char infoPage[1024];
int doinfo;
void SetupInfoPage(char *dbname)
{
  DatabaseID dbid;
  USHORT version;
  AppID owner;
  RTM create_date, backup_date;
  BYTE create_str[33], backup_str[33];
  BYTE name[33], owner_info[33];
  USHORT total_block;
  UWORD total_byte;

  strcpy(infoPage, "Unknown Error...");
  if (!DataFindDB(dbname, &dbid)) return;
  DataDBInfo(dbid, &version, &owner, &create_date, &backup_date, name, owner_info);
  DataDBSize(dbid, &total_block, &total_byte);
  RtcFormatDate(&create_date, NULL, create_str);
  RtcFormatDate(&backup_date, NULL, backup_str);
  sprintf(infoPage, "Name: %s\rOwner: %s\rCreated: %s\rBacked Up:%s\rBlocks: %d\rBytes:%d",
	  name, owner_info, create_str, backup_str, total_block, total_byte);
}

BOOLEAN FormMainHandleEvent(EvtType* Event)
{
  BYTE*  item_text;
  DatabaseID dbid;
  WORD wValue;
  WORD wMaxValue;
  WORD wMinValue;
  WORD wPageSize;
  WORD wTotalNumOfLine;
  WORD wLineNum;
  
  switch(Event->eventType)
    {
    case EVT_FORM_OPEN:
      gitem_num = -1;
      ListDeleteAllItems(LIST_NAME);
      ListDeleteAllItems(LIST_OWNER);
      DisplayDBList();
      ListSetTopItemNum(LIST_NAME,gtop_num);
      ListSetTopItemNum(LIST_OWNER,gtop_num);
      ListSetHighlightedItem(LIST_NAME, gitem_num);
      ListSetHighlightedItem(LIST_OWNER, gitem_num);
      ListSetScrollbar(LIST_NAME,SCROLLBAR_MAIN);
      FormDrawForm(Event->eventID);
      return TRUE;
    case EVT_MENU_SELECT_ITEM:
      switch(Event->para1)
	{
	case 0:
	  doinfo = 0;
	  FormPopupForm(FORM_ABOUT);
	  break;
	case 1:
	  if (gitem_num==-1) return FALSE;
	  ListGetListItem(LIST_NAME, gitem_num, &item_text);
	  SetupInfoPage(item_text);
	  doinfo = 1;
	  FormPopupForm(FORM_ABOUT);
	  break;
	case 2:
	  byowner = byowner?0:1;
	  FormPopupForm(FORM_MAIN);
	default:
	  return FALSE;
	}
      break;
    case EVT_INLAY_SELECT:
      switch(Event->para1)
	{
	case INLAY_EXIT:
	case INLAY_MAIN_MENU:
	  FormGotoApp("Mainmenu");
	  return TRUE;
	default:
	  return FALSE;
	}
      break;
    case EVT_LIST_SELECT:
      gitem_num = Event->para1;
      ListSetHighlightedItem(LIST_NAME, gitem_num);
      ListSetHighlightedItem(LIST_OWNER, gitem_num);
      ListDrawList(LIST_NAME);
      ListDrawList(LIST_OWNER);
      break;
    case EVT_CONTROL_SELECT:
      switch(Event->eventID)
	{
	case BUTTON_DELETE:
	  if(gitem_num!=-1)
	    {
	      ListGetListItem(LIST_NAME, gitem_num,&item_text);
	      if(DataFindDB(item_text,&dbid))
		DataDeleteDBEx(dbid);
	    }
	  ListDeleteAllItems(LIST_NAME);
	  ListDeleteAllItems(LIST_OWNER);
	  DisplayDBList();
	  ListSetTopItemNum(LIST_NAME,gtop_num);
	  ListSetTopItemNum(LIST_OWNER,gtop_num);
	  ListDrawList(LIST_NAME);
	  ListDrawList(LIST_OWNER);
	  ListSetScrollbar(LIST_NAME,SCROLLBAR_MAIN);
	  gitem_num = -1;
	  break;
	default:
	  return FALSE;
	}
      break;
    case EVT_IO_KEY_CTRL:
      if((Event->eventID!=EVT_IO_KEY_PRESS)&&(Event->eventID!=EVT_IO_KEY_REPEAT))
	return FALSE;
    case EVT_SCROLLBAR_REPEAT:
    case EVT_SCROLLBAR_SELECT:
      ScrollbarGetScrollbar (SCROLLBAR_MAIN,&wValue,&wMaxValue,&wMinValue,&wPageSize,&wTotalNumOfLine);
      if((Event->eventType==EVT_IO_KEY_CTRL)&&(Event->para2==IO_UP_ARROW))
	wValue -= (wValue) ? 1 : 0;
      if((Event->eventType==EVT_IO_KEY_CTRL)&&(Event->para2==IO_DOWN_ARROW))
	wValue += (wValue<wMaxValue) ? 1 : 0;
      ScrollbarSetScrollbar (SCROLLBAR_MAIN,Event->para2,wMaxValue,wMinValue,wPageSize,wTotalNumOfLine);
      ScrollbarDrawScrollbar (SCROLLBAR_MAIN);
      ListSetTopItemNum(LIST_NAME,wValue);
      ListSetTopItemNum(LIST_OWNER,wValue);
      ListDrawList(LIST_NAME);
      ListDrawList(LIST_OWNER);
      gtop_num = wValue;
      break;
    default:
      return FALSE;
    }
  return TRUE;
}

BOOLEAN FormAboutHandleEvent(EvtType* Event)
{
  switch(Event->eventType)
    {
    case EVT_FORM_OPEN:
      FieldSetText(FIELD_ABOUT,doinfo?infoPage:"Helio DB Utility v0.06\rPandora Technology (c)2000\rHelio is a registered trademark of VTech Holdings Ltd. or its subsidiaries.\rModifications by\r   Earle F. Philhower III\r   earle@ziplabel.com\rhttp://www.ziplabel.com/helio");
      FormDrawForm(Event->eventID);
      break;
    case EVT_CONTROL_SELECT:
      switch(Event->eventID)
	{
	case BUTTON_ABOUT_OK:
	  FormPopupForm(FORM_MAIN);
	  break;
	default:
	  return FALSE;
	}
      break;
    case EVT_INLAY_SELECT:
      switch(Event->para1)
	{
	case INLAY_OK:
	case INLAY_EXIT:
	  FormPopupForm(FORM_MAIN);
	  break;
	case INLAY_MAIN_MENU:
	  FormGotoApp("Mainmenu");
	  break;
	default:
	  return FALSE;
	}
      break;
    default:
      return FALSE;
    }
  return TRUE;
}

void FormGotoApp(BYTE* app_name)
{
  ObjectID objid;

  FormGetActiveFormID(&objid);
  EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
  SysGetAppID(app_name,&objid);
  EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
  EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
  return;
}

/**
   void DeviceGetOSVersionNumber(BYTE *osVersion)
   {
   BYTE temp[16];
   BYTE i;

   SysGetOSVersionNo(temp);
   //check if all are printable chars
   for(i=0;i<(strlen(temp))&&(i<16);i++)
   {
   if((temp[i]<0x20)||(temp[i]>0x7e))
   {
   //nope so let's try old API
   SysGetOSVersionNo(&temp);
   break;
   }
			
   }
   strcpy(osVersion, temp);
   }
**/

void DisplayDBList()
{
  DBHeader dbh;
  MatInfoList* mat_ptr;
  USHORT i;
  BYTE* buff, *ptr;
  int items, z, j, cmp;

  items = 0;
  mat_ptr = MemoryGetMatPtr(0);
  for(i=0;i<mat_ptr->total_entry;i++)
    {
      if(MemoryBlockType(mat_ptr,i) == MAT_BLOCK_DB_REC)
	{
	  MemoryReadData(mat_ptr,i,0,DBHEADER_SIZE,(BYTE*)&dbh);
	  buff = qmalloc(sizeof(BYTE)*(dbh.length-DBHEADER_SIZE)+1);
	  MemoryReadData(mat_ptr,i,DBHEADER_SIZE,dbh.length - DBHEADER_SIZE,buff);
	
	  z=0;
	  for (j=0; j<items;j++) {
	    if (!byowner) {
	      ListGetListItem(LIST_NAME, j, &ptr);
	      if (strcasecmp(ptr, buff)>0) {
		z=1;
		ListInsertItem(LIST_NAME, j, buff);
		ListInsertItem(LIST_OWNER, j, buff + strlen(buff) + 1);
		j=items;
	      }
	    } else {
	      ListGetListItem(LIST_OWNER, j, &ptr);
	      cmp = strcasecmp(ptr, buff + strlen(buff) + 1);
	      if (cmp>0) {
		z=1;
		ListInsertItem(LIST_NAME, j, buff);
		ListInsertItem(LIST_OWNER, j, buff + strlen(buff) + 1);
		j=items;
	      } else if (cmp==0) {
		ListGetListItem(LIST_NAME, j, &ptr);
		if (strcasecmp(ptr, buff)>0) {
		  z=1;
		  ListInsertItem(LIST_NAME, j, buff);
		  ListInsertItem(LIST_OWNER, j, buff + strlen(buff) + 1);
		  j=items;
		}
	      }
	    }
	  }
	  if (z==0) {
	    ListInsertItem(LIST_NAME, j, buff);
	    ListInsertItem(LIST_OWNER, j, buff + strlen(buff) + 1);
	  }
	  items++;
	  qfree(buff);
	}
    }
}

Err DataDeleteDBEx(DatabaseID dbid)
{
  MatInfoList* mat_ptr;
  USHORT i;
  USHORT block, next_block;

  mat_ptr = MemoryGetMatPtr(0);
  for(i=0;i<mat_ptr->total_entry;i++)
    {
      if(MemoryFindStartBlock(mat_ptr, dbid, &block) == TRUE)
	{
	  if(BlockType(mat_ptr->mat[block].attribute) == MAT_BLOCK_DB_REC)
	    {
	      MemoryReleaseBlock(mat_ptr, block, FALSE, FALSE);
	      while (MemoryNextBlock(mat_ptr, block, &next_block) == TRUE)
		{
		  MemoryReleaseBlock(mat_ptr, next_block, FALSE, FALSE);
		  block = next_block;
		}
	      return TRUE;
	    }
	}
    }
  return ERR_DATA_DB_MISS;
}

Err ListGetHighlightedItemEx(ObjectID list_id,SHORT *item_num)
{
  List *addr;
  BYTE object_type;

  if(UISearchForAddress(list_id,&object_type,(void**)&addr) != TRUE) 
    return ERR_UI_RES_NOT_FOUND;
  *item_num =  addr->list_highlighted_item;
  return TRUE;
}

BOOLEAN ListSetScrollbar(ObjectID list_id, ObjectID scroll_id)
{
  USHORT total_num_items;
  USHORT max_num_items_display;
  USHORT top_item_num;
  USHORT current_num_items_display;
  WORD max_value;
  WORD min_value;
  WORD pagesize;
  WORD total_num_lines;
  BYTE object_type;
  List *list_ptr;
  Scrollbar *scroll_ptr;

  FormGetObjectPointer(LIST_NAME, &object_type, (void**)&list_ptr);
  FormGetObjectPointer(SCROLLBAR_MAIN, &object_type, (void**)&scroll_ptr);
	
  FormGetObjectPointer(list_id, &object_type, (void**)&list_ptr);
  FormGetObjectPointer(scroll_id, &object_type, (void**)&scroll_ptr);

  max_num_items_display = list_ptr->list_max_num_items_on_display;
  total_num_items = list_ptr->list_total_num_items;
  top_item_num = list_ptr->list_top_item_num;
  current_num_items_display = list_ptr->list_num_items_on_display;
  total_num_lines = total_num_items;
  min_value = 0;

  if (top_item_num == 65535)
    {
      ScrollbarSetScrollbarVisible(scroll_id,TRUE);
      pagesize = 1;
      max_value = total_num_lines - pagesize;
      top_item_num = max_value;
      scroll_ptr->scrollbar_draw_pagesize = pagesize;
    }
  else if (top_item_num > 0 && total_num_items <= max_num_items_display)
    {
      ScrollbarSetScrollbarVisible(scroll_id,TRUE);
      pagesize = total_num_items - top_item_num;
      max_value = total_num_lines - pagesize;
      scroll_ptr->scrollbar_draw_pagesize = pagesize;
    }
  else if (total_num_items > max_num_items_display)
    {
      ScrollbarSetScrollbarVisible(scroll_id,TRUE);
      pagesize = max_num_items_display;
      max_value = total_num_lines - pagesize;	
      scroll_ptr->scrollbar_draw_pagesize = max_num_items_display;
    }
  else
    {
      ScrollbarSetScrollbarVisible(scroll_id,FALSE);
      ScrollbarEraseScrollbar(scroll_id);
      return FALSE;
    }

  if (top_item_num > (total_num_items - max_num_items_display) && total_num_items >= max_num_items_display)
    {	
      pagesize = total_num_lines - top_item_num;	
      scroll_ptr->scrollbar_draw_pagesize = max_num_items_display;
      max_value = total_num_items - pagesize;
      ScrollbarSetScrollbar(scroll_id, max_value, max_value, min_value, pagesize, total_num_lines);
    }
  else
    {
      ScrollbarSetScrollbar(scroll_id, top_item_num, max_value, min_value, pagesize, total_num_lines);
    }
  ScrollbarDrawScrollbar(scroll_id);
  return TRUE;         
}
