#include "main.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <setjmp.h>
#include "../stdlib/fnt.h"
#include "../stdlib/my_stdio.h"
#include "../iflib/iflib.h"

unsigned char Dragon[15][8][5];
int Counter, UndoCount;
unsigned char SaveMoveX[144], SaveMoveY[144], SaveMoveZ[144], SaveMoveN[144];
int CheckResumeFile();
#define RESUMEFILE "Dragon 1.0 Resume"
#define RESUMEFILETYPE "Dragon 1.0 Resume Type"
extern void CpuChangeSpeed(int);
void ResetBoard();
void ShowDragon();
#define DEFAULTTILE "Dragon Tiles"

int xsize, ysize;
char *mem;
int seed;
int poweroff = 0;
unsigned long startTime, deltaTime;
jmp_buf env;

int inhint;
int totalfree;
int hintcnt;
unsigned char TileX[144], TileY[144], TileZ[144], TileN[144];

static int active = 0;

#define tileWidth 10
#define tileHeight 17
#define TileFaceWidth tileWidth
#define TileFaceHeight tileHeight
#define ParallaxX 1
#define ParallaxY 2
#define DragonX 5
#define DragonY 20
BitmapTemplate tileBitmap[36];
char tileFile[33];
UWORD timer = 0;
#define TIMERDELAY 1000

int Hilite1=-1, Hilite2=-1;
void NewGame()
{
  inhint = 0;
  srand(clock());
  startTime=clock();
  deltaTime = 0;
  ResetBoard();
  ShowDragon();
}

int LoadImage(char *name)
{
  FILE *fp;
  unsigned char a,b,c,d;
  int bigxsize, bigysize;
  mem = NULL;
  
  fp=fopen(name, "rb");
  if (fp==NULL) {
    strcpy(tileFile, DEFAULTTILE);
    fp=fopen(tileFile, "rb");
    if (fp==NULL) {
      DoAbout( "Fatal Error!",
	       "You must install the HDB",
	       "\"Dragon Tiles\" before running",
	       "HelioDragon.  See the file",
	       "\"dragon.txt\" for more info.",
	       "http://www.ziplabel.com/helio");
      
      return FALSE;
    }
  }
  a=fgetc(fp);
  b=fgetc(fp);
  c=fgetc(fp);
  d=fgetc(fp);
  bigxsize=(a<<24)|(b<<16)|(c<<8)|(d<<0);
  a=fgetc(fp);
  b=fgetc(fp);
  c=fgetc(fp);
  d=fgetc(fp);
  bigysize=(a<<24)|(b<<16)|(c<<8)|(d<<0);
  
  fseek(fp, 8+((bigxsize*4)*bigysize), SEEK_SET);
  
  a=fgetc(fp);
  b=fgetc(fp);
  c=fgetc(fp);
  d=fgetc(fp);
  xsize=(a<<24)|(b<<16)|(c<<8)|(d<<0);
  a=fgetc(fp);
  b=fgetc(fp);
  c=fgetc(fp);
  d=fgetc(fp);
  ysize=(a<<24)|(b<<16)|(c<<8)|(d<<0);
  mem = qmalloc(xsize*4*ysize);
  fread(mem, 1, xsize*4*ysize, fp);
  fclose(fp);

  return TRUE;
}

void DrawImage()
{
  int i, y;
  UWORD *lcd;
  BYTE *ptr;
  UWORD *spaceword;


  LcdSetColorMode(GREYSCALE_MODE);
  lcd=LcdGetLcdMemAddress();
  if (!mem) return;

  for (y=0; y<ysize; y++) {
    ptr = mem + (y*xsize*4);
    spaceword = (UWORD*)ptr;
    for (i=0; i<xsize; i++) lcd[i] = spaceword[i];
    for (i=xsize; i<20; i++) lcd[i] = 0x00000000;
    lcd += 20;
  }
}


int GetTile(int reset)
{
  static unsigned char tile[144];
  int n;

  if (reset) {
    memset(tile, 0, 144);
    return 0;
  } else {
    do {
      n = rand()%144;
    } while (tile[n]);
    tile[n] = 1;
    return n+1;
  }
}


void GrabBitmaps()
{
  int x, y, cnt;
  cnt = 0;
  for (y=0; y<4; y++)
    for (x=0; x<9; x++) {
      tileBitmap[cnt].xcoord = x*(tileWidth);
      tileBitmap[cnt].ycoord = y*(tileHeight);
      tileBitmap[cnt].width = tileWidth+1;
      tileBitmap[cnt].height = tileHeight+1;
      LcdGetBitmap(&tileBitmap[cnt]);
      cnt++;
    }
}

void FreeBitmaps()
{
  int i;
  for (i=0; i<36; i++)
    qfree(tileBitmap[i].bitmap_data);
}

int SetupGlobal()
{
  if (!LoadImage(tileFile)) return FALSE;
  DrawImage();
  GrabBitmaps();
  FntClearScreen();
  return TRUE;
}


void ResetBoard()
{
  int	x, y, z;

  Counter = 144;
  UndoCount = Counter;
  
  GetTile(1);
  for(z=0; z<5; z++)
    for(y=0; y<8; y++)
	for(x=0;x<15;x++)
	  Dragon[x][y][z] = 0;

  // Set up main tower (center of dragon)
  for(z=0;z<=3;z++)				
    for(y=0+z;y<=7-z;y++)
      for(x=3+z;x<=10-z;x++)
	Dragon[x][y][z] = GetTile(0);

  Dragon[1][0][0] = GetTile(0);
  Dragon[2][0][0] = GetTile(0);
  Dragon[11][0][0] = GetTile(0);
  Dragon[12][0][0] = GetTile(0);
  Dragon[2][2][0] = GetTile(0);
  Dragon[11][2][0] = GetTile(0);
  Dragon[0][3][0] = GetTile(0);
  Dragon[1][3][0] = GetTile(0);
  Dragon[2][3][0] = GetTile(0);
  Dragon[11][3][0] = GetTile(0);
  Dragon[12][3][0] = GetTile(0);
  Dragon[13][3][0] = GetTile(0);
  Dragon[14][3][0] = GetTile(0);
  Dragon[1][4][0] = GetTile(0);
  Dragon[2][4][0] = GetTile(0);
  Dragon[11][4][0] = GetTile(0);
  Dragon[12][4][0] = GetTile(0);
  Dragon[2][5][0] = GetTile(0);
  Dragon[11][5][0] = GetTile(0);
  Dragon[1][7][0] = GetTile(0);
  Dragon[2][7][0] = GetTile(0);
  Dragon[11][7][0] = GetTile(0);
  Dragon[12][7][0] = GetTile(0);
  Dragon[7][3][4] = GetTile(0); //Top tile

}


void ShowTile(int n, int x, int y)
{
  ObjectBounds bnds;
  int rv, cnt;
  if (n==Hilite1 || n==Hilite2) rv=1;
  else rv=0;
  n--; // n=1..145, want 0..144
  bnds.xcoord = x;
  bnds.ycoord = y;
  bnds.width = tileWidth+1;
  bnds.height = tileHeight+1;
  LcdDrawBox(&bnds, rv?COLOR_WHITE:COLOR_BLACK,
	     rv?COLOR_BLACK:COLOR_WHITE, TRUE);
  if (n!=144) {
    cnt = n/4;
    tileBitmap[cnt].xcoord = x;
    tileBitmap[cnt].ycoord = y;
    LcdDrawBitmap(&tileBitmap[cnt], rv?TRUE:FALSE);
  }
}

void ShowStatus()
{
  ObjectBounds bnds;
  char buff[64];
  unsigned long sec, min;

  if (active) return;

  FntSetFont(smallFont);

  bnds.xcoord = 0;
  bnds.ycoord = 0;
  bnds.width = 160;
  bnds.height = 5+FntLineHeight()+1;
  LcdEraseRegion(&bnds);

  // Draw time and status
  sprintf(buff, "Tiles: %d", Counter);
  FntDrawString(buff, 10+0, 5+0, FALSE);

  sec = (clock() - startTime)/1000 + deltaTime;
  min = sec/60;
  sec = sec-min*60;
  sprintf(buff, "Time: %ld:%02ld", min, sec);
  FntDrawString(buff, 10+80, 5+0, FALSE);
}

void YouWin()
{
  char youwin[8][15] = {
    ".x.x..xx..x..x.",
    ".x.x.x..x.x..x.",
    "..x..x..x.x..x.",
    "..x...xx...xx..",
    "...............",
    "x.x.x.xxx.xx..x",
    "x.x.x..x..x.x.x",
    ".x.x..xxx.x..xx" };
  int offy, offx, x, y, cnt;

  CpuChangeSpeed(0);

  offy=TileFaceHeight;
  offx=TileFaceWidth/2;
  for (offy=TileFaceHeight*8; offy>TileFaceHeight; offy--) {
    FntClearScreen();
    cnt=1;
    for (y=0; y<8; y++)
      for (x=0; x<15; x++)
	if (youwin[y][x]!='.') {
	  ShowTile(cnt, x*TileFaceWidth+offx, y*TileFaceHeight+offy);
	  cnt += 4;
	  if (cnt>144) cnt = 1;
	}
  }
  FntBeep();
  usleep(1000000);
}

void ShowDragon()
{
  int	x,y,z,x1,y1,n;

  CpuChangeSpeed(0);
  FntClearScreen();
  // Draw the tiles using the painter's algorithm (start at the back)
  for(z=0;z<=4;z++) // Show all the tiles remaining
    for(x=-14;x<=0;x++)
      for(y=0;y<=7;y++) {
	n = Dragon[-x][y][z]; // Get tile
	if (n>0) { //If there is a tile then display it
	  //Convert tile coordinates into graphic coordinates
	  x1 = -x*TileFaceWidth + z*ParallaxX + DragonX;
	  y1 = y*TileFaceHeight - z*ParallaxY + DragonY;

	  // Deal with shifted tiles
	  if (y==3) {
	    // Tiles on ends are shifted down half a tile
	    if(x==0 || x==-13 || x==-14)
	      y1 = y1 + TileFaceHeight/2;
	    //Top tile is shifted down and to the left
	    if(x==-7 && z==4) {
	      y1 = y1 + TileFaceHeight/2;
	      x1 = x1 - TileFaceWidth/2;
	    }
	  }
	  
	  // If there is a tile above then don't show tile face
	  if (z < 3)
	    if (Dragon[-x][y][z+1]!=0)
	      n = 145;	//Blank tile
	  
	  ShowTile(n, x1, y1);
	}
      }

  ShowStatus();
}


int Select(int penx, int peny, int *rx, int *ry, int *rz)
{
  int x, y, z;

  // Is there a tile here?
  z = 4;
  do {
    // Get tile coordinates (X,Y) from mouse position (MX,MY)
    x = (penx - DragonX - z*ParallaxX) / TileFaceWidth;
    if (x<0) x = 0;
    if (x>14) x = 14;
    y = (peny -DragonY + z*ParallaxY) / TileFaceHeight;
    if (y<0) y = 0;
    if (y>7) y = 7;
    
    // Handle shifted tiles
    if(y==4)
      if(x==0 || x==13 || x==14) y = 3;
    if (z==4) {
      if (x==6) x = 7;
      if (y==4) y = 3;
    }
    
    if (Dragon[x][y][z] != 0) break;
    
    if (z==0) return FALSE;
    z = z-1;
  } while (1);

  if (x>0 && x<14)
    if ( (Dragon[x-1][y][z]!=0 && Dragon[x+1][y][z]!=0) ||
	 (z==3 && Dragon[7][3][4] != 0) ||
	 (x==1 && y==4 && Dragon[0][3][0]!=0) ||
	 (x==12 && y==4 && Dragon[13][3][0]!=0) ) {
      FntBeep();
      return FALSE;
    }

  //EFP3 fix parallax bug
  while (z<4 && Dragon[x][y][z+1] != 0)
    z++;

  *rx = x;
  *ry = y;
  *rz = z;
  return TRUE;
}



//main entry point of program
int __main(WORD cmd, void *cmd_arg)
{
  switch(cmd)
  {
    case LAUNCH_CMD_NORMAL_LAUNCH:
      UIApplicationInit();		//initialize UI resources
      DBG_APP_BEGIN();
      DBG_BREAK();
      if (setjmp(env)==0) {
	srand(seed=clock());
	FormPopupForm(FORM_MAIN);	        //start main form
	EventLoop();			//run main event loop
      }
      DBG_APP_END();
      UIDeleteAllAppObjects();	        //main event loop has stopped, cleanup
      break;
    case LAUNCH_CMD_GOTO_REC:
      if(((GotoRec*)cmd_arg)->find_string)
        pfree(((GotoRec*)cmd_arg)->find_string);
    case LAUNCH_CMD_FIND:
    case LAUNCH_CMD_ALARM_HIT:
      pfree(cmd_arg);
      break;
    default:
      return FALSE;
  }
  return TRUE;
}

void PowerOff() {
  poweroff = 1;
}

void EventLoop(void)
{
  EvtType event;

  while(1) {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event))
      continue;
    if(MenuHandleEvent(&event))
      continue;
    if(ApplicationHandleEvent(&event))
      continue;
    FormDispatchEvent(&event);
    if(event.eventType==EVT_APP_STOP || poweroff)
      break;
  }
}

BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
  BYTE object_type;
  Form *form_ptr;
  void* evtHandler;
	
  switch(Event->eventType) {
  case EVT_FORM_LOAD:
    if((Event->para1==1)||(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
      FormInitAllFormObjects((ObjectID)Event->eventID);
    if(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
      return FALSE;
    switch((ObjectID)Event->eventID) {
    case FORM_MAIN:
      evtHandler = (void*)FormMainHandleEvent;
      break;
    default:
      return FALSE;
    }
    FormSetEventHandler((ObjectID)Event->eventID,(void**)&FormDispatchEvent,evtHandler);
    FormSetActiveForm((ObjectID)Event->eventID);
    break;
  default:
    return FALSE;
  }
  return TRUE;
}


void SaveResumeFile()
{
  FILE *file;
  int x, y, z;
  unlink(RESUMEFILE);
  filetype(RESUMEFILETYPE);
  file = fopen(RESUMEFILE,"wb");
  if (file) {
    fwrite(&seed, 1, sizeof(int), file);
    fwrite(SaveMoveX, 144, 1, file);
    fwrite(SaveMoveY, 144, 1, file);
    fwrite(SaveMoveZ, 144, 1, file);
    fwrite(SaveMoveN, 144, 1, file);
    fwrite(&Counter, 1, sizeof(int), file);
    fwrite(&UndoCount, 1, sizeof(int), file);
    for (x=0; x<15; x++)
      for (y=0; y<8; y++)
	for (z=0; z<5; z++)
	  fputc(Dragon[x][y][z], file);
    fwrite(tileFile, 33, 1, file);
    deltaTime += (clock() - startTime)/1000;
    fwrite(&deltaTime, 1, sizeof(long), file);
    fclose(file);
  }
}

int CheckResumeFile()
{
  int ok;
  FILE *file;
  int x, y, z;
  
  strcpy(tileFile, DEFAULTTILE);
  file = fopen(RESUMEFILE, "rb");
  if (file) {
    fread(&seed, 1, sizeof(int), file);
    fread(SaveMoveX, 144, 1, file);
    fread(SaveMoveY, 144, 1, file);
    fread(SaveMoveZ, 144, 1, file);
    fread(SaveMoveN, 144, 1, file);
    fread(&Counter, 1, sizeof(int), file);
    fread(&UndoCount, 1, sizeof(int), file);
    for (x=0; x<15; x++)
      for (y=0; y<8; y++)
	for (z=0; z<5; z++)
	  Dragon[x][y][z]=fgetc(file);
    fread(tileFile, 33, 1, file);
    deltaTime=0;
    fread(&deltaTime, 1, sizeof(long), file);
    fclose(file);
    ok = 1;
  } else
    ok = 0;
  unlink(RESUMEFILE);
  return ok;
}

void ShuffleTiles()
{
  int i, x,y,z,x1,y1,z1, t;
  CpuChangeSpeed(0);
  for (i=0; i<Counter/2; i++) {
    do {x=rand()%15;y=rand()%8;z=rand()%5;} while (Dragon[x][y][z]==0);
    do {x1=rand()%15;y1=rand()%8;z1=rand()%5;} while (Dragon[x1][y1][z1]==0);
    t = Dragon[x][y][z];
    Dragon[x][y][z] = Dragon[x1][y1][z1];
    Dragon[x1][y1][z1] = t;
  }
  inhint = 0;
}

void GiveHint()
{
  int	I, J;
  int	 Gap, JG, T,i,x,y,z;
  if (!inhint) {
    // Scan for and make a list of the unblocked tiles
    i = 0;
    for (z=0; z<=4; z++)
      for (y=0; y<=7; y++)
	for(x=0;x<=14;x++) {
	  if (Dragon[x][y][z]!=0) 			// Tile exists
	    if (! 
		( (z<4 && Dragon[x][y][z+1]!=0) ||	// Is there a tile above?
		  ( (x>0 && Dragon[x-1][y][z]!=0) && 		// Tile on the left and
		    (x<14 && Dragon[x+1][y][z]!=0))||		// tile on the right?
		  (z==3 && Dragon[7][3][4]!=0) ||		// Top tile blocks 4 tiles
		  (x==1 && y==4 && Dragon[0][3][0]!=0) ||	// Shifted tiles block 2
		  (x==12 && y==4 && Dragon[13][3][0]!=0) ) ) { // Tile is not blocked
	      TileX[i] = x;		       // Put it in the list
	      TileY[i] = y;
	      TileZ[i] = z;
	      TileN[i] = Dragon[x][y][z];
	      i++;
	    }
	}
    // Sort the list
    Gap = i /2;
    while (Gap > 0) {
      for (I = Gap; I<=i-1; I++) {
	J = I - Gap;
	do {
	  if (J < 0) break;
	  JG = J +Gap;
	  if (TileN[J] <= TileN[JG]) break;
	  T = TileN[J]; TileN[J] = TileN[JG]; TileN[JG] = T;
	  T = TileX[J]; TileX[J] = TileX[JG]; TileX[JG] = T;
	  T = TileY[J]; TileY[J] = TileY[JG]; TileY[JG] = T;
	  T = TileZ[J]; TileZ[J] = TileZ[JG]; TileZ[JG] = T;
	  J = J - Gap;
	} while(1);
      }
      Gap = Gap/2;
    }
    
    totalfree = i;
    hintcnt = 0;
    inhint = 1;
  } // end if(!inhint)

  // Show doubles
  for (J = hintcnt; J<=totalfree-2; J++) {
    if ((TileN[J]-1)/4 == (TileN[J+1]-1)/4) {
      Hilite1 = TileN[J];
      Hilite2 = TileN[J+1];
      hintcnt = J+1;
      ShowDragon();
      return;
    }
  }
  // Oops, no more, redo starting at beginning (kludge, but easy to code!)
  FntBeep();
  hintcnt = 0;
  Hilite1 = Hilite2 = -1;
  // Show doubles
  for (J = hintcnt; J<=totalfree-2; J++) {
    if ((TileN[J]-1)/4 == (TileN[J+1]-1)/4) {
      Hilite1 = TileN[J];
      Hilite2 = TileN[J+1];
      hintcnt = J+1;
      ShowDragon();
      return;
    }
  }
  //Fallthru, didn't have any moves from beginning!
  active = 1;
  if (DoYesNo("No Moves! Start New Game?", FORM_MAIN)) NewGame();
  ShowDragon();
}


BOOLEAN FormMainHandleEvent(EvtType* Event)
{
  int x, y, z;
  static int lastx, lasty;
  static int x1, y1, z1;
  char buff[33];

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    if (!active) {
      FormDrawForm(Event->eventID);
      ResetBoard();
      if (!CheckResumeFile())
	deltaTime = 0;
      if (!SetupGlobal()) {
	FormGotoApp("Mainmenu");
	longjmp(env, 1);
      }
      startTime=clock();
      //      deltaTime = 0;
      timer = TmrIntEnable(TIMERDELAY,ShowStatus);
      inhint = 0;
    }
    active = 0;
    Hilite1 = Hilite2 = -1;
    ShowDragon();
    break;

  case EVT_MENU_SELECT_ITEM:
    switch(Event->para1) {
    case MENU_ABOUT:
      active = 1;
      DoAbout("HelioDragon v1.1",
	      "Released March 10, 2002",
	      "Earle F. Philhower, III",
	      "earle@ziplabel.com",
	      "http://www.ziplabel.com/helio",
	      "Based on MJ.XPL by Loren Blaney");
      break;

    case MENU_NEW:
      active = 1;
      if (DoYesNo("Start New Game?", FORM_MAIN)) NewGame();
      break;

    case MENU_TILES:
      LcdSetColorMode(BLACK_AND_WHITE_MODE);
      active = 1;
      if (GetFileName("", "GrayscaleFile2", "Select Tile Image File", buff, 0)) {
	FreeBitmaps();
	if (strlen(tileFile)>0) strcpy(tileFile, buff);
	if (!SetupGlobal()) {
	  FormGotoApp("Mainmenu");
	  longjmp(env, 1);
	}
	ShowDragon();
      }
      LcdSetColorMode(GREYSCALE_MODE);
      break;

    case MENU_UNDO:
      if (Counter<144) {
	Dragon[SaveMoveX[Counter]][SaveMoveY[Counter]][SaveMoveZ[Counter]] =
	  SaveMoveN[Counter];
	Counter++;
	Dragon[SaveMoveX[Counter]][SaveMoveY[Counter]][SaveMoveZ[Counter]] =
	  SaveMoveN[Counter];
	Counter++;
	ShowDragon();
      } else
	FntBeep();
      break;

    case MENU_SHUFFLE:
      ShuffleTiles();
      ShowDragon();
      break;

    case MENU_REDO:
      if (Counter > UndoCount) {
      Counter--;
      Dragon[SaveMoveX[Counter]][SaveMoveY[Counter]][SaveMoveZ[Counter]] = 0;
      Counter--;
      Dragon[SaveMoveX[Counter]][SaveMoveY[Counter]][SaveMoveZ[Counter]] = 0;
      ShowDragon();
      } else 
	FntBeep();
      break;
      
    case MENU_HINT:
      GiveHint();
      break;
    }
    return TRUE;

  case PEN_EVENT:
    switch (Event->eventID) {
    case PEN_DOWN:
      lastx = Event->para1;
      lasty = Event->para2;
      if (inhint) { Hilite1 = Hilite2 = -1; inhint = 0;}
      if (Select(lastx, lasty, &x, &y, &z)) {
	if (Hilite1==-1)  
	  Hilite1 = Dragon[x1=x][y1=y][z1=z];
	else if (Hilite1==Dragon[x][y][z]) {
	  // Same tile, deselect
	  Hilite1 = -1;
	} else if ((Hilite1-1)/4 == (Dragon[x][y][z]-1)/4) {
	  // Match
	  Hilite2 = Dragon[x][y][z];
	  ShowDragon();
	  FntBeep();
	  Counter--;
	  SaveMoveX[Counter] = x1;
	  SaveMoveY[Counter] = y1;
	  SaveMoveZ[Counter] = z1;
	  SaveMoveN[Counter] = Dragon[x1][y1][z1];
	  Dragon[x1][y1][z1] = 0;
	  Counter--;
	  SaveMoveX[Counter] = x;
	  SaveMoveY[Counter] = y;
	  SaveMoveZ[Counter] = z;
	  SaveMoveN[Counter] = Dragon[x][y][z];
	  Dragon[x][y][z] = 0;
	  Hilite1 = Hilite2 = -1;
	  UndoCount = Counter;
	  if (Counter==0) {
	    active = 1;
	    YouWin();
	    if (DoYesNo("You Won! Start New Game?", FORM_MAIN)) NewGame();
	  }
	} else {
	  // Mismatch, select other tile instead
	  Hilite1 = Dragon[x1=x][y1=y][z1=z];
	}
	ShowDragon();
      } else { // Clicked outside of any tile
	Hilite1 = Hilite2 = -1;
	ShowDragon();
      }
      break;
      
    case PEN_MOVE:
      break;

    case PEN_UP:
      break;
    }
    break;

  case EVT_APP_STOP:
    SaveResumeFile();
    break;
    
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      GiveHint();
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormGotoApp("Mainmenu");
      break;
    default:
      return FALSE;
    }
    break;
  default:
    return FALSE;
  }
  return TRUE;
}

void FormGotoApp(BYTE* app_name)
{
  ObjectID objid;

  FormGetActiveFormID(&objid);
  EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
  SysGetAppID(app_name,&objid);
  EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
  EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
}
