//AbouHelp.c Part of Helio shopping list application
// Code for the About and Help form called from the Menu of the main form
 
char *shoppingHelp="Main Screen: Shows all items currently on your shopping list for all stores.\r\rCategory DropDown List: Here you choose which category to show in the list. Categories are user defined labels to sort and filter items other than by store. Ex: Dairy, Produce, Vacation. Tapping \"Shopping List\" will show only items with quantity more than 0.\r\rStore DropDown List: Tap the store you want to see items for. Items with \"Any\" as store, will show up for all stores.\r\rColumn headers:\rTapping on the column headers will sort the list in ascending order.\rD: Done. When tapping in this column for the item that has been purchased, there will be a \"V\" in it, and the item will be crossed out. Tapping once more in this column will reset the quantity to 0, and remove it from the shopping list.\rQ: Quantity. Tapping in this column for an item, increases the quantity by one.\rItem: Tapping the item takes you to the editing screen.\rAisle: Aisle number in the store. Tapping in the aisle column will remove the selected item temporarily from the list (hide it). To get everything back, tap on any filter/sorting.\r\rNew button will take you to a screen where you can enter new items. See below.\r\rSort button lets you select sorting criteria - by item, category, store, or aisle. If you have many items in your database, this can take quite awhile.\r\rBlack box with numbers: The first number shows how many items are in your current filtered list. The second shows number of items in your database.\r\r\Menu:\rTapping the menu button, presents you with the following options:\r\rSave List: This will save the list currently displayed, to a memo in the unfiled category titled Shopping List.\r\rReset All: This will reset all quantities to 0.\r\rBackup DB: This saves all records in the shopping database to a memo in the unfiled category. It works for backup of up to 500 records. They will be saved to memos titled Backup of Shopping Information. Backup of Shopping Information 2-5.\r\rRestore DB: Since there is no way of restoring hdb files, this was meant to take its place in case of a problem with the Helio leading to a reset. If the shopping list accidentally is deleted, choosing this option, will restore the database. However it does not work after a hard reset. Also, it will restore all memos titled Backup of Shopping Information. It is therefore important to keep only one series before making a restore, otherwise it will result in duplicate entries. After restoring the database, the stores and categories have to be entered manually to show up in the drop down lists. They exist in the database for the items, so will only have to be entered on the edit store/category forms.\r\rLarge/Small Font. This will toggle the font used.\r\rTapping Exit takes you out of the program. All settings will be saved when exiting/powering off the program.\r\rEditing screen:\r\rItem: Max 30 characters allowed.\rStore: Choose from the list or tap edit stores to add a new store.\rAisle: Max 2 characters. If only one digit is entered, the program will put this on the second place for characters. This can make it seem as though no more characters are allowec. To solve: Use backspace key.\rQuantity: Max 2 characters.\rCategory: Choose from the list or tap edit categories to add a new category.\rTo return to main screen, tap OK (item is saved without asking), or Exit.\r\rEdit Stores\rAny number of stores can be added to the database. Remember that items entered with Any as a store, will show up on all lists.\r\rEdit Category\rAny number of categories can be added to the database.\r\rLists can be scrolled using the hard scroll buttons on the side of the Helio.";

//BOOLEAN FormHelpHandleEvent(EvtType* Event)
//BOOLEAN FormAboutHandleEvent(EvtType* Event)

BOOLEAN FormHelpHandleEvent(EvtType* Event)
{   
    
    WORD value;
    WORD maxValue;
    WORD minValue;
    WORD pageSize;
    WORD totalLines;
   
    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            ScrollbarInitScrollbar(HELP_SCROLLBAR);
            FieldInitField((ObjectID)HELP_FIELD);
            FieldSetText((ObjectID)HELP_FIELD,shoppingHelp);
            FieldGetTotalNumOfLines (HELP_FIELD, &totalLines);
            ScrollbarSetScrollbar(HELP_SCROLLBAR, 0, totalLines - 13, 0, 12, totalLines);
            ScrollbarSetScrollbarDrawPagesize((ObjectID)HELP_SCROLLBAR, 12);
            //ScrollbarInitScrollbar(HELP_SCROLLBAR);
           // ScrollbarDrawScrollbar(HELP_SCROLLBAR);
            //FieldSetTopLineNum (HELP_FIELD, 0);
            FormDrawForm(Event->eventID);
            break;
        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case HBTN_OK:
                    qfree(shoppingHelp);   
                    FormPopupForm(FORM_MAIN);
                    break;
            }
            break;
        case EVT_SCROLLBAR_REPEAT:
        case EVT_SCROLLBAR_SELECT:        
             ScrollbarGetScrollbar(HELP_SCROLLBAR, &value, &maxValue, &minValue,
                  &pageSize, &totalLines);
             ScrollbarSetScrollbar(HELP_SCROLLBAR, Event->para2, maxValue, minValue,
                  pageSize, totalLines);
             ScrollbarDrawScrollbar(HELP_SCROLLBAR);    
             FieldSetTopLineNum((ObjectID)HELP_FIELD, value);
             FieldDrawField((ObjectID)HELP_FIELD);
             break;
        default:
            return FALSE;
        }
    return TRUE;
}

BOOLEAN FormAboutHandleEvent(EvtType* Event)
{
    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            FormDrawForm(Event->eventID);
            break;
        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case ABTN_OK:
                    FormSaveBehindBits(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
            }
            break;
        default:
            return FALSE;
        }
    return TRUE;
}