/*          SHOPPING LIST FOR THE HELIO
===========================================================================
File        :   main.c
Author(s)   :   Heidi Gerstle
Company     :
Project     :   Helio  ShoppingList
Date        :   11/14/01-
Purpose     :   main file
Revision    :
Note        :   I do not have any background in programming, and the code is based
                on examples and the help files from VTech. 
                I am sure there are lots that can be improved. 
                As can be seen I am not very comfortable passing variables in functions. 
                There are also a lot of global variables.
===========================================================================
*/

#include "main.h"
#include <system.h>
#include "function.c"
#include "AboHelp.c"
#include "Backup.c"
#include "Edit.c"
#include "Database.c"
#include "Categ.c"
#include "Store.c"

#define MEMODB (BYTE*)("Memo Database")
#define SAME   2

DatabaseID     ShopperdbID;
//USHORT         Vlines; 
BYTE           *menuText;  
char    sz[100];  //for debug purposes

void    Read_Database();
void    Write_Database();
void    Delete_Store();

void    Category_Filter();
void    Delete_Lists();
void    Draw_Lists();
void    Done_Quantity();
void    Filter();
void    Postpone_Item();
void    Qty_Records();
void    Redraw_Line();
void    Reset_Qty();
void    Resume();
void    Save_Quantity();
void    SaveSettings();
void    ScrollDown();
void    ScrollUp();
void    Set_Font();
void    Shopping_List();
void    Store_Filter();

//List 1: Quantity
//List 2: Item
//Field 0: Item
//Field 1: Quantity
//Field 2: Category
//Field 3: Store
//Field 4: Aisle
//Field 5: Done =V
//db cat 0= all records
//db cat 1= all categories
//db cat 2= all stores
//db cat 3= Settings: 1:Font,2:Category,3:Store,4:Sortfield

//main entry point of program
__main(WORD cmd, void *cmd_arg)
{
    switch(cmd)
    {
        case LAUNCH_CMD_NORMAL_LAUNCH:
            UIApplicationInit();        //initialize UI resources
            #ifdef DEBUG
                DBG_APP_BEGIN();
            #endif
            FormInitAllFormObjects(FORM_MAIN);
            FormInitAllFormObjects(FORM_ADD_EDIT);
            FormInitAllFormObjects(FORM_SAVE);
            FormInitAllFormObjects(FORM_CAT);
            FormInitAllFormObjects(FORM_EDITCAT);
            FormInitAllFormObjects(FORM_ABOUT);
            FormInitAllFormObjects(FORM_HELP);
            FormInitAllFormObjects(FORM_STORES);
            FormInitAllFormObjects(FORM_SORT);
            FormInitAllFormObjects(FORM_DELETE);
            FormInitAllFormObjects(FORM_EDITSTORES);
            //Vlines=10;
            Create_Database();
            CategoryToPopupTrigger();
            StoreToPopupTrigger();
            Resume(); 
            FormPopupForm(FORM_MAIN);           
            EventLoop();            //run main event loop
            #ifdef DEBUG
                DBG_APP_END();
            #endif
            UIDeleteAllAppObjects();    //main event loop has stopped, cleanup
            break;
        case LAUNCH_CMD_GOTO_REC:
            if(((GotoRec*)cmd_arg)->find_string)
                pfree(((GotoRec*)cmd_arg)->find_string);
        case LAUNCH_CMD_FIND: 
        case LAUNCH_CMD_ALARM_HIT: 
            pfree(cmd_arg);
            break;
        default:
            return FALSE;
        }
    return TRUE;
}

void EventLoop(void)
{
    EvtType event;

    while(1)
    {
        EvtGetEvent(&event);
        if(SystemHandleEvent(&event))
            continue;
        if(MenuHandleEvent(&event))
            continue;
        if(ApplicationHandleEvent(&event))
            continue;
        FormDispatchEvent(&event);
        if(event.eventType==EVT_APP_STOP)
        {           
            SaveSettings();
            qfree(cat_name); 
            qfree(item_cat);          
            qfree(item_text);
            qfree(store_name);
            qfree(buffer);
            qfree(buffer1);
            qfree(item_store);
            qfree(record_aisle);
            qfree(record_category);
            qfree(record_done);
            qfree(record_edittext);
            qfree(record_qty);
            qfree(record_store);
            qfree(record_text);
            qfree(recordText);
            qfree(store);
            qfree(record_cate); 
            qfree(menuText);  
            break;
        }
    }
}

BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
    BYTE object_type;
    Form *form_ptr;
    void* evtHandler;

    switch(Event->eventType)
    {
        case EVT_FORM_LOAD:
            if((Event->para1==1)||(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
                FormInitAllFormObjects((ObjectID)Event->eventID);
            if(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
                return FALSE;
            switch((ObjectID)Event->eventID)
            {
                case FORM_MAIN:
                    evtHandler = (void*)FormMainHandleEvent;
                    break;
                case FORM_ADD_EDIT:
                    evtHandler = (void*)FormEditHandleEvent;
                    break;
                case FORM_SAVE:
                    evtHandler = (void*)FormSaveHandleEvent;
                    break;
                case FORM_ABOUT:
                    evtHandler = (void*)FormAboutHandleEvent;
                    break;
                case FORM_HELP:
                    evtHandler = (void*)FormHelpHandleEvent;
                    break;
                case FORM_CAT:
                    evtHandler = (void*)FormCatHandleEvent;
                    break;
                case FORM_EDITCAT:
                    evtHandler = (void*)FormCatNameHandleEvent;
                    break;
                case FORM_STORES:
                    evtHandler = (void*)FormStoreHandleEvent;
                    break;
                case FORM_EDITSTORES:
                    evtHandler = (void*)FormStoreNameHandleEvent;
                    break;
                case FORM_SORT:
                    evtHandler = (void*)FormSortHandleEvent;
                    break;
                case FORM_DELETE:
                    evtHandler = (void*)FormDeleteHandleEvent;
                    break;
                default:
                    return FALSE;
                }
            FormSetEventHandler((ObjectID)Event->eventID,(void**)&FormDispatchEvent,evtHandler);
            FormSetActiveForm((ObjectID)Event->eventID);
            break;
        default:
            return FALSE;
        }
    return TRUE;
}


BOOLEAN FormMainHandleEvent(EvtType* Event)
{
    ObjectID  which_list; 
    int max;

    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            if(strstr(item_cat,"Edit Categories"))
                item_cat="All";                
            if(strstr(item_store,"Edit Stores"))
                item_store="All Stores";                                        
            ControlSetLabel(POPUP_STORE, item_store);
            ControlSetLabel(POPUP_CATEGORY, item_cat);            
            FormDrawForm(FORM_MAIN);
            Set_Font();
            Filter();            
            break;
        case EVT_APP_STOP:
           
        case EVT_INLAY_SELECT:
            switch(Event->para1)
            {
                case INLAY_EXIT:
                    FormGotoApp("Mainmenu");
                    break;

                case INLAY_MAIN_MENU:
                    FormGotoApp("Mainmenu");
                    break;
                default:
                    return FALSE;
                }
            break;
        case    EVT_CONTROL_POPUP_SELECT:
            ControlPopupGetSelectedItem(POPUP_CATEGORY, &item_no);
            ControlPopupGetPopupItem(POPUP_CATEGORY, item_no, &item_cat);
            ControlPopupGetSelectedItem(POPUP_STORE, &item_no);
            ControlPopupGetPopupItem(POPUP_STORE, item_no, &item_store);
            Filter();
            break;
        case EVT_MENU_SELECT_ITEM:
            switch(Event->para1)
            {
                case 0://Save Shopping List
                    Save_List();
                    break;
                case 1://Reset all qty to 0
                    Reset_Qty();
                    break;
                case 2://Backup Database to Memo
                    Backup_toMemo();
                    break;
                case 3:// Restore Backuped Database from Memo
                    //doesn't work after hard reset
                    Restore_Database();
                    break;
                case 4: //Change font
                    MenuGetMenuItem (MENU_MAIN, 4,&menuText );
                    if(strstr(menuText, "Large Font"))
                    {  
                        font=MEDIUM_FONT;
                        MenuDeleteItem(MENU_MAIN, 4);
                        MenuInsertItem(MENU_MAIN, 4, "Small Font");
                        max=7;
                        //Vlines=13;
                    }                   
                    else
                    {
                        font=SMALL_FONT;
                        MenuDeleteItem(MENU_MAIN, 4);
                        MenuInsertItem(MENU_MAIN, 4, "Large Font");
                        max=11;
                       // Vlines=10;
                    }
                    ListSetNumItemsDisplay (LIST_ITEMS, max);
                    ListSetNumItemsDisplay (LIST_QTY, max);
                    ListSetNumItemsDisplay (LIST_DONE, max);
                    ListSetNumItemsDisplay (LIST_AISLE, max);
                    ListSetFont(LIST_ITEMS,font);
                    ListSetFont(LIST_QTY,font);
                    ListSetFont(LIST_DONE,font);
                    ListSetFont(LIST_AISLE,font);
                    Draw_Lists();
                    Redraw_Line();  
                    break;
                
                case 5://Help    
                    FormPopupForm(FORM_HELP);
                    break;
                case 6://About
                    FormSaveBehindBits(FORM_MAIN);
                    FormPopupForm(FORM_ABOUT);
                    break;
            }
            break;
        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case BTN_NEW:
                    edit_chk=0;
                    //done_chk=0;
                    del_chk=0;
                    FormSetFormActiveObject(FORM_ADD_EDIT, TB_ITEM);
                    FormPopupForm (FORM_ADD_EDIT);
                    TextboxSetInsertPointOn(TB_ITEM);
                    break;
                case BTN_SORT:
                    FormSaveBehindBits(FORM_MAIN);
                    FormPopupForm(FORM_SORT);                    
                    break;
                case BTN_ITEM:
                    sort_field=0;
                    Filter();                    
                    break;
                case BTN_AISLE:
                    sort_field=4;
                    Filter();
                    break;
                case BTN_DONE:
                    sort_field=5;
                    Filter();
                    break;
            }

            break;
        case EVT_LIST_ARROW:
                Redraw_Line();
                break;
                
        case EVT_LIST_SELECT:
            ListGetSelectedItem(LIST_ITEMS, &listno);
            FormGetActiveObject(FORM_MAIN, &which_list);
            switch (which_list)
            {
                case 57: //clicking qty
                    Save_Quantity();
                    break;

                case 59:    //clicking done
                //Reset quantity to 0
                    ListGetSelectedItem(LIST_ITEMS, &listno);
                    ListGetListItem(LIST_DONE, listno, (BYTE **) &recordText);

                    if(strstr(recordText,"V"))
                    {
                        qty_no=1;
                        Save_Quantity();
                    }
                    else
                    {
                        Done_Record();
                    }
                    break;

                case 60:  //clicking aisle
                // remove from shopping list, is not deleted
                    Postpone_Item();
                    break;

                default:
                    edit_chk=1;
                    del_chk=1;
                    Edit_Item();
                    FormSetFormActiveObject(FORM_ADD_EDIT, TB_ITEM);
                    FormPopupForm(FORM_ADD_EDIT);
                    TextboxSetInsertPointOn(TB_ITEM);
                    break;
            }
            break;
        case EVT_KEY:
            //FormGetActiveObject(ObjectID form_id, ObjectID *active_id)
            //FormGetActiveObject(FORM_ADD_EDIT,&object_type);
            //TextboxAddKeyInChar(object_type, (BYTE) (Event-> para1));
            //TextboxDrawTextbox (object_type);
            break;

        case EVT_IO_KEY_CTRL:
             if (Event->eventID == EVT_IO_KEY_PRESS || Event->eventID == EVT_IO_KEY_REPEAT)
             {                 
                 if (Event->para2 == IO_UP_ARROW)
                        ScrollUp();
                 else if (Event->para2 == IO_DOWN_ARROW)
                         ScrollDown();
                 return TRUE;
             }
             return FALSE;

        default:
            return FALSE;
        }
    return TRUE;
}

BOOLEAN FormSortHandleEvent(EvtType* Event)
{
    switch(Event->eventType)
    {
        case EVT_FORM_OPEN:
            FormDrawForm(Event->eventID);
            break;
        case EVT_CONTROL_SELECT:
            switch (Event->eventID)
            {
                case SORT_BTN_X:
                    FormRestoreBitBehind(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
                case SORT_BTN_ITEM:
                    sort_field=0;
                    Filter();
                    FormRestoreBitBehind(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
                case SORT_BTN_CAT:
                    sort_field=2;
                    Filter();
                    FormRestoreBitBehind(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
                case SORT_BTN_STORE:
                    sort_field=3;
                    Filter();
                    FormRestoreBitBehind(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
                case SORT_BTN_AISLE:
                    sort_field=4;
                    Filter();
                    FormRestoreBitBehind(FORM_MAIN);
                    FormPopupForm(FORM_MAIN);
                    break;
            }
            break;
        default:
            return FALSE;
        }
    return TRUE;
}

void FormGotoApp(BYTE* app_name)
{
    ObjectID objid;
    #ifdef DEBUG
        DBG_MESSAGE("+FormGotoApp()\r\n");
    #endif
    FormGetActiveFormID(&objid);
    EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
    SysGetAppID(app_name,&objid);
    EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
    EvtAppendEvt(EVT_APP_LAUNCH,objid,0,0,NULL);
    #ifdef DEBUG
        DBG_MESSAGE("-FormGotoApp()\r\n");
    #endif
}

/*-----Using the scroll buttons on the side of the Helio-----*/

void ScrollUp()
{
    ListGetTopItemNum(LIST_DONE, &item_num) ;
    item_num=item_num-1;
    Draw_Lists();
    Redraw_Line();
}

void ScrollDown()
{
    ListGetTopItemNum(LIST_DONE, &item_num) ;
    item_num=item_num+1;    
    Draw_Lists(); 
    Redraw_Line();
}

/*-------Save and Resume Settings between Sessions-----------*/
void SaveSettings()
{
    int     x;
    int     max;
    UBYTE   rec_cat; 
    unsigned char ns[3];


    if(DataFindDB("ShopperDB", &ShopperdbID))
    {
        if(DataOpenDB(ShopperdbID,0,OPEN_RW))
        {
            DataTotalRecord(ShopperdbID, &recCount);
            for(x=0;x<recCount;x++)
            {                
                if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                {
                    DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);       
                    if(rec_cat==3)
                    {                
                        //font 
                        DBG_MESSAGE("Save_settings-font\r\n");                          
                        if(font==SMALL_FONT)
                            DataWriteField(ShopperdbID,rec_id, 0, 31, "Small Font");
                         else DataWriteField(ShopperdbID,rec_id, 0, 31, "Large Font");                 
                        
                        //categroy
                        DataWriteField(ShopperdbID,rec_id, 1, 31,  item_cat);
                        //store
                        DataWriteField(ShopperdbID,rec_id, 2, 31,  item_store);
                        sprintf (ns, "%i", sort_field); 
                        // strcpy(sort_name,ns);                 
                        DataWriteField(ShopperdbID,rec_id, 3, 2, ns); 
                        //DataWriteField(ShopperdbID,rec_id, 3, 2, sort_name);               
                        DBG_MESSAGE("Save_settings-font\r\n");
                    }    
                    DataCloseRecord(ShopperdbID,rec_id);
                }
            }
            DataCloseDB(ShopperdbID);
        }
    } 
}


void Resume()
{
    int     x;    
    BYTE    *saveFont;
    UBYTE   rec_cat; 
    BYTE    *sort_name;
    int     version;    //to see if it reads an older db
    
    version=0;

    if(DataFindDB("ShopperDB", &ShopperdbID))
    {
        if(DataOpenDB(ShopperdbID,0,OPEN_RW))
        {
           DataTotalRecord(ShopperdbID, &recCount);
           for(x=0;x<recCount;x++)
           {
               if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
               {
                  DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                  if(rec_cat==3)
                  {
                     version=1;
                     DataGetField(ShopperdbID, rec_id, 0, &saveFont, &byte_read);                    
                    
                     if(strstr(saveFont,"Small Font"))
                     {
                           font=SMALL_FONT;
                           //MenuDeleteItem(MENU_MAIN, 4);
                           //MenuInsertItem(MENU_MAIN, 4, "Large Font");
                     }
                      else 
                      {
                          font=MEDIUM_FONT; 
                          //MenuDeleteItem(MENU_MAIN, 4);
                          //MenuInsertItem(MENU_MAIN, 4, "Small Font");
                      }
                      DataGetField(ShopperdbID, rec_id, 1, &item_cat, &byte_read);
                      DataGetField(ShopperdbID, rec_id, 2, &item_store, &byte_read);
                      
                      DataGetField(ShopperdbID, rec_id, 3, &sort_name, &byte_read);
                      sort_field=atol((char*)sort_name);
                   }                   
                  DataCloseRecord(ShopperdbID,rec_id);
               }
               //else if there is no records in category 3
                  if(version==0) //Reading older database
                   {
                       font=SMALL_FONT;
                       MenuDeleteItem(MENU_MAIN, 4);
                       MenuInsertItem(MENU_MAIN, 4, "Large Font");
                       sort_field=0;
                       item_cat="Shopping List";
                       item_store="All";
                   }
           }
           DataCloseDB(ShopperdbID);
        }
    }    
    Set_Font();
    qfree(saveFont);
    qfree(sort_name);
}

/*---------------------Display-------------------------*/
void Set_Font()
{
    int max;
    
    if (font==SMALL_FONT)
    {
        MenuDeleteItem(MENU_MAIN, 4);
        MenuInsertItem(MENU_MAIN, 4, "Large Font");
        max=7;
        //Vlines=13;
    }    
    else
    {     
        MenuDeleteItem(MENU_MAIN, 4);
        MenuInsertItem(MENU_MAIN, 4, "Small Font");
        max=11;
        //Vlines=10;
    }
    ListSetNumItemsDisplay (LIST_ITEMS, max);
    ListSetNumItemsDisplay (LIST_QTY, max);
    ListSetNumItemsDisplay (LIST_DONE, max);
    ListSetNumItemsDisplay (LIST_AISLE, max);
    
    ListSetFont(LIST_ITEMS,font);
    ListSetFont(LIST_QTY,font);
    ListSetFont(LIST_DONE,font);
    ListSetFont(LIST_AISLE,font);
}

//Goes through list to see what item has V(done)
//If yes- draw line

void Redraw_Line()
{
    USHORT  num_items;
    USHORT  item_num;
    USHORT  max_num_items;
    USHORT  Vlines;
    int     x;
    int     atline;
    int     fontline=34;
    
    if(font==SMALL_FONT) 
    {
        fontline=34;
        Vlines=10;
    }
    if(font==MEDIUM_FONT) 
    {
        fontline=36;
        Vlines=12;
    }
   
    if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
    {
       DataTotalRecord(ShopperdbID, &recCount);
       if(recCount>0)
       {
           ListGetTotalItems(LIST_DONE, &num_items);
           ListGetTopItemNum(LIST_DONE, &item_num);
           for (x=0;x<num_items; x++)
           {
                ListGetListItem(LIST_DONE, x, (BYTE **) &item_text);    
          
                if(strstr(item_text,"V"))
                {
                    atline =(x-item_num)*Vlines+fontline;
                    if((atline>29)&&(atline<142))           
                       LcdDrawHoriLine(30, 146, atline, NON_DOTTED_LINE, COLOR_BLACK, COLOR_WHITE);
               } 
           }
       }
       DataCloseDB(ShopperdbID);
    }
}

/*------------------Filters------------------------*/


void Filter()
{          
    if(strstr(item_cat,"All")&&strstr(item_store,"All Stores"))
    {
        Read_Database();        
    }
    else if(strstr(item_cat,"Shopping List"))
    {
        Shopping_List(); 
    }  
    else 
    { 
        Category_Filter();
    } 
}

void Read_Database() //Reads all records
{
    int     x;
    UBYTE   rec_cat;
    
    ListGetTopItemNum(LIST_DONE, &item_num) ; 
    Delete_Lists();

    if(DataFindDB("ShopperDB", &ShopperdbID))
    {
        if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
        {
            DataTotalRecord(ShopperdbID, &recCount);
            for(x=0;x<recCount;x++)
            {
                if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
                {
                    DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                    if(rec_cat==0)
                    {                
                        DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                        ListInsertItem(LIST_ITEMS,x,buffer);
                        DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                        ListInsertItem(LIST_QTY,x,buffer);
                        DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                        ListInsertItem(LIST_STORE,x,buffer);
                        DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                        ListInsertItem(LIST_AISLE,x,buffer);
                        DataGetField(ShopperdbID, rec_id, 5, &buffer, &byte_read);
                        ListInsertItem(LIST_DONE,x,buffer);
                        qfree(buffer);        
                     }
                    DataCloseRecord(ShopperdbID,rec_id);
                }
            }
            DataCloseDB(ShopperdbID);
        }
    }
    Draw_Lists();
    Redraw_Line();
    Qty_Records();
    ControlSetLabel(POPUP_STORE,item_store);
    ControlSetLabel(POPUP_CATEGORY, item_cat);
}

//called as part of all filters. Displays no. of items in the list, 
//possibly different from no. in database.

void Qty_Records() 
{
    int     no=0;
    SHORT   items;
    int     x;
    UBYTE   rec_cat;
    char    sz[5];

    if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
    {
        DataTotalRecord(ShopperdbID, &recCount);
        for(x=0;x<recCount;x++)
        {
            if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
            {
               DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
               if(rec_cat==0)
               {
                   no=no+1;
               }
               DataCloseRecord(ShopperdbID,rec_id);
            }
        }
        DataCloseDB(ShopperdbID);
    }
    ListGetNumOfItems(LIST_ITEMS, &items);
    sprintf(sz,"%i/%i",items,no);
    StringSetText(STR_REC,sz);
    StringDrawString(STR_REC);
    FormSetActiveForm(FORM_MAIN);
}


void Shopping_List()
{
    int     x;
    UBYTE   rec_cat;
    
    ListGetTopItemNum(LIST_DONE, &item_num) ; 
    Delete_Lists();

    if(DataFindDB("ShopperDB", &ShopperdbID))
    {
        if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
        {
           DataTotalRecord(ShopperdbID, &recCount);
           for(x=0;x<recCount;x++)
           {
               if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
               {
                  DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);
                  if(rec_cat==0)
                  {
                      DataGetField(ShopperdbID, rec_id, 1, &buffer1, &byte_read);
                      if (!strstr("0",buffer1))  //if qty>0
                      {
                          if(strstr(item_store,"All Stores"))
                          {
                              //read all data with qty >0
                              DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                              ListInsertItem(LIST_ITEMS,x,buffer);
                              DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                              ListInsertItem(LIST_QTY,x,buffer);
                              DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                              ListInsertItem(LIST_STORE,x,buffer);
                              DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                              ListInsertItem(LIST_AISLE,x,buffer);
                              DataGetField(ShopperdbID, rec_id, 5, &buffer, &byte_read);
                              ListInsertItem(LIST_DONE,x,buffer);
                          }
                          else //filter on item_store
                          {
                              DataGetField(ShopperdbID, rec_id, 3, &buffer1, &byte_read);
                              if(strstr(item_store,buffer1)||strstr(buffer1,"Any"))
                              {                                  
                                  DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                                  ListInsertItem(LIST_ITEMS,x,buffer);
                                  DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                                  ListInsertItem(LIST_QTY,x,buffer);
                                  DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                                  ListInsertItem(LIST_STORE,x,buffer);
                                  DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                                  ListInsertItem(LIST_AISLE,x,buffer);
                                  DataGetField(ShopperdbID, rec_id, 5, &buffer, &byte_read);
                                  ListInsertItem(LIST_DONE,x,buffer);
                              }
                          }                    
                          qfree(buffer);
                      }
                      DataCloseRecord(ShopperdbID,rec_id);
                      qfree(buffer1);
               }
               }
           }
           DataCloseDB(ShopperdbID);
        }
    }
    ControlSetLabel(POPUP_STORE,item_store);
    ControlSetLabel(POPUP_CATEGORY, item_cat);//new
    Draw_Lists();
    Redraw_Line();
    Qty_Records();
}

void Category_Filter()
{
    int     x;
    UBYTE   rec_cat;
    BYTE    *buffer2;
    BYTE    *buffer1;
    
    ListGetTopItemNum(LIST_DONE, &item_num) ; 
    Delete_Lists();
     
    if(DataOpenDB(ShopperdbID,sort_field,OPEN_RW))
    {
       DataTotalRecord(ShopperdbID, &recCount);       
       for(x=0;x<recCount;x++)
       {
           if(DataOpenRecord(ShopperdbID,x,&rec_id,NULL))
           {
               DataRecordInfo(ShopperdbID,rec_id, NULL, &rec_cat, NULL, NULL, NULL);           
               if(rec_cat==0)
               {            
                   //all categories filter on store
                   DataGetField(ShopperdbID, rec_id, 3, &buffer2, &byte_read); //store 
                   if (strstr(item_cat,"All")&&(strstr(item_store,buffer2)||strstr(buffer2,"Any")))
                   {                 
                       DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                       ListInsertItem(LIST_ITEMS,x,buffer);
                       DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                       ListInsertItem(LIST_QTY,x,buffer);
                       DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                       ListInsertItem(LIST_STORE,x,buffer);
                       DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                       ListInsertItem(LIST_AISLE,x,buffer);
                       DataGetField(ShopperdbID, rec_id, 5, &buffer, &byte_read);
                       ListInsertItem(LIST_DONE,x,buffer);
                       qfree(buffer);
                   }
                   //all stores filter on category
                   DataGetField(ShopperdbID, rec_id, 2, &buffer1, &byte_read);
                   if (strstr(item_store,"All Stores")&&strstr(item_cat,buffer1))
                   {                              
                       DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                       ListInsertItem(LIST_ITEMS,x,buffer);
                       DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                       ListInsertItem(LIST_QTY,x,buffer);
                       DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                       ListInsertItem(LIST_STORE,x,buffer);
                       DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                       ListInsertItem(LIST_AISLE,x,buffer);
                       DataGetField(ShopperdbID, rec_id, 5, &buffer, &byte_read);
                       ListInsertItem(LIST_DONE,x,buffer);
                       qfree(buffer);
                   }
                   //Filter on both store and category                       
                   else if (strstr(item_cat,buffer1)&&(strstr(item_store,buffer2)||strstr(buffer2,"Any")))
                   {               
                           DataGetField(ShopperdbID, rec_id, 0, &buffer, &byte_read);
                           ListInsertItem(LIST_ITEMS,x,buffer);
                           DataGetField(ShopperdbID, rec_id, 1, &buffer, &byte_read);
                           ListInsertItem(LIST_QTY,x,buffer);
                           DataGetField(ShopperdbID, rec_id, 3, &buffer, &byte_read);
                           ListInsertItem(LIST_STORE,x,buffer);
                           DataGetField(ShopperdbID, rec_id, 4, &buffer, &byte_read);
                           ListInsertItem(LIST_AISLE,x,buffer);
                           DataGetField(ShopperdbID, rec_id, 5, &buffer, &byte_read);
                           ListInsertItem(LIST_DONE,x,buffer);
                           qfree(buffer);
                    }   
                    qfree(buffer2);
                    qfree(buffer1);            
                }
                DataCloseRecord(ShopperdbID,rec_id);    
           }        
       }
       DataCloseDB(ShopperdbID);    
       Draw_Lists();
       Redraw_Line();
       Qty_Records();
       ControlSetLabel(POPUP_STORE,item_store);
       ControlSetLabel(POPUP_CATEGORY, item_cat);
    }
}

/*-------------Lists--------------------*/

void Postpone_Item()
{
    if(listno!=NO_SELECTION)
    {
        ListGetTopItemNum(LIST_DONE, &item_num) ;  
        ListDeleteItem(LIST_QTY, listno);
        ListDeleteItem(LIST_ITEMS, listno);
        ListDeleteItem(LIST_DONE, listno);
        ListDeleteItem(LIST_AISLE, listno);
        Draw_Lists();
        Redraw_Line();
    }
}

void  Draw_Lists()
{

    ListSetTopItemNum(LIST_QTY, item_num);
    ListSetTopItemNum(LIST_ITEMS, item_num);
    ListSetTopItemNum(LIST_DONE, item_num);
    ListSetTopItemNum(LIST_AISLE, item_num);
    ListDrawList(LIST_QTY);
    ListDrawList(LIST_ITEMS);
    ListDrawList (LIST_DONE);
    ListDrawList (LIST_AISLE);
}

void  Delete_Lists()
{
    ListDeleteAllItems(LIST_QTY);
    ListDeleteAllItems(LIST_ITEMS);
    ListDeleteAllItems(LIST_DONE);
    ListDeleteAllItems(LIST_AISLE);
    ListDeleteAllItems(LIST_STORE);
}


