#include "stdafx.h"
#include "include\App.h"
#include "include\alarmgr.h"

#ifdef PC_SIM
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#endif 

BYTE playing;
BYTE Buffer[5];
BYTE selectedFlag;
BYTE occupant[4];
BYTE referenceOccupant[4];
BYTE scoreOccupant[2][2];
BYTE row;
AppID app_id;

ObjectBounds outsideBounds;
ObjectBounds gameoverBounds;
ObjectBounds highestScoreBounds;
ObjectBounds highestScoreLabelBounds;
ObjectBounds selectedBounds;
ObjectBounds selectedLabelBounds;
ObjectBounds occupantBounds;
ObjectBounds occupantScoreBounds;
ObjectBounds bounds;
ObjectBounds scoreBounds;

/********************************************************
 * Function:    MasterMindInit
 * Purpose:     MasterMind application initialise
 * Scope:		internal
 * Input:		
 * Output:		
 * Return:		
 * Comment: 	None
 *********************************************************/
void MasterMindInit()
{
	bounds.xcoord = 0;
	bounds.ycoord = 0;
	bounds.width = 12;
	bounds.height = 14;

	scoreBounds.xcoord = 0;
	scoreBounds.ycoord = 0;
	scoreBounds.width = 12;
	scoreBounds.height = 7;

	outsideBounds.xcoord = 9;
	outsideBounds.ycoord = 24;
	outsideBounds.width  = 90;
	outsideBounds.height = 130;

	selectedBounds.xcoord = 110;
	selectedBounds.ycoord = 34;
	selectedBounds.width = 40;
	selectedBounds.height = 20;

	selectedLabelBounds.xcoord = 110;
	selectedLabelBounds.ycoord = 24;
	selectedLabelBounds.width = 40;
	selectedLabelBounds.height = 20;

	gameoverBounds.xcoord = 32;
	gameoverBounds.ycoord = 26;
	gameoverBounds.width  = 60;
	gameoverBounds.height = 10;

#ifdef PC_SIM
        srand( (unsigned)time( NULL ) );
#endif

	playing = 0;
	selectedFlag = 0;
	row = 0;
}	

void setOccupantBounds()
{
	BYTE x;
	BYTE y;

	occupantBounds.xcoord = 13;
	occupantBounds.ycoord = 136;
	occupantBounds.width = 48;
	occupantBounds.height = 14;
	
	occupantScoreBounds.xcoord = 71;
	occupantScoreBounds.ycoord = 136;
	occupantScoreBounds.width = 24;
	occupantScoreBounds.height = 14;

	bounds.xcoord = 13;
	bounds.ycoord = 136;

	scoreBounds.xcoord = 71;
	scoreBounds.ycoord = 136;

	if (row != 1 && row < 7)
	{
		occupantBounds.ycoord = occupantBounds.ycoord - 16 * (row - 1);
		occupantScoreBounds.ycoord = occupantScoreBounds.ycoord - 16 * (row - 1); 
	}

	for (x = 0; x < 4; x++)
	{
		bounds.xcoord = 13 + (12 * x);
		bounds.ycoord = 136 - 16 * (row - 1);
		LcdDrawBox(&bounds, COLOR_BLACK, COLOR_WHITE, DRAW_NOT_FILL);	
	}
	for (x = 0; x < 2; x++)
	{
		for (y = 0; y < 2; y++)
		{
			scoreBounds.xcoord = 71 + (12 * x);
			scoreBounds.ycoord = 136 + (7 * y) - 16 * (row - 1);
			LcdDrawBox(&scoreBounds, COLOR_BLACK, COLOR_WHITE, DRAW_NOT_FILL);	
		}
	}
}

int random()
{

#ifdef PC_SIM
	return rand();
#endif
#ifdef PR31700
        RTM seed;
        static ss = 0;
	RtcGetTime(&seed);
        if ( (ss += seed.hour + seed.sec + seed.msec * 1.5 + 1) > 1000)
              ss -= 1000;
        return ss;
#endif
}

void newGame()
{
	BYTE x;
	BYTE y;

	for (x = 0; x < 4; x++)
	{
		occupant[x] = 0;
	}
	for (x = 0; x < 2; x++)
	{
		for (y = 0; y < 2; y++)
		{
			scoreOccupant[x][y] = 0;
		}
	}

	for (x = 0; x < 4; x++)
	{
#ifdef PC_SIM
                referenceOccupant[x] = fmod(abs(random ()), 4) + 1;
#else
                referenceOccupant[x] = abs (random ()) % 4 + 1;
#endif
	}

	playing = 1;
	selectedFlag = 1;
	row = 1;
	
	drawSelected((BYTE*)"Color 1");
	LcdDrawBox(&outsideBounds, COLOR_BLACK, COLOR_WHITE, DRAW_NOT_FILL);
	LcdDrawFixedString(&selectedLabelBounds, (BYTE*)("Selected:"), COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 0);
	setOccupantBounds();
}

void drawSelected(BYTE* x)
{
	LcdEraseRegion(&selectedBounds);
	LcdDrawFixedString(&selectedBounds, x, COLOR_GREY1, COLOR_WHITE, SMALL_FONT, FALSE, 1);
}

void gameover()
{
	BYTE x;
	playing = 0;
	LcdDrawFixedString(&gameoverBounds, (BYTE*)("Game Over"), COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 1);
	
	for (x = 0; x < 4; x++)
	{
		bounds.xcoord = 28 + 12 * x ;
		bounds.ycoord = 36;
		LcdDrawBox(&bounds, COLOR_BLACK, COLOR_GREY1, DRAW_NOT_FILL);	
		sprintf((char*)Buffer, "%d", referenceOccupant[x]);
		bounds.xcoord = bounds.xcoord + 4;
		bounds.ycoord = bounds.ycoord + 3;
		LcdDrawFixedString(&bounds, Buffer, COLOR_BLACK, COLOR_GREY1, SMALL_FONT, FALSE, 0);
	}
}

int compare()
{
	BYTE x;
	BYTE y;
	BYTE i = 0;
	BYTE j = 0;
	BYTE black = 0;
        BYTE grey = 0;
        BYTE grey1 = 0;
        BYTE grey2 = 0;
        BYTE grey3 = 0;
        BYTE grey4 = 0;
	BYTE refOne = 0;
	BYTE refTwo = 0;
	BYTE refThree = 0;
	BYTE refFour = 0;
	BYTE one = 0;
	BYTE two = 0;
	BYTE three = 0;
	BYTE four = 0;
	for (x = 0; x < 4; x++)
	{
		if (referenceOccupant[x] == 1)
                        refOne += 1;
		if (referenceOccupant[x] == 2)
                        refTwo += 1;
		if (referenceOccupant[x] == 3)
                        refThree += 1;
		if (referenceOccupant[x] == 4)
                        refFour += 1;
		if (occupant[x] == 1)
                        one += 1;
		if (occupant[x] == 2)
                        two += 1;
		if (occupant[x] == 3)
                        three += 1;
		if (occupant[x] == 4)
                        four += 1;
		if (occupant[x] == referenceOccupant[x])
                        black += 1;
	}
        grey1 = min(refOne, one);
        grey2 = min(refTwo, two);
        grey3 = min(refThree, three);
        grey4 = min(refFour, four);
        grey = grey1 + grey2 + grey3 + grey4 - black;

	if (black == 4)
	{
		for (x = 0; x < 2; x++)
		{
			for (y = 0; y < 2; y++)
			{
				scoreBounds.xcoord = 71 + (12 * x);
				scoreBounds.ycoord = 136 + (7 * y) - 16 * (row - 1);
				LcdDrawBox(&scoreBounds, COLOR_BLACK, COLOR_BLACK, DRAW_NOT_FILL);	
			}
		}
		return 1;
	}
	else
	{
		for (y = 0; y < 2; y++)
		{
			for (x = 0; x < 2; x++)
			{
				if (black > 0)
				{
					scoreBounds.xcoord = 71 + (12 * x);
					scoreBounds.ycoord = 136 + (7 * y) - 16 * (row - 1);
					LcdDrawBox(&scoreBounds, COLOR_BLACK, COLOR_BLACK, DRAW_NOT_FILL);	
                                        black -= 1;
				}
				else if (grey > 0)
				{
					scoreBounds.xcoord = 71 + (12 * x);
					scoreBounds.ycoord = 136 + (7 * y) - 16 * (row - 1);
					LcdDrawBox(&scoreBounds, COLOR_BLACK, COLOR_GREY1, DRAW_NOT_FILL);	
                                        grey -= 1;
				}
			}
		}
		return 0;
	}
	return 0;
}

void processAction(BYTE x)
{
	BYTE i;
	bounds.xcoord = 12 * (x + 1) + 1;
	bounds.ycoord = 136 - 16 * (row - 1);
	LcdDrawBox(&bounds, COLOR_BLACK, COLOR_GREY1, DRAW_NOT_FILL);	
	sprintf((char*)Buffer, "%d", selectedFlag);
	bounds.xcoord = bounds.xcoord + 3;
	bounds.ycoord = bounds.ycoord + 3;
	LcdDrawFixedString(&bounds, Buffer, COLOR_BLACK, COLOR_GREY1, SMALL_FONT, FALSE, 0);
	occupant[x] = selectedFlag;
	if (occupant[0] != 0 && occupant[1] != 0 && occupant[2] != 0 && occupant[3] != 0)
	{
		if (compare())
		{
			gameover();
		}
		else
		{
			if (row < 6)
			{
				row = row + 1;
				setOccupantBounds();
				for (i = 0; i < 4; i++)
					occupant[i] = 0;
			}
			else if (row == 6)
				gameover();
		}
	}
} 

/********************************************************
 * Function:    MasterMindMain
 * Purpose: 	This function is the event handler for the FORM_MASTERMIND
 * Scope:		application/internal
 * Input:		Event		received event
 * Output:		None
 * Return:		TRUE if handled
				FALSE if not handled
 * Comment: 	None
 *********************************************************/
BOOLEAN MasterMindMain (EvtType *Event)
{
	BYTE x;
	BYTE i; 

        switch (Event->eventType)
		{
			// - Event handler for menu.
			case EVT_MENU_SELECT_ITEM:
				if (Event->para1 == 0)
				{
					FormPopupForm (FORM_MASTERMIND_HELP);
					return TRUE;
				}

#ifdef PR31700
			case EVT_INLAY_SELECT:
            if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
            {
				SysGetAppID((BYTE*)("Mainmenu"), &app_id);
                EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
                EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
            }
            break;
#endif

		case PEN_EVENT:
			i = 0;
			if (Event->eventID == PEN_UP)
			{
				if (playing == 0) return TRUE;
				if (Event->para1 >= occupantBounds.xcoord && Event->para2 >= occupantBounds.ycoord && Event->para1 <= occupantBounds.xcoord + occupantBounds.width && Event->para2 <= occupantBounds.ycoord + occupantBounds.height)
				{
					for (x = 0; x < 4; x++)
					{
						if (Event->para1 >= (x * 12) + 13)
							i++;
					}
					processAction(i - 1);
				}
					
			}
			return TRUE;

		case EVT_CONTROL_SELECT:
			if (Event->eventID == BUTTON_NEW)
			{	
				//if (playing) return TRUE;
				newGame();				
				return TRUE;
			}
			if (Event->eventID == BUTTON_COLOR4)
			{
				if (playing == 0)  return TRUE;
				drawSelected((BYTE*)"Color 4");
				selectedFlag = 4;
				return TRUE;
			}
			if (Event->eventID == BUTTON_COLOR3)
			{	
				if (playing == 0) return TRUE;
				selectedFlag = 3;
				drawSelected((BYTE*)"Color 3");
				return TRUE;
			}
			if (Event->eventID == BUTTON_COLOR2)
			{	
				if (playing == 0) return TRUE;
				drawSelected((BYTE*)"Color 2");
				selectedFlag = 2;
				return TRUE;
			}
			if (Event->eventID == BUTTON_COLOR1)
			{	
				if (playing == 0) return TRUE;
				drawSelected((BYTE*)"Color 1");
				selectedFlag = 1;
				return TRUE;
			}
			return TRUE;

                case EVT_FORM_OPEN:
                        FormDrawForm(FORM_MASTERMIND);
			MasterMindInit();
			return TRUE;
		default:
			//TRACE("\n%d %d %d ", Event->eventType , Event->eventID , Event->para1 );
                return FALSE;
	}
}

BOOLEAN MasterMindHelpMain (EvtType *Event)
{
	BYTE ObjectType;
	Field FieldHelp;
        WORD wLineNum;
        WORD wValue;
        WORD wMaxValue;
        WORD wMinValue;
        WORD wPageSize;
        WORD wTotalNumOfLine;

	switch (Event->eventType)
	{
		// - Event handler for controls.
		case EVT_CONTROL_SELECT:	
			// - Exit Button is pressed.
			if (Event->eventID == BUTTON_EXIT)
			{	
				FormPopupForm (FORM_MASTERMIND);
				return TRUE;
			}

		// - Event handler for form open.
		case EVT_FORM_OPEN:
			ScrollbarInitScrollbar ((ObjectID)SCROLLBAR_HELP);
			FieldInitField((ObjectID)FIELD_HELP);
			FieldGetTotalNumOfLines ((ObjectID)FIELD_HELP, &wLineNum);
			ScrollbarSetScrollbar ((ObjectID)SCROLLBAR_HELP, 0,
                                                                   wLineNum - 12, 0, 12, wLineNum);
                        ScrollbarSetScrollbarDrawPagesize((ObjectID)SCROLLBAR_HELP, 12);

			FormDrawForm (FORM_MASTERMIND_HELP);
			
			//TetrisHelpInit ();
			break;

		// - Event handler for scrollbar.
		case EVT_SCROLLBAR_REPEAT:
		case EVT_SCROLLBAR_SELECT:
			ScrollbarGetScrollbar ((ObjectID)SCROLLBAR_HELP,
								   &wValue, &wMaxValue, &wMinValue,
								   &wPageSize, &wTotalNumOfLine);
			ScrollbarSetScrollbar ((ObjectID)SCROLLBAR_HELP, 
								   Event->para2, wMaxValue, wMinValue,
								   wPageSize, wTotalNumOfLine);
			ScrollbarDrawScrollbar ((ObjectID)SCROLLBAR_HELP);

			FieldSetTopLineNum ((ObjectID)FIELD_HELP, wValue);
			FieldDrawField ((ObjectID)FIELD_HELP);
			break;
			
		// - Event handler for all other events.
		default:
			return FALSE;
	}
	return TRUE;
}
