/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   cpuioreg.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Header file of Cpu Io Register
Revision    :   1.1
Note        :   None
===========================================================================
*/

#include "platform.h"

#ifdef PR31700


#ifndef CPU_IO_REGISTER
#define CPU_IO_REGISTER
#define CPU_IOREG_BASE         ((int*)0xb0c00000)  /* Cpu Io register address*/

#define IOREG_MEM_CONFIG_0           0                     /* 0X0   */ 
#define IOREG_MEM_CONFIG_1           1                     /* 0X4   */ 
#define IOREG_MEM_CONFIG_2           2                     /* 0X8   */ 
#define IOREG_MEM_CONFIG_3           3                     /* 0XC   */ 
#define IOREG_MEM_CONFIG_4           4                     /* 0X10  */ 
#define IOREG_MEM_CONFIG_5           5                     /* 0X14  */ 
#define IOREG_MEM_CONFIG_6           6                     /* 0X18  */ 
#define IOREG_MEM_CONFIG_7           7                     /* 0X1C  */ 
#define IOREG_MEM_CONFIG_8           8                     /* 0X20  */ 
#define IOREG_VIDEO_CTRL_1          10                     /* 0X28  */ 
#define IOREG_VIDEO_CTRL_2          11                     /* 0X2C  */ 
#define IOREG_VIDEO_CTRL_3          12                     /* 0X30  */ 
#define IOREG_VIDEO_CTRL_4          13                     /* 0X34  */ 
#define IOREG_VIDEO_CTRL_5          14                     /* 0X38  */ 
#define IOREG_VIDEO_CTRL_6          15                     /* 0X3C  */ 
#define IOREG_VIDEO_CTRL_7          16                     /* 0X40  */ 
#define IOREG_VIDEO_CTRL_8          17                     /* 0X44  */ 
#define IOREG_VIDEO_CTRL_9          18                     /* 0X48  */ 
#define IOREG_VIDEO_CTRL_10         19                     /* 0X4C  */ 
#define IOREG_VIDEO_CTRL_11         20                     /* 0X50  */ 
#define IOREG_VIDEO_CTRL_12         21                     /* 0X54  */ 
#define IOREG_VIDEO_CTRL_13         22                     /* 0X58  */ 
#define IOREG_VIDEO_CTRL_14         23                     /* 0X5C  */ 
#define IOREG_SIB_SIZE              24                     /* 0X60  */ 
#define IOREG_SIB_SND_RX_START      25                     /* 0X64  */ 
#define IOREG_SIB_SND_TX_START      26                     /* 0X68  */ 
#define IOREG_SIB_TEL_RX_START      27                     /* 0X6C  */ 
#define IOREG_SIB_TEL_TX_START      28                     /* 0X70  */ 
#define IOREG_SIB_CTRL              29                     /* 0X74  */ 
#define IOREG_SIB_SND_HLDG          30                     /* 0X78  */ 
#define IOREG_SIB_TEL_HLDG          31                     /* 0X7C  */ 
#define IOREG_SIB_SF0_CTRL          32                     /* 0X80  */ 
#define IOREG_SIB_SF1_CTRL          33                     /* 0X84  */ 
#define IOREG_SIB_SF0_STATUS        34                     /* 0X88  */ 
#define IOREG_SIB_SF1_STATUS        35                     /* 0X8C  */ 
#define IOREG_SIB_DMA_CTRL          36                     /* 0X90  */ 
#define IOREG_IR_CTRL_1             40                     /* 0XA0  */ 
#define IOREG_IR_CTRL_2             41                     /* 0XA4  */ 
#define IOREG_IR_HLDG               42                     /* 0XA8  */ 
#define IOREG_UARTA_CTRL_1          44                     /* 0XB0  */ 
#define IOREG_UARTA_CTRL_2          45                     /* 0XB4  */ 
#define IOREG_UARTA_DMA_CTRL_1      46                     /* 0XB8  */ 
#define IOREG_UARTA_DMA_CTRL_2      47                     /* 0XBC  */ 
#define IOREG_UARTA_DMA_CNT         48                     /* 0XC0  */ 
#define IOREG_UARTA_HLDG            49                     /* 0XC4  */ 
#define IOREG_UARTB_CTRL_1          50                     /* 0XC8  */ 
#define IOREG_UARTB_CTRL_2          51                     /* 0XCC  */ 
#define IOREG_UARTB_DMA_CTRL_1      52                     /* 0XD0  */ 
#define IOREG_UARTB_DMA_CTRL_2      53                     /* 0XD4  */ 
#define IOREG_UARTB_DMA_CNT         54                     /* 0XD8  */ 
#define IOREG_UARTB_HLDG            55                     /* 0XDC  */ 
#define IOREG_MBUS_CTRL_1           56                     /* 0XE0  */ 
#define IOREG_MBUS_CTRL_2           57                     /* 0XE4  */ 
#define IOREG_MBUS_DMA_CTRL_1       58                     /* 0XE8  */ 
#define IOREG_MBUS_DMA_CTRL_2       59                     /* 0XEC  */ 
#define IOREG_MBUS_DMA_COUNT        60                     /* 0XF0  */ 
#define IOREG_MBUS_TX_HLDG          61                     /* 0XF4  */ 
#define IOREG_MBUS_RX_HLDG          62                     /* 0XF8  */ 
#define IOREG_INT_STATUS_1          64                     /* 0X100 */ 
#define IOREG_INT_STATUS_2          65                     /* 0X104 */ 
#define IOREG_INT_STATUS_3          66                     /* 0X108 */ 
#define IOREG_INT_STATUS_4          67                     /* 0X10C */ 
#define IOREG_INT_STATUS_5          68                     /* 0X110 */ 
#define IOREG_INT_STATUS_6          69                     /* 0X114 */ 
#define IOREG_INT_ENABLE_1          70                     /* 0X118 */ 
#define IOREG_INT_ENABLE_2          71                     /* 0X11C */ 
#define IOREG_INT_ENABLE_3          72                     /* 0X120 */ 
#define IOREG_INT_ENABLE_4          73                     /* 0X124 */ 
#define IOREG_INT_ENABLE_5          74                     /* 0X128 */ 
#define IOREG_INT_ENABLE_6          75                     /* 0X12C */ 
#define IOREG_RTC_HIGH              80                     /* 0X140 */ 
#define IOREG_RTC_LOW               81                     /* 0X144 */ 
#define IOREG_ALARM_HIGH            82                     /* 0X148 */ 
#define IOREG_ALARM_LOW             83                     /* 0X14C */ 
#define IOREG_TIMER_CTRL            84                     /* 0X150 */ 
#define IOREG_PERIODIC_TIMER        85                     /* 0X154 */ 
#define IOREG_SPI_CTRL              88                     /* 0X160 */ 
#define IOREG_SPI_HLDG              89                     /* 0X164 */ 
#define IOREG_IO_CTRL               96                     /* 0X180 */ 
#define IOREG_MFIO_DATA_OUT         97                     /* 0X184 */ 
#define IOREG_MFIO_DIRECTN          98                     /* 0X188 */ 
#define IOREG_MFIO_DATA_IN          99                     /* 0X18C */ 
#define IOREG_MFIO_SEL             100                     /* 0X190 */ 
#define IOREG_IO_POWER_DOWN        101                     /* 0X194 */ 
#define IOREG_MFIO_POWER_DOWN      102                     /* 0X198 */ 
#define IOREG_CLK_CTRL             112                     /* 0X1C0 */ 
#define IOREG_POWER_CTRL           113                     /* 0X1C4 */ 
#define IOREG_SIU_TEST             114                     /* 0X1C8 */ 
#define IOREG_CHI_CTRL             118                     /* 0X1D8 */ 
#define IOREG_CHI_PTR_ENABLE       119                     /* 0X1DC */ 
#define IOREG_CHI_RX_PTR_A         120                     /* 0X1E0 */ 
#define IOREG_CHI_RX_PTR_B         121                     /* 0X1E4 */ 
#define IOREG_CHI_TX_PTR_A         122                     /* 0X1E8 */ 
#define IOREG_CHI_TX_PTR_B         123                     /* 0X1EC */ 
#define IOREG_CHI_SIZE             124                     /* 0X1F0 */ 
#define IOREG_CHI_RX_START         125                     /* 0X1F4 */ 
#define IOREG_CHI_TX_START         126                     /* 0X1F8 */ 
#define IOREG_CHI_HLDG             127                     /* 0X1FC */ 



/* define the location of permanent storage when power off */



enum CpuRegSavingStorage {
                                                      //  pMEM_CONFIG_0    ,
                                                      //  pMEM_CONFIG_1    ,
                                                      //  pMEM_CONFIG_2    ,
                                                      //  pMEM_CONFIG_3    ,
                                                      //  pMEM_CONFIG_4    ,
                                                      //  pMEM_CONFIG_5    ,
                                                      //  pMEM_CONFIG_6    ,
                                                      //  pMEM_CONFIG_7    ,
                                                      //  pMEM_CONFIG_8    ,

                                                      //  pVIDEO_CTRL_1    ,
                                                      //  pVIDEO_CTRL_2    ,
                                                      //  pVIDEO_CTRL_3    ,
                                                      //  pVIDEO_CTRL_4    ,
                                                      //  pVIDEO_CTRL_5    ,
                                                      //  pVIDEO_CTRL_6    ,
                                                      //  pVIDEO_CTRL_7    ,
                                                      //  pVIDEO_CTRL_8    ,
                                                      //  pVIDEO_CTRL_9    ,
                                                      //  pVIDEO_CTRL_10   ,
                                                      //  pVIDEO_CTRL_11   ,
                                                      //  pVIDEO_CTRL_12   ,
                                                      //  pVIDEO_CTRL_13   ,
                                                      //  pVIDEO_CTRL_14   ,

                                                      //  pSIB_SIZE        ,
                                                      //  pSIB_SND_RX_START,
                                                      //  pSIB_SND_TX_START,
                                                      //  pSIB_TEL_RX_START,
                                                      //  pSIB_TEL_TX_START,
                                                      //  pSIB_CTRL        ,
                                                      //  pSIB_SND_HLDG
                                                      //  pSIB_TEL_HLDG
                                                      //  pSIB_SF0_CTRL    ,
                                                      //  pSIB_SF1_CTRL    ,
                                                      //  pSIB_SF0_STATUS  ,
                                                      //  pSIB_SF1_STATUS  ,
                                pSIB_DMA_CTRL    ,
                                                      //  pIR_CTRL_1       ,
                                                      //  pIR_CTRL_2       ,
                                                      //  pIR_HLDG         ,
                                pUARTA_CTRL_1    ,
                                                      //  pUARTA_CTRL_2    ,
                                                      //  pUARTA_DMA_CTRL_1,
                                                      //  pUARTA_DMA_CTRL_2,
                                                      //  pUARTA_DMA_CNT   ,
                                                      //  pUARTA_HLDG
                                pINT_ENABLE_1    ,
                                pINT_ENABLE_2    ,
                                pINT_ENABLE_3    ,
                                pINT_ENABLE_4    ,
                                pINT_ENABLE_5    ,
                                pINT_ENABLE_6    ,
                                                      //  pRTC_HIGH        ,
                                                      //  pRTC_LOW         ,
                                                      //  pALARM_HIGH      ,
                                                      //  pALARM_LOW       ,
                                                      //  pTIMER_CTRL      ,
                                                      //  pPERIODIC_TIMER  ,

                                                      //  pSPI_CTRL        ,
                                                      //  pSPI_HLDG        ,
                                pIO_CTRL         ,
                                pMFIO_DATA_OUT   ,
                                pMFIO_DIRECTN    ,
                                pMFIO_SEL        ,
                                pIO_POWER_DOWN   ,
                                pMFIO_POWER_DOWN ,

                                pCLK_CTRL        ,

                                pPOWER_CTRL      ,



/* other variable to be save */

                                pCP0_STATUS_REG  ,

                                MAX_SAVE_LOC        /* no of WORD entry */

                         };


#endif	CPU_IO_REGISTER

#endif  PR31700

