/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   dm_os.h
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for dynamic memory allocation for OS
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#ifndef _DM_OS_H_
#define _DM_OS_H_

#include <stddef.h>
/* use standard C library */
#ifdef PC_SIM
#include <malloc.h>
#define meminit()   void(0)
#define pmalloc(x)  (void *) malloc(x)
#define pcalloc(x,y)  (void *) calloc(x,y)
#define pfree(x)    free(x)
#else
void meminit(void);
void *pmalloc(size_t);
void *pcalloc(size_t, size_t);
void pfree(void *);
#endif
#endif
