/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   eventmgr.h
Author(s)   :   Brian Lee
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for event and event queue
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#ifndef __EVENTMGR_HEADER__
#define __EVENTMGR_HEADER__

#include "include\QTYPE.H"
#include "include\DATATYPE.H"

#define NULL_EVENT 0

/* public function prototype */

void    EvtGetEvent(EvtType *);
void    EvtQueueCreate(EvtQueueType *);
BOOLEAN EvtQueueEmpty(EvtQueueType *);
BOOLEAN EvtQueueFull(EvtQueueType *);
void    EvtAppend(EvtType, EvtQueueType *);
void    EvtAppendEvt(WORD, WORD, WORD, WORD, void *);
void    EvtServe(EvtType *, EvtQueueType *);
void 	EvtAppendEvtReplace(WORD, WORD, WORD, WORD, void *);
void 	EvtAppendEvtReplaceByTypeOnly(WORD, WORD, WORD, WORD, void *);

BOOLEAN EvtAddEventHandler(BOOLEAN (*fct)());
BOOLEAN EvtRemoveEventHandler(BOOLEAN (*fct)());
BOOLEAN EvtHandler(void);
void 	EvtInitHandler(void);

#endif /* __EVENTMGR_HEADER__ */
