/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   init.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for CPU Init Routine for the Download program  
                to download program from UART Port A with Srecord format              
Revision    :   1.1
Note        :   version 2.0
===========================================================================
*/              


/******************************************************************************
#
# You have to define either
#    EL              for little endian
#    EB              for big endian
#
#******************************************************************************/

                          


/* bit definition of MEM cfg reg 0 */

#define BANK1CONF_16SD                  0x000C0000
#define BANK1CONF_8SD                   0x00080000
#define BANK1CONF_32D                   0x00040000
#define BANK1CONF_16D                   0x00000000
#define BANK0CONF_16SD                  0x00030000
#define BANK0CONF_8SD                   0x00020000
#define BANK0CONF_32D                   0x00010000
#define BANK0CONF_16D                   0x00000000

#define ROWSEL1_3                       0x0000C000
#define ROWSEL1_2                       0x00008000
#define ROWSEL1_1                       0x00004000
#define ROWSEL1_0                       0x00000000
#define ROWSEL0_3                       0x00003000
#define ROWSEL0_2                       0x00002000
#define ROWSEL0_1                       0x00001000
#define ROWSEL0_0                       0x00000000

#define COLSEL1_9                       0x00000900
#define COLSEL1_8                       0x00000800
#define COLSEL1_7                       0x00000700
#define COLSEL1_6                       0x00000600
#define COLSEL1_5                       0x00000500
#define COLSEL1_4                       0x00000400
#define COLSEL1_3                       0x00000300
#define COLSEL1_2                       0x00000200
#define COLSEL1_1                       0x00000100
#define COLSEL1_0                       0x00000000
#define COLSEL0_9                       0x00000090
#define COLSEL0_8                       0x00000080
#define COLSEL0_7                       0x00000070
#define COLSEL0_6                       0x00000060
#define COLSEL0_5                       0x00000050
#define COLSEL0_4                       0x00000040
#define COLSEL0_3                       0x00000030
#define COLSEL0_2                       0x00000020
#define COLSEL0_1                       0x00000010
#define COLSEL0_0                       0x00000000



/* bit definition of MEM cfg reg 2 */

#define CS3ACCVAL1_15                   0xF0000000
#define CS3ACCVAL1_14                   0xE0000000
#define CS3ACCVAL1_13                   0xD0000000
#define CS3ACCVAL1_12                   0xC0000000
#define CS3ACCVAL1_11                   0xB0000000
#define CS3ACCVAL1_10                   0xA0000000
#define CS3ACCVAL1_9                    0x90000000
#define CS3ACCVAL1_8                    0x80000000
#define CS3ACCVAL1_7                    0x70000000
#define CS3ACCVAL1_6                    0x60000000
#define CS3ACCVAL1_5                    0x50000000
#define CS3ACCVAL1_4                    0x40000000
#define CS3ACCVAL1_3                    0x30000000
#define CS3ACCVAL1_2                    0x20000000
#define CS3ACCVAL1_1                    0x10000000
#define CS3ACCVAL1_0                    0x00000000

#define CS3ACCVAL2_15                   0x0F000000
#define CS3ACCVAL2_14                   0x0E000000
#define CS3ACCVAL2_13                   0x0D000000
#define CS3ACCVAL2_12                   0x0C000000
#define CS3ACCVAL2_11                   0x0B000000
#define CS3ACCVAL2_10                   0x0A000000
#define CS3ACCVAL2_9                    0x09000000
#define CS3ACCVAL2_8                    0x08000000
#define CS3ACCVAL2_7                    0x07000000
#define CS3ACCVAL2_6                    0x06000000
#define CS3ACCVAL2_5                    0x05000000
#define CS3ACCVAL2_4                    0x04000000
#define CS3ACCVAL2_3                    0x03000000
#define CS3ACCVAL2_2                    0x02000000
#define CS3ACCVAL2_1                    0x01000000
#define CS3ACCVAL2_0                    0x00000000

#define CS2ACCVAL1_15                   0x00F00000
#define CS2ACCVAL1_14                   0x00E00000
#define CS2ACCVAL1_13                   0x00D00000
#define CS2ACCVAL1_12                   0x00C00000
#define CS2ACCVAL1_11                   0x00B00000
#define CS2ACCVAL1_10                   0x00A00000
#define CS2ACCVAL1_9                    0x00900000
#define CS2ACCVAL1_8                    0x00800000
#define CS2ACCVAL1_7                    0x00700000
#define CS2ACCVAL1_6                    0x00600000
#define CS2ACCVAL1_5                    0x00500000
#define CS2ACCVAL1_4                    0x00400000
#define CS2ACCVAL1_3                    0x00300000
#define CS2ACCVAL1_2                    0x00200000
#define CS2ACCVAL1_1                    0x00100000
#define CS2ACCVAL1_0                    0x00000000


#define CS2ACCVAL2_15                   0x000F0000
#define CS2ACCVAL2_14                   0x000E0000
#define CS2ACCVAL2_13                   0x000D0000
#define CS2ACCVAL2_12                   0x000C0000
#define CS2ACCVAL2_11                   0x000B0000
#define CS2ACCVAL2_10                   0x000A0000
#define CS2ACCVAL2_9                    0x00090000
#define CS2ACCVAL2_8                    0x00080000
#define CS2ACCVAL2_7                    0x00070000
#define CS2ACCVAL2_6                    0x00060000
#define CS2ACCVAL2_5                    0x00050000
#define CS2ACCVAL2_4                    0x00040000
#define CS2ACCVAL2_3                    0x00030000
#define CS2ACCVAL2_2                    0x00020000
#define CS2ACCVAL2_1                    0x00010000
#define CS2ACCVAL2_0                    0x00000000

#define CS1ACCVAL1_15                   0x0000F000
#define CS1ACCVAL1_14                   0x0000E000
#define CS1ACCVAL1_13                   0x0000D000
#define CS1ACCVAL1_12                   0x0000C000
#define CS1ACCVAL1_11                   0x0000B000
#define CS1ACCVAL1_10                   0x0000A000
#define CS1ACCVAL1_9                    0x00009000
#define CS1ACCVAL1_8                    0x00008000
#define CS1ACCVAL1_7                    0x00007000
#define CS1ACCVAL1_6                    0x00006000
#define CS1ACCVAL1_5                    0x00005000
#define CS1ACCVAL1_4                    0x00004000
#define CS1ACCVAL1_3                    0x00003000
#define CS1ACCVAL1_2                    0x00002000
#define CS1ACCVAL1_1                    0x00001000
#define CS1ACCVAL1_0                    0x00000000

#define CS1ACCVAL2_15                   0x00000F00
#define CS1ACCVAL2_14                   0x00000E00
#define CS1ACCVAL2_13                   0x00000D00
#define CS1ACCVAL2_12                   0x00000C00
#define CS1ACCVAL2_11                   0x00000B00
#define CS1ACCVAL2_10                   0x00000A00
#define CS1ACCVAL2_9                    0x00000900
#define CS1ACCVAL2_8                    0x00000800
#define CS1ACCVAL2_7                    0x00000700
#define CS1ACCVAL2_6                    0x00000600
#define CS1ACCVAL2_5                    0x00000500
#define CS1ACCVAL2_4                    0x00000400
#define CS1ACCVAL2_3                    0x00000300
#define CS1ACCVAL2_2                    0x00000200
#define CS1ACCVAL2_1                    0x00000100
#define CS1ACCVAL2_0                    0x00000000

#define CS0ACCVAL1_15                   0x000000F0
#define CS0ACCVAL1_14                   0x000000E0
#define CS0ACCVAL1_13                   0x000000D0
#define CS0ACCVAL1_12                   0x000000C0
#define CS0ACCVAL1_11                   0x000000B0
#define CS0ACCVAL1_10                   0x000000A0
#define CS0ACCVAL1_9                    0x00000090
#define CS0ACCVAL1_8                    0x00000080
#define CS0ACCVAL1_7                    0x00000070
#define CS0ACCVAL1_6                    0x00000060
#define CS0ACCVAL1_5                    0x00000050
#define CS0ACCVAL1_4                    0x00000040
#define CS0ACCVAL1_3                    0x00000030
#define CS0ACCVAL1_2                    0x00000020
#define CS0ACCVAL1_1                    0x00000010
#define CS0ACCVAL1_0                    0x00000000

#define CS0ACCVAL2_15                   0x0000000F
#define CS0ACCVAL2_14                   0x0000000E
#define CS0ACCVAL2_13                   0x0000000D
#define CS0ACCVAL2_12                   0x0000000C
#define CS0ACCVAL2_11                   0x0000000B
#define CS0ACCVAL2_10                   0x0000000A
#define CS0ACCVAL2_9                    0x00000009
#define CS0ACCVAL2_8                    0x00000008
#define CS0ACCVAL2_7                    0x00000007
#define CS0ACCVAL2_6                    0x00000006
#define CS0ACCVAL2_5                    0x00000005
#define CS0ACCVAL2_4                    0x00000004
#define CS0ACCVAL2_3                    0x00000003
#define CS0ACCVAL2_2                    0x00000002
#define CS0ACCVAL2_1                    0x00000001
#define CS0ACCVAL2_0                    0x00000000


/* bit definition of MEM cfg reg 3 */

#define CARD2ACCVAL_15                  0xF0000000
#define CARD2ACCVAL_14                  0xE0000000
#define CARD2ACCVAL_13                  0xD0000000
#define CARD2ACCVAL_12                  0xC0000000
#define CARD2ACCVAL_11                  0xB0000000
#define CARD2ACCVAL_10                  0xA0000000
#define CARD2ACCVAL_9                   0x90000000
#define CARD2ACCVAL_8                   0x80000000
#define CARD2ACCVAL_7                   0x70000000
#define CARD2ACCVAL_6                   0x60000000
#define CARD2ACCVAL_5                   0x50000000
#define CARD2ACCVAL_4                   0x40000000
#define CARD2ACCVAL_3                   0x30000000
#define CARD2ACCVAL_2                   0x20000000
#define CARD2ACCVAL_1                   0x10000000
#define CARD2ACCVAL_0                   0x00000000

#define CARD1ACCVAL_15                  0x0F000000
#define CARD1ACCVAL_14                  0x0E000000
#define CARD1ACCVAL_13                  0x0D000000
#define CARD1ACCVAL_12                  0x0C000000
#define CARD1ACCVAL_11                  0x0B000000
#define CARD1ACCVAL_10                  0x0A000000
#define CARD1ACCVAL_9                   0x09000000
#define CARD1ACCVAL_8                   0x08000000
#define CARD1ACCVAL_7                   0x07000000
#define CARD1ACCVAL_6                   0x06000000
#define CARD1ACCVAL_5                   0x05000000
#define CARD1ACCVAL_4                   0x04000000
#define CARD1ACCVAL_3                   0x03000000
#define CARD1ACCVAL_2                   0x02000000
#define CARD1ACCVAL_1                   0x01000000
#define CARD1ACCVAL_0                   0x00000000

#define CARD2IOACCVAL_15                0x00F00000
#define CARD2IOACCVAL_14                0x00E00000
#define CARD2IOACCVAL_13                0x00D00000
#define CARD2IOACCVAL_12                0x00C00000
#define CARD2IOACCVAL_11                0x00B00000
#define CARD2IOACCVAL_10                0x00A00000
#define CARD2IOACCVAL_9                 0x00900000
#define CARD2IOACCVAL_8                 0x00800000
#define CARD2IOACCVAL_7                 0x00700000
#define CARD2IOACCVAL_6                 0x00600000
#define CARD2IOACCVAL_5                 0x00500000
#define CARD2IOACCVAL_4                 0x00400000
#define CARD2IOACCVAL_3                 0x00300000
#define CARD2IOACCVAL_2                 0x00200000
#define CARD2IOACCVAL_1                 0x00100000
#define CARD2IOACCVAL_0                 0x00000000

#define CARD1IOACCVAL_15                0x000F0000
#define CARD1IOACCVAL_14                0x000E0000
#define CARD1IOACCVAL_13                0x000D0000
#define CARD1IOACCVAL_12                0x000C0000
#define CARD1IOACCVAL_11                0x000B0000
#define CARD1IOACCVAL_10                0x000A0000
#define CARD1IOACCVAL_9                 0x00090000
#define CARD1IOACCVAL_8                 0x00080000
#define CARD1IOACCVAL_7                 0x00070000
#define CARD1IOACCVAL_6                 0x00060000
#define CARD1IOACCVAL_5                 0x00050000
#define CARD1IOACCVAL_4                 0x00040000
#define CARD1IOACCVAL_3                 0x00030000
#define CARD1IOACCVAL_2                 0x00020000
#define CARD1IOACCVAL_1                 0x00010000
#define CARD1IOACCVAL_0                 0x00000000



/* bit definition of MEM cfg reg 3 */

#define WATCHTIMEVAL_27_5usec           0x00F00000
#define WATCHTIMEVAL_25_8usec           0x00E00000
#define WATCHTIMEVAL_24_1usec           0x00D00000
#define WATCHTIMEVAL_22_4usec           0x00C00000
#define WATCHTIMEVAL_20_7usec           0x00B00000
#define WATCHTIMEVAL_18_9usec           0x00A00000
#define WATCHTIMEVAL_17_2usec           0x00900000
#define WATCHTIMEVAL_15_5usec           0x00800000
#define WATCHTIMEVAL_13_8usec           0x00700000
#define WATCHTIMEVAL_12_0usec           0x00600000
#define WATCHTIMEVAL_10_3usec           0x00500000
#define WATCHTIMEVAL_8_6usec            0x00400000
#define WATCHTIMEVAL_6_9usec            0x00300000
#define WATCHTIMEVAL_5_2usec            0x00200000
#define WATCHTIMEVAL_3_4usec            0x00100000
#define WATCHTIMEVAL_1_7usec            0x00000000

#define RFSHVAL1_1950usec               0x00003F00
#define RFSHVAL1_1920usec               0x00003E00
#define RFSHVAL1_1890usec               0x00003D00
#define RFSHVAL1_1860usec               0x00003C00
#define RFSHVAL1_1830usec               0x00003B00
#define RFSHVAL1_1800usec               0x00003A00
#define RFSHVAL1_1770usec               0x00003900
#define RFSHVAL1_1730usec               0x00003800
#define RFSHVAL1_1700usec               0x00003700
#define RFSHVAL1_1670usec               0x00003600
#define RFSHVAL1_1640usec               0x00003500
#define RFSHVAL1_1610usec               0x00003400
#define RFSHVAL1_1580usec               0x00003300
#define RFSHVAL1_1550usec               0x00003200
#define RFSHVAL1_1520usec               0x00003100
#define RFSHVAL1_1490usec               0x00003000
#define RFSHVAL1_1460usec               0x00002F00
#define RFSHVAL1_1430usec               0x00002E00
#define RFSHVAL1_1400usec               0x00002D00
#define RFSHVAL1_1370usec               0x00002C00
#define RFSHVAL1_1340usec               0x00002B00
#define RFSHVAL1_1310usec               0x00002A00
#define RFSHVAL1_1280usec               0x00002900
#define RFSHVAL1_1250usec               0x00002800
#define RFSHVAL1_1220usec               0x00002700
#define RFSHVAL1_1190usec               0x00002600
#define RFSHVAL1_1150usec               0x00002500
#define RFSHVAL1_1120usec               0x00002400
#define RFSHVAL1_1090usec               0x00002300
#define RFSHVAL1_1060usec               0x00002200
#define RFSHVAL1_1030usec               0x00002100
#define RFSHVAL1_1000usec               0x00002000
#define RFSHVAL1_970usec                0x00001F00
#define RFSHVAL1_940usec                0x00001E00
#define RFSHVAL1_910usec                0x00001D00
#define RFSHVAL1_880usec                0x00001C00
#define RFSHVAL1_850usec                0x00001B00
#define RFSHVAL1_820usec                0x00001A00
#define RFSHVAL1_790usec                0x00001900
#define RFSHVAL1_760usec                0x00001800
#define RFSHVAL1_730usec                0x00001700
#define RFSHVAL1_700usec                0x00001600
#define RFSHVAL1_670usec                0x00001500
#define RFSHVAL1_640usec                0x00001400
#define RFSHVAL1_610usec                0x00001300
#define RFSHVAL1_570usec                0x00001200
#define RFSHVAL1_540usec                0x00001100
#define RFSHVAL1_510usec                0x00001000
#define RFSHVAL1_480usec                0x00000F00
#define RFSHVAL1_450usec                0x00000E00
#define RFSHVAL1_420usec                0x00000D00
#define RFSHVAL1_390usec                0x00000C00
#define RFSHVAL1_360usec                0x00000B00
#define RFSHVAL1_330usec                0x00000A00
#define RFSHVAL1_300usec                0x00000900
#define RFSHVAL1_270usec                0x00000800
#define RFSHVAL1_240usec                0x00000700
#define RFSHVAL1_210usec                0x00000600
#define RFSHVAL1_180usec                0x00000500
#define RFSHVAL1_150usec                0x00000400
#define RFSHVAL1_120usec                0x00000300
#define RFSHVAL1_90usec                 0x00000200
#define RFSHVAL1_60usec                 0x00000100
#define RFSHVAL1_15usec                 0x00000000

#define RFSHVAL0_1950usec               0x0000003F
#define RFSHVAL0_1920usec               0x0000003E
#define RFSHVAL0_1890usec               0x0000003D
#define RFSHVAL0_1860usec               0x0000003C
#define RFSHVAL0_1830usec               0x0000003B
#define RFSHVAL0_1800usec               0x0000003A
#define RFSHVAL0_1770usec               0x00000039
#define RFSHVAL0_1730usec               0x00000038
#define RFSHVAL0_1700usec               0x00000037
#define RFSHVAL0_1670usec               0x00000036
#define RFSHVAL0_1640usec               0x00000035
#define RFSHVAL0_1610usec               0x00000034
#define RFSHVAL0_1580usec               0x00000033
#define RFSHVAL0_1550usec               0x00000032
#define RFSHVAL0_1520usec               0x00000031
#define RFSHVAL0_1490usec               0x00000030
#define RFSHVAL0_1460usec               0x0000002F
#define RFSHVAL0_1430usec               0x0000002E
#define RFSHVAL0_1400usec               0x0000002D
#define RFSHVAL0_1370usec               0x0000002C
#define RFSHVAL0_1340usec               0x0000002B
#define RFSHVAL0_1310usec               0x0000002A
#define RFSHVAL0_1280usec               0x00000029
#define RFSHVAL0_1250usec               0x00000028
#define RFSHVAL0_1220usec               0x00000027
#define RFSHVAL0_1190usec               0x00000026
#define RFSHVAL0_1150usec               0x00000025
#define RFSHVAL0_1120usec               0x00000024
#define RFSHVAL0_1090usec               0x00000023
#define RFSHVAL0_1060usec               0x00000022
#define RFSHVAL0_1030usec               0x00000021
#define RFSHVAL0_1000usec               0x00000020
#define RFSHVAL0_970usec                0x0000001F
#define RFSHVAL0_940usec                0x0000001E
#define RFSHVAL0_910usec                0x0000001D
#define RFSHVAL0_880usec                0x0000001C
#define RFSHVAL0_850usec                0x0000001B
#define RFSHVAL0_820usec                0x0000001A
#define RFSHVAL0_790usec                0x00000019
#define RFSHVAL0_760usec                0x00000018
#define RFSHVAL0_730usec                0x00000017
#define RFSHVAL0_700usec                0x00000016
#define RFSHVAL0_670usec                0x00000015
#define RFSHVAL0_640usec                0x00000014
#define RFSHVAL0_610usec                0x00000013
#define RFSHVAL0_570usec                0x00000012
#define RFSHVAL0_540usec                0x00000011
#define RFSHVAL0_510usec                0x00000010
#define RFSHVAL0_480usec                0x0000000F
#define RFSHVAL0_450usec                0x0000000E
#define RFSHVAL0_420usec                0x0000000D
#define RFSHVAL0_390usec                0x0000000C
#define RFSHVAL0_360usec                0x0000000B
#define RFSHVAL0_330usec                0x0000000A
#define RFSHVAL0_300usec                0x00000009
#define RFSHVAL0_270usec                0x00000008
#define RFSHVAL0_240usec                0x00000007
#define RFSHVAL0_210usec                0x00000006
#define RFSHVAL0_180usec                0x00000005
#define RFSHVAL0_150usec                0x00000004
#define RFSHVAL0_120usec                0x00000003
#define RFSHVAL0_90usec                 0x00000002
#define RFSHVAL0_60usec                 0x00000001
#define RFSHVAL0_15usec                 0x00000000

