/*  Timer.h             */

#include "include\datatype.h"

#ifndef _TIMER_H_
#define _TIMER_H_

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

typedef struct
{
	UWORD h;
	UWORD l;
} CLONG;

typedef struct                      /* rtm structure */
{
	SHORT hsec;
	SHORT sec;
	SHORT min;
	SHORT hour;
	SHORT mday;
	SHORT mon;
	SHORT year;
	SHORT wday;
	SHORT yday;
	BOOLEAN isdst;
} RTM;

extern RTM ALARM_TIME;           /* record the alarm time in HW timer */
extern BOOLEAN ALARM_STATUS;		/* alarm status  */

RTM RtcGetTime();
void RtcSetTime(RTM);
void RtcSetDst(BOOLEAN);
CLONG RtcDiffTime(RTM, RTM);
RTM AlmGetTime(void);
void AlmSetTime(RTM);
void AlmSetStatus(BOOLEAN);
UWORD TmrIntEnable(UWORD, void*);
void TmrIntDisable(UWORD);
#endif
