/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   el.h
Author(s)   :   Garick Ngai
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for EL module
Revision    :   1.1
Note        :   None
===========================================================================
*/              

#ifndef _ONEL_
#define _ONEL_

#include "include\datatype.h"
#include "include\ioconmsg.h"
#include "include\iocon.h"
#include "include\QTYPE.H"
#include "include\print.h"
#include "include\uart.h"
#include "include\pr31700s.h"
#include "include\pr31700c.h"

extern UWORD are_el_on;


    /* Command For Accessory */
#define Time_On_EL      60000

    /* I/O Control */
#define EL_PIN          0x00000200
#define ON_EL_PIN       0x00000200
#define DIS_EL_PIN      0xfffffdff
#define OFF_EL_PIN      0xfffffdff


void ELInit();
void EnELTimerInt();
void DisELTimerInt();
void ELCtrl();
void OffEL();
void OnEL();
void ResetELWhenOn();
void ELState(UWORD *elstate);
void CheckEL();

#endif  /* _ONEL_ */


