#include "stdafx.h"
#include "resource.h"
#include "include\kernel.h"
#include "include\resmgr.h"
#include "include\app.h"
#include "include\appfunc.h"
#include "include\ui.h"
#include "include\uifunc.h"
#include "include\inlay.h"
#include "include\system.h"
#include "include\alarmgr.h"


/* ==================================================================== */
/* ========================= Function Prototypes ====================== */
/* ==================================================================== */

BOOLEAN (*FormDispatchEvent)(EvtType *Event);

void EventLoop();
extern UBYTE res_data[];
void MMUInit();
void KernelInit();
void ResInit();
void AlarmAppInit();
void AlarmAppClassifyHit();
void AlarmAppShowList();
void AlarmCreateVirTable();
static BOOLEAN ApplicationHandleEvent(EvtType *Event);
AppID app_id;
extern UWORD *sys_page, *app_page;
extern REGISTRY app_reg[];
extern UBYTE resdata[8903];

UBYTE sysres_data[1];

/* ==================================================================== */
/* ========================= Global Defines =========================== */
/* ==================================================================== */

/* ==================================================================== */
/* ========================= Global Variables ========================= */
/* ==================================================================== */




/********************************************************
 * Function:	ApplicationHandleEvent
 * Purpose: 	This function is used to load the specific data of
				form and set event handler of the form
 * Scope:		application/internal
 * Input:		Event		received event
 * Output:		None
 * Return:		TRUE if handled
				FALSE if not handled
 * Comment: 	None
 *********************************************************/
static BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
	Form *form_ptr;
	ObjectID form_id;
	BYTE object_type;
	Err Error;

	if (Event->eventType == EVT_FORM_LOAD)
	{
	  form_id = (ObjectID)Event->eventID;
	  Error = UISearchForAddress(form_id,&object_type,(void**)&form_ptr);
	  if (Event->para1 == 1 || Error != TRUE)
	  {
		FormInitForm(form_id);
	  }
	  if (!UISearchForAddress(form_id,&object_type,(void**)&form_ptr)) return FALSE;
	  switch (form_id)
      {
                        case FORM_MASTERMIND: FormSetEventHandler(FORM_MASTERMIND, (void**)&FormDispatchEvent, (void*) MasterMindMain);
				   break;
                        case FORM_MASTERMIND_HELP: FormSetEventHandler(FORM_MASTERMIND_HELP, (void**)&FormDispatchEvent, (void*) MasterMindHelpMain);
				   break;

	  }
	  FormSetActiveForm(form_id);
	  return TRUE;
	}
	return FALSE;
}

/********************************************************
 * Function:	EventLoop
 * Purpose: 	This function is a loop to get events from event
				manager and then passes the event to different
				event handler
 * Scope:		application
 * Input:		None
 * Output:		None
 * Return:		None
 * Comment: 	None
 *********************************************************/
void EventLoop(void)
{
	EvtType event;
	do
	{
		EvtGetEvent (&event);
		if (!SystemHandleEvent(&event))
			if (!MenuHandleEvent(&event))
				if (!ApplicationHandleEvent(&event))
					FormDispatchEvent(&event);

	}
	#ifdef PC_SIM
	while (event.eventType != EVT_APP_STOP && m_bIsExit == FALSE);
	#else
	while (event.eventType != EVT_APP_STOP);
	#endif
}
/********************************************************
 * Function:	main
 * Purpose: 	main procedure of the application
 * Scope:		Application
 * Input:		None
 * Output:		None
 * Return:		None
 * Comment: 	None
 *********************************************************/
__main(WORD cmd, void* cmd_ptr)
{
    InlaySetEnableStatus(FALSE);
    SystemSetMappedHardwareKeyStatus(FALSE);
    BatteryWarningSetEnableStatus(FALSE);

    MasterMindAppLaunch(cmd, cmd_ptr);

    InlaySetEnableStatus(TRUE);
    AlarmMgrEnable(TRUE);
    SystemSetMappedHardwareKeyStatus(TRUE);
    BatteryWarningSetEnableStatus(TRUE);    
}
