#include "stdafx.h"
#include "include\App.h"
#include "include\alarmgr.h"

#ifdef PC_SIM
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#endif 

BYTE Buffer[5];
BYTE tag = 0;
BYTE playing = 0;
BYTE bomb = 0;
UWORD timerValue = 0;
UWORD highestScore = 9999;
UWORD timeElapsed = 0;

#ifdef PC_SIM
BYTE moveTime = 10;
#endif
#ifdef PR31700
UWORD moveTime = 1000;
#endif

DatabaseID MineSweeperdbID;
BYTE* ptr;
UWORD numByteRead;
AppID app_id;


BYTE occupant[MINESWEEPER_WIDTH][MINESWEEPER_HEIGHT];
BYTE occupantTag[MINESWEEPER_WIDTH][MINESWEEPER_HEIGHT];

ObjectBounds outsideBounds;
ObjectBounds timeBounds;
ObjectBounds timeLabelBounds;
ObjectBounds bombBounds;
ObjectBounds bombLabelBounds;
ObjectBounds bounds;
ObjectBounds gameoverBounds;
ObjectBounds highestScoreBounds;
ObjectBounds highestScoreLabelBounds;

/********************************************************
 * Function:    MineSweeperInit
 * Purpose:     MineSweeper application initialise
 * Scope:		internal
 * Input:		
 * Output:		
 * Return:		
 * Comment: 	None
 *********************************************************/
void MineSweeperInit()
{
	BYTE x;
	BYTE y;

	bounds.xcoord = 0;
	bounds.ycoord = 0;
	bounds.width = MINESWEEPER_X;
	bounds.height = MINESWEEPER_Y;
	
	outsideBounds.xcoord = 8;
	outsideBounds.ycoord = 24;
    outsideBounds.width  = 94;
	outsideBounds.height = 130;

    timeBounds.xcoord = 110;
	timeBounds.ycoord = 34;
    timeBounds.width  = 40;
	timeBounds.height = 20;

    timeLabelBounds.xcoord = 110;
	timeLabelBounds.ycoord = 24;
    timeLabelBounds.width  = 40;
	timeLabelBounds.height = 20;

    bombLabelBounds.xcoord = 110;
	bombLabelBounds.ycoord = 54;
	bombLabelBounds.width  = 40;
	bombLabelBounds.height = 20;

    bombBounds.xcoord = 110;
	bombBounds.ycoord = 64;
	bombBounds.width  = 40;
    bombBounds.height = 20;

	gameoverBounds.xcoord = 30;
	gameoverBounds.ycoord = 75;
	gameoverBounds.width  = 60;
	gameoverBounds.height = 20;

	highestScoreBounds.xcoord = 70;
	highestScoreBounds.ycoord = 95;
	highestScoreBounds.width  = 40;
	highestScoreBounds.height = 20;

	highestScoreLabelBounds.xcoord = 15;
	highestScoreLabelBounds.ycoord = 95;
	highestScoreLabelBounds.width  = 60;
	highestScoreLabelBounds.height = 20;

	tag = 0;
	playing = 0;
	bomb = 0;
	timerValue = 0;
	highestScore = 9999;

#ifdef PC_SIM
	moveTime = 10;
#endif
#ifdef PR31700
	moveTime = 1000;
#endif

	timeElapsed = 0;

	if (DataFindDB((BYTE*)"MineSweeperDB", &MineSweeperdbID) == TRUE)
	{
	    DataOpenDB(MineSweeperdbID,0,OPEN_RW);
                DataGetField(MineSweeperdbID, 0x80001001, 1, &ptr, &numByteRead);
		highestScore = *(UWORD*)ptr;
		qfree(ptr);
	}

	for (x = 0; x < MINESWEEPER_WIDTH; x++)
	{
		for (y = 0; y < MINESWEEPER_HEIGHT; y++)
		{
			occupant[x][y] = -1 ;
			occupantTag[x][y] = -1;
		}
	}
	for (x = 1; x < MINESWEEPER_WIDTH - 1; x++)
	{
		for (y = 1; y < MINESWEEPER_HEIGHT - 1; y++)
		{
			occupant[x][y] = 0;
			occupantTag[x][y] = 0;
		}
	}
	MineSweeperRepaint();
}			

void gameover()
{
	//LcdDrawBox(&outsideBounds, COLOR_BLACK, COLOR_WHITE, DRAW_NOT_FILL);	
	playing = 0;
        
	//MineSweeperRepaint();
	LcdDrawFixedString(&gameoverBounds, (BYTE*)("You Won!"), COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 1);
	LcdDrawFixedString(&highestScoreLabelBounds, (BYTE*)("Fastest time:"), COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 1);
	if (timeElapsed < highestScore)
                highestScore = timeElapsed;
        
	sprintf((char*)Buffer, "%d", highestScore);
	
	LcdDrawFixedString(&highestScoreBounds, Buffer, COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 1);
        timeElapsed = 0;
        TmrIntDisable(timerValue);
}


void gameover1()
{
	//LcdDrawBox(&outsideBounds, COLOR_BLACK, COLOR_WHITE, DRAW_NOT_FILL);	
	playing = 0;
        
	//MineSweeperRepaint();
	LcdDrawFixedString(&gameoverBounds, (BYTE*)("You Lost!"), COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 1);
	LcdDrawFixedString(&highestScoreLabelBounds, (BYTE*)("Fastest time:"), COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 1);
        
	sprintf((char*)Buffer, "%d", highestScore);
	
	LcdDrawFixedString(&highestScoreBounds, Buffer, COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 1);
        timeElapsed = 0;
        TmrIntDisable(timerValue);
}



BYTE processAction(BYTE x, BYTE y)
{
	BYTE count = 0;
	BYTE x1;
	BYTE y1;
	BYTE flag = 0;
	if (tag == 0)
	{
		if (x < 1 || x > 10 || y < 1 || y > 13 || occupantTag[x][y] == 4)
		{
		}
		else
		{
			if (occupant[x][y] == 1) 
			{
				gameover1();
				return 1;
			}
			else
			{	
				occupant[x][y] = 2;
				bounds.xcoord = (x * MINESWEEPER_X);
				bounds.ycoord = (y * MINESWEEPER_Y) + 19;
				LcdDrawBox(&bounds, COLOR_GREY1, COLOR_WHITE, DRAW_FILL);
			}
			for (x1 = x - 1; x1 < x + 2; x1++)
			{
				for (y1 = y - 1; y1 < y + 2; y1++)
				{
					if (occupant[x1][y1] == 1)
					{
						count = count + 1;
					}
				}
			}	
			if (count != 0)
			{
				sprintf((char*)Buffer, "%d", count);
				bounds.xcoord = bounds.xcoord + 2;
				LcdDrawFixedString(&bounds, Buffer, COLOR_BLACK, COLOR_GREY1, SMALL_FONT, FALSE, 0);
				flag = 0;
				for (x1 = 1; x1 < MINESWEEPER_WIDTH - 1; x1++)
				{
					for (y1 = 1; y1 < MINESWEEPER_HEIGHT - 1; y1++)
					{
						if (occupant[x1][y1] == 0)
						flag = 1;
					}
				}
				if (bomb == 0 && flag == 0)
					gameover();
				return 1;
			}	
			else
			{
				for (x1 = x - 1; x1 < x + 2; x1++)
				{
					for (y1 = y - 1; y1 < y + 2; y1++)
					{
						if (occupant[x1][y1] == 0)
						{
							occupant[x1][y1] = 3;
						}
					}
				}		
			}
			process();
			flag = 0;
			for (x1 = 1; x1 < MINESWEEPER_WIDTH - 1; x1++)
			{
				for (y1 = 1; y1 < MINESWEEPER_HEIGHT - 1; y1++)
				{
					if (occupant[x1][y1] == 0)
					flag = 1;
				}
			}
			if (bomb == 0 && flag == 0)
				gameover();

			return 1;
		}
		return 0;
	}
	else
	{
		if (occupant[x][y] == 2) return 0;

		if (occupantTag[x][y] == 4)
		{
			occupantTag[x][y] = 0;
			bomb = bomb + 1;
			sprintf((char*)Buffer, "%d", bomb);
			bounds.xcoord = (x * MINESWEEPER_X);
			bounds.ycoord = (y * MINESWEEPER_Y) + 19;

			LcdEraseRegion(&bombBounds);
			LcdDrawFixedString(&bombBounds, Buffer, COLOR_GREY1, COLOR_WHITE, SMALL_FONT, FALSE, 1);

			LcdDrawBox(&bounds, COLOR_BLACK, COLOR_WHITE, DRAW_NOT_FILL);
			if (occupant[x][y] == 2)
				LcdDrawBox(&bounds, COLOR_GREY1, COLOR_WHITE, DRAW_FILL);
			return 1;
		}
		else
		{
			occupantTag[x][y] = 4;
			bounds.xcoord = (x * MINESWEEPER_X);
			bounds.ycoord = (y * MINESWEEPER_Y) + 19;
			if (bomb == 0) return 0;
			LcdDrawBox(&bounds, COLOR_GREY2, COLOR_WHITE, DRAW_FILL);
			bomb = bomb - 1;
			flag = 0;
			for (x1 = 1; x1 < MINESWEEPER_WIDTH - 1; x1++)
			{
				for (y1 = 1; y1 < MINESWEEPER_HEIGHT - 1; y1++)
				{
					if (occupant[x1][y1] == 0)
					flag = 1;
				}
			}
                        if (bomb == 0 && flag == 0)
				gameover();
			sprintf((char*)Buffer, "%d", bomb);
			LcdEraseRegion(&bombBounds);
			LcdDrawFixedString(&bombBounds, Buffer, COLOR_GREY1, COLOR_WHITE, SMALL_FONT, FALSE, 1);
			return 1;
		}
	}
	return 0;
}	

void process()
{
	BYTE x;
	BYTE y;
	BYTE count = 0;
	for (x = 1; x < MINESWEEPER_WIDTH - 1; x++)
	{
		for (y = 1; y < MINESWEEPER_HEIGHT - 1 ; y++)
		{
			if (occupant[x][y] == 3)
			{
				processAction(x, y);
			}
		}
	}
}

void timer()
{
	timeElapsed = timeElapsed + 1;
	sprintf((char*)Buffer, "%d", timeElapsed);
	LcdEraseRegion(&timeBounds);
	LcdDrawFixedString(&timeBounds, Buffer, COLOR_GREY1, COLOR_WHITE, SMALL_FONT, FALSE, 1);
}

void newGame()
{
	BYTE x;
	BYTE y;
	BYTE count = 0;
	BYTE randomx = 0;
	BYTE randomy = 0;
	ControlSetLabel(BUTTON_TAG, (BYTE*)("Tag"));
	ControlDrawControl(BUTTON_TAG);
	tag = 0;
	playing = 1;
	bomb = 15;
	TmrIntDisable(timerValue);
	timeElapsed = 0;

#ifdef PC_SIM
	srand( (unsigned)time( NULL ) );
#endif

	timerValue = TmrIntEnable(moveTime, timer);
	//LcdDrawBox(&outsideBounds, COLOR_BLACK, COLOR_WHITE, DRAW_NOT_FILL);
	LcdDrawFixedString(&timeLabelBounds, (BYTE*)("Time(Sec):"), COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 1);
	LcdDrawFixedString(&bombLabelBounds, (BYTE*)("Bomb:"), COLOR_BLACK, COLOR_WHITE, SMALL_FONT, FALSE, 1);
	sprintf((char*)Buffer, "%d", bomb);
	LcdEraseRegion(&bombBounds);
	LcdDrawFixedString(&bombBounds, Buffer, COLOR_GREY1, COLOR_WHITE, SMALL_FONT, FALSE, 1);
	
	for (x = 1; x <= MINESWEEPER_WIDTH - 1; x++)
	{
		for (y = 1; y <= MINESWEEPER_HEIGHT - 1; y++)
		{
			occupant[x][y] = 0;
			occupantTag[x][y] = 0;
		}
	}
	do
	{
#ifdef PC_SIM
		randomx = fmod(abs(random()), MINESWEEPER_WIDTH - 2) + 1;
		randomy = fmod(abs(random()), MINESWEEPER_HEIGHT - 2) + 1;
#else
                randomx = abs(random()) % (MINESWEEPER_WIDTH - 2) + 1;
                randomy = abs(random()) % (MINESWEEPER_HEIGHT - 2) + 1;
#endif
		if (occupant[randomx][randomy] == 0)
		{
			occupant[randomx][randomy] = 1;
			count = count + 1;
		}
	} while (count <= 14);
	
	
	for (x = 1; x < MINESWEEPER_WIDTH - 1; x++)
	{
		for (y = 1; y < MINESWEEPER_HEIGHT - 1; y++)
		{
			bounds.xcoord = (x * MINESWEEPER_X);
			bounds.ycoord = (y * MINESWEEPER_Y) + 19;
			LcdDrawBox(&bounds, COLOR_BLACK, COLOR_WHITE, DRAW_NOT_FILL);
			//if (occupant[x][y])
			//	LcdDrawBox(&bounds, COLOR_BLACK, COLOR_BLACK, DRAW_FILL);
		}
	}
}

void MineSweeperRepaint()
{
	BYTE x;
	BYTE y;
	for (x = 1; x < MINESWEEPER_WIDTH - 1; x++)
	{
		for (y = 1; y < MINESWEEPER_HEIGHT - 1; y++)
		{
			bounds.xcoord = (x * MINESWEEPER_X);
			bounds.ycoord = (y * MINESWEEPER_Y) + 19;
			LcdDrawBox(&bounds, COLOR_WHITE, COLOR_WHITE, DRAW_FILL);
		}
	}
}

int random()
{

#ifdef PC_SIM
	return rand();
#endif
#ifdef PR31700
        RTM seed;
        static ss = 0;
		RtcGetTime(&seed);
        if ( (ss += seed.hour + seed.sec + seed.msec * 1.5 + 1) > 1000)
              ss -= 1000;
        return ss;
#endif
}

/********************************************************
 * Function:    MineSweeperMain
 * Purpose: 	This function is the event handler for the FORM_MINESWEEPER
 * Scope:		application/internal
 * Input:		Event		received event
 * Output:		None
 * Return:		TRUE if handled
				FALSE if not handled
 * Comment: 	None
 *********************************************************/
BOOLEAN MineSweeperMain(EvtType *Event)
{
	BYTE x;
	BYTE y;
	BYTE i;
	BYTE j;
	switch(Event->eventType)
	{
/*		// - Event handler for menu.
		case EVT_MENU_SELECT:
			if (Playing == 1)
			{
				PauseGame ();
				nMenu = 1;
			}
			return TRUE;*/

		// - Event handler for menu.
		case EVT_MENU_SELECT_ITEM:
			

			if (Event->para1 == 0)
			{
				gameover ();
				FormPopupForm (FORM_MINESWEEPER_HELP);
				return TRUE;
			}

                        break;

               case EVT_INLAY_SELECT:
            if (Event->para1 == INLAY_OK || Event->para1 == INLAY_EXIT)
            {
				SysGetAppID((BYTE*)("Mainmenu"), &app_id);
                EvtAppendEvt(EVT_APP_STOP, 0, 0, 0, NULL);
                EvtAppendEvt(EVT_APP_LAUNCH, app_id, 0, 0, NULL);
            }
            break;

		case PEN_EVENT:
			if (Event->eventID == PEN_UP)
			{
				if (playing == 0) return TRUE;
				if (Event->para1 >= 10 && Event->para1 <= 100 && Event->para2 >= 29 && Event->para2 <= 149)
				{	
					i = 0;
					j = 0;
					for (x = 1; x < MINESWEEPER_WIDTH - 1; x++)
					{
						if (Event->para1 >= (x * MINESWEEPER_X)) 
							i++;
					}
					for (y = 1; y < MINESWEEPER_HEIGHT - 1; y++)
					{
						if (Event->para2 >= (y * MINESWEEPER_Y) + 19)
							j++;
					}
					processAction(i, j);
				}
				return TRUE;
			}
			return TRUE;
		case EVT_CONTROL_SELECT:
			if (Event->eventID == BUTTON_NEW)
			{	
				//if (playing) return TRUE;
				newGame();
				return TRUE;
			}
			if (Event->eventID == BUTTON_TAG)
			{	
				if (tag == 0)
				{
					ControlSetLabel(BUTTON_TAG, (BYTE*)("Untag"));
					ControlDrawControl(BUTTON_TAG);
					tag = 1;
				}
				else 
				{
					ControlSetLabel(BUTTON_TAG, (BYTE*)("Tag"));
					ControlDrawControl(BUTTON_TAG);
					tag = 0;
				}
				return TRUE;
			}
			return TRUE;
			
		case EVT_FORM_OPEN:
                        FormDrawForm(FORM_MINESWEEPER);
			MineSweeperInit();
			return TRUE;
		default:
                        //TRACE("\n%d %d %d ", Event->eventType , Event->eventID , Event->para1 );
			return FALSE;
	}
}

BOOLEAN MineSweeperHelpMain(EvtType *Event)
{
	BYTE ObjectType;
	Field FieldHelp;
	WORD wValue;
	WORD wMaxValue;
	WORD wMinValue;
	WORD wPageSize;
	WORD wTotalNumOfLine;
	WORD wLineNum;
        BYTE* szText;

	switch (Event->eventType)
	{
		// - Event handler for controls.
		case EVT_CONTROL_SELECT:	
			// - Exit Button is pressed.
			if (Event->eventID == BUTTON_EXIT)
			{	
				FormPopupForm (FORM_MINESWEEPER);
				return TRUE;
			}

		// - Event handler for form open.
		case EVT_FORM_OPEN:
			ScrollbarInitScrollbar ((ObjectID)SCROLLBAR_HELP);
			FieldInitField((ObjectID)FIELD_HELP);

			FieldGetTotalNumOfLines ((ObjectID)FIELD_HELP, &wLineNum);
			ScrollbarSetScrollbar ((ObjectID)SCROLLBAR_HELP, 0,
                                                                   wLineNum - 12, 0, 12, wLineNum);
                        ScrollbarSetScrollbarDrawPagesize((ObjectID)SCROLLBAR_HELP, 12);

                        szText = (BYTE*)qmalloc (1000 * sizeof (BYTE));
			strcpy (szText, "MineSweeper is a game of analytical strategy and deductive reasoning. The screen is in grids with hidden landmines and the objective of the game is to safely uncover all the tiles without setting off any landmines. The information on the right side keeps track of the elapsed time and the number of mines still hidden in the 9 x 12 grid. Use the stylus and tap the tile and click on it to see whether there is a landmine hidden underneath. If the tile turns grey, that means there is no landmine in the immediate vicinity, the eight tiles surrounding the one uncovered. The numbers 1 to 8 on some tiles indicate the number of landmines in the neighbourhood. When a safe tile is uncovered, the other safe tiles in the area will automatically reveal themselves. The tagged/untagged button on the screen allows the player to mark the exact location of the landmine and keep track of the number of mines uncovered. The game ends when a landmine explodes or when the player has successfully avoided all landmines.");
			FieldInsertText ((ObjectID)FIELD_HELP, szText, sizeof (szText));
			qfree (szText);
			FormDrawForm (FORM_MINESWEEPER_HELP);
			
			break;

		// - Event handler for scrollbar.
		case EVT_SCROLLBAR_REPEAT:
		case EVT_SCROLLBAR_SELECT:
			ScrollbarGetScrollbar ((ObjectID)SCROLLBAR_HELP,
								   &wValue, &wMaxValue, &wMinValue,
								   &wPageSize, &wTotalNumOfLine);
			ScrollbarSetScrollbar ((ObjectID)SCROLLBAR_HELP, 
								   Event->para2, wMaxValue, wMinValue,
								   wPageSize, wTotalNumOfLine);
			ScrollbarDrawScrollbar ((ObjectID)SCROLLBAR_HELP);

			FieldSetTopLineNum ((ObjectID)FIELD_HELP, wValue);
			FieldDrawField ((ObjectID)FIELD_HELP);
			break;
			
		// - Event handler for all other events.
		default:
			return FALSE;
	}
	return TRUE;
}
