/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   lcddrv.h
Author(s)   :   Brian Lee, Thomas Cheng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for LCD device driver
Revision    :   1.1
Note        :   None
===========================================================================
*/              
                

#ifndef	_LCDDRV_
#define	_LCDDRV_

#include "include\Font.h"
#include "include\Ui.h"

#define SIZE_OF_BYTE	8
#define SIZE_OF_WORD	32

#define WORD_MASK	0xFFFFFFFF

#define LCD_WIDTH	160
#define	LCD_HEIGHT	160

#define BITS_OF_GREY	4
#define LCD_SIZE  LCD_WIDTH*LCD_HEIGHT/SIZE_OF_WORD*BITS_OF_GREY

#ifdef PR31700
#define LCD_VIDRATE (LCD_WIDTH / 4 - 1) + 31
#endif	/* PR31700 */

#define ChkWithinScreen()	(UWORD)xcoord >= 0 && (UWORD)ycoord >= 0 && (UWORD)xcoord < LCD_WIDTH && (UWORD)ycoord < LCD_HEIGHT
#define CoordToWordPos(xcoord, ycoord)    (UWORD)((UWORD)xcoord + (UWORD)ycoord * LCD_WIDTH) * BITS_OF_GREY / SIZE_OF_WORD

#define EL32(x)	 (((UWORD)x << 24) | (((UWORD)x & 0x0000FF00) << 8) | \
					(((UWORD)x & 0x00FF0000) >> 8) | ((UWORD)x >> 24))

//#define CoordToWordPosR(xcoord, ycoord)     (LCD_HEIGHT - ((UWORD)ycoord + 1) + (UWORD)xcoord * LCD_WIDTH) * BITS_OF_GREY / SIZE_OF_WORD
//#define CoordToBitPos(xcoord)		(LCD_WIDTH - ((UWORD)xcoord + 1) * BITS_OF_GREY) % SIZE_OF_WORD
//#define CoordToBitPosR(xcoord)       ((UWORD)xcoord * BITS_OF_GREY) % SIZE_OF_WORD

extern BYTE rotation;
extern UWORD lcd_mem[LCD_SIZE];

void LcdInit(void);
#ifdef PR31700
void LcdClr(void);
void LcdTurnOn(void);
void LcdTurnOff(void);
#endif	/* PR31700 */
UWORD WordPack(UWORD word1, BYTE word1_shift, UWORD word2, BYTE word2_shift,
	BYTE merge_pt);
UWORD WordHead1Pack(UWORD word1, UWORD word2, BYTE merge_pt);
UWORD WordHead2Pack(UWORD word1, UWORD word2, BYTE merge_pt1, BYTE merge_pt2);
UWORD WordBodyPack(UWORD word1, UWORD word2, BYTE merge_pt);
UWORD WordTail1Pack(UWORD word1, BYTE word1_shift, UWORD word2, BYTE merge_pt);
UWORD WordTail2Pack(UWORD word1, UWORD word2, UWORD word3, BYTE merge_pt1,
	BYTE merge_pt2);
//UWORD WordSwap(UWORD word1);

BYTE PixelRead(SHORT xcoord, SHORT ycoord);
void PixelWrite(SHORT xcoord, SHORT ycoord, BYTE color);
UWORD WordRead(SHORT xcoord, SHORT ycoord);
void WordWrite(SHORT xcoord, SHORT ycoord, UWORD word);

#endif	_LCDDRV_
