/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   resmgr.h
Author(s)   :   Kenny Ng
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Header file for resource manager
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef __RESMGR_H_
#define	__RESMGR_H_

#include "include\datatype.h"
#include "include\mmu.h"
#include "include\ui.h"

#define ERR_RES_OBJ_MISS	160
#define ERR_RES_NO_MEM		161
#define ERR_RES_NOT_OPEN	162
#define ERR_RES_INV_FIELD	163

#define SYS_RES_ID              2000
#define INSTALL_RES_ID		10000

struct _ResPtr
{
	AppID app;
	ObjectID obj_id;
	UWORD obj_addr;
	UWORD field_addr;
	USHORT last_field;
	struct _ResPtr *next;
};

typedef struct _ResPtr ResLnk;

Err ResOpen(ObjectID obj_id);
Err ResGetField(ObjectID obj_id, USHORT field_num, BYTE **buffer, UWORD *byte_read);
Err ResReadField(ObjectID obj_id, USHORT field_num, UWORD start_pos, UWORD num_byte, BYTE **buffer, UWORD *byte_read);
Err ResFieldSize(ObjectID obj_id, USHORT field_num, UWORD *field_size);
Err ResGetPointer(ObjectID obj_id, USHORT field_num, USHORT offset, void **pointer);
Err ResClose(ObjectID obj_id);
Err ResFieldInfo(AppID app, ObjectID obj_id, USHORT field_num, UWORD *field_size, UWORD *field_addr);
BOOLEAN ResObjInfo(AppID app, ObjectID obj_id, ResLnk **res_ptr);
BOOLEAN ResObjLocate(UWORD res_addr, ObjectID obj_id, UWORD *obj_addr);
void ResSkipByte(UWORD, UWORD, UWORD*);
void ResReadByte(UWORD start_addr, UWORD num_byte, BYTE *data, UWORD *last_addr);
#endif
