/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   uart.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for UART low level device driver
Revision    :   1.1
Note        :   None
===========================================================================
*/              



#include    "include\datatype.h"
#include    "include\msg.h"
#include    "include\qtype.h"
#include    "include\pr31700s.h"
#include    "include\pr31700c.h"
   
#ifndef         __UART_DRIVER__
#define         __UART_DRIVER__

/* return  constant */
#define UART_SUCCESS    1
#define UART_BUF_FULL   0
#define UART_BUF_EMPTY  0
#define UART_DMA_BUSY   1

#define BAUD(a)         (230400/a-1)

#define UART_BAUD115200 BAUD(115200)
#define UART_BAUD57600	BAUD(57600)
#define UART_BAUD38400	BAUD(38400)
#define UART_BAUD19200	BAUD(19200)
#define UART_BAUD9600	BAUD(9600)
#define UART_BAUD4800	BAUD(4800)
#define UART_BAUD2400	BAUD(2400)
#define UART_BAUD1200	BAUD(1200)
#define UART_BAUD600	BAUD(600)
#define UART_BAUD300	BAUD(300)

#define UART_INIT_MASK	0x02E

/* parity bit */
#define UART_PARITY_NONE	0
#define UART_PARITY_EVEN	(3<<1)
#define UART_PARITY_ODD 	(1<<1)

/* data bit */
#define UART_DATABIT7		(1<<3)
#define UART_DATABIT8		0

/* stop bit */
#define UART_STOPBIT1		0
#define UART_STOPBIT2		(1<5)


/* general constant */

#define UART_A                  0
#define UART_B                  1
#define UART_BUF_SIZE           20


/* Uart Std operation */
/*UART A */
#define UartAEnableRxInt()      CPU->REG_INT_ENABLE_2 |=  (1<<31)
#define UartAClearRxInt()       CPU->REG_INT_STATUS_2  =  (1<<31)
#define UartADisableRxInt()     CPU->REG_INT_ENABLE_2 &= ~(1<<31)

#define UartAEnableRxOvrRunInt()  CPU->REG_INT_ENABLE_2 |=  (1<<30)
#define UartAClearRxOvrRunInt()   CPU->REG_INT_STATUS_2  =  (1<<30)
#define UartADisableRxOvrRunInt() CPU->REG_INT_ENABLE_2 &= ~(1<<30)

#define UartAChkInt()           (CPU->REG_INT_STATUS_2 >>22)&0x3ff
#define UartAChkRxxInt()        (CPU->REG_INT_STATUS_2 >>27)&0x1f
#define UartAChkTxxInt()        (CPU->REG_INT_STATUS_2 >>24)&0x3
                                             
#define UartAChkRxInt()         (CPU->REG_INT_STATUS_2 >>31)&1
#define UartAChkRxOvrRunInt()   (CPU->REG_INT_STATUS_2 >>30)&1
#define UartAChkFrameErrInt()   (CPU->REG_INT_STATUS_2 >>29)&1
#define UartAChkBrkErrInt()     (CPU->REG_INT_STATUS_2 >>28)&1
#define UartAChkPrtyErrInt()    (CPU->REG_INT_STATUS_2 >>27)&1
#define UartAChkTxInt()         (CPU->REG_INT_STATUS_2 >>26)&1
#define UartAChkTxOvrRunInt()   (CPU->REG_INT_STATUS_2 >>25)&1
#define UartAChkTxEmptyInt()    (CPU->REG_INT_STATUS_2 >>24)&1


/* UART B */
#define UartBEnableRxInt()      CPU->REG_INT_ENABLE_2 |=  (1<<21)
#define UartBClearRxInt()       CPU->REG_INT_STATUS_2  =  (1<<21)
#define UartBDisableRxInt()     CPU->REG_INT_ENABLE_2 &= ~(1<<21)

#define UartBEnableRxOvrRunInt()  CPU->REG_INT_ENABLE_2 |=  (1<<20)
#define UartBClearRxOvrRunInt()   CPU->REG_INT_STATUS_2  =  (1<<20)
#define UartBDisableRxOvrRunInt() CPU->REG_INT_ENABLE_2 &= ~(1<<20)

#define UartBChkInt()           (CPU->REG_INT_STATUS_2 >>12)&0x3ff
#define UartBChkRxxInt()        (CPU->REG_INT_STATUS_2 >>17)&0x1f
#define UartBChkTxxInt()        (CPU->REG_INT_STATUS_2 >>14)&0x3
                                             
#define UartBChkRxInt()         (CPU->REG_INT_STATUS_2 >>21)&1
#define UartBChkRxOvrRunInt()   (CPU->REG_INT_STATUS_2 >>20)&1
#define UartBChkFrameErrInt()   (CPU->REG_INT_STATUS_2 >>19)&1
#define UartBChkBrkErrInt()     (CPU->REG_INT_STATUS_2 >>18)&1
#define UartBChkPrtyErrInt()    (CPU->REG_INT_STATUS_2 >>17)&1
#define UartBChkTxInt()         (CPU->REG_INT_STATUS_2 >>16)&1
#define UartBChkTxOvrRunInt()   (CPU->REG_INT_STATUS_2 >>15)&1
#define UartBChkTxEmptyInt()    (CPU->REG_INT_STATUS_2 >>14)&1

                                                          



/* Uart A DMA */
#define UartAEnableTxDma()      (CPU->REG_UARTA_CTRL_1 |= ENDMATX )
#define UartADisableTxDma()     (CPU->REG_UARTA_CTRL_1 &= ~ENDMATX )

#define UartAEnableDmaInt()     (CPU->REG_INT_ENABLE_2 |=  UARTADMAFULLINT )
#define UartAClearDmaInt()      CPU->REG_INT_STATUS_2   =  UARTADMAFULLINT
#define UartADisableDmaInt()    (CPU->REG_INT_ENABLE_2 &= ~UARTADMAFULLINT )
#define UartAChkDmaFullInt()    (CPU->REG_INT_STATUS_2 >>23)&1
#define UartAChkDmaHFullInt()   (CPU->REG_INT_STATUS_2 >>22)&1

#define UartADmaAddr(a)         (CPU->REG_UARTA_DMA_CTRL_1 = (a))
#define UartASetDmaLen(a)       (CPU->REG_UARTA_DMA_CTRL_2 = (a))



/* Uart B DMA */
#define UartBEnableTxDma()      (CPU->REG_UARTB_CTRL_1 |= ENDMATX )
#define UartBDisableTxDma()     (CPU->REG_UARTB_CTRL_1 &= ~ENDMATX )

#define UartBEnableDmaInt()     (CPU->REG_INT_ENABLE_2 |=  UARTBDMAFULLINT )
#define UartBClearDmaInt()      CPU->REG_INT_STATUS_2   =  UARTBDMAFULLINT
#define UartBDisableDmaInt()    (CPU->REG_INT_ENABLE_2 &= ~UARTBDMAFULLINT )
#define UartBChkDmaFullInt()    (CPU->REG_INT_STATUS_2 >>13)&1
#define UartBChkDmaHFullInt()   (CPU->REG_INT_STATUS_2 >>12)&1

#define UartBDmaAddr(a)         (CPU->REG_UARTB_DMA_CTRL_1 = (a))
#define UartBSetDmaLen(a)       (CPU->REG_UARTB_DMA_CTRL_2 = (a))




/* function prototype */

/* for testing only */

void UartPrints(BYTE *c);
WORD    UartStatus(WORD port_no);
WORD    UartRxData(WORD port_no, BYTE *data);
WORD    UartTxData(WORD port_no, BYTE data);
void    UartPrintf(WORD port_no, BYTE *buffer);
BYTE    UartGetc(WORD port_no);
void    UartPutc(WORD port_no, BYTE data);


void    UartEnable(WORD port);
void    UartDisable(WORD port);
WORD    UartReadBuf(WORD port, BYTE *buf);
//void    UartIsrRx(WORD port);
void    UartIsrRx();
void    UartErrorHandle(WORD msg, WORD para1, WORD para2);
void    UartWriteBuf(WORD port, BYTE *buf, WORD length);
void    UartInit(WORD port, WORD baud, WORD config);

WORD    UartChkRxDmaBusy(WORD port);
WORD    UartChkTxDmaBusy(WORD port);

WORD    UartChkCfg(WORD port);
WORD    UartChkStatus(WORD port);


void UartMgr();

/* msg to uart manager */

#define UART_RX_BUF_FULL        1
#define UART_RX_FIRST_BYTE      2
#define UART_TX_COMPLETE        3

/* error msg to uart manager */
#define UART_RX_BUF_OVERFLOW    10
#define UART_RX_OVERRUN         11
#define UART_RX_PRTY_ERR        12


#define NULL    0



/* GLOBAL Variable */
/* UART_A */


extern BYTE    UartATxBuf[UART_BUF_SIZE];       /* UART Tx buffer (DMA) */
extern BYTE    UartARxBuf1[UART_BUF_SIZE];       /* UART Rx buffer       */
extern BYTE    UartARxBuf2[UART_BUF_SIZE];       /* UART Rx buffer       */

extern WORD    UartARxReadPtr;
extern WORD    UartARxWritePtr;

extern BYTE    *UartARxBuf;        /* UART Rx buffer ptr  */
extern BYTE    *UartARxWrkBuf;     /* UART Rx buffer ptr  */


/* UART_B */
extern BYTE    UartBTxBuf[UART_BUF_SIZE];       /* UART Tx buffer (DMA) */
extern BYTE    UartBRxBuf1[UART_BUF_SIZE];       /* UART Rx buffer      */
extern BYTE    UartBRxBuf2[UART_BUF_SIZE];       /* UART Rx buffer      */

extern BYTE    *UartBRxBuf;       /* UART Rx buffer ptr      */
extern BYTE    *UartBWrkRxBuf;    /* UART Rx buffer ptr      */

extern WORD    UartBRxReadPtr;
extern WORD    UartBRxWritePtr;

extern MsgType UartMsg;

extern MsgQueueType msgQueue;
extern void MsgAppend(MsgType msg, MsgQueueType *Q);


#endif  __UART_DRIVER__

