/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   dev_io.h
Author(s)   :   Andrew Hui
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   Header file for CPU H/W I/O pin
Revision    :   1.1
Note        :   23/09/98   Prepared by Andrew Hui (AH)                     
                23/09/98   V1.0 release (AH)                               
                10/12/98   V1.1 release (AH)                               
                15/12/98   V1.2 release (AH) (Optimize to O3)              
===========================================================================
*/

#include "platform.h"
#ifdef PR31700

#ifndef  __IO_DEVICE_DRIVER__
#define  __IO_DEVICE_DRIVER__


/* delay 16-24 ms for debounce before power up occur */
#define OnButnEnableDebounce()  (CPU->REG_POWER_CTRL |=  DBNCONBUTN )
#define OnButnDisableDebounce() (CPU->REG_POWER_CTRL &= ~DBNCONBUTN )

#define OnButnClearInt()    CPU->REG_INT_STATUS_5  =  (0x3 <<22)
#define OnButnEnableInt()   CPU->REG_INT_ENABLE_5 |=  (0x3 <<22)
#define OnButnDisableInt()  CPU->REG_INT_ENABLE_5 &= ~(0x3 <<22)
#define OnButnChkInt()      (CPU->REG_INT_STATUS_5>>22)&0x3

#endif  __IO_DEVICE_DRIVER__
#endif

