/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on October 1st, 1999

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   gf.h
Author(s)   :   Henry Fok
Company     :   VTech Informations Ltd.
Project     :   Helio 
Date:	    :   October 1st, 1999
Purpose:	:   header file for Global Find
Revision    :   1.1
Note        :   None
===========================================================================
*/              


#ifndef	_GF_H_
#define _GF_H_

#include "include\ui.h"
#include "include\uifunc.h"
#include "include\mmu.h"

//================ GFResult Event	==================
#define	EVT_GFIND_STRING_ENTER		6000
#define EVT_GFIND_STRING_EXIT		6001
#define EVT_GFIND_STRING_SELECT		6002

#define GF_NO_ERROR			1
#define GF_NO_MEM			0

//================ Global Find Global Variable ==================
extern USHORT gf_num_items;
extern EvtType gf_old_event;
extern USHORT gf_top_item_num;
extern BOOLEAN gf_popup;
extern BYTE gf_error;


//================ Global Find Data Structure ==================
typedef struct _GFindResultBlock
{
	AppID						app_id;
	DatabaseID					dbid;
	RecordID					rec_id;
	USHORT						field_num;
	BYTE						*display_string;
	struct _GFindResultBlock	*next;
}GFindResultBlock;
extern GFindResultBlock *gf_link;

//========= Application Handle Event Function ====================
BOOLEAN GlobalFindInput(EvtType *Event);
BOOLEAN GlobalFindResult(EvtType *Event);

//================= Global Find System Functions ====================
void GlobalFindInit();
BOOLEAN GlobalFindAddItem(AppID appid, DatabaseID dbid, RecordID rec_id, USHORT field_num, BYTE *string, BOOLEAN override);
void GlobalFindDeleteAllItems();
void GlobalFindPopupGlobalFind(void);
void GlobalFindRestoreRunningApp(void);
WORD GlobalFindSearchText(BYTE *short_string, BYTE *whole_string);
void GlobalFindPrepareGotoRecCmd(ObjectID clicked_string_id, void **cmd_ptr);
void GlobalFindRestorePreviousFormStatus();
//void    GlobalFindSetEnableStatus(BYTE status);
//BOOLEAN GlobalFindCheckEnableStatus();

//================= GFResult Application Functions ====================
void GlobalFindSetupScrollbar();
void GlobalFindPutDataToTable();
void GlobalFindScrollbarSetTable(EvtType *Event);
void GlobalFindSetMatchString(BYTE *matching_string);
BOOLEAN GlobalFindStringHandleEvent(EvtType *Event);
void GlobalFindPrepareAppSeparator(AppID app_id);
void GlobalFindSearchData(BYTE *search_string);

#endif
