/*
================================ COPYRIGHT ================================
The contents of this file are subject to the VTech Informations Ltd. License
of VT-OS Ver. 1.1 operating system (the "License"); you may not use this 
file except in compliance with the License.  
 
Software distributed under the License is distributed on an "AS IS" basis, 
WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License 
for the specific language governing rights and limitations under the License.
 
The Original Code is VT-OS Ver. 1.1 Operating System, released 
on March 1st, 2000

The Initial Developer of the Original Code is VTech Informations Ltd.  All 
codes are Copyright (C) VTech Informations Ltd. 1999.  All Rights Reserved.
===========================================================================
*/

/*
===========================================================================
File        :   main.c
Author(s)   :   Richard Gaski
Company     :   Pandora Technology
Project     :   Helio 
Date:	    :   March 1st, 2000
Purpose:	:   main file
Revision    :   1.1
Note        :   None
===========================================================================
*/        

#include "main.h"

//main entry point of program
__main(WORD cmd, void *cmd_arg)
{
  switch(cmd)
  {
    case LAUNCH_CMD_NORMAL_LAUNCH:
      UIApplicationInit();		//initialize UI resources
      FormPopupForm(FORM_MAIN);	        //start main form
      EventLoop();			//run main event loop
      UIDeleteAllAppObjects();		//main event loop has stopped, cleanup
      break;
    case LAUNCH_CMD_GOTO_REC:
      if(((GotoRec*)cmd_arg)->find_string)
        pfree(((GotoRec*)cmd_arg)->find_string);
    case LAUNCH_CMD_FIND:
    case LAUNCH_CMD_ALARM_HIT:
      pfree(cmd_arg);
      break;
    default:
      return FALSE;
    }
    return TRUE;
}

void EventLoop(void)
{
  EvtType event;

  while(1)
  {
    EvtGetEvent(&event);
    if(SystemHandleEvent(&event))
      continue;
    if(MenuHandleEvent(&event))
      continue;
    if(ApplicationHandleEvent(&event))
      continue;
    FormDispatchEvent(&event);
    if(event.eventType==EVT_APP_STOP)
      break;
  }
  return;
}

BOOLEAN ApplicationHandleEvent(EvtType *Event)
{
  Form* form_ptr;
  BYTE  object_type;
  void* evtHandler;
	
  switch(Event->eventType)
  {
    case EVT_FORM_LOAD:
      if((Event->para1==1)||(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE))
        FormInitAllFormObjects((ObjectID)Event->eventID);
      if(UISearchForAddress((ObjectID)Event->eventID,&object_type,(void**)&form_ptr)!=TRUE)
        return FALSE;
      switch((ObjectID)Event->eventID)
      {
        case FORM_MAIN:
          evtHandler = (void*)FormMainHandleEvent;
	  break;
	default:
	  return FALSE;
      }
      FormSetEventHandler((ObjectID)Event->eventID,(void**)&FormDispatchEvent,evtHandler);
      FormSetActiveForm((ObjectID)Event->eventID);
      break;
    default:
      return FALSE;
  }
  return TRUE;
}

BOOLEAN FormMainHandleEvent(EvtType* Event)
{
  switch(Event->eventType)
  {
    case EVT_FORM_OPEN:
      CreateNewBitmaps();
      FormDrawForm(Event->eventID);
      break;
    case EVT_BITMAP_SELECT:
      break;
    case EVT_INLAY_SELECT:
      switch(Event->para1)
      {
        case INLAY_EXIT:
	case INLAY_MAIN_MENU:
	  FormGotoApp("Mainmenu");
	  break;
      }
      break;
    default:
      return FALSE;
  }
  return TRUE;
}

void FormGotoApp(BYTE* app_name)
{
  ObjectID object_id;

  FormGetActiveFormID(&object_id);
  EvtAppendEvt(EVT_FORM_CLOSE, object_id, 0, 0, NULL);
  SysGetAppID(app_name,&object_id);
  EvtAppendEvt(EVT_APP_STOP,0,0,0,NULL);
  EvtAppendEvt(EVT_APP_LAUNCH,object_id,0,0,NULL);
  return;
}

void CreateNewBitmaps(void)
{
  Bitmap* addr;
  Bitmap* bitmap;
  BYTE object_id;
  BYTE object_type;

  FormGetObjectPointer(BITMAP_MAIN, &object_type, (void **)&addr);
  for(object_id=2;object_id<57;object_id++)
  {
    //create new UI object
    UIAddressToLookupTable(object_id,object_type,(void**)&bitmap);
    //copy existing bitmap data
    memcpy(bitmap,addr,sizeof(Bitmap)*sizeof(BYTE));
    //update object id
    bitmap->identification.ui_object_id = object_id;
    //create its own copy of bitmap data
    bitmap->bitmap_bitmap1.bitmap_data = qmalloc(addr->bitmap_bitmap1.size*sizeof(BYTE));
    memcpy(bitmap->bitmap_bitmap1.bitmap_data,addr->bitmap_bitmap1.bitmap_data,addr->bitmap_bitmap1.size*sizeof(BYTE));
    //set new coords
    bitmap->bounds.xcoord = bitmap->bitmap_bitmap1.xcoord = ((object_id - 1) % 8) * 20;
    bitmap->bounds.ycoord = bitmap->bitmap_bitmap1.ycoord = (((object_id - 1) / 8) * 20) + 20;
    //add to form
    FormAddOneObject(FORM_MAIN,object_id,object_type);
  }
}