#ifndef __GADGET_H__
#define __GADGET_H__

#define OBJ_TYPE_NOTHING    0
#define OBJ_TYPE_TXTBTN     1
#define OBJ_TYPE_BMPBTN     2
#define OBJ_TYPE_PSHBTN     3
#define OBJ_TYPE_SCROLLBAR  4
#define OBJ_TYPE_RICHTEXT   5
#define OBJ_TYPE_LIVETEXT   6
#define OBJ_TYPE_TOOLBAR    7

typedef struct {
           ObjectID  formID;
           int       obj_type;
           void     *obj;
           void     *next;
           BOOLEAN (*ObjectMsgProcess)(void *obj, EvtType *Event);
           BOOLEAN (*ObjectDestroy)(void *obj);
           BOOLEAN (*ObjectDraw)(void *obj);
        } TGadgetList;

BOOLEAN  GadgetRegister(void *obj, ObjectID formID, int obj_type, void *MsgFunc, void *KillFunc, void *DrawFunc);
BOOLEAN  GadgetHandler(EvtType *event);
BOOLEAN  GadgetDestroyAll();
BOOLEAN  GadgetDrawForm(ObjectID formID);

TGadgetList *gadget_reg_root = NULL;

//----------------------------------------------------------------------------
BOOLEAN GadgetDrawForm(ObjectID formID) {
   TGadgetList *ref;

   ref = gadget_reg_root;
   while (ref != NULL) {
      if (ref->formID == formID) ref->ObjectDraw(ref->obj);
      ref = (TGadgetList *) ref->next;
   };

   return TRUE;
};
//----------------------------------------------------------------------------
BOOLEAN GadgetRegister(void *obj, ObjectID formID, int obj_type, void *MsgFunc, void *KillFunc, void *DrawFunc) {
   TGadgetList *tmp;
   TGadgetList *ref;

   tmp = (TGadgetList *) qmalloc(sizeof(TGadgetList));
   tmp->formID = formID;
   tmp->obj_type = obj_type;
   tmp->obj = obj;
   tmp->next = NULL;
   tmp->ObjectMsgProcess = MsgFunc;
   tmp->ObjectDestroy = KillFunc;
   tmp->ObjectDraw = DrawFunc;
   ref = gadget_reg_root;
   if (ref == NULL) {
      gadget_reg_root = tmp;
   } else {
      while (ref->next != NULL) (TGadgetList *) ref = ref->next;
      ref->next = tmp;
   };
   return TRUE;
};
//----------------------------------------------------------------------------
BOOLEAN  GadgetHandler(EvtType *event) {
   TGadgetList *ref;
   EvtType      tmp;
   ObjectID     formID;

   ref = gadget_reg_root;
   FormGetActiveFormID(&formID);
   while (ref != NULL) {
      if (ref->formID == formID) {
         memcpy(&tmp, event, sizeof(EvtType));
         if (ref->ObjectMsgProcess(ref->obj, &tmp)) {
            EvtAppendEvt(tmp.eventType, tmp.eventID, tmp.para1, tmp.para2, tmp.evtPBP);
         };
      };
      ref = (TGadgetList *) ref->next;
   };
};
//----------------------------------------------------------------------------
BOOLEAN  GadgetDestroyAll() {
   TGadgetList *ref;
   TGadgetList *tmp;

   if (gadget_reg_root == NULL) return TRUE;
   ref = gadget_reg_root;
   while (ref != NULL) {
      tmp = ref;
      ref = (TGadgetList *) ref->next;
      tmp->ObjectDestroy(tmp->obj);
      qfree(tmp);
   }; 
   gadget_reg_root = NULL;

   return TRUE;
};
//----------------------------------------------------------------------------

#endif


