#ifndef __IMAGE_H__
#define __IMAGE_H__

#include "clipper.h"

typedef struct {
   int t, w, h;
   UWORD *data;
} TImageRes;

int ImageGetHeight(TImageRes *item);
int ImageGetWidth(TImageRes *item);
int ImageDraw(TImageRes *item, int x, int y);

//----------------------------------------------------------------------
int ImageDraw00(TImageRes *item, int x, int y) {
   int y1, y2, x1, x2, i, j, s, d;
   BYTE *data;

   data = (BYTE *)(item->data + 1);
   i = x + item->w - 1;
   j = y + item->h - 1;
   x1 = (x < lcd_clip.x1) ? lcd_clip.x1 : x;
   y1 = (y < lcd_clip.y1) ? lcd_clip.y1 : y;
   x2 = (i > lcd_clip.x2) ? lcd_clip.x2 : i;
   y2 = (j > lcd_clip.y2) ? lcd_clip.y2 : j;

   if ((item->w & 7) > 0) s = (item->w / 8 + 1);
      else s = (item->w / 8);

   y = (y1-y)*s;
   d = x1 - x;
   for (j = y1; j <= y2; j++, y += s) {
      for (x = d, i = x1; i <= x2; i++, x++) {
         if ((data[y+x/8] & ((UWORD) 0x80 >> (x & 7)) ) == 0) LcdSetPixel(i, j, 15);
            else LcdSetPixel(i, j, 0);
      };
   };

   return item->w;  
};
//----------------------------------------------------------------------
int ImageDrawFF(TImageRes *item, int x, int y) {
   int y1, y2, x1, x2, i, j, s, d;
   UWORD *data;

   data = item->data;
   i = x + item->w - 1;
   j = y + item->h - 1;
   x1 = (x < lcd_clip.x1) ? lcd_clip.x1 : x;
   y1 = (y < lcd_clip.y1) ? lcd_clip.y1 : y;
   x2 = (i > lcd_clip.x2) ? lcd_clip.x2 : i;
   y2 = (j > lcd_clip.y2) ? lcd_clip.y2 : j;

   if ((item->w & 31) > 0) s = (item->w / 32 + 1);
      else s = (item->w / 32);

   y = (y1-y)*s;
   d = x1 - x;
   for (j = y1; j <= y2; j++, y += s) {
      for (x = d, i = x1; i <= x2; i++, x++) {
         if ((data[y+x/32] & ((UWORD) 0x80000000 >> (x & 31)) ) == 0) LcdSetPixel(i, j, 15);
            else LcdSetPixel(i, j, 0);
      };
   };

   return item->w;
};
//----------------------------------------------------------------------
int ImageDraw(TImageRes *item, int x, int y) {
  
   if (item == NULL) return 0;
   switch (item->t) {
      case 0: return ImageDraw00(item, x, y);
   };
   return ImageDrawFF(item, x, y);
};
//----------------------------------------------------------------------
int ImageGetHeight(TImageRes *item) {
   if (item == NULL) return 0;
   return item->h;
}
//----------------------------------------------------------------------
int ImageGetWidth(TImageRes *item) {
   if (item == NULL) return 0;
   return item->w;
}
//----------------------------------------------------------------------

#endif

