#ifndef __SCROLLER_H__
#define __SCROLLER_H__

#include "gadget.h"
#include "bmpbtn.h"

#include "scroll.inc"

#define SCROLL_TYPE_HORZ   0
#define SCROLL_TYPE_VERT   1

#define PIVOT_MIN_WIDTH    8

typedef struct {
           int ID;
           int t, x, y, w, h;
           int min, max, pos, page;
           int a1, a2, a3, a4, a5, a6;
           int b1, b2;
           int PivotW;
           int grab;
           int MarkA, MarkP;
           double stepsize;
           TBmpBtn *MinBtn;
           TBmpBtn *MaxBtn;
        } TScrollBar;

TScrollBar *ScrollCreate(int ID, int t, int x, int y, int size);
BOOLEAN     ScrollDestroy(TScrollBar *obj);
BOOLEAN     ScrollSetProperties(TScrollBar *obj, int min, int max, int pos, int page);
BOOLEAN     ScrollMsgProcess(TScrollBar *obj, EvtType *event);
BOOLEAN     ScrollDraw(TScrollBar *obj);
BOOLEAN     ScrollSetPos(TScrollBar *obj, int pos);
BOOLEAN     ScrollRegister(void *obj, ObjectID formID);

//----------------------------------------------------------------------------
TScrollBar *ScrollCreate(int ID, int t, int x, int y, int size) {
   TScrollBar *tmp;

   tmp = (TScrollBar *) qmalloc(sizeof(TScrollBar));
   tmp->ID = ID;
   tmp->t = t;
   tmp->x = x;
   tmp->y = y;
   tmp->min = 0;
   tmp->max = 0;
   tmp->pos = 0;
   tmp->page = 0;
   if (t == SCROLL_TYPE_HORZ) {
      tmp->MinBtn = BmpBtnCreate(ID, x, y, &_scroll_lt_bmp);
      tmp->MaxBtn = BmpBtnCreate(ID, x, y, &_scroll_rt_bmp);
      tmp->w = size;
      tmp->h = 10;
   };
   if (t == SCROLL_TYPE_VERT) {
      tmp->MinBtn = BmpBtnCreate(ID, x, y, &_scroll_up_bmp);
      tmp->MaxBtn = BmpBtnCreate(ID, x, y, &_scroll_dn_bmp);
      tmp->w = 10;
      tmp->h = size;
   };
   ScrollSetProperties(tmp, 0, 0, 0, 1);
   return tmp;
};
//----------------------------------------------------------------------------
BOOLEAN ScrollDestroy(TScrollBar *obj) {
   qfree(obj->MinBtn);
   qfree(obj->MaxBtn);
   qfree(obj);
   return TRUE;
};
//----------------------------------------------------------------------------
BOOLEAN ScrollSetProperties(TScrollBar *obj, int min, int max, int pos, int page) {
   int resolution, bandwidth, r1, r2;
   double scalefactor;

   obj->min = min;
   obj->max = max;
   obj->pos = pos;
   obj->page = page;

   bandwidth = obj->max - obj->min + 1;

   if (obj->t == SCROLL_TYPE_HORZ) {
      resolution = obj->w - obj->MinBtn->img->w - obj->MaxBtn->img->w - PIVOT_MIN_WIDTH;
      scalefactor = (double) ((double) bandwidth / (double) resolution);
      obj->a1 = obj->x;
      obj->a2 = obj->x + obj->MinBtn->img->w - 1;
      if (scalefactor < 1) {
         obj->PivotW = obj->w - obj->MinBtn->img->w - obj->MaxBtn->img->w - bandwidth + 1;
         obj->stepsize = 1;
      } else {
         obj->PivotW = PIVOT_MIN_WIDTH+1;
         obj->stepsize = scalefactor;
      };
      r1 = (obj->pos - obj->min) / obj->stepsize;
      r2 = resolution - r1 - obj->PivotW;

      obj->a3 = obj->a2 + r1 + 1;
      obj->a4 = obj->a3 + obj->PivotW - 1;
      obj->a5 = obj->x + obj->w - obj->MaxBtn->img->w;
      obj->a6 = obj->x + obj->w - 1;
      obj->b1 = obj->y;
      obj->b2 = obj->y + obj->h - 1;
      obj->MaxBtn->x = obj->a5;
      obj->MaxBtn->y = obj->b1;
   };

   if (obj->t == SCROLL_TYPE_VERT) {
      resolution = obj->h - obj->MinBtn->img->h - obj->MaxBtn->img->h - PIVOT_MIN_WIDTH;
      scalefactor = (double) ((double) bandwidth / (double) resolution);
      obj->a1 = obj->y;
      obj->a2 = obj->y + obj->MinBtn->img->h - 1;
      if (scalefactor < 1) {
         obj->PivotW = obj->h - obj->MinBtn->img->h - obj->MaxBtn->img->h - bandwidth + 1;
         obj->stepsize = 1;
      } else {
         obj->PivotW = PIVOT_MIN_WIDTH+1;
         obj->stepsize = scalefactor;
      };
      r1 = (obj->pos - obj->min) / obj->stepsize;
      r2 = resolution - r1 - obj->PivotW;

      obj->a3 = obj->a2 + r1 + 1;
      obj->a4 = obj->a3 + obj->PivotW - 1;
      obj->a5 = obj->y + obj->h - obj->MaxBtn->img->h;
      obj->a6 = obj->y + obj->h - 1;
      obj->b1 = obj->x;
      obj->b2 = obj->x + obj->w - 1;
      obj->MaxBtn->x = obj->b1;
      obj->MaxBtn->y = obj->a5;
   };

};
//----------------------------------------------------------------------------
BOOLEAN ScrollSetPos(TScrollBar *obj, int pos) {

   int resolution, bandwidth, r1, r2;

   if (pos < obj->min) pos = obj->min;
   if (pos > obj->max) pos = obj->max;
   obj->pos = pos;

   bandwidth = obj->max - obj->min + 1;

   if (obj->t == SCROLL_TYPE_HORZ) {
     resolution = obj->w - obj->MinBtn->img->w - obj->MaxBtn->img->w - PIVOT_MIN_WIDTH;
   };

   if (obj->t == SCROLL_TYPE_VERT) {
     resolution = obj->h - obj->MinBtn->img->h - obj->MaxBtn->img->h - PIVOT_MIN_WIDTH;
   };

   r1 = (obj->pos - obj->min) / obj->stepsize;
   r2 = resolution - r1 - obj->PivotW;
   obj->a3 = obj->a2 + r1 + 1;
   obj->a4 = obj->a3 + obj->PivotW - 1;

};
//----------------------------------------------------------------------------
BOOLEAN ScrollDraw(TScrollBar *obj) {
ObjectBounds r1, pivot, r2;
   if (obj->t == SCROLL_TYPE_HORZ) {
        r1.xcoord = obj->a2+1;
        r1.ycoord = obj->b1;
        r1.width = obj->a3 - r1.xcoord;
        r1.height = obj->b2 - r1.ycoord + 1;
        pivot.xcoord = obj->a3;
        pivot.ycoord = obj->b1;
        pivot.width = obj->a4 - pivot.xcoord + 1;
        pivot.height = obj->b2 - pivot.ycoord + 1;
        r2.xcoord = obj->a4+1;
        r2.ycoord = obj->b1;
        r2.width = obj->a5 - r2.xcoord;
        r2.height = obj->b2 - r2.ycoord + 1;
   };
   if (obj->t == SCROLL_TYPE_VERT) {
        r1.xcoord = obj->b1;
        r1.ycoord = obj->a2+1;
        r1.width = obj->b2 - r1.xcoord + 1;
        r1.height = obj->a3 - r1.ycoord;
        pivot.xcoord = obj->b1;
        pivot.ycoord = obj->a3;
        pivot.width = obj->b2 - pivot.xcoord + 1;
        pivot.height = obj->a4 - pivot.ycoord + 1;
        r2.xcoord = obj->b1;
        r2.ycoord = obj->a4+1;
        r2.width = obj->b2 - r2.xcoord + 1;
        r2.height = obj->a5 - r2.ycoord;
   };

   LcdDrawBox(&r1, 0, 15, 0);
   LcdDrawBox(&r2, 0, 15, 0);
   LcdDrawBox(&pivot, 15, 0, 0);
   BmpBtnDraw(obj->MinBtn);
   BmpBtnDraw(obj->MaxBtn);
};
//----------------------------------------------------------------------------
BOOLEAN ScrollMsgProcess(TScrollBar *obj, EvtType *event) {
   int x, y, disp;

   if (BmpBtnMsgProcess(obj->MinBtn, event)) {
      if ((event->eventType == EVT_CONTROL_SELECT) || 
          (event->eventType == EVT_CONTROL_REPEAT)) {
         event->eventID = obj->ID;
         event->eventType = EVT_SCROLLBAR_REPEAT;
         event->para1 = obj->pos;
         ScrollSetPos(obj, obj->pos - 1);
         event->para2 = obj->pos;
      };
      ScrollDraw(obj);
      return TRUE;
   };
   if (BmpBtnMsgProcess(obj->MaxBtn, event)) {
      if ((event->eventType == EVT_CONTROL_SELECT) || 
          (event->eventType == EVT_CONTROL_REPEAT)) {
         event->eventID = obj->ID;
         event->eventType = EVT_SCROLLBAR_REPEAT;
         event->para1 = obj->pos;
         ScrollSetPos(obj, obj->pos + 1);
         event->para2 = obj->pos;
      };
      ScrollDraw(obj);
      return TRUE;
   };

   x = event->para1;
   y = event->para2;

   switch (event->eventType) {
      case PEN_EVENT:
         switch (event->eventID) {
            case PEN_DOWN:
               obj->grab = 0;
               if (obj->t == SCROLL_TYPE_HORZ) {
                  if ((x >= obj->a3) && (x <= obj->a4) &&
                     (y >= obj->y) && (y - obj->y < obj->h)) {
                      obj->MarkA = x;
                      obj->MarkP = obj->pos;
                      obj->grab = 1;
                  };
                  if ((x > obj->a2) && (x < obj->a3) &&
                     (y >= obj->y) && (y - obj->y < obj->h)) {
                     event->eventID = obj->ID;
                     event->eventType = EVT_SCROLLBAR_REPEAT;
                     event->para1 = obj->pos;
                     ScrollSetPos(obj, obj->pos - obj->page);
                     event->para2 = obj->pos;
                     SndPlaySndEffect(SNDRES5_BEEP);
                     ScrollDraw(obj);
                     return TRUE;
                  };
                  if ((x > obj->a4) && (x < obj->a5) &&
                     (y >= obj->y) && (y - obj->y < obj->h)) {
                     event->eventID = obj->ID;
                     event->eventType = EVT_SCROLLBAR_REPEAT;
                     event->para1 = obj->pos;
                     ScrollSetPos(obj, obj->pos + obj->page);
                     event->para2 = obj->pos;
                     SndPlaySndEffect(SNDRES5_BEEP);
                     ScrollDraw(obj);
                     return TRUE;
                  };
               };
               if (obj->t == SCROLL_TYPE_VERT) {
                  if ((y >= obj->a3) && (y <= obj->a4) &&
                     (x >= obj->x) && (x - obj->x < obj->w)) {
                     obj->MarkA = y;
                     obj->MarkP = obj->pos;
                     obj->grab = 1;
                  };
                  if ((y > obj->a2) && (y < obj->a3) &&
                     (x >= obj->x) && (x - obj->x < obj->w)) {
                     event->eventID = obj->ID;
                     event->eventType = EVT_SCROLLBAR_REPEAT;
                     event->para1 = obj->pos;
                     ScrollSetPos(obj, obj->pos - obj->page);
                     event->para2 = obj->pos;
                     SndPlaySndEffect(SNDRES5_BEEP);
                     ScrollDraw(obj);
                     return TRUE;
                  };
                  if ((y > obj->a4) && (y < obj->a5) &&
                     (x >= obj->x) && (x - obj->x < obj->w)) {
                     event->eventID = obj->ID;
                     event->eventType = EVT_SCROLLBAR_REPEAT;
                     event->para1 = obj->pos;
                     ScrollSetPos(obj, obj->pos + obj->page);
                     event->para2 = obj->pos;
                     SndPlaySndEffect(SNDRES5_BEEP);
                     ScrollDraw(obj);
                     return TRUE;
                  };
               };
               break;
            case PEN_MOVE:
               if (obj->grab == 1) {
                  if (obj->t == SCROLL_TYPE_HORZ) {
                     disp = x - obj->MarkA;
                  };
                  if (obj->t == SCROLL_TYPE_VERT) {
                     disp = y - obj->MarkA;
                  };
                  if (obj->MarkP + disp * obj->stepsize != obj->pos) {
                     event->eventID = obj->ID;
                     event->eventType = EVT_SCROLLBAR_REPEAT;
                     event->para1 = obj->pos;
                     ScrollSetPos(obj, obj->MarkP + disp * obj->stepsize);
                     event->para2 = obj->pos;
                     ScrollDraw(obj);
                     return TRUE;
                  };
               };
               break;
            case PEN_UP:
               obj->grab = 0;
               break;
         };
         break;
   };    
   return FALSE;
};
//----------------------------------------------------------------------------
BOOLEAN ScrollRegister(void *obj, ObjectID formID) {
   return GadgetRegister(obj, formID, OBJ_TYPE_SCROLLBAR, ScrollMsgProcess, ScrollDestroy, ScrollDraw);
};
//----------------------------------------------------------------------------

#endif
