/*
*	SmallBASIC - Math RTL
*
*	Nicholas Christopoulos
*/

#if !defined(_blib_math_h)
#define _blib_math_h

#include "sys.h"

#define		SEGLEN(Ax,Ay,Bx,By)		line_length(Ax,Ay,Bx,By)
#define		PTSIGN(Ax,Ay,Bx,By,Qx,Qy)	(ZSGN((Qx) * ((Ay) - (By)) + (Qy) * ((Bx) - (Ax)) + (Ax) * (By) - (Ay) * (Bx)))

double		line_segangle(int type, double Adx, double Ady, double Bdx, double Bdy) SEC(BMATH2);
double		line_length(double Ax, double Ay, double Bx, double By)					SEC(BMATH2);
void 		mat_gauss_jordan (double *a, double *b, int n, double toler)			SEC(BMATH2);
void		mat_inverse(double *a, int n)											SEC(BMATH2);
void	mat_det2(double t, int m, int k, double *a, int *done, double *v, int n, double toler)	SEC(BMATH2);
double	mat_determ(double *a, int n, double toler)	SEC(BMATH2);
double	statmeandev(double *e, int count)	SEC(BMATH2);
double	statspreads(double *e, int count)		SEC(BMATH2);
double	statspreadp(double *e, int count)	SEC(BMATH2);

#endif


