/*
*	SmallBASIC module (shared-lib) manager
*
*	2001/12/07, Nicholas Christopoulos
*
*	This program is distributed under the terms of the GPL v2.0 or later
*	Download the GNU Public License (GPL) from www.gnu.org
*/

/*
*	VFS extention its not working, yet!
*/

#if !defined(_sb_extlib_h)
#define	_sb_extlib_h

#include "sys.h"
#include "var.h"
#include "device.h"

/*
*	shared-lib supported API 
*/
typedef enum {
	lib_lang_ext,		// Language extention
	lib_vfs_driver,		// VFS driver

	lib_null
	} slib_tp;

/*
*	shared-lib information structure
*/
typedef struct {
	int		id;
#if defined(OS_LIMITED)
	char	name[32];		// name of library (basename)
#else
	char	name[256];		// name of library (basename)
	char	fullname[1024];	// full pathname
#endif
	void	*handle;		// handle to the lib
	slib_tp type;			// type of the API
	dword	flags;			// flags

	/* ------------------  Language  ------------------ */

	int		proc_count;
	int		func_count;

	/* ------------------ VFS driver ------------------ */

	char	vfs_drvname[5]; 	// VFS driver name (ex: MEMO, PDOC, etc)

	}	slib_t;

/*
* 	slib_t flags
*/
//#define	SBL_LOADED		1

void	sblmgr_init(int mcount, const char *list)			SEC(TRASH);
int		sblmgr_getfuncname(int lib, int index, char *buf)	SEC(TRASH);
int		sblmgr_getprocname(int lib, int index, char *buf)	SEC(TRASH);
int		sblmgr_procexec(int lib, int index)					SEC(TRASH);
int		sblmgr_funcexec(int lib, int index, var_t *ret)		SEC(TRASH);
void	sblmgr_close(void)									SEC(TRASH);

/* --------------------------------------------------- Common interface --------------------------------------------------- */

/*
*	Parameter structure
*/
typedef struct	{
	var_t		*var_p;		// the parameter itself
	byte		byref;		// parameter can be used as byref
	} slib_par_t;

/*
*	common API
*/
int		sblib_init(void);	// initialize the library (returns 0 on error)
void	sblib_close(void);	// closes the library
int		sblib_type(void);	// returns the 'slib_tp' value (type of API)

/* ------------------------------------------------------  Language  ------------------------------------------------------ */

/*
*	Notes:
*	* Procedure & functions names are limited to 32 characters (33 with \0)
*/

int		sblib_proc_count(void);						   		// returns the number of the procedures
int		sblib_proc_getname(int index, char *proc_name);		// returns the 'index' procedure name
int		sblib_proc_exec(int index, int param_count,	   		// executes the 'index' procedure
			slib_par_t *params, var_t *retval);

int		sblib_func_count(void);								// returns the number of the functions
int		sblib_func_getname(int index, char *func_name);		// returns the 'index' function name
int		sblib_func_exec(int index, int param_count,			// executes the 'index' function
			slib_par_t *params, var_t *retval);

/* ------------------------------------------------------ VFS Driver ------------------------------------------------------ */

/*
*	function 'index' values for VFS drivers
*/
enum slib_vfs_idx_t	{

	/* ---- required ---- */

	lib_vfs_open,					// open a file	
	lib_vfs_close,					// close a file	
	lib_vfs_read,					// read			
	lib_vfs_write,					// write
	lib_vfs_eof,					// EOF

	/* ---- optional ---- */

	lib_vfs_tell,					// position in file
	lib_vfs_length,					// length of file
	lib_vfs_seek,					// seek

	lib_vfs_chmod,					// chmod
	lib_vfs_access,					// returns the file attributes 

	lib_vfs_files,					// returns array of filenames

	lib_vfs_chdir,					// change current directory
	lib_vfs_mkdir,					// create a new directory
	lib_vfs_rmdir,					// remove a directory

	lib_vfs_null					// not used
	};	

void	sblib_vfsname(char*);								// returns the driver's name (i.e. "MEMO"), always 4 chars
int		sblib_vfs_exec(int index, int param_count,			// executes the 'index' function
			slib_par_t **params, slib_par_t *retval);

#endif

