/*
*	SmallBASIC:	low-level platform driver
*
*	(Check device.h)
*
*	ndc: 2001-02-13
*
*	This program is distributed under the terms of the GPL v2.0 or later
*	Download the GNU Public License (GPL) from www.gnu.org
*/

#if !defined(_palm_dev_h)
#define _palm_dev_h

#if defined(__cplusplus)
extern "C" {
#endif

#if defined(USE_OFBIS)
#include <ofbis.h>
#endif

int		osd_devinit(void)												; // in main seg please //SEC(BIO); 
int		osd_devrestore(void)											SEC(BIO);

/*
*   check events
*/
int		osd_events();

/*
*   clear screen
*/
void	osd_cls(void)													SEC(BIO);

/*
*   current position (actually only for text)
*   values are in pixels
*/
void	osd_setxy(int x, int y)											SEC(BIO);
int		osd_getx(void)													SEC(BIO);
int		osd_gety(void)													SEC(BIO);

/*
*   text font
*/
int		osd_textwidth(const char *str)									SEC(BIO);
int		osd_textheight(const char *str)									SEC(BIO);

/*
*   pen/mouse (read device.h)
*/
void	osd_setpenmode(int enable)										SEC(BIO);
int		osd_getpen(int mode)											SEC(BIO);

/*
*   write/get string to/from device
*/
void	osd_write(const char *str)										SEC(BIO);
char	*osd_gets(char *dest, int size)									SEC(BIO);

/*
*   set colors
*   Note: background color is used only on texts
*/
void	osd_setcolor(long color)										SEC(BIO);
void	osd_settextcolor(long fg, long bg) 								SEC(BIO);

/*
*   set/get pixel color
*/
void	osd_setpixel(int x, int y)										; // in main seg please //SEC(BIO);
long	osd_getpixel(int x, int y)										SEC(BIO);

/*
*   draw line
*/
void	osd_line(int x1, int y1, int x2, int y2)						; // in main seg please //SEC(BIO);

/*
*   draw parallelogram (filled or not)
*/
void	osd_rect(int x1, int y1, int x2, int y2, int fill)				SEC(BIO);

/*
*   plays a tone (frq = frequency, dur = duration in milliseconds, vol = volume (0..99), bgplay = true for play on background)
*/
void	osd_sound(int frq, int dur, int vol, int bgplay)				SEC(BIO);

/*
*   beep :)
*/
void	osd_beep(void)													SEC(BIO);

/*
*   if framebuffer technique is used; this routine must write buffer to video-ram
*/
void    osd_refresh(void)                                               SEC(BIO);

#if defined(__cplusplus)
}
#endif

#endif

