/*
*	System error manager
*
*	Nicolas Christopoulos
*
*	This program is distributed under the terms of the GPL v2.0 or later
*	Download the GNU Public License (GPL) from www.gnu.org
*/

#include "sys.h"

#if defined(_PalmOS)
//	#define ERROR_CHECK_LEVEL 2
//	defined by PalmOpt...h
	#include "sbpad.h"
	#include "smbas.h"
#elif defined(_WinGUI) || defined(_Win32)
	#include <windows.h>
#endif
#if defined(_BCB_W32_IDE)
	#include "win32/bcb.h"
#endif

#include "panic.h"

static char preload_panic_buffer[SB_PANICMSG_SIZE+1];

/**
*/
void	panic(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	#if defined(_PalmOS)
	StrVPrintF(preload_panic_buffer, fmt, ap);
	#else
	vsprintf(preload_panic_buffer, fmt, ap);
	#endif
	va_end(ap);
	
	#if defined(_BCB_W32_IDE)
	bcb_mgrerr("%s", preload_panic_buffer);
	#elif defined(_WinGUI) || defined(_Win32)
	MessageBox(NULL, preload_panic_buffer, "SB Panic", MB_OK);
	#elif defined(_VTOS)
	MessageBox("FATAL PANIC", preload_panic_buffer, TRUE);
    #elif defined(_FRANKLIN_EBM)
	GUI_Alert(ALERT_ERROR, preload_panic_buffer);
	#elif defined(_PalmOS)
	ErrDisplay(preload_panic_buffer);
	#else
	fprintf(stderr, "\n\nPANIC: %s\a\n\n", preload_panic_buffer);
	fflush(stderr);

   	memmgr_setabort(1);
	exit(1);
	#endif
}

/**
*/
void	warning(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	#if defined(_PalmOS)
	StrVPrintF(preload_panic_buffer, fmt, ap);
	#else
	vsprintf(preload_panic_buffer, fmt, ap);
	#endif
	va_end(ap);
	
	#if defined(_WinGUI) || defined(_Win32)
	MessageBox(NULL, preload_panic_buffer, "SB Warning", MB_OK);
	#elif defined(_PalmOS)
	FrmCustomAlert(InfoAlertID, "Warning:", preload_panic_buffer, "");
//	ErrNonFatalDisplay(preload_panic_buffer);
	#elif defined(_VTOS)
	MessageBox("WARNING", preload_panic_buffer, FALSE);
    #elif defined(_FRANKLIN_EBM)
	GUI_Alert(ALERT_ERROR, preload_panic_buffer);
	#else // defined(_UnixOS) 
	fprintf(stderr, preload_panic_buffer);
	#endif
}

/**
*/
void	debug(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	strcpy(preload_panic_buffer,"DEBUG: ");
	#if defined(_PalmOS)
	StrVPrintF(&preload_panic_buffer[7], fmt, ap);
	#else
	vsprintf(&preload_panic_buffer[7], fmt, ap);
	#endif
	va_end(ap);
	
	#if defined(_WinGUI) || defined(_Win32)
	MessageBox(NULL, preload_panic_buffer, "SB Debug", MB_OK);
	#elif defined(_PalmOS)
	ErrNonFatalDisplay(preload_panic_buffer);
	#elif defined(_VTOS)
	MessageBox("WARNING", preload_panic_buffer, FALSE);
    #elif defined(_FRANKLIN_EBM)
	GUI_Alert(ALERT_ERROR, preload_panic_buffer);
	#else // defined(_UnixOS) 
	fprintf(stderr, preload_panic_buffer);
	#endif
}



