/*
*	SmallBASIC run-time errors
*
*	Nicholas Christopoulos
*/

#if	!defined(_sberr_h)
#define	_sberr_h

#include "sys.h"

void	rt_raise(const char *fmt, ...);

#if defined(OS_LIMITED)
void	err_syntax(void)			SEC(TRASH);		// SYNTAX ERROR
void	err_syntaxsep(int c)		SEC(TRASH);		// MISSING SEPARATOR 'c'
void	err_matdim(void)			SEC(TRASH);
void	err_missing_rp(void)		SEC(TRASH);
void	err_parm_num(void)			SEC(TRASH);		// UDP/F: PARAMETERS NUMBER INCORRECT
#else
#define	err_syntax() 				rt_raise("%s (%d): Syntax error!\n", __FILE__, __LINE__)
#define	err_syntaxsep(c)			rt_raise("%s (%d): Syntax error. Missing separator '%c'.\n", __FILE__, __LINE__, (c))
#define	err_missing_rp()			rt_raise("%s (%d): Missing ')'.\n", __FILE__, __LINE__)
#define	err_matdim()				rt_raise("%s (%d): Dimension error.\n", __FILE__, __LINE__)
#define	err_parm_num()				rt_raise("%s (%d): Parameters error.\n", __FILE__, __LINE__)
#endif
void	err_typemismatch(void)		SEC(TRASH);		// TYPE MISMATCH
void	err_stackmess(void)			SEC(TRASH);		// GENERIC STACK ERROR (if you play with GOTOs, you can create it easily)
void	err_parm_byref(int n)		SEC(TRASH);		// UDP/F: PARAMETER IS 'BY REFERENCE' SO CONSTANTS DOES NOT ALLOWED
void	err_notarray(void)			SEC(TRASH);
void	err_out_of_range(void)		SEC(TRASH);
void	err_missing_lp(void)		SEC(TRASH);
void	err_missing_sep(void)		SEC(TRASH);
void	err_division_by_zero(void)	SEC(TRASH);
void	err_matop(void)				SEC(TRASH);
void	err_argerr(void)			SEC(TRASH);		// Parameter with wrong value
void	err_stackoverflow(void)		SEC(TRASH);
void	err_stackunderflow(void)	SEC(TRASH);
void	err_arrmis_lp(void)			SEC(TRASH);
void	err_arrmis_rp(void)			SEC(TRASH);
void	err_arridx(void)			SEC(TRASH);
void	err_varisarray(void)		SEC(TRASH);
void	err_varisnotarray(void)		SEC(TRASH);
void	err_vararridx(void)			SEC(TRASH);
void	err_varnotnum(void)	   		SEC(TRASH);
void	err_evsyntax(void)			SEC(TRASH);
void	err_evtype(void)			SEC(TRASH);
void	err_evargerr(void)			SEC(TRASH);
void	err_unsup(void)				SEC(TRASH);
void	err_file(dword code)		SEC(TRASH);
void	err_matsig(void)			SEC(TRASH);
void	err_stridx(void)			SEC(TRASH);
void	err_parfmt(const char *fmt)	SEC(TRASH);
void	err_fopen(void)				SEC(TRASH);
void	err_syntaxanysep(const char *seps)	SEC(TRASH);		// No separator found
void	err_parsepoly(int idx, int mark)	SEC(TRASH);

#define	err_type_mismatch()			err_typemismatch()
#define	err_syntax_error()			err_syntax()

#endif

