/**
*	SmallBASIC, pseudo-compiler structures & globals
*
*	Nicholas Christopoulos
*
*	This program is distributed under the terms of the GPL v2.0 or later
*	Download the GNU Public License (GPL) from www.gnu.org
*/

#if !defined(_sb_scan_h)
#define _sb_scan_h

#include "sys.h"

/*
*	GENERIC KEYWORDS (basic bc-types & oldest code)
*/
struct keyword_s {
	char	name[16];		/* keyword */
	code_t	code;			/* byte-code */
	};

#if !defined(SCAN_MODULE)
extern struct keyword_s keyword_table[];
#endif

/*
*	OPERATORS (not the symbols)
*/
struct opr_keyword_s {
	char	name[16];		/* keyword name */
	code_t	code;
	code_t	opr;
	};

#if !defined(SCAN_MODULE)
extern struct opr_keyword_s opr_table[];
#endif

/*
*	SPECIAL SEPERATORS
*/
struct spopr_keyword_s {
	char	name[16];		/* keyword name */
	code_t	code;
	};

#if !defined(SCAN_MODULE)
extern struct spopr_keyword_s spopr_table[];
#endif

/*
*	BUILDIN-FUNCTIONS
*/
struct func_keyword_s {
	char	name[16];		/* keyword name */
	fcode_t	fcode;			/* keyword code */
	};

#if !defined(SCAN_MODULE)
extern struct func_keyword_s func_table[];
#endif

/*
*	BUILD-IN PROCEDURES
*/
struct proc_keyword_s {
	char	name[16];		/* keyword name */
	pcode_t	pcode;			/* keyword code */
	};

#if !defined(SCAN_MODULE)
extern struct proc_keyword_s proc_table[];
#endif

/*
*	EXTERNAL FUNCTIONS & PROCEDURES
*/
typedef struct {
	char	name[33];		/* keyword name */
	int		lib_id;			/* library id */
	pcode_t	pcode;			/* keyword code */
	} ext_proc_node_t;

typedef struct {
	char	name[33];		/* keyword name */
	int		lib_id;			/* library id */
	fcode_t	fcode;			/* keyword code */
	} ext_func_node_t;

#if !defined(SCAN_MODULE)
extern ext_proc_node_t	*ext_proc_table;
extern int				ext_proc_size;
extern int				ext_proc_count;

extern ext_func_node_t	*ext_func_table;
extern int				ext_func_size;
extern int				ext_func_count;
#endif

/*
*	compiler's 
*/
#if !defined(SCAN_MODULE)
extern int				scan_error;			// error flag
extern int				scan_line;			// source line count (if error, the last text line)
#endif

#endif

