/*
*	strings
*
*	Nicholas Christopoulos, 5/5/2000
*/

#if !defined(_sb_str_h)
#define _sb_str_h

#include "sys.h"

#if defined(__cplusplus)
extern "C" {
#endif

// SJIS
//Begin: Modified by Araiguma
#define IsJIS1Font(x)           (((x) >= 0x81 && (x) <= 0x9f) || ((x) >= 0xe0 && (x) <= 0xef))
#define IsJIS2Font(x)           ((x) >= 0x40 && (x) <= 0xfc)
#define IsJISFont(x)            (IsJIS1Font((x >> 8) & 0xff) && IsJIS2Font(x & 0xff))
// End :  Modified by Araiguma

// Big5
#define IsBig51Font(x)           ((x) >= 0x81 && (x) <= 0xfe)
#define IsBig52Font(x)           (((x) >= 0x40 && (x) <= 0x7e) || ((x) >= 0xa1 && (x) <= 0xfe))
#define IsBig5Font(x)            (IsBig51Font((x >> 8) & 0xff) && IsBig52Font(x & 0xff))

// generic multibyte
#define IsGMB1Font(x)           ((x) >= 0x81 && (x) <= 0xfe)
#define IsGMB2Font(x)           ((x) >= 0x21 && (x) <= 0xff)
#define IsGMBFont(x)            (IsGMB1Font((x >> 8) & 0xff) && IsGMB2Font(x & 0xff))

#define	is_digit(c)	((c) >= 48 && (c) <= 57)
#define	is_upper(c)	((c) >= 65 && (c) <= 90)
#define	is_lower(c)	((c) >= 97 && (c) <= 122)
#define	to_upper(c)	(((c) >= 97 && (c) <= 122) ? (c) - 32 : (c))
#define	to_lower(c)	(((c) >= 65 && (c) <= 90) ? (c) + 32 : (c))
#define	is_hexdigit(c)	(is_digit((c)) || (to_upper((c)) >= 65 && to_upper((c)) <= 70))

int		is_alpha(int ch)				SEC(BCSCAN);
int		is_alnum(int ch)				SEC(BCSCAN);
int		is_space(int ch)				SEC(BCSCAN);
int		is_wspace(int c)				SEC(BCSCAN);
int		is_all_digits(const char *text)	SEC(BCSCAN);
int		is_keyword(const char *name)	SEC(BCSCAN);
int		is_number(const char *str)		SEC(BCSCAN);
#if !defined(_Win32)
char	*strupr(char *str)				SEC(BCSCAN);
#endif
char	*get_keyword(char *text, char *dest)	SEC(BCSCAN);
char	*get_numexpr(char *text, char *dest, int *type, long *lv, double *dv) SEC(BCSCAN);
//char	*get_numexpr(char *text, char *dest)	SEC(BCSCAN);
void	str_alltrim(char *str)			SEC(BCSCAN);

long	bintol(const char *str)			SEC(BCSCAN);
long	octtol(const char *str)			SEC(BCSCAN);
long	hextol(const char *str)			SEC(BCSCAN);
double	strtof(const char *str)			SEC(BCSCAN);
#define	xstrtof(s)	strtof((s))
long	xstrtol(const char *str)		SEC(BCSCAN);
char	*ftostr(double num, char *dest)	SEC(BCSCAN);
char	*ltostr(long num, char *dest)	SEC(BCSCAN);

char	*stristr(const char *s1, const char *s2)							SEC(BCSCAN);
char	*q_strstr(const char *s1, const char *s2, const char *pairs)		SEC(BCSCAN);

#if defined(_PalmOS)
char	*strrchr(const char *source, int ch) SEC(BCSCAN);
#endif

double	numexpr_strtof(char *source) SEC(BCSCAN);
long	numexpr_strtol(char *source) SEC(BCSCAN);

char	*encldup(const char *source, const char *pairs)						SEC(BCSCAN);
char	*discldup(const char *source, const char *pairs, const char *ignpairs)	SEC(BCSCAN);
char	*sqzdup(const char *source)		SEC(BCSCAN);
char	*transdup(const char *src, const char *what, const char *with)	SEC(BCSCAN);
char	*trimdup(const char *str)		SEC(BCSCAN);
char    *chgfilename(char *dest, char *source, char *newdir, char *prefix, char *new_ext, char *suffix) SEC(BCSCAN);
char    *xbasename(char *dest, const char *source) SEC(BCSCAN);

#if defined(_WinBCB)
#define	strncasecmp(a,b,n)	strnicmp(a,b,n)
#endif

#if defined(__cplusplus)
}
#endif

#endif

