/*
*	system
*
*	Nicholas Christopoulos
*/

#if !defined(_sb_sys_h)
#define _sb_sys_h

#if defined(__cplusplus)
extern "C" {
#endif

/*
*	CPU's FLAGS
*	-----------
*
*	CPU_BIGENDIAN  		--- The words are stored reversed; first the low-byte followed by high-byte (Intel x86)
*	CPU_LITTLEENDIAN	--- The words are stored normal; first the high-byte followed by low-byte (Motorola 68K)
*	CPU_CODESEG64K		--- 64KB code size limit
*	CPU_REG16			--- 16bit registers (64KB code|data segments)
*
*	OS FLAGS
*	--------
*	OS_PATHNAME_SIZE	--- Maximum full-path name size (DOS=64,Unix/Win32=1024)
*	OS_FILENAME_SIZE	--- Maximum filename size (DOS=12,Unix/Win32=256)
*	OS_NAME				--- OS name!
*	OS_DIRSEP			--- OS directory separator (unix=/, win=\\)
*	OS_LIMITED			--- Use few resources
*
*	Special flags
*	-------------
*	MALLOC_LIMITED		--- Limited systems without memory handles
*/

#define OS_PREC32
//#define OS_PREC64

// default
#define	OS_ADDR32

//#define MALLOC_LIMITED

#if defined(_PalmOS)
/* ------------------------------------------------------------------------------------ */

/*
*   PalmOS
*/

	#define	CPU_LITTLEENDIAN
	#define	CPU_CODESEG64K

	#define	OS_PATHNAME_SIZE	64
	#define	OS_FILENAME_SIZE	64
	#define	OS_FILEHANDLES		16

	#define	OS_NAME		"PalmOS"
	#define	OS_DIRSEP	'/'

	#define	OS_LIMITED

	#undef	OS_ADDR32
	#define	OS_ADDR16

	// Creator ID
	#define	ID_SmBa		0x536D4261

	// Type IDs
	#define	ID_DATA		0x44415441		// SB's internal
	#define ID_UFST		0x55465354		// User's file ID

	#include <PalmOS.h>
	#include <PalmCompatibility.h>
    #if defined(SONY_CLIE)
	#include "sony_sdk_patch.h"
    #endif
	#include <string.h>
	#include <stdarg.h>
	#include "mathlib.h"

#elif defined(_VTOS)
/* ------------------------------------------------------------------------------------ */

/*
*   Helio: Cygnus-based GCC and MY_STDLIB interface libraries required
*/

	#define	CPU_BIGENDIAN
//	#define	CPU_CODESEG64K

	#undef	OS_ADDR32
	#define	OS_ADDR16

	#define	OS_PATHNAME_SIZE	256
	#define	OS_FILENAME_SIZE	32
	#define	OS_FILEHANDLES		16

	#define	OS_NAME		"VTOS"
	#define OS_VER          0x0103
	#define	OS_DIRSEP	'/'

//	#define	OS_LIMITED

	#include <system.h>
	#include <stdio.h>
	#include <string.h>
	#include <stdarg.h>
	#include <math.h>
	#include "my_stdio.h"
	extern void MessageBox(char *title, char *msg, int fatal);

#elif defined(_FRANKLIN_EBM) 
	#include "franklin.h"
	#include "ebm_object.h"

	#define CPU_LITTLEENDIAN
	#define OS_PATHNAME_SIZE    EBO_LEN_NAME+EBO_LEN_EXT
	#define OS_FILENAME_SIZE    EBO_LEN_NAME
	#define OS_FILEHANDLES      16

	#define OS_NAME     "EBM"
	#define OS_DIRSEP   '/'
	#define OS_LIMITED

	#undef  OS_ADDR32
	#define OS_ADDR16

#elif defined(_DOS) 
/* ------------------------------------------------------------------------------------ */

/*
*   DOS/DJGPP
*/
	#define	CPU_BIGENDIAN

    // use long-filenames for DOS (its works on DJGPP; but only under windows)
    #define _DOS_LFN

    #if defined(_DOS_LFN)
	#define	OS_PATHNAME_SIZE	1024
	#define	OS_FILENAME_SIZE	256
	#define	OS_FILEHANDLES		256
    #else
	#define	OS_PATHNAME_SIZE	256
	#define	OS_FILENAME_SIZE	12
	#define	OS_FILEHANDLES		20
    #endif

	#define	OS_NAME		"DOS32/DJGPP"
//	#define	OS_DIRSEP	'\\'
	#define	OS_DIRSEP	'/'     // djgpp uses /

	#include <stdio.h>
	#include <stdarg.h>
	#include <stdlib.h>
	#include <math.h>
	#include <math.h>
	#include <time.h>
	#include <io.h>
	#include <unistd.h>     // djgpp only
	#include <sys/stat.h>
	#include <fcntl.h>
	#include <dos.h>
#else
/* ------------------------------------------------------------------------------------ */

/*
*   Linux/Win32
*/

	// TODO: check other CPU's
	#define	CPU_BIGENDIAN

	#define	OS_PATHNAME_SIZE	1024
	#define	OS_FILENAME_SIZE	256
	#define	OS_FILEHANDLES		256

	#if defined(_UnixOS)
		#define	OS_NAME		"Unix"
		#define	OS_DIRSEP	'/'
	#elif defined(_Win32)
		#define	OS_NAME		"Win32"
//		#define	OS_DIRSEP	'\\'
		#if defined(_WinBCB)
		#define	OS_DIRSEP	'\\'
	#else
		#define	OS_DIRSEP	'/'
	#endif
	#else
		#define	OS_NAME		"Unknown"
		#define	OS_DIRSEP	'/'
	#endif

	#include <stdio.h>
	#include <stdlib.h>
	#include <stdarg.h>
	#include <math.h>
	#include <math.h>
	#include <time.h>
	#if defined(_UnixOS)
		#include <unistd.h>
	#else
		#include <io.h>
	#endif
	#include <sys/stat.h>
	#include <fcntl.h>
#endif
#if defined(_BCB_W32_IDE)
	#include "win32/bcb.h"
#endif

//#if defined(CPU_REG16) && !defined(CPU_CODESEG64K)
//	#define	CPU_CODESEG64K
//#endif

#if defined(CPU_CODESEG64K)
	#define	SEC(x)	__attribute__((section(#x)))
#else
	#define	SEC(x)	
#endif

#if defined(CPU_BIGENDIAN)	// __i386__
	#define	BS16(x)	((((x) >> 8) & 0xff) | (((x) & 0xff) << 8))
	#define	BS32(x)	((((x) & 0xff000000) >> 24) | (((x) & 0x00ff0000) >>  8) | (((x) & 0x0000ff00) <<  8) | (((x) & 0x000000ff) << 24))
#else
	#define	BS16(x)	(x)
	#define	BS32(x)	(x)
#endif

/*
*	SB's constants
*/

#define	SB_STR_VER		"0.8.1"
#define	SB_DWORD_VER	0x801

#if defined(OS_LIMITED)
	#define	SB_PANICMSG_SIZE	255		
#else
	#define	SB_PANICMSG_SIZE	1023
#endif

#define	SB_KEYWORD_SIZE		32
#if defined(OS_LIMITED)
#define	SB_SOURCELINE_SIZE	511			// compiler - max. text line
#define	SB_TEXTLINE_SIZE	255			// RTL
#else
#define	SB_SOURCELINE_SIZE	4095		// compiler
#define	SB_TEXTLINE_SIZE	1023		// RTL
#endif

#define	SB_EXEC_STACK_SIZE	256			// executor's stack size

// STD MACROS
#define	ABS(x)			( ((x) < 0) ? -(x) : (x) )
#define	SGN(a)			( ((a)<0)? -1 : 0 )
#define	ZSGN(a)			( ((a)<0)? -1 : (((a)>0)? 1 : 0)  )
#define	SWAP(a,b,c)		( (c) = (a), (a) = (b), (b) = (c) )
#define FLOOR(a)        ((a)>0 ? (int)(a) : -(int)(-a))
#define CEILING(a)  	((a)==(int)(a) ? (a) : (a)>0 ? 1+(int)(a) : -(1+(int)(-a)))
#define ROUND(a)        ((a)>0 ? (int)(a+0.5) : -(int)(0.5-a))
#define ISWAP(a,b)		( a^=b, b^=a, a^=b )
#define	I2MIN(a,b)		( ((a) < (b)) ? (a) : (b) )
#define	I2MAX(a,b)		( ((a) > (b)) ? (a) : (b) )
/* clamp the input to the specified range */
#define CLAMP(v,l,h)    ((v)<(l) ? (l) : (v) > (h) ? (h) : v)

//#define ENABLE_VMM
#if !defined(_PalmOS) 
	#include "unx_memmgr.h"	// on MALLOC_LIMITED it is has empty routines
#endif
#include "pmem.h"
#include "panic.h"
#include "str.h"

#if !defined(_PalmOS)
// global command-line args
extern char     **g_argv;
extern int      g_argc;
#endif

/*
*	some stupid differences
*/
#if defined(_PalmOS)
	#define xsprintf	StrPrintF
#else
	#define xsprintf	sprintf
#endif

#if defined(__cplusplus)
}
#endif

#endif



