#include <system.h>
#include <string.h>
#include "my_stdio.h"
#include "../zlib/zlib.h"

static char *version="STDLIB V1.3 - libz.a - setjmp.s - "__DATE__;

// Have a default file available?
#ifdef INCLUDED
#if 0
static unsigned char *zorkname="Sample Text File";
static unsigned char zork[]="\
STDLIB V1.0 - Earle F. Philhower, III - earle@ziplabel.com\r\
December 25, 2001  -  HO HO HO!\r\
http://www.ziplabel.com/helio\r\
\r\
This.is.a.library.that.I.am.using.to.make.my.porting.of.apps \
to the Helio much easier.  The file my_stdio.c implements most \
of the file related functions in stdio.h.  Fnt.c implements \
custom font routines and has 2 fixed-width fonts installed.\
\r\
It's only of use to developers, and I make no guarantees that \
I have all the bugs worked out.   If you find or fix any problems \
feel free to drop me a line!\
\r\
earle@ziplabel.com";
static int zorksz=0;
static int zorkisstring = 1;
#endif
#include "zork2.c"
static unsigned char *zorkname="Zork II";
static unsigned int zorksz=ZS;
static unsigned int zorkisstring = 0;
#endif


#define MAXFILES 32
static MYFILE *open_file[MAXFILES];


void *calloc(int sz, int amnt)
{
  return qmalloc(sz*amnt);
}
void free(void *ptr)
{
  qfree(ptr);
}

static int CommitBank(MYFILE *fp)
{
  Err err;
  DatabaseID 	dbid;
  int bank2save;
  unsigned char dout[3000];
  int outsz;

  if (fp==NULL) return FALSE;
  if (fp->bank==NULL) return FALSE;
  bank2save = 0x80000000 | ((fp->bankoff/2048)+1);
  err=DataFindDB(fp->name, &dbid);
  if (err!=TRUE) return EOF;
  err=DataOpenDB(dbid, 0, OPEN_RW);
  if (err!=TRUE) return EOF;
  err=DataNewRecordWithID(dbid, bank2save, 0, 1);
  if (fp->zdoc) {
    outsz=3000;
    compress(dout, &outsz, fp->bank, 2048);
    err=DataWriteField(dbid, bank2save, 0, outsz, dout);
  } else
    err=DataWriteField(dbid, bank2save, 0, 2048, fp->bank);
  DataCloseRecord(dbid, bank2save);
  DataCloseDB(dbid);
  qfree(fp->bank);
  fp->bank=NULL;
  return TRUE;
}

static int Flush(MYFILE *fp)
{
  DatabaseID dbid;
  Err err;
  char buff[8];

  if (fp==NULL) return EOF;
  if (fp->bank)
    CommitBank(fp);

  err=DataFindDB(fp->name, &dbid);
  if (err!=TRUE) return EOF;
  err=DataOpenDB(dbid, 0, OPEN_RW);
  if (err!=TRUE) return EOF;
  err=DataNewRecordWithID(dbid, 0x80000000, 0, 1);
  buff[0]='Z';
  buff[1]='D';
  buff[2]='O';
  buff[3]='C';
  buff[7] = 255&(fp->maxwrite>>24);
  buff[6] = 255&(fp->maxwrite>>16);
  buff[5] = 255&(fp->maxwrite>>8);
  buff[4] = 255&(fp->maxwrite);
  err=DataWriteField(dbid, 0x80000000, 0, 8, buff);
  DataCloseRecord(dbid, 0x80000000);
  DataCloseDB(dbid);
  return TRUE;
}

static char OverrideType[32]={0};

static int MakeZDOCFile(const char *name, const char *type)
{
  DatabaseID 	dbid;
  char *FileType = "Binary";
  int len;
  Err err;
  char buff[8];

  for(len=0; len<strlen(type); len++)
    if (type[len]=='t') FileType = "Text";

  if (OverrideType[0]) FileType=OverrideType;

  err=DataNewDB(name, 1, FileType, &dbid);
  err=DataOpenDB(dbid, 0, OPEN_RW);
  OverrideType[0] = 0;
  if (err!=TRUE) return EOF;
  err=DataNewRecordWithID(dbid, 0x80000000, 0, 1);
  buff[0]='Z';
  buff[1]='D';
  buff[2]='O';
  buff[3]='C';
  buff[4] = buff[5] = buff[6] = buff[7] = 0;
  err=DataWriteField(dbid, 0x80000000, 0, 8, buff);
  DataCloseRecord(dbid, 0x80000000);
  DataCloseDB(dbid);
  if (err!=TRUE) return EOF;
  return TRUE;
}

static int GetDBLength(const char *name, int *len, int *zdoc, int nozip)
{
  DatabaseID 	dbid;
  unsigned char *bufptr;
  UWORD recbytes, rec_num;
  Err err;
  int id;
  int done;
  UWORD bytes;
  char buff[33];

  strcpy(buff,name);
#ifdef INCLUDED
  // Special case the compiled in one
  if (strcmp(name, zorkname)==0) {
    *zdoc = 0;
    if (zorkisstring) zorksz = strlen(zork);
    *len = zorksz;
    return TRUE;
  }
#endif

  *len = 0;
  *zdoc = 0;
  if (name==NULL) return FALSE;
  err=DataFindDB(buff, &dbid);
  if (err!=TRUE) return FALSE;
  err=DataOpenDB(dbid, 0, OPEN_RO);
  if (err!=TRUE) return FALSE;
  if (nozip==0) {
    rec_num=0x80000000;
    if ((err=DataGetField(dbid, rec_num, 0, (BYTE**)&bufptr, &recbytes))==TRUE) {
      DataCloseRecord(dbid, rec_num);
      if (recbytes==8) {
	if (bufptr[0]=='Z' && bufptr[1]=='D' && bufptr[2]=='O' && bufptr[3]=='C') {
	  bytes = bufptr[7];
	  bytes = (bytes<<8) | (0xff & bufptr[6]);
	  bytes = (bytes<<8) | (0xff & bufptr[5]);
	  bytes = (bytes<<8) | (0xff & bufptr[4]);
	  *len = bytes;
	  *zdoc = 1;
	}
	qfree(bufptr);
	return TRUE;
      } else
	qfree(bufptr);
    } else
      DataCloseRecord(dbid, rec_num);
  }

  bytes = 0;
  id = 0;
  done = 0;
  while (!done) {
    rec_num=(0x80000000 | (1+(id)));
    if ((err=DataGetField(dbid, rec_num, 0, (BYTE**)&bufptr, &recbytes))==TRUE) {
      bytes += recbytes;
      qfree(bufptr);
    } else {
      done = 1;
    }
    DataCloseRecord(dbid, rec_num);
    id++;
  }
  DataCloseDB(dbid);
  *len = bytes;

  return TRUE;
}


static MYFILE *Record(MYFILE *fp)
{
  int i;
  
  if (fp==NULL) return NULL;
  for (i=0;i<MAXFILES;i++) {
    if (open_file[i]==NULL) {
      open_file[i] = fp;
      return fp;
    }
  }
  if (fp->bank) qfree(fp->bank);
  qfree(fp);
  return NULL;
}

static int Destroy(MYFILE *fp)
{
  int i;
  if (fp==NULL) return FALSE;
  for (i=0;i<MAXFILES;i++) {
    if (open_file[i]==fp) {
      open_file[i] = NULL;
      return TRUE;
    }
  }
  return FALSE;
}

void my_cleanup()
{
  int i;
  for (i=0;i<MAXFILES;i++) {
    if (open_file[i]!=NULL) {
      my_fclose(open_file[i]);
    }
  }
}

int my_filetype(const char *type)
{
  if (type==NULL) {
    OverrideType[0]=0;
    return TRUE;
  }
  strncpy(OverrideType, type, 31);
  OverrideType[31] = 0;
  return TRUE;
}

void *my_fopen(const char *name, const char *mode)
{
  MYFILE *ptr;
  int i;
  
  if (name==NULL || mode==NULL)
    return NULL;

  ptr = qmalloc(sizeof(MYFILE));
  if (ptr==NULL) return NULL;
  strcpy(ptr->name, name);
  strcpy(ptr->type, mode);
  if (mode[0]=='w') {
    ptr->write = 1;
    ptr->append = 0;
    ptr->readonly = 0;
    for (i=0; i<strlen(mode); i++) if (mode[i]=='+') ptr->append = 1;
    if (!ptr->append) unlink(name);
    if (GetDBLength(name, &(ptr->size), &(ptr->zdoc), FALSE) != TRUE) {
      MakeZDOCFile(name, mode);
      ptr->zdoc = 1;
      ptr->size = 0;
    }
    OverrideType[0]=0;
    ptr->bank = NULL;
    ptr->bankoff = 0;
    if (ptr->append)
      ptr->maxwrite = ptr->size;
    else
      ptr->maxwrite = 0;
    ptr->curptr = ptr->maxwrite;
    return Record(ptr);
  } else {
    OverrideType[0]=0;
    ptr->write = 0;
    if (GetDBLength(name, &(ptr->size), &(ptr->zdoc), FALSE) != TRUE) {
      qfree(ptr);
      return NULL;
    }
    ptr->curptr = 0;
    ptr->readonly = 1;
    ptr->bank = NULL;
    ptr->bankoff = 0;
    return Record(ptr);
  }
}

int my_fclose(MYFILE *file)
{
  if (file==NULL)
    return EOF;
  if (file->write)
    Flush(file);
  if (file->bank!=NULL)
    qfree(file->bank);
  qfree(file);
  return Destroy(file);
}



int my_fseek(MYFILE *file, int off, int origin)
{
  if (file==NULL)
    return EOF;
  switch(origin) {
  case 0:
    file->curptr = off;
    break;
  case 1:
    file->curptr += off;
    break;
  case 2:
    file->curptr = (file->size) - off;
    break;
  }
  if (file->curptr>file->size) file->curptr = file->size;
  if (file->curptr<0) file->curptr = 0;
  return TRUE;
}

int my_ftell(MYFILE *file)
{
  if (file==NULL)
    return EOF;
  return file->curptr;
}

static void LoadBank(MYFILE *fp)
{
  DatabaseID dbid;
  int delta, rec_num, bank2load;
  unsigned char *bufptr, *ptr;
  int recbytes;
  Err err;

  if (fp==NULL) return;

#ifdef INCLUDED
  if (strcmp(fp->name, zorkname)==0) return;
#endif

  delta = fp->curptr - fp->bankoff;
  if (delta>=0 && delta<2048 && fp->bank!=NULL)
    return;
  bank2load = fp->curptr/2048;
  if (fp->bank) qfree(fp->bank);
  fp->bank = NULL;

  err=DataFindDB(fp->name, &dbid);
  err=DataOpenDB(dbid, 0, OPEN_RO);
  rec_num=(0x80000000 | (1+(bank2load)));
  if ((err=DataGetField(dbid, rec_num, 0, (BYTE**)&bufptr, &recbytes))==TRUE) {
    if (fp->zdoc) {
      int len;
      ptr = qmalloc(2048);
      if (ptr==NULL) {
	qfree(bufptr);
	return;
      }
      len = 2048;
      uncompress(ptr, (uLongf*)&len, bufptr, recbytes);
      qfree(bufptr);
      bufptr = ptr;
    }
    fp->bankoff = 2048 * bank2load;
    fp->bank = bufptr;
  } else {
    if (!fp->readonly) {
      fp->bankoff = 2048 * bank2load;
      fp->bank = qmalloc(2048);
    }
  }
      
  DataCloseRecord(dbid, rec_num);
  DataCloseDB(dbid);


}

static unsigned char OneByte(MYFILE *fp)
{
  unsigned char x;
  int newbank;

  if (fp==NULL) return EOF;

#ifdef INCLUDED
  if (strcmp(fp->name, zorkname)==0) {
    if (fp->curptr<zorksz)
      return zork[fp->curptr++];
    else
      return EOF;
  }
#endif

  if (fp->bank==NULL) return EOF;
  x=fp->bank[fp->curptr-fp->bankoff];
  fp->curptr++;
  newbank = (fp->curptr/2048);
  if (newbank*2048 != fp->bankoff)
    LoadBank(fp);
  return x;
}

int my_fread(unsigned char *buffer, int size, int count, MYFILE *file)
{
  int totxfr;
  int i;
  
  if (file==NULL) return 0;
  if (buffer==NULL) return 0;

  totxfr = 0;
  if (!file->readonly) CommitBank(file);
  LoadBank(file);
  while (count && ((file->curptr+size)<=file->size)) {
    totxfr++;
    for (i=0; i<size; i++)
      *(buffer++) = OneByte(file);
    count--;
  }
  
  return totxfr;
}

static int WriteOneByte(MYFILE *fp, unsigned char chr)
{
  int x, newbank;
  
  if (fp==NULL) return EOF;
  if (fp->bank==NULL)
    LoadBank(fp);
  x=fp->curptr-fp->bankoff;
  if (fp->bank!=NULL) fp->bank[x] = chr;
  else return EOF;
  fp->curptr++;
  newbank = (fp->curptr/2048);
  if (newbank*2048 != fp->bankoff)
    CommitBank(fp);
  return 1;
}

int my_fwrite(const unsigned char *buffer, int size, int count, MYFILE *fp)
{
  int totxfr;
  if (fp==NULL || buffer==NULL) return EOF;

  totxfr = size*count;
  while(totxfr--) 
    WriteOneByte(fp, *(buffer++));
  if (fp->maxwrite<fp->curptr) fp->maxwrite = fp->curptr;
  if (fp->maxwrite>fp->size) fp->size = fp->maxwrite;
  return count;
}

int my_fgetc(MYFILE *file)
{
  if (file==NULL)
    return 0;
  
  if (file->curptr<file->size) {
    if (!file->readonly) CommitBank(file);
    LoadBank(file);
    return OneByte(file);
  }
  
  return EOF;
}

int my_fputc( int c, MYFILE *stream )
{
  char ca;
  ca = (char)(c&255);
  return my_fwrite(&ca, 1, 1, stream);
}


int my_feof(MYFILE *fp)
{
  if (fp==NULL) return TRUE;
  if (fp->curptr<fp->size) return FALSE;
  return TRUE;
}


int my_fsize(MYFILE *fp)
{
  if (fp==NULL) return 0;
  else return fp->size;
}

int my_fsize_true(MYFILE *fp)
{
  int sz, zd;

  if (fp==NULL) return 0;
  sz = 0;
  GetDBLength(fp->name, &sz, &zd, TRUE);
  return sz;
}

int my_unlink(const char *filename)
{
  DatabaseID dbid;

  DataCloseAllDB();
  if (DataFindDB(filename, &dbid)==TRUE) {
    DataCloseAllDB();
    if (DataDeleteDB(dbid)==TRUE) return TRUE;
  }
  return FALSE;
}

int ListAllDBs(unsigned char *owner, int list_id)
{                     
  USHORT i,j, z,vers, items;
  AppID own;
  RTM crdt, bkdt;
  MatInfoList *mat_info;
  BYTE name[80], ownstr[80], *ptr;
  items=0;

#ifdef INCLUDED
  ListInsertItem(list_id, items++, zorkname); // Special-cased
#endif
  mat_info = MemoryGetMatPtr(0);
  for(i=0;i<mat_info[0].total_entry;i++)  {	/* find all database header */
    if((BlockType(mat_info[0].mat[i].attribute) == MAT_BLOCK_DB_REC)) 	{
      DataDBInfo(mat_info[0].mat[i].id, &vers, &own, &crdt, &bkdt, name, ownstr);
      if ((owner!=NULL)?(strncmp(owner, ownstr,32)==0):(1==1)) {
	z=0;
	for (j=0; j<items;j++) {
	  ListGetListItem(list_id, j, &ptr);
	  if (strcmp(ptr, name)>0) {
	    z=1;
	    ListInsertItem(list_id, j, name);
	    j=items;
	  }
	}
	if (z==0)
	  ListInsertItem(list_id, items, name);
	items++;
      }
    }
  }
  return items;
}


// Misc helper functions
int atoi(const char *str)
{
  int x;
  x=0;
  if (str==NULL) return 0;

  while (*str) {
    if (*str>='0' && *str<='9')
      x = x*10 + *str - '0';
    else
      return x;
    str++;
  }
  return x;
}

unsigned long my_time(int ignored)
{
  RTM t;
  unsigned long x;

  RtcGetTime(&t);
  x = t.mday;
  x = x*24 + t.hour;
  x = x*60 + t.min;
  x = x*60 + t.sec;
  return x;
}

