#include <system.h>
#include "docfile.h"
#include "../stdlib/fnt.h"
#define NOREDEFINE
#include "../stdlib/my_stdio.h"


typedef struct HDB_DOC_HEADER_STRUCT
{
  USHORT version;			//HelioDOC version
  USHORT reserved1;		//RFU
  UWORD  uncomp_size;		//total size of doc
  USHORT total_recs;		//number of text records
  USHORT rec_size;		//max size of records
  UWORD  reserved2;		//RFU
} HDBDocHeader;

int IsDocFile(char *name)
{
  DatabaseID dbid;
  RecordID recid;
  HDBDocHeader *hdr;
  UWORD size;

  if (DataFindDB(name, &dbid)!=TRUE) return FALSE;
  if (DataOpenDB(dbid, DB_NO_SORT, OPEN_RO)!=TRUE) return FALSE;
  if (DataOpenRecord(dbid, 0, &recid, NULL)!=TRUE) { DataCloseDB(dbid); return FALSE; }
  if (DataReadField(dbid, recid, 0, 0, READ_TO_END, (BYTE **)&hdr, &size)!=TRUE) { DataCloseDB(dbid); return FALSE; }
  DataCloseDB(dbid);
  if (size!=sizeof(HDBDocHeader)) { qfree(hdr); return FALSE; }
  if (hdr->version==2) {qfree(hdr); return TRUE;}
  qfree(hdr);
  return FALSE; 
}


int doc_decode(DOCFILE *fp, int num);

DOCFILE *doc_fopen(char *name, char *mode) //mode ignored
{
  DOCFILE *fp;
  RecordID recid;
  HDBDocHeader *hdr;
  UWORD size;
  int i;

  fp = qmalloc(sizeof(DOCFILE));
  if (fp==NULL) return NULL;
  memset(fp, 0, sizeof(DOCFILE));
  strcpy(fp->name, name);
  DataFindDB(name, &fp->dbid);
  DataOpenDB(fp->dbid, DB_NO_SORT, OPEN_RO);
  DataOpenRecord(fp->dbid, 0, &recid, NULL);
  DataReadField(fp->dbid, recid, 0, 0, READ_TO_END, (BYTE **)&hdr, &size);
  DataCloseDB(fp->dbid);
  fp->baserec = recid;
  fp->totalrecs=hdr->total_recs;
  fp->startptr=qmalloc(sizeof(int)*fp->totalrecs);
  if (fp->startptr==NULL) {
    qfree(fp);
    return NULL;
  }
  fp->startptr[0] = 0;
  for (i=1; i<fp->totalrecs; i++)
      fp->startptr[i]=fp->startptr[i-1]+doc_decode(fp, i-1);
  fp->size=fp->startptr[fp->totalrecs-1]+doc_decode(fp, fp->totalrecs-1);
  fp->bankrec=-1;
  qfree(hdr);
  return fp;
}

void doc_fclose(DOCFILE *fp)
{
  if (fp==NULL) return;
  if (fp->startptr) qfree(fp->startptr);
  qfree(fp);
}

int doc_fseek(DOCFILE *file, int off, int origin)
{
  if (file==NULL)
    return EOF;

  switch(origin) {
  case 0:
    file->curptr = off;
    break;
  case 1:
    file->curptr += off;
    break;
  case 2:
    file->curptr = (file->size) - off;
    break;
  }
  if (file->curptr>file->size) file->curptr = file->size;
  if (file->curptr<0) file->curptr = 0;

  return TRUE;
}


int doc_ftell(DOCFILE *fp)
{
  if (fp==NULL) return EOF;
  else return fp->curptr;
}

int doc_feof(DOCFILE *fp)
{
  if (fp==NULL) return TRUE;
  if (fp->curptr<fp->size) return FALSE;
  return TRUE;
}  

int doc_fsize(DOCFILE *fp)
{
  if (fp==NULL) return 0;
  else return fp->size;
}

static void doc_LoadBank(DOCFILE *fp)
{
  int i;

  if (fp==NULL) return;
  if (fp->bankrec!=-1 && fp->bankoff<=fp->curptr && (fp->bankoff+fp->banklen)>fp->curptr) return;

  for (i=fp->totalrecs-1; i>0;i--)
    if (fp->startptr[i]<=fp->curptr) break;
  doc_decode(fp, i);
  fp->bankoff = fp->startptr[i];
}

static int doc_OneByte(DOCFILE *fp)
{
  int x;
  
  if (fp==NULL) return EOF;
  doc_LoadBank(fp);
  x=fp->bank[fp->curptr-fp->bankoff];
  fp->curptr++;
  if (fp->curptr>fp->size) fp->curptr = fp->size;
  if (fp->hasungetc) {
    x = fp->ungetc;
    fp->hasungetc = 0;
  }
  return x;
}

int doc_fgetc(DOCFILE *fp)
{
  if (fp==NULL)
    return 0;
  
  if (fp->curptr<fp->size) {
    return doc_OneByte(fp);
  }
  return EOF;
}

int doc_fread(unsigned char *buffer, int size, int count, DOCFILE *file)
{
  int totxfr;
  int i;
  
  if (file==NULL) return 0;
  if (buffer==NULL) return 0;

  totxfr = 0;
  doc_LoadBank(file);
  while (count && ((file->curptr+size)<=file->size)) {
    totxfr++;
    for (i=0; i<size; i++)
      *(buffer++) = doc_OneByte(file);
    count--;
  }
  
  return totxfr;
}

int doc_ungetc(unsigned char c, DOCFILE *fp)
{
  if (fp==NULL) return EOF;
  if (fp->hasungetc) return EOF;
  if (fp->curptr<1) return EOF;
  fp->curptr--;
  fp->hasungetc=1;
  fp->ungetc = c;
  
  return TRUE;
}



int doc_decode(DOCFILE *fp, int num)
{
  unsigned char* fromTooFar;
  unsigned char* toTooFar;
  unsigned char* decodeStart;
  unsigned int c;
  // old inputs
  unsigned char* decodeTo;
  unsigned char* decodeFrom, *real;
  int decodeFromLen;
  int maxDecodeLen;

  // These are used only in B commands
  int     windowLen;
  int     windowDist;
  unsigned char* windowCopyFrom;
  RecordID recid;
  Err err;
  UWORD recnum;

  DataOpenDB(fp->dbid, DB_NO_SORT, OPEN_RO);
  DataRecIDtoNum(fp->dbid, fp->baserec+num+1,&recnum);
  err = DataOpenRecord(fp->dbid, recnum , &recid, NULL);
  DataReadField(fp->dbid, recid, 0, 0, READ_TO_END, (BYTE **)&decodeFrom, (UWORD*) &decodeFromLen);
  DataCloseDB(fp->dbid);
  decodeTo = fp->bank;
  maxDecodeLen = 5000;
  real = decodeFrom;
  if(err!=TRUE) return 0;

  fromTooFar  = &decodeFrom[decodeFromLen];
  toTooFar = &decodeTo[maxDecodeLen];
  decodeStart = decodeTo;

  while(decodeFrom < fromTooFar && decodeTo < toTooFar)
    {
      c = *(decodeFrom++);

      // type C command (space + char)
      if (c >= 0xC0)
        {
	  *(decodeTo++)=' ';
	  if (decodeTo < toTooFar)
	    *(decodeTo++)=c & 0x7F;
        }
      // type B command (sliding window sequence)
      else if (c >= 0x80)
        {
	  // Move this to high bits and read low bits
	  c = (c<<8) | *(decodeFrom++);
	  // 3 + low 3 bits (Beirne's 'n'+3)
	  windowLen = 3 + (c & 0x7);
	  // next 11 bits (Beirne's 'm')
	  windowDist = (c >> 3) & 0x07FF;
	  windowCopyFrom = decodeTo - windowDist;

	  windowLen = min(windowLen, toTooFar - decodeTo);
	  while(windowLen--)
	    *(decodeTo++) = *(windowCopyFrom++);
        }
      //self-representing, no command.
      else if (c >= 0x09)
        {
	  *(decodeTo++)=c;
        }
      //type A command (next c chars are literal)
      else if (c >= 0x01)
        {
	  c = min(c, toTooFar - decodeTo);
	  while(c--)
	    *(decodeTo++) = *(decodeFrom++);
        }
      //c == 0, also self-representing
      else
        {
	  *(decodeTo++)=c;
        }
    }

  qfree(real);
  fp->bankrec = num;
  fp->banklen = decodeTo - decodeStart;
  if (num>0)
    fp->bankoff = fp->startptr[num-1];
  else
    fp->bankoff = 0;
  return decodeTo - decodeStart;
}
