#include <system.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "res\resource.h"
#include "../stdlib/my_stdio.h"
#include "../stdlib/fnt.h"
#include "main.h"
#include "docfile.h"

char savename[64];
int savesmall = 0;
int savego = 0;

void LoadPrefs();
void SavePrefs();
int CheckResumeFile();
void FontChanged();
void ListHilightItem(int id, int item);
void ListHilightString(int id, char *str);


int CheckResumeFile()
{
  FILE *file;

  savename[0]=0;
  file = fopen("TextViewResume","rb");
  if (file) {
    fread(savename, 1, 64, file);
    fclose(file);
  }
  unlink("TextViewResume");
  
  if (savename[0]) {
    file = fopen(savename,"rb");
    if (!file) savename[0] = 0;
    else fclose(file);
  }
  return savename[0];
}
int wenttosearch=-1;
int wenttotoc=-1;

BOOLEAN FormIfaceHandleEvent(EvtType* Event)
{
  SHORT item;
  BYTE *ptr;
  ObjectID objid;
  char buff[100];

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    LoadPrefs();
    wenttosearch=-1;
    wenttotoc=-1;
    if (CheckResumeFile()) {
      SavePrefs();
      savego=1;
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
    } else {
      FormDrawForm(Event->eventID);
      ListDeleteAllItems(LIST_IFACE);
      ListAllDBs(pref.filetype[0]==0?NULL:pref.filetype, LIST_IFACE);
      if (!strcmp(pref.filetype,"Text")) 
	ListAllDBs("<", LIST_IFACE);

      ListSetSelectedItem(LIST_IFACE, NO_SELECTION);
      ListDrawList(LIST_IFACE);
    }
    break;

  case EVT_MENU_SELECT_ITEM:
    if (Event->para1==0) FormPopupForm(FORM_TYPE);
    else if (Event->para1==1) FormPopupForm(FORM_ABOUT);
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(Event->eventID, Event->para1);
    ListSetHighlightedItem(Event->eventID, Event->para1);
    ListDrawList(Event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      ListGetTotalItems(LIST_IFACE, &item);
      if (item==0) break;
      ListGetSelectedItem(LIST_IFACE, &item);
      if (item == NO_SELECTION) return TRUE;
      ListGetListItem(LIST_IFACE, item, (BYTE **)&ptr);
      strcpy(savename, ptr);
      savego = 1;
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      SavePrefs();
      FormPopupForm(FORM_MAIN);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      SavePrefs();
      FormGotoApp("Mainmenu");
      savego = 0;
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    ListGetTotalItems(LIST_IFACE, &item);
    if (item==0) break;
    ListGetSelectedItem(LIST_IFACE, &item);
    if (item == NO_SELECTION) return TRUE;
    ListGetListItem(LIST_IFACE, item, (BYTE **)&ptr);
    switch (Event->eventID) {
    case OPEN_BUTTON:
      strcpy(savename, ptr);
      savesmall = 0;
      savego = 1;
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    case INFO_BUTTON:
      strcpy(savename, ptr);
      FormPopupForm(FORM_INFO);
      break;
    case DELETE_BUTTON:
      unlink(ptr);
      sprintf(buff,"BMs.%s",savename);
      unlink(buff);
      sprintf(buff,"TOC.%s",savename);
      unlink(buff);
      ListDeleteAllItems(LIST_IFACE);
      ListAllDBs(pref.filetype[0]==0?NULL:pref.filetype, LIST_IFACE);
      if (!strcmp(pref.filetype,"Text")) 
	ListAllDBs("<", LIST_IFACE);
      ListSetSelectedItem(LIST_IFACE, NO_SELECTION);
      ListDrawList(LIST_IFACE);
      break;
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}


void TypeOK()
{
  BYTE *text_ptr;

  TextboxGetTextPointer(TEXT_TYPE, &text_ptr);
  TextboxSetInsertPointOff(TEXT_TYPE);
  FormRestoreBitBehind(FORM_TYPE);
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_TYPE, 0, 0, NULL);
  if (strcmp(pref.oldtype1, text_ptr) && strcmp(pref.oldtype2, text_ptr) &&
      strcmp(pref.oldtype3, text_ptr) && strcmp(pref.oldtype4, text_ptr) &&
      strlen(text_ptr) ) {
    strcpy(pref.oldtype4, pref.oldtype3);
    strcpy(pref.oldtype3, pref.oldtype2);
    strcpy(pref.oldtype2, pref.oldtype1);
    strcpy(pref.oldtype1, text_ptr);
  }
  strcpy(pref.filetype, text_ptr);
  SavePrefs();
  FormPopupForm(FORM_IFACE);
}

BOOLEAN FormTypeHandleEvent(EvtType* Event)
{
  SHORT item;
  BYTE *ptr;

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    // Setup the old filetype menu
    ControlPopupDeleteAllItems(TYPE_POPLIST);
    ControlPopupInsertItem( TYPE_POPLIST, 0, "Types..." );
    if (pref.oldtype1[0])
      ControlPopupInsertItem( TYPE_POPLIST, 1, pref.oldtype1 );
    if (pref.oldtype2[0])
      ControlPopupInsertItem( TYPE_POPLIST, 2, pref.oldtype2 );
    if (pref.oldtype3[0])
      ControlPopupInsertItem( TYPE_POPLIST, 3, pref.oldtype3 );
    if (pref.oldtype4[0])
      ControlPopupInsertItem( TYPE_POPLIST, 4, pref.oldtype4 );
    ControlPopupSetSelectedItem(TYPE_POPLIST, 0);
    StippleBackground();
    FormSaveBehindBits(Event->eventID);
    FormDrawForm(Event->eventID);
    TextboxSetText(TEXT_TYPE, pref.filetype);
    TextboxSetInsertPointPositionByCharPos(TEXT_TYPE, strlen(pref.filetype));
    TextboxSetInsertPointOn(TEXT_TYPE);
    TextboxDrawTextbox(TEXT_TYPE);
    FormObjectSetFocus(TEXT_TYPE);
    break;
    
  case EVT_CONTROL_POPUP_SELECT:
    ControlPopupGetSelectedItem(TYPE_POPLIST, &item);
    if (item==0 || item==NO_SELECTION) break;
    ControlPopupGetPopupItem(TYPE_POPLIST, item, &ptr);
    TextboxSetText(TEXT_TYPE, ptr);
    TypeOK();
    break;

  case EVT_KEY:
    if (Event->eventID == SOFT_KEY) {	
      if ((BYTE)(Event->para1) == 13)
	TypeOK();
      else
	TextboxAddKeyInChar(TEXT_TYPE, (BYTE)(Event->para1));
    }
    return TRUE;
    break;

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      TypeOK();
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      TextboxSetInsertPointOff(TEXT_TYPE);
      FormRestoreBitBehind(FORM_TYPE);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_TYPE, 0, 0, NULL);
      FormPopupForm(FORM_IFACE);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}

void LineOK()
{
  BYTE *text_ptr;
  int line;

  TextboxGetTextPointer(TEXT_LINE, &text_ptr);
  line = atoi(text_ptr);
  GotoLine(line, -1);
  TextboxSetInsertPointOff(TEXT_LINE);
  FormRestoreBitBehind(FORM_LINE);
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_LINE, 0, 0, NULL);
  FormPopupForm(FORM_MAIN);
}
 

BOOLEAN FormLineHandleEvent(EvtType* Event)
{
  char buff[64];

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    StippleBackground();
    sprintf(buff, "%d", topline+curline);
    FormSaveBehindBits(Event->eventID);
    FormDrawForm(Event->eventID);
    TextboxSetText(TEXT_LINE, buff);
    TextboxSetInsertPointPositionByCharPos(TEXT_LINE, strlen(buff));
    TextboxSetInsertPointOn(TEXT_LINE);
    TextboxDrawTextbox(TEXT_LINE);
    FormObjectSetFocus(TEXT_LINE);
    break;
	
  case EVT_KEY:
    if (Event->eventID == SOFT_KEY) {	
      if ((BYTE)(Event->para1) == 13)
	LineOK();
      else
	TextboxAddKeyInChar(TEXT_LINE, (BYTE)(Event->para1));
    }
    return TRUE;
    break;

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      LineOK();
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      TextboxSetInsertPointOff(TEXT_LINE);
      FormRestoreBitBehind(FORM_LINE);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_LINE, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}


BOOLEAN FormInfoHandleEvent(EvtType* Event)
{
  char buff[128], buff2[128];
  FILE *fp;

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(Event->eventID);
    ListDeleteAllItems(LIST_INFO);
    FormDrawForm(Event->eventID);
    ListInsertItem(LIST_INFO, 0, savename);
    fp = fopen(savename, "rb");
    sprintf(buff, "Text Size: %d", fsize(fp));
    ListInsertItem(LIST_INFO, 1, buff);    
    sprintf(buff, "Memory Size: %d", fsize_true(fp));
    ListInsertItem(LIST_INFO, 2, buff);
    fclose(fp);
    sprintf(buff,"BMs.%s",savename);
    fp = fopen(buff,"rb");
    if (fp) {
      sprintf(buff,"Bookmarks: %d  -  ", fsize(fp)/sizeof(Bookmark));
      fclose(fp);
    } else buff[0] = 0;
    sprintf(buff2,"TOC.%s",savename);
    fp = fopen(buff2, "rb");
    if (fp) {
      sprintf(buff2, "%sTOC Present", buff);
      fclose(fp);
    } else
      sprintf(buff2, "%sTOC Not Present", buff);
    ListInsertItem(LIST_INFO, 3, buff2);
    ListSetSelectedItem(LIST_INFO, 0);
    ListDrawList(LIST_INFO);
    break;
	

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormRestoreBitBehind(FORM_INFO);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_INFO, 0, 0, NULL);
      FormPopupForm(FORM_IFACE);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}



BOOLEAN FormAboutHandleEvent(EvtType* Event)
{
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    StippleBackground();
    ListSetSelectedItem(LIST_ABOUT, NO_SELECTION);
    FormSaveBehindBits(Event->eventID);
    FormDrawForm(Event->eventID);
    break;
	

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormRestoreBitBehind(FORM_ABOUT);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_ABOUT, 0, 0, NULL);
      FormPopupForm(FORM_IFACE);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}

void SavePrefs()
{
  FILE *fp;
  filetype("TextView Binary");
  fp=fopen("TextViewPrefs1.5","wb");
  fwrite(&pref, 1, sizeof(Pref), fp);
  fclose(fp);
}

void LoadPrefs()
{
  FILE *fp;
  strcpy(pref.filetype, "Text");
  pref.byline = 1;
  pref.status = 1;
  pref.font = 0;
  pref.justified=0;
  strcpy(pref.oldtype1, "Binary");
  pref.oldtype2[0] = pref.oldtype3[0] = pref.oldtype4[0] = 0;
  pref.oldsearch1[0] = pref.oldsearch2[0] = pref.oldsearch3[0] =
    pref.oldsearch4[0] = 0;
  pref.casesensitive = 0;
  fp = fopen("TextViewPrefs1.5","rb");
  if(fp==NULL) return;
  if (fsize(fp)==sizeof(Pref)) fread(&pref, 1, sizeof(Pref), fp);
  fclose(fp);
}

int bookmarks = 0;
Bookmark *bookmark = NULL;

void ListBookmarks(int id, char *name)
{
  int x;
  char buff[128];
  FILE *fp;

  bookmarks = 0;
  if (bookmark) qfree(bookmark);
  bookmark = NULL;
  ListDeleteAllItems(id);

  sprintf(buff,"BMs.%s",savename);
  fp = fopen(buff,"rb");
  if (fp) {
    bookmarks = fsize(fp)/sizeof(Bookmark);
    bookmark = qmalloc(1+fsize(fp));
    if (!bookmark) {
      ListInsertItem(id, 0, "Out Of Memory...");
      ListSetSelectedItem(id, NO_SELECTION);
      ListDrawList(id);
      fclose(fp);
      return;
    }
    fread(bookmark, 1, fsize(fp), fp);
    fclose(fp);
  }
  for (x=0; x<bookmarks; x++) {
    sprintf(buff, "%s (at %d)", bookmark[x].name, bookmark[x].offset);
    ListInsertItem(id, x, buff);
  }
  
  ListSetSelectedItem(id, NO_SELECTION);
  ListDrawList(id);
}

void DeleteBookmark(int item)
{
  Bookmark *ptr;
  char buff[256];
  FILE *fp;
  int x, y;

  sprintf(buff,"BMs.%s",savename);
  if (bookmarks<=1) {
    if (bookmark) qfree(bookmark);
    bookmark = NULL;
    bookmarks = 0;
    unlink(buff);
  } else {
    ptr = qmalloc((bookmarks-1)*sizeof(Bookmark));
    if (!ptr) return;
    for (x=0, y=0; x<bookmarks; x++)
      if(item!=x) memcpy(&(ptr[y++]), &(bookmark[x]), sizeof(Bookmark));
    bookmarks--;
    qfree(bookmark);
    bookmark = ptr;
    filetype("TextView Bookmark");
    fp = fopen(buff,"wb");
    if (fp) {
      fwrite(bookmark, sizeof(Bookmark), bookmarks, fp);
      fclose(fp);
    }
  }
}

void GotoBookmark(int item)
{
  GotoLine(-1, bookmark[item].offset);
}


BOOLEAN FormBookmarkHandleEvent(EvtType* Event)
{
  SHORT item;
  ObjectID objid;
	
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    FormDrawForm(Event->eventID);
    ListBookmarks(LIST_BOOKMARK, savename);
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(Event->eventID, Event->para1);
    ListSetHighlightedItem(Event->eventID, Event->para1);
    ListDrawList(Event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      ListGetTotalItems(LIST_BOOKMARK, &item);
      if (item==0) break;
      ListGetSelectedItem(LIST_BOOKMARK, &item);
      if (item == NO_SELECTION) return TRUE;
      GotoBookmark(item);
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormPopupForm(FORM_MAIN);
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    if (Event->eventID==ADD_BOOKMARK) {
      FormPopupForm(FORM_ADDBOOKMARK);
      break;
    }
    ListGetTotalItems(LIST_BOOKMARK, &item);
    if (item==0) break;
    ListGetSelectedItem(LIST_BOOKMARK, &item);
    if (item == NO_SELECTION) return TRUE;
    switch (Event->eventID) {
    case OPEN_BOOKMARK:
      GotoBookmark(item);
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    case DELETE_BOOKMARK:
      DeleteBookmark(item);
      ListBookmarks(LIST_BOOKMARK, savename);
      break;
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}


void AddBookmark()
{
  BYTE *text_ptr;
  Bookmark *ptr;
  char buff[256];
  extern FILE *fp;
  extern DOCFILE *dfp;
  FILE *bmf;

  sprintf(buff,"BMs.%s",savename);
  TextboxGetTextPointer(TEXT_ADDBOOKMARK, &text_ptr);
  TextboxSetInsertPointOff(TEXT_ADDBOOKMARK);
  FormRestoreBitBehind(FORM_ADDBOOKMARK);
  if (text_ptr[0]) {
    ptr = qmalloc((bookmarks+1)*sizeof(Bookmark));
    if (!ptr) return;
    if (bookmark) memcpy(ptr, bookmark, bookmarks*sizeof(Bookmark));
    if (bookmark) qfree(bookmark);
    bookmark = ptr;
    bookmark[bookmarks].offset = FTELL();
    strncpy(bookmark[bookmarks].name, text_ptr, 35);
    bookmark[bookmarks].name[35] = 0;
    bookmarks++;
    filetype("TextView Bookmark");
    bmf=fopen(buff,"wb");
    if (bmf) {
      fwrite(bookmark, sizeof(Bookmark), bookmarks, bmf);
      fclose(bmf);
    }
  }
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_ADDBOOKMARK, 0, 0, NULL);
  FormPopupForm(FORM_MAIN);
}
 

BOOLEAN FormAddBookmarkHandleEvent(EvtType* Event)
{
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    FormSaveBehindBits(Event->eventID);
    FormDrawForm(Event->eventID);
    TextboxSetText(TEXT_ADDBOOKMARK, "");
    TextboxSetInsertPointPositionByCharPos(TEXT_ADDBOOKMARK, 0);
    TextboxSetInsertPointOn(TEXT_ADDBOOKMARK);
    TextboxDrawTextbox(TEXT_ADDBOOKMARK);
    FormObjectSetFocus(TEXT_ADDBOOKMARK);
    break;
	
  case EVT_KEY:
    if (Event->eventID == SOFT_KEY) {	
      if ((BYTE)(Event->para1) == 13)
	AddBookmark();
      else
	TextboxAddKeyInChar(TEXT_ADDBOOKMARK, (BYTE)(Event->para1));
    }
    return TRUE;
    break;

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      AddBookmark();
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      TextboxSetInsertPointOff(TEXT_ADDBOOKMARK);
      FormRestoreBitBehind(FORM_ADDBOOKMARK);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_LINE, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}

void ChangeToFont(char *str) {
  if (strcmp(str, "Small Proportional Font")==0) pref.font = smallFont;
  else if (strcmp(str, "Standard Proportional Font")==0) pref.font = stdFont;
  else if (strcmp(str, "Small Fixed Font")==0) pref.font = smallFixedFont;
  else if (strcmp(str, "Standard Fixed Font")==0) pref.font = stdFixedFont;
  else {
    pref.font = userFont;
    strcpy(pref.fontname, str);
  }
  SavePrefs();
  FontChanged();
}

void ListHilightString(int id, char *str)
{
  USHORT items;
  int i;
  BYTE *ptr;
  SHORT viewnum, total;
  int topnum, listsel;

  ListGetNumOfItems(id, &items);
  for (i=0; i<items; i++) {
    ListGetListItem(id, i, &ptr);
    if (!strcmp(ptr, str)) {
      ListGetNumItemsDisplay(id, &viewnum);
      ListGetTotalItems(id, &total);
      if (i>=total) i=0;
      if (i<0) i=total-1;
      listsel=i;
      ListSetSelectedItem(id, listsel);
      ListSetHighlightedItem(id, listsel);

      topnum=listsel-(viewnum/2)+1;
      if (topnum<0) topnum=0;

      if (topnum+viewnum>total) {
	topnum=total-viewnum;
	if (topnum<0) topnum=listsel;
      }
      ListSetTopItemNum(id,topnum);
      return;
    }
  }
}

BOOLEAN FormFontHandleEvent(EvtType* Event)
{
  SHORT item;
  BYTE *ptr;
  ObjectID objid;
	
  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    LoadPrefs();
    FormDrawForm(Event->eventID);
    ListDeleteAllItems(LIST_FONT);
    ListAllDBs("FontPDB", LIST_FONT);
    ListInsertItem(LIST_FONT, 0, "Small Proportional Font");
    ListInsertItem(LIST_FONT, 1, "Standard Proportional Font");
    ListInsertItem(LIST_FONT, 2, "Small Fixed Font");
    ListInsertItem(LIST_FONT, 3, "Standard Fixed Font");
    ListSetSelectedItem(LIST_FONT, NO_SELECTION);
    ListDrawList(LIST_FONT);
    if (pref.font<=3) {
      ListSetSelectedItem(LIST_FONT, pref.font);
      ListSetHighlightedItem(LIST_FONT, pref.font);
    } else ListHilightString(LIST_FONT, pref.fontname);
    ListDrawList(LIST_FONT);
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(Event->eventID, Event->para1);
    ListSetHighlightedItem(Event->eventID, Event->para1);
    ListDrawList(Event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      ListGetTotalItems(LIST_FONT, &item);
      if (item==0) break;
      ListGetSelectedItem(LIST_FONT, &item);
      if (item == NO_SELECTION) return TRUE;
      ListGetListItem(LIST_FONT, item, (BYTE **)&ptr);
      ChangeToFont(ptr);
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormPopupForm(FORM_MAIN);
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    ListGetTotalItems(LIST_FONT, &item);
    if (item==0) break;
    ListGetSelectedItem(LIST_FONT, &item);
    if (item == NO_SELECTION) return TRUE;
    ListGetListItem(LIST_FONT, item, (BYTE **)&ptr);
    switch (Event->eventID) {
    case OPEN_FONT:
      ChangeToFont(ptr);
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    case DELETE_FONT:
      if (unlink(ptr)) {
	EvtAppendEvt(EVT_FORM_CLOSE, FORM_FONT, 0, 0, NULL);
	FormPopupForm(FORM_FONT);
      }
      break;
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}
void SetCheckbox(ObjectID itemID, int value) {
   Control *itemPTR;
   Err      found;
   BYTE     objectType;

   found = UISearchForAddress(itemID, &objectType, (void *) &itemPTR);
   if (found) {
      ((ControlTemplateCheckBox*) (itemPTR->control_template))->control_value = value;
      ControlDrawControl(itemID);
   }
}

int GetCheckbox(ObjectID itemID)
{
  Control *itemPTR;
   Err      found;
   BYTE     objectType;

   found = UISearchForAddress(itemID, &objectType, (void *) &itemPTR);
   if (found) {
      return ((ControlTemplateCheckBox*) (itemPTR->control_template))->control_value;
   }
   return FALSE;
}

char lastsearch[64]={0};
void SearchWordOK()
{
  BYTE *text_ptr;

  TextboxGetTextPointer(TEXT_SEARCHWORD, &text_ptr);
  if (strcmp(pref.oldsearch1, text_ptr) && strcmp(pref.oldsearch2, text_ptr) &&
      strcmp(pref.oldsearch3, text_ptr) && strcmp(pref.oldsearch4, text_ptr) &&
      strlen(text_ptr) ) {
    strcpy(pref.oldsearch4, pref.oldsearch3);
    strcpy(pref.oldsearch3, pref.oldsearch2);
    strcpy(pref.oldsearch2, pref.oldsearch1);
    strcpy(pref.oldsearch1, text_ptr);
  }
  strcpy(lastsearch, text_ptr);
  pref.casesensitive = GetCheckbox(CASE_CHECK);
  TextboxSetInsertPointOff(TEXT_SEARCHWORD);
  FormRestoreBitBehind(FORM_SEARCHWORD);
  EvtAppendEvt(EVT_FORM_CLOSE, FORM_SEARCHWORD, 0, 0, NULL);
  if (strlen(lastsearch)<1)
    FormPopupForm(FORM_MAIN);
  else
    FormPopupForm(FORM_SEARCH);
}


void SettingsOK(int gotomain)
{
  SHORT item;

  pref.status = GetCheckbox(CHECK_STATUS)?1:0;
  pref.justified = GetCheckbox(CHECK_JUSTIFIED)?1:0;
  ControlPopupGetSelectedItem(POPUP_SCROLLBY, &item);
  if (item==NO_SELECTION) item=0;
  pref.byline=item?0:1;
  SavePrefs();
  if (gotomain) {
    EvtAppendEvt(EVT_FORM_CLOSE, FORM_SETTINGS, 0, 0, NULL);
    FormPopupForm(FORM_MAIN);
  }
}

BOOLEAN FormSettingsHandleEvent(EvtType* Event)
{

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    StippleBackground();
    ControlPopupSetSelectedItem(POPUP_SCROLLBY, pref.byline?0:1);
    SetCheckbox(CHECK_STATUS, pref.status?1:0);
    SetCheckbox(CHECK_JUSTIFIED, pref.justified?1:0);
    FormDrawForm(Event->eventID);
    break;

  case EVT_CONTROL_SELECT:
    if (Event->eventID==BUTTON_CHANGEFONT) {
      SettingsOK(0);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_SETTINGS, 0, 0, NULL);
      FormPopupForm(FORM_FONT);
    } else if (Event->eventID==SETTINGS_OK) {
      SettingsOK(1);
    } else if (Event->eventID==SETTINGS_CANCEL) {
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_SETTINGS, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
    }
    break;
	
  case EVT_CONTROL_POPUP_SELECT:
    ControlDrawControl(POPUP_SCROLLBY);
    break;

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      SettingsOK(1);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_SETTINGS, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}




BOOLEAN FormSearchWordHandleEvent(EvtType* Event)
{
  SHORT item;
  BYTE *ptr;

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    // Setup the old filetype menu
    ControlPopupDeleteAllItems(SEARCH_POPLIST);
    ControlPopupInsertItem(SEARCH_POPLIST, 0, "Previous Searches...");
    if (pref.oldsearch1[0])
      ControlPopupInsertItem(SEARCH_POPLIST, 1, pref.oldsearch1);
    if (pref.oldsearch2[0])
      ControlPopupInsertItem(SEARCH_POPLIST, 2, pref.oldsearch2);
    if (pref.oldsearch3[0])
      ControlPopupInsertItem(SEARCH_POPLIST, 3, pref.oldsearch3);
    if (pref.oldsearch4[0])
      ControlPopupInsertItem(SEARCH_POPLIST, 4, pref.oldsearch4);
    ControlPopupSetSelectedItem(SEARCH_POPLIST, 0);
    SetCheckbox(CASE_CHECK, pref.casesensitive);
    StippleBackground();
    FormSaveBehindBits(Event->eventID);
    FormDrawForm(Event->eventID);
    TextboxSetText(TEXT_SEARCHWORD, lastsearch);
    TextboxSetInsertPointPositionByCharPos(TEXT_SEARCHWORD, strlen(lastsearch));
    TextboxSetInsertPointOn(TEXT_SEARCHWORD);
    TextboxDrawTextbox(TEXT_SEARCHWORD);
    FormObjectSetFocus(TEXT_SEARCHWORD);
    break;
	
    
  case EVT_CONTROL_POPUP_SELECT:
    ControlPopupGetSelectedItem(SEARCH_POPLIST, &item);
    if (item==0 || item==NO_SELECTION) break;
    ControlPopupGetPopupItem(SEARCH_POPLIST, item, &ptr);
    TextboxSetInsertPointOff(TEXT_SEARCHWORD);
    TextboxSetText(TEXT_SEARCHWORD, "");
    TextboxSetLeftCharPos(TEXT_SEARCHWORD, 0);
    TextboxSetRightCharPos(TEXT_SEARCHWORD, 0);
    TextboxDrawTextbox(TEXT_SEARCHWORD);
    TextboxSetText(TEXT_SEARCHWORD, ptr);
    TextboxSetInsertPointPositionByCharPos(TEXT_SEARCHWORD, strlen(ptr));
    TextboxSetInsertPointOn(TEXT_SEARCHWORD);
    TextboxDrawTextbox(TEXT_SEARCHWORD);
    ControlPopupSetSelectedItem(SEARCH_POPLIST, 0);
    ControlDrawControl(SEARCH_POPLIST);
    break;

  case EVT_KEY:
    if (Event->eventID == SOFT_KEY) {	
      if ((BYTE)(Event->para1) == 13)
	SearchWordOK();
      else
	TextboxAddKeyInChar(TEXT_SEARCHWORD, (BYTE)(Event->para1));
    }
    return TRUE;
    break;

  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      SearchWordOK();
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      TextboxSetInsertPointOff(TEXT_SEARCHWORD);
      FormRestoreBitBehind(FORM_SEARCHWORD);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_SEARCHWORD, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    default:
      return FALSE;
    }
    break;
	
  default:
    return FALSE;
  }
  return TRUE;
}


int searchhits;
unsigned int searchoff[100];
unsigned char searchstr[100][40];
#define CPU_CLK_75M        (0<<10)
#define CPU_CLK_37M        (1<<10)
extern void CpuChangeSpeed(int);
void Search()
{
  unsigned int pos, size, off, len, rsz;
  char locbuff[64];
  extern FILE *fp;
  extern DOCFILE *dfp;

  if (FPISNULL) return;
  CpuChangeSpeed(CPU_CLK_75M);
  StippleBackground();
  len = strlen(lastsearch);
  pos = FTELL();
  size = FSIZE()-1;
  searchhits=0;
  off = 0;
  len = strlen(lastsearch);
  if (pref.casesensitive) {
    while (searchhits<100 && FTELL()<size) {
      FSEEK(off, SEEK_SET);
      FREAD(locbuff, 1, len);
      if (strncmp(locbuff, lastsearch, len)==0) {
	FSEEK(off, SEEK_SET);
	rsz = FREAD(&(searchstr[searchhits][0]), 1, 39);
	searchstr[searchhits][rsz<39?rsz:39]=0;
	searchoff[searchhits] = off;
	searchhits++;
      }
      off++;
      if ((off%1000)==0) {
	sprintf(locbuff, "Searching %d", off);
	FntDrawString(locbuff,0,0,TRUE);
      }
    }
  } else {
    // DUPLICATE OF ABOVE, JUST STRNCASECOMP VS. STRNCMP
    while (searchhits<100 && FTELL()<size) {
      FSEEK(off, SEEK_SET);
      FREAD(locbuff, 1, len);
      if (strncasecmp(locbuff, lastsearch, len)==0) {
	FSEEK(off, SEEK_SET);
	rsz = FREAD(&(searchstr[searchhits][0]), 1, 39);
	searchstr[searchhits][rsz<39?rsz:39]=0;
	searchoff[searchhits] = off;
	searchhits++;
      }
      off++;
      if ((off%1000)==0) {
	sprintf(locbuff, "Searching %d", off);
	FntDrawString(locbuff,0,0,TRUE);
      }
    }
  }
  CpuChangeSpeed(CPU_CLK_37M);
  FSEEK(pos, SEEK_SET);
}


void ListWidth(char *dest, char *left, char *right, int width)
{
  int fnt, wr, wl;
  char *p;

  fnt = FntGetFont();
  FntSetFont(smallFont);
  wr = FntStringWidth(right);
  wl = 0;
  p = dest;
  while (*left && *left!='\r' && *left!='\n' && ((wl+wr)<width)) {
    *(dest++) = *(left++);
    *dest = 0;
    wl = FntStringWidth(p);
  }
  while ((wl+wr)<width) {
    *(dest++) = ' ';
    *dest = 0;
    wl = FntStringWidth(p);
  }

  *(--dest)=0;
  strcat(p, right);
  FntSetFont(fnt);
}


BOOLEAN FormSearchHandleEvent(EvtType* Event)
{
  SHORT item;
  ObjectID objid;
  int i;
  char buff[512], at[64];

  switch(Event->eventType) {
  case EVT_FORM_OPEN:
    Search();
    FormDrawForm(Event->eventID);
    ListDeleteAllItems(LIST_SEARCH);
    if (searchhits) {
      for (i=0; i<searchhits; i++) {
	sprintf(at, " %d ",  searchoff[i]);
	ListWidth(buff, searchstr[i], at, 140);
	//	sprintf(buff, "%s - %d", searchstr[i], searchoff[i]);
	ListInsertItem(LIST_SEARCH, i, buff);
      }
    } else
      ListInsertItem(LIST_SEARCH, 0, "No Search Hits...");
    ListSetSelectedItem(LIST_SEARCH, NO_SELECTION);
    ListDrawList(LIST_SEARCH);
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(Event->eventID, Event->para1);
    ListSetHighlightedItem(Event->eventID, Event->para1);
    ListDrawList(Event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(Event->para1) {
    case INLAY_OK:
      ListGetTotalItems(LIST_SEARCH, &item);
      if (item==0 || searchhits==0) break;
      ListGetSelectedItem(LIST_SEARCH, &item);
      if (item == NO_SELECTION) return TRUE;
      wenttotoc=-1;
      GotoLine(-1, searchoff[wenttosearch=item]);
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    ListGetTotalItems(LIST_SEARCH, &item);
    if (Event->eventID==EXIT_SEARCH) {
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_SEARCH, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    }
    if (item==0 || searchhits==0) break;
    ListGetSelectedItem(LIST_SEARCH, &item);
    if (item == NO_SELECTION && Event->eventID!=EXIT_SEARCH) return TRUE;
    switch (Event->eventID) {
    case GOTO_SEARCH:
      wenttotoc=-1;
      GotoLine(-1, searchoff[wenttosearch=item]);
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}

int tocs = 0;
TOC *toc = NULL;

void GotoTOC(int item)
{
  if (toc==NULL) GotoLine(-1, 0);
  if (item>tocs) item=tocs;
  wenttosearch=-1;
  GotoLine(-1, toc[wenttotoc=item].offset);
}

void ListTOC(int listid, char *fname)
{
  char tocname[64];
  FILE *fp;
  int alloctoc;
  unsigned char linebuff[128];
  int pos, c;
  
  tocs = 0;
  if (toc) qfree(toc);
  toc = NULL;
  ListDeleteAllItems(listid);

  sprintf(tocname, "TOC.%s", fname);
  alloctoc = 128;
  toc = qmalloc(alloctoc*sizeof(TOC));
  fp = fopen(tocname, "rt");
  if (!fp || !toc) {
    ListInsertItem(listid, 0, "No Table of Contents Found...");
    return;
  }
  while (!feof(fp)) {
    pos = 0;
    // Read in a text line
    do {
      c = fgetc(fp);
      linebuff[pos] = c;
      if (c=='\r' || c=='\n' || c==EOF) break;
      pos++;
    } while(pos<127);
    linebuff[pos] = 0;
    if (strlen(linebuff)<3) continue;
    toc[tocs].offset = atoi(linebuff);
    pos = 0;
    while (linebuff[pos]==' ' || (linebuff[pos]>='0' && linebuff[pos]<='9'))
      pos++;
    strncpy(toc[tocs].label, linebuff+pos, 32);
    toc[tocs].label[31] = 0;
    sprintf(linebuff, "%s (%d)", toc[tocs].label, toc[tocs].offset);
    ListInsertItem(listid, tocs, linebuff);
    tocs++;
    if (tocs>alloctoc) {
      TOC *tmp;
      tmp = qmalloc((alloctoc+128)*sizeof(TOC));
      if (tmp==NULL) {
	fclose(fp);
	return;
      }
      memcpy(tmp, toc, alloctoc*sizeof(TOC));
      qfree(toc);
      toc= tmp;
      alloctoc += 128;
    }
  }
  fclose(fp);
}

BOOLEAN FormTOCHandleEvent(EvtType* event)
{
  SHORT item;
  ObjectID objid;
	
  switch(event->eventType) {
  case EVT_FORM_OPEN:
    wenttosearch=-1;
    //    wenttotoc=-1;
    ListTOC(LIST_TOC, savename);
    ListSetSelectedItem(LIST_TOC, NO_SELECTION);
    if (wenttotoc>=0) ListHilightItem(LIST_TOC, wenttotoc);
    FormDrawForm(event->eventID);
    break;

  case EVT_LIST_SELECT:
    ListSetSelectedItem(event->eventID, event->para1);
    ListSetHighlightedItem(event->eventID, event->para1);
    ListDrawList(event->eventID);
    return TRUE;
		
  case EVT_INLAY_SELECT:
    switch(event->para1) {
    case INLAY_OK:
      ListGetTotalItems(LIST_TOC, &item);
      if (item==0) break;
      ListGetSelectedItem(LIST_TOC, &item);
      if (item == NO_SELECTION) return TRUE;
      GotoBookmark(item);
      EvtAppendEvt(EVT_FORM_CLOSE, FORM_TOC, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    case INLAY_EXIT:
    case INLAY_MAIN_MENU:
      FormPopupForm(FORM_MAIN);
      break;
    default:
      return FALSE;
    }
    break;
		
  case EVT_CONTROL_SELECT:
    if (!tocs) break;
    ListGetSelectedItem(LIST_TOC, &item);
    if (item == NO_SELECTION) return TRUE;
    switch (event->eventID) {
    case OPEN_TOC:
      GotoTOC(item);
      FormGetActiveFormID(&objid);
      EvtAppendEvt(EVT_FORM_CLOSE, objid, 0, 0, NULL);
      FormPopupForm(FORM_MAIN);
      break;
    }
    break;
		
  default:
    return FALSE;
  }
  return TRUE;
}


void ListHilightItem(int id, int item)
{
  USHORT items;
  int i;
  SHORT viewnum, total;
  int topnum, listsel;

  ListGetNumOfItems(id, &items);
  i = item;
  ListGetNumItemsDisplay(id, &viewnum);
  ListGetTotalItems(id, &total);
  if (i>=total) i=0;
  if (i<0) i=total-1;
  listsel=i;
  ListSetSelectedItem(id, listsel);
  ListSetHighlightedItem(id, listsel);
  
  topnum=listsel-(viewnum/2)+1;
  if (topnum<0) topnum=0;
  
  if (topnum+viewnum>total) {
    topnum=total-viewnum;
    if (topnum<0) topnum=listsel;
  }
  ListSetTopItemNum(id,topnum);

}

